/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.function.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bsp.function.dao.SysActFunctionMapper;
import com.jxdinfo.hussar.bsp.function.model.SysActFunction;
import com.jxdinfo.hussar.bsp.function.model.SysActFunctionParm;
import com.jxdinfo.hussar.bsp.function.service.ISysActFunctionParmService;
import com.jxdinfo.hussar.bsp.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysActFunctionServiceImpl
extends ServiceImpl<SysActFunctionMapper, SysActFunction>
implements ISysActFunctionService {
    @Resource
    private SysActFunctionMapper sysActFunctionMapper;
    @Autowired
    private ISysActFunctionParmService sysActFunctionParmService;

    @Override
    public ApiResponse<?> add(String functionName, String functionBean, String functionParm) {
        Date currTime = Date.from(LocalDateTime.now().atZone(ZoneOffset.ofHours(8)).toInstant());
        SysActFunction sysActFunction = new SysActFunction();
        sysActFunction.setFunctionName(functionName);
        sysActFunction.setFunctionBean(functionBean);
        sysActFunction.setCreateTime(currTime);
        int insertResult = this.sysActFunctionMapper.insert((Object)sysActFunction);
        if (insertResult != 1) {
            return ApiResponse.fail("\u65b0\u589e\u5931\u8d25");
        }
        if (ToolUtil.isNotEmpty((Object)functionParm)) {
            ArrayList<SysActFunctionParm> parmList = new ArrayList<SysActFunctionParm>();
            JSONArray jsonArray = JSON.parseArray((String)functionParm);
            for (int i = 0; i < jsonArray.size(); ++i) {
                SysActFunctionParm sysActFunctionParm = new SysActFunctionParm();
                sysActFunctionParm.setFunctionId(sysActFunction.getFunctionId());
                sysActFunctionParm.setParmKey(jsonArray.getJSONObject(i).getString("parmKey"));
                sysActFunctionParm.setParmName(jsonArray.getJSONObject(i).getString("parmName"));
                sysActFunctionParm.setCreateTime(currTime);
                parmList.add(sysActFunctionParm);
            }
            boolean saveResult = this.sysActFunctionParmService.saveBatch(parmList);
            if (!saveResult) {
                return ApiResponse.fail("\u65b0\u589e\u5931\u8d25");
            }
        }
        return ApiResponse.success("\u65b0\u589e\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<?> update(String functionId, String functionName, String functionBean, boolean change, String functionParm, String delIds) {
        List<String> delList;
        boolean delResult;
        Date currTime = Date.from(LocalDateTime.now().atZone(ZoneOffset.ofHours(8)).toInstant());
        if (change) {
            SysActFunction sysActFunction = new SysActFunction();
            sysActFunction.setFunctionId(functionId);
            sysActFunction.setFunctionBean(functionBean);
            sysActFunction.setFunctionName(functionName);
            sysActFunction.setUpdateTime(currTime);
            int updateResult = this.sysActFunctionMapper.updateById((Object)sysActFunction);
            if (updateResult != 1) {
                return ApiResponse.fail("\u4fee\u6539\u5931\u8d25");
            }
        }
        if (ToolUtil.isNotEmpty((Object)functionParm)) {
            JSONArray jsonArray = JSON.parseArray((String)functionParm);
            ArrayList<SysActFunctionParm> addList = new ArrayList<SysActFunctionParm>();
            ArrayList<SysActFunctionParm> updateList = new ArrayList<SysActFunctionParm>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                SysActFunctionParm sysActFunctionParm = new SysActFunctionParm();
                String parmId = jsonArray.getJSONObject(i).getString("parmId");
                if (ToolUtil.isNotEmpty((Object)parmId)) {
                    sysActFunctionParm.setParmId(parmId);
                    sysActFunctionParm.setParmName(jsonArray.getJSONObject(i).getString("parmName"));
                    sysActFunctionParm.setParmKey(jsonArray.getJSONObject(i).getString("parmKey"));
                    sysActFunctionParm.setUpdateTime(currTime);
                    updateList.add(sysActFunctionParm);
                    continue;
                }
                sysActFunctionParm.setFunctionId(functionId);
                sysActFunctionParm.setParmName(jsonArray.getJSONObject(i).getString("parmName"));
                sysActFunctionParm.setParmKey(jsonArray.getJSONObject(i).getString("parmKey"));
                sysActFunctionParm.setCreateTime(currTime);
                addList.add(sysActFunctionParm);
            }
            boolean insertResult = true;
            boolean updateResult = true;
            if (addList.size() != 0) {
                insertResult = this.sysActFunctionParmService.saveBatch(addList);
            }
            if (updateList.size() != 0) {
                updateResult = this.sysActFunctionParmService.updateBatchById(updateList);
            }
            if (!insertResult || !updateResult) {
                return ApiResponse.fail("\u4fee\u6539\u5931\u8d25");
            }
        }
        if (ToolUtil.isNotEmpty((Object)delIds) && !(delResult = this.sysActFunctionParmService.removeByIds(delList = Arrays.asList(delIds.split(","))))) {
            return ApiResponse.fail("\u4fee\u6539\u5931\u8d25");
        }
        return ApiResponse.success("\u4fee\u6539\u6210\u529f");
    }

    @Override
    public List<SysActFunction> queryFunctionList(Page page, String functionName) {
        return this.sysActFunctionMapper.queryFunctionList(page, functionName);
    }

    @Override
    public void exportFunction(String functionId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        List functionList = this.sysActFunctionMapper.selectList((Wrapper)new QueryWrapper().in((Object)"FUNCTION_ID", Arrays.asList(functionId.split(","))));
        List functionParmList = this.sysActFunctionParmService.list((Wrapper)new QueryWrapper().in((Object)"FUNCTION_ID", Arrays.asList(functionId.split(","))));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("function", functionList);
        data.put("functionParm", functionParmList);
        data.put("export_type", "lcdpBpmFunction");
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            outputStream.write(JSONObject.toJSONBytes(data, (SerializerFeature[])new SerializerFeature[0]));
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

