/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.exception;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.bsp.exception.BpmExceptionHander;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0x7FFFFFFE)
public class BpmInterfaceExceptionHander {
    private static final Logger logger = LoggerFactory.getLogger(BpmExceptionHander.class);

    @ExceptionHandler(value={RuntimeException.class})
    @Order(value=0x7FFFFFFE)
    public BpmResponseResult bizExceptionHandler(HttpServletRequest req, Exception e) {
        StackTraceElement stackTraceElement = e.getStackTrace()[0];
        StringBuilder sb = new StringBuilder();
        sb.append("\u5f02\u5e38\u7c7b\u578b\uff1a").append(e.toString()).append(";");
        sb.append("\u5f02\u5e38\u7c7b\u540d\uff1a").append(stackTraceElement.getFileName()).append(";");
        sb.append("\u5f02\u5e38\u65b9\u6cd5\u540d\uff1a").append(stackTraceElement.getMethodName()).append(";");
        sb.append("\u5f02\u5e38\u884c\u6570\uff1a").append(stackTraceElement.getLineNumber()).append(";");
        sb.append("\u8bf7\u6c42\u8def\u5f84\uff1a").append(req.getRequestURL()).append(";");
        HashMap<String, String> map = new HashMap<String, String>(req.getParameterMap());
        map.remove("tenantCipher");
        for (String key : map.keySet()) {
            String[] message = (String[])map.get(key);
            if (message.length == 0) {
                map.put(key, null);
                continue;
            }
            if (message.length != 1) continue;
            map.put(key, message[0]);
        }
        if (ToolUtil.isNotEmpty(map)) {
            sb.append("\u8bf7\u6c42\u53c2\u6570\uff1a").append(JSONObject.toJSONString(map)).append(";");
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("userId", HttpKit.getIp());
        info.put("userAccount", HttpKit.getIp());
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        info.put("sessionId", HttpKit.getSeesionId());
        info.put("tenantId", req.getParameter("tenantId"));
        info.put("tenantCipher", req.getParameter("tenantCipher"));
        InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.exceptionLog(info, sb.toString()));
        logger.error("\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38\uff01\u539f\u56e0\u662f\uff1a{}", (Object)sb.toString());
        e.printStackTrace();
        return InstallResult.getResult("0", sb.toString(), null);
    }
}

