/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.exception;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.impl.DefinitionEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.exception.TenantLackInfoException;
import com.jxdinfo.hussar.bsp.exception.TenantLockException;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0x7FFFFFFD)
public class BpmExceptionHander {
    private static Logger LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);

    @ExceptionHandler(value={TenantException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantException e) {
        return ApiResponse.fail("\u79df\u6237\u4fe1\u606f\u4e0d\u6b63\u786e");
    }

    @ExceptionHandler(value={TenantLackInfoException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLackInfoException e) {
        return ApiResponse.fail("\u79df\u6237\u4fe1\u606f\u4e0d\u5b8c\u6574");
    }

    @ExceptionHandler(value={TenantLockException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLockException e) {
        return ApiResponse.fail("\u7528\u6237\u5df2\u88ab\u7981\u7528");
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(HttpServletRequest req, PublicClientException e) {
        if (e.getIsSaveLogger().booleanValue()) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            StringBuilder sb = new StringBuilder();
            sb.append(e.getReason());
            sb.append("\u5f02\u5e38\u7c7b\u540d\uff1a").append(stackTraceElement.getClassName());
            sb.append("\u5f02\u5e38\u65b9\u6cd5\u540d\uff1a").append(stackTraceElement.getMethodName());
            sb.append(";\u5f02\u5e38\u6587\u4ef6\u540d\uff1a").append(stackTraceElement.getFileName());
            sb.append("\u5f02\u5e38\u884c\u6570\uff1a").append(stackTraceElement.getLineNumber());
            sb.append("\u8bf7\u6c42\u8def\u5f84\uff1a").append(req.getRequestURL()).append(";");
            HashMap map = new HashMap(req.getParameterMap());
            map.remove("tenantCipher");
            for (Map.Entry k : map.entrySet()) {
                String[] message = (String[])k.getValue();
                if (message.length == 0) {
                    map.put(k.getKey(), null);
                    continue;
                }
                if (message.length != 1) continue;
                map.put(k.getKey(), message[0]);
            }
            if (ToolUtil.isNotEmpty(map)) {
                sb.append("\u8bf7\u6c42\u53c2\u6570\uff1a").append(JSONObject.toJSONString(map)).append(";");
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("userId", HttpKit.getIp());
            info.put("userAccount", HttpKit.getIp());
            info.put("ip", HttpKit.getIp());
            info.put("port", HttpKit.getPort());
            info.put("host", HttpKit.getHost());
            info.put("localIp", HttpKit.getLocalIp());
            info.put("localPort", HttpKit.getLocalPort());
            info.put("localHost", HttpKit.getLocalHost());
            info.put("sessionId", HttpKit.getSeesionId());
            info.put("tenantId", req.getParameter("tenantId"));
            info.put("tenantCipher", req.getParameter("tenantCipher"));
            InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.exceptionLog(info, sb.toString()));
            LOGGER.error(sb.toString());
            e.printStackTrace();
        }
        return InstallResult.getResult(e.getCode(), e.getReason(), e.getResult());
    }
}

