/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processinst.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.entrusthi.service.EntrustHiSerive;
import com.jxdinfo.hussar.bpm.notice.service.SysActTaskNoticeService;
import com.jxdinfo.hussar.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.bpm.processinst.model.ProcessInstVariable;
import com.jxdinfo.hussar.bpm.processinst.model.vo.ProcessInstVo;
import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProcessInstServiceImpl
implements ProcessInstService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessInstMapper processInstMapper;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private EntrustHiSerive entrustHiSerive;
    @Autowired
    private SysActTaskNoticeService sysActTaskNoticeService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Value(value="${spring.datasource.url}")
    private String url;

    @Override
    public Map<String, Object> getProcessList(Map<String, Object> map) {
        map.put("dbType", this.url.split(":")[1]);
        Page pages = new Page((long)((Integer)map.get("page")).intValue(), (long)((Integer)map.get("limit")).intValue());
        List<ProcessInst> instList = this.processInstMapper.getListMySql((Page<ProcessInst>)pages, map);
        HashSet<String> procInstIds = new HashSet<String>();
        for (ProcessInst processInst : instList) {
            procInstIds.add(processInst.getProcessInstanceId());
        }
        if (!instList.isEmpty()) {
            List<ProcessInstVo> nodeList = this.processInstMapper.getNodeNames(procInstIds);
            List<ProcessInstVariable> variables = this.processInstMapper.getAllVariables(procInstIds);
            HashMap<String, Set> nodeMap = new HashMap<String, Set>();
            for (ProcessInstVo node : nodeList) {
                String procInstId = node.getProcessInsId();
                Set set = (Set)nodeMap.get(procInstId);
                set = set == null ? new HashSet() : set;
                set.add(node.getActName());
                nodeMap.put(procInstId, set);
            }
            HashMap<String, String> processCodeMap = new HashMap<String, String>();
            for (ProcessInstVariable processInstVariable : variables) {
                if (processCodeMap.get(processInstVariable.getProcessInstId()) != null && !"1".equals(processInstVariable.getVariableType())) continue;
                processCodeMap.put(processInstVariable.getProcessInstId(), processInstVariable.getTextValue());
            }
            for (ProcessInst processInst : instList) {
                processInst.setProcessCode((String)processCodeMap.get(processInst.getProcessInstanceId()));
                Set nodeNames = (Set)nodeMap.get(processInst.getProcessInstanceId());
                if (nodeNames == null || nodeNames.isEmpty()) continue;
                processInst.setNames(String.join((CharSequence)",", nodeNames));
            }
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("count", pages.getTotal());
        dataMap.put("data", instList);
        return dataMap;
    }

    @Override
    public ApiResponse<Map<String, Object>> suspendProcessInstanceById(String processInstCode) {
        try {
            this.runtimeService.suspendProcessInstanceById(processInstCode);
            return ApiResponse.success("\u6302\u8d77\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ApiResponse.fail("\u6302\u8d77\u5931\u8d25\uff01");
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> activateProcessById(String processInstCode) {
        try {
            this.runtimeService.activateProcessInstanceById(processInstCode);
            return ApiResponse.success("\u6fc0\u6d3b\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ApiResponse.fail("\u6fc0\u6d3b\u5931\u8d25\uff01");
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> deleteProcessInstance(String processInstCode) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstCode).singleResult();
        if (historicProcessInstance != null) {
            if (historicProcessInstance.getEndTime() != null) {
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            } else {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstCode)).list();
                StringBuilder taskIds = new StringBuilder();
                for (Task task : tasks) {
                    taskIds.append(",").append(task.getId());
                }
                if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                    this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
                }
                this.runtimeService.deleteProcessInstance(historicProcessInstance.getId(), "");
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            }
            QueryWrapper ccQueryWrapper = new QueryWrapper();
            ccQueryWrapper.eq((Object)"PROC_INST_ID", (Object)historicProcessInstance.getId());
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            QueryWrapper urgeQueryWrapper = new QueryWrapper();
            urgeQueryWrapper.eq((Object)"PROC_INST_ID", (Object)historicProcessInstance.getId());
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"process_inst_id", (Object)historicProcessInstance.getId());
            this.entrustHiSerive.remove((Wrapper)queryWrapper);
            QueryWrapper queryWrapperNotice = new QueryWrapper();
            queryWrapperNotice.eq((Object)"process_inst_id", (Object)historicProcessInstance.getId());
            this.sysActTaskNoticeService.remove((Wrapper)queryWrapperNotice);
            return ApiResponse.success("\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail("\u5220\u9664\u5931\u8d25\uff01");
    }

    @Override
    public ApiResponse<?> deleteFinishedProcessInstance(String processInstCode) {
        try {
            this.historyService.deleteHistoricProcessInstance(processInstCode);
            QueryWrapper ccQueryWrapper = new QueryWrapper();
            ccQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstCode);
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            QueryWrapper urgeQueryWrapper = new QueryWrapper();
            urgeQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstCode);
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"process_inst_id", (Object)processInstCode);
            this.entrustHiSerive.remove((Wrapper)queryWrapper);
            QueryWrapper queryWrapperNotice = new QueryWrapper();
            queryWrapperNotice.eq((Object)"process_inst_id", (Object)processInstCode);
            this.sysActTaskNoticeService.remove((Wrapper)queryWrapperNotice);
            return ApiResponse.success("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ApiResponse.fail("\u5220\u9664\u5931\u8d25\uff01");
        }
    }
}

