/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processentrust.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.entrusthi.service.EntrustHiSerive;
import com.jxdinfo.hussar.bpm.interfacelog.annontion.InterfaceLog;
import com.jxdinfo.hussar.bpm.processentrust.model.SysActEntrust;
import com.jxdinfo.hussar.bpm.processentrust.service.SysActEntrustService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysActEntrust"})
public class SysActEntrustController
extends BaseController {
    @Autowired
    private SysActEntrustService sysActEntrustService;
    @Autowired
    private EntrustHiSerive entrustHiSerive;

    @RequestMapping(value={"/list"})
    @InterfaceLog(key="/sysActEntrust/list", value="\u67e5\u8be2\u59d4\u6258\u5217\u8868", type="\u67e5\u8be2")
    public BpmResponseResult list(String userId, String processId, String state, String page, String size) {
        if (ToolUtil.isEmpty((Object)userId)) {
            return InstallResult.getResult("0", "\u7528\u6237ID\u4e3a\u7a7a", null);
        }
        if ("null".equals(page)) {
            page = "1";
        }
        if ("null".equals(size)) {
            size = "20";
        }
        Page pages = new Page((long)Integer.parseInt(page), (long)Integer.parseInt(size));
        QueryWrapper ew = new QueryWrapper();
        ew.like(ToolUtil.isNotEmpty((Object)processId), (Object)"process_id", (Object)processId);
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date date = new Date();
        if ("1".equals(state)) {
            ew.eq(ToolUtil.isNotEmpty((Object)state), (Object)"state", (Object)state);
            ew.gt(ToolUtil.isNotEmpty((Object)date), (Object)"end_time", (Object)date);
            ew.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper.eq((Object)"consignor", (Object)userId)).or(i -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"consignee", (Object)userId);
                });
            });
            ew.orderByAsc((Object)"start_time");
        } else if ("0".equals(state)) {
            ew.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"consignor", (Object)userId)).or()).eq((Object)"consignee", (Object)userId);
            });
            ew.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq(ToolUtil.isNotEmpty((Object)state), (Object)"state", (Object)state)).or()).le(ToolUtil.isNotEmpty((Object)date), (Object)"end_time", (Object)date);
            });
            ew.orderByAsc((Object)"start_time");
        } else {
            ew.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"consignor", (Object)userId)).or()).eq((Object)"consignee", (Object)userId);
            });
            ew.orderByAsc((Object)"start_time");
        }
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        List list = ((Page)this.sysActEntrustService.page((IPage)pages, (Wrapper)ew)).getRecords();
        result.put("count", (Object)pages.getTotal());
        result.put("data", (Object)list);
        jsonArray.add((Object)result);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @RequestMapping(value={"/entrustHistoryList"})
    @InterfaceLog(key="/sysActEntrust/entrustHistoryList", value="\u67e5\u8be2\u59d4\u6258", type="\u65b0\u589e")
    public BpmResponseResult entrustHistoryList(@RequestParam(required=false) String userId, @RequestParam(required=false) String tenantId, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="10") Integer limit) {
        return this.entrustHiSerive.entrustHistoryList(userId, page, limit, tenantId);
    }

    @RequestMapping(value={"/add"})
    @InterfaceLog(key="/sysActEntrust/add", value="\u6dfb\u52a0\u59d4\u6258", type="\u65b0\u589e")
    public BpmResponseResult add(String processId, String processName, String consignor, String consignorName, String consignee, String consigneeName, String state, String startTime, String endTime, String companyCode, String companyName) {
        SysActEntrust sysActEntrust1 = SysActEntrustController.getSysActEntrust(IdWorker.get32UUID(), processId, processName, consignor, consignorName, consignee, consigneeName, state, startTime, endTime, companyCode, companyName, null);
        QueryWrapper ew = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)ew.eq((Object)"consignor", (Object)sysActEntrust1.getConsignor())).eq((Object)"process_id", (Object)sysActEntrust1.getProcessId())).eq(companyCode != null, (Object)"company_code", (Object)companyCode)).isNull(companyCode == null, (Object)"company_code");
        List list = this.sysActEntrustService.list((Wrapper)ew);
        if (list.size() >= 1) {
            return InstallResult.getResult("0", "\u6b64\u6d41\u7a0b\u5df2\u6709\u59d4\u6258\u4eba\uff01", null);
        }
        this.sysActEntrustService.save((Object)sysActEntrust1);
        return InstallResult.getResult("1", "\u4fdd\u5b58\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/addBatch"})
    @InterfaceLog(key="/sysActEntrust/addBatch", value="\u6dfb\u52a0\u59d4\u6258", type="\u65b0\u589e")
    public BpmResponseResult addBatch(String processId, String processName, String consignor, String consignorName, String consignee, String consigneeName, String state, String startTime, String endTime, String companyCode, String companyName) {
        SysActEntrust sysActEntrust = null;
        ArrayList<SysActEntrust> tt = new ArrayList<SysActEntrust>();
        String[] ids = null;
        ids = processId.split(",");
        String[] names = null;
        names = processName.split(",");
        List list = null;
        int isRight = 0;
        for (int i = 0; i < ids.length; ++i) {
            String id = String.valueOf(ids[i]);
            String name = String.valueOf(names[i]);
            sysActEntrust = SysActEntrustController.getSysActEntrust(IdWorker.get32UUID(), id, name, consignor, consignorName, consignee, consigneeName, state, startTime, endTime, companyCode, companyName, null);
            QueryWrapper ew = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)ew.eq((Object)"consignor", (Object)sysActEntrust.getConsignor())).eq((Object)"process_id", (Object)sysActEntrust.getProcessId())).eq((Object)"state", (Object)1)).eq(companyCode != null, (Object)"company_code", (Object)companyCode)).isNull(companyCode == null, (Object)"company_code");
            list = this.sysActEntrustService.list((Wrapper)ew);
            Timestamp a = new Timestamp(System.currentTimeMillis());
            if (list.size() >= 1) {
                boolean isContinue = false;
                for (SysActEntrust date : list) {
                    Timestamp b = date.getEndTime();
                    if (!a.before(b)) continue;
                    isContinue = true;
                    break;
                }
                if (isContinue) continue;
            }
            tt.add(sysActEntrust);
            ++isRight;
        }
        if (isRight == 0) {
            return InstallResult.getResult("0", "\u6b64\u6d41\u7a0b\u5df2\u6709\u59d4\u6258\u4eba\uff01", null);
        }
        this.sysActEntrustService.saveBatch(tt, ids.length);
        return InstallResult.getResult("1", "\u4fdd\u5b58\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/delete"})
    @InterfaceLog(key="/sysActEntrust/delete", value="\u5220\u9664\u59d4\u6258", type="\u5220\u9664")
    public BpmResponseResult delete(@RequestParam String tEntrustId) {
        this.sysActEntrustService.removeByIds(Arrays.asList(tEntrustId.split(",")));
        return InstallResult.getResult("1", "\u5220\u9664\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/update"})
    @InterfaceLog(key="/sysActEntrust/update", value="\u4fee\u6539\u59d4\u6258", type="\u4fee\u6539")
    public BpmResponseResult update(String id, String consignee, String consigneeName, String startTime, String endTime) {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String updateTime = dateFormat.format(date);
        SysActEntrust sysActEntrust1 = SysActEntrustController.getSysActEntrust(id, null, null, null, null, consignee, consigneeName, null, startTime, endTime, null, null, updateTime);
        QueryWrapper ew = new QueryWrapper();
        ((QueryWrapper)ew.eq((Object)"consignor", (Object)sysActEntrust1.getConsignor())).eq((Object)"process_id", (Object)sysActEntrust1.getProcessId());
        SysActEntrust sysActEntrust2 = (SysActEntrust)((Object)this.sysActEntrustService.getOne((Wrapper)ew));
        if (sysActEntrust2 == null || sysActEntrust2.getId().equals(sysActEntrust1.getId())) {
            this.sysActEntrustService.updateById((Object)sysActEntrust1);
            return InstallResult.getResult("1", "\u4fee\u6539\u6210\u529f\uff01", null);
        }
        return InstallResult.getResult("0", "\u4fee\u6539\u5931\u8d25\uff01", null);
    }

    @RequestMapping(value={"/detail"})
    @InterfaceLog(key="/sysActEntrust/detail", value="\u67e5\u8be2\u59d4\u6258\u7684\u8be6\u60c5", type="\u67e5\u8be2")
    public BpmResponseResult detail(String tEntrustId) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(this.sysActEntrustService.getById((Serializable)((Object)tEntrustId)));
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @RequestMapping(value={"/updateState"})
    @InterfaceLog(key="/sysActEntrust/updateState", value="\u4fee\u6539\u59d4\u6258\u72b6\u6001", type="\u4fee\u6539")
    public BpmResponseResult updateState(@RequestParam String tEntrustId, @RequestParam String state) {
        this.sysActEntrustService.updataState(tEntrustId, state);
        if ("1".equals(state)) {
            return InstallResult.getResult("1", "\u542f\u7528\u6210\u529f\uff01", null);
        }
        return InstallResult.getResult("1", "\u7981\u7528\u6210\u529f\uff01", null);
    }

    private static SysActEntrust getSysActEntrust(String id, String processId, String processName, String consignor, String consignorName, String consignee, String consigneeName, String state, String startTime, String endTime, String companyCode, String companyName, String updateTime) {
        SysActEntrust sysActEntrust = new SysActEntrust();
        sysActEntrust.setId(id);
        sysActEntrust.setProcessId(processId);
        sysActEntrust.setProcessName(processName);
        sysActEntrust.setConsignor(consignor);
        sysActEntrust.setConsignorName(consignorName);
        sysActEntrust.setConsignee(consignee);
        sysActEntrust.setConsigneeName(consigneeName);
        sysActEntrust.setState(state);
        sysActEntrust.setStartTime(Timestamp.valueOf(startTime));
        sysActEntrust.setEndTime(Timestamp.valueOf(endTime));
        sysActEntrust.setCompanyCode(companyCode);
        sysActEntrust.setCompanyName(companyName);
        sysActEntrust.setUpdateTime(updateTime);
        return sysActEntrust;
    }
}

