/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.listener;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bsp.procpath.service.ISysActProcPathService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class GodAxeDefaultListener
implements ExecutionListener {
    private final String GodAxePath = "/GodAxeVariables";
    private ITenantConfigService iTenantConfigService = (ITenantConfigService)SpringContextHolder.getBean(ITenantConfigService.class);
    private ISysActProcPathService sysActProcPathService = (ISysActProcPathService)SpringContextHolder.getBean(ISysActProcPathService.class);
    private ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private static Logger LOGGER = LoggerFactory.getLogger(GodAxeDefaultListener.class);
    @Value(value="${bpm.need-log:false}")
    private boolean needLog;

    public void notify(DelegateExecution delegateExecution) throws Exception {
        long tenantStart = System.currentTimeMillis();
        String tenantId = delegateExecution.getTenantId();
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        long tenantEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u83b7\u53d6\u79df\u6237ID\uff1a" + (tenantEnd - tenantStart));
            LOGGER.info("\u83b7\u53d6\u79df\u6237ID\uff1a" + (tenantEnd - tenantStart));
        }
        HashMap<String, String> map = new HashMap<String, String>(2);
        String[] ids = delegateExecution.getProcessDefinitionId().split(":");
        BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(delegateExecution.getProcessDefinitionId());
        long bmEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\uff1a" + (bmEnd - tenantEnd));
            LOGGER.info("\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\uff1a" + (bmEnd - tenantEnd));
        }
        map.put("beanId", ids[0] + ":" + this.modelService.getRealVersion(delegateExecution.getProcessDefinitionId()) + CommonCodeUtil.getVisitorNodeId(((ExecutionEntity)delegateExecution).getActivityId(), bm));
        long versionEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u83b7\u53d6\u6d41\u7a0b\u7248\u672c\uff1a" + (versionEnd - bmEnd));
            LOGGER.info("\u83b7\u53d6\u6d41\u7a0b\u7248\u672c\uff1a" + (versionEnd - bmEnd));
        }
        map.put("businessId", delegateExecution.getProcessBusinessKey());
        String procPath = this.sysActProcPathService.getProcPath(ids[0]);
        long pathEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u83b7\u53d6\u9879\u76ee\u5730\u5740\uff1a" + (pathEnd - versionEnd));
            LOGGER.info("\u83b7\u53d6\u9879\u76ee\u5730\u5740\uff1a" + (pathEnd - versionEnd));
        }
        if ("1".equals(tenantConfig.getIsGodAxe())) {
            Map variable;
            String path = tenantConfig.getProjectAddress();
            if (ToolUtil.isNotEmpty((Object)procPath) && !"null".equals(procPath)) {
                path = procPath;
            }
            long start = System.currentTimeMillis();
            String result = HttpUtil.get((String)(path + "/GodAxeVariables"), map);
            long end = System.currentTimeMillis();
            if (this.needLog) {
                System.out.println("\u83b7\u53d6visitor\u4fe1\u606f\uff1a" + (end - start));
                LOGGER.info("\u83b7\u53d6visitor\u4fe1\u606f\uff1a" + (end - start));
            }
            if (ToolUtil.isNotEmpty((Object)result) && ToolUtil.isNotEmpty((Object)(variable = (Map)JSON.parseObject((String)result, HashMap.class)))) {
                delegateExecution.setVariables(variable);
            }
        }
    }
}

