/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.listener;

import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.listener.ActivityCompletedListener;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.util.DataPushUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ActivityCreateListener
implements ActivitiEventListener {
    @Resource
    private ITenantConfigService iTenantConfigService;
    @Value(value="${bpm.need-log:false}")
    private boolean needLog;
    private static Logger logger = LogManager.getLogger(ActivityCompletedListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        String dataPushAddress;
        long start = System.currentTimeMillis();
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(taskEntity.getTenantId());
        String userId = (String)taskEntity.getVariable("startUser");
        if (ToolUtil.isNotEmpty((Object)userId)) {
            taskEntity.removeVariable("startUser");
        }
        if (tenantConfig != null && "1".equals(tenantConfig.getIsDataPush()) && ToolUtil.isNotEmpty((Object)(dataPushAddress = tenantConfig.getDataPushAddress()))) {
            String processInstanceId = taskEntity.getProcessInstanceId();
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)BpmConstant.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("action", "add");
            map.put("taskId", taskEntity.getId());
            if (historicProcessInstance != null) {
                map.put("businessKey", historicProcessInstance.getBusinessKey());
                map.put("startUserId", historicProcessInstance.getStartUserId());
            } else {
                map.put("businessKey", taskEntity.getProcessInstance().getBusinessKey());
                map.put("startUserId", userId);
            }
            map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
            map.put("processDefinitionId", taskEntity.getProcessDefinitionId());
            map.put("processDefinitionKey", taskEntity.getProcessDefinitionId().split(":")[0]);
            map.put("taskName", taskEntity.getName());
            userId = ToolUtil.isEmpty((Object)this.getAssigneeByTaskId(taskEntity)) ? userId : this.getAssigneeByTaskId(taskEntity);
            map.put("userId", userId);
            map.put("sendUser", taskEntity.getVariable("sendUser"));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            map.put("startDate", simpleDateFormat.format(taskEntity.getCreateTime()));
            map.put("endDate", null);
            map.put("url", taskEntity.getFormKey());
            map.put("description", taskEntity.getVariable("todoConfiguration"));
            map.put("comment", null);
            map.put("processName", taskEntity.getProcessInstance().getProcessDefinition().getName());
            map.put("processInstanceId", processInstanceId);
            DataPushUtil.addData(map);
        }
        long end = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u53d1\u8d77\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start));
            logger.info("\u53d1\u8d77\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start));
        }
    }

    private String getAssigneeByTaskId(TaskEntity taskEntity) {
        StringBuilder users = new StringBuilder();
        Set identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && identityLinks.size() > 0) {
            for (IdentityLink identityLink : identityLinks) {
                users.append(",").append(identityLink.getUserId());
            }
        }
        if (taskEntity.getAssignee() != null) {
            users.append(",").append(taskEntity.getAssignee());
        }
        if (ToolUtil.isNotEmpty((Object)users.toString())) {
            return users.substring(1);
        }
        return "";
    }

    public boolean isFailOnException() {
        logger.error("\u521b\u5efa\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u63a8\u9001\u51fa\u9519");
        return false;
    }
}

