/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.interfacelog.factory;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.bpm.interfacelog.dao.SysActInterfaceLogMapper;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogFactory;
import com.jxdinfo.hussar.bpm.interfacelog.factory.LogType;
import com.jxdinfo.hussar.bpm.interfacelog.model.SysActInterfaceLog;
import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.mutidatasource.util.ChangeDatasource;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.Map;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class InterfaceLogTaskFactory {
    private static SysActInterfaceLogMapper sysActInterfaceLogMapper = (SysActInterfaceLogMapper)SpringContextHolder.getBean(SysActInterfaceLogMapper.class);
    private static ISysUserService iSysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);
    private static Logger logger = LoggerFactory.getLogger(InterfaceLogTaskFactory.class);

    public static TimerTask bussinessLog(final Map<String, String> map, final String bussinessName, final String className, final String methodName, final String msg, final String type, final String levelEvent, final SysUser sysUser) {
        return new TimerTask(){

            @Override
            public void run() {
                SysActInterfaceLog sysActLog = InterfaceLogFactory.createSysSecurityLog(LogType.BUSSINESS, map, bussinessName, className, methodName, msg, LogType.SUCCESS.getMessage(), type, levelEvent);
                try {
                    InterfaceLogTaskFactory.insertSecurityLog(sysActLog, sysUser);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u63a5\u53e3\u8c03\u7528\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask exceptionLog(final Map<String, String> info, final String msg) {
        return new TimerTask(){

            @Override
            public void run() {
                String tenantId = (String)info.get("tenantId");
                String tenantCipher = (String)info.get("tenantCipher");
                ChangeDatasource changeDatasource = new ChangeDatasource();
                changeDatasource.change();
                SysUser sysUser = iSysUserService.queryTenantByTenantId(tenantId, tenantCipher);
                if (sysUser == null) {
                    throw new TenantException();
                }
                info.put("userId", sysUser.getUserId());
                info.put("userAccount", sysUser.getUserAccount());
                info.put("userName", sysUser.getUserName());
                SysActInterfaceLog sysActLog = InterfaceLogFactory.createExceptionLogLog(info, msg);
                try {
                    InterfaceLogTaskFactory.insertSecurityLog(sysActLog, sysUser);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u5f02\u5e38\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    private static void insertSecurityLog(SysActInterfaceLog sysActLog, SysUser sysUser) {
        ChangeDatasource changeDatasource = new ChangeDatasource();
        changeDatasource.change(sysUser);
        sysActLog.setLogId(IdWorker.get32UUID());
        sysActInterfaceLogMapper.insert(sysActLog);
    }
}

