/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.flowevents.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.bpm.flowevents.dao.FlowEventsServiceMapper;
import com.jxdinfo.hussar.bpm.flowevents.model.FlowTask;
import com.jxdinfo.hussar.bpm.flowevents.model.Variables;
import com.jxdinfo.hussar.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FlowEventsServiceImpl
implements FlowEventsService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskEngineService taskEngineService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private FlowEventsServiceMapper flowEventsServiceMapper;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    ProcessDefinitionsService processDefinitionsService;
    @Value(value="${spring.datasource.url}")
    private String url;

    @Override
    public BpmResponseResult todoList(String userId, String processDefinitionKey, String message, String startUserId, String startTime, String endTime, Integer page, Integer limit, String type, String tenantId, String category, String taskDefKey) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("todoConfiguration", message);
        map.put("startUserId", startUserId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("state", "0");
        map.put("definitionKey", taskDefKey);
        map.put("category", category);
        String dbType = this.url.split(":")[1];
        map.put("dbType", dbType);
        List<FlowTask> datas = this.flowEventsServiceMapper.todoList(pages, map);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        for (FlowTask flowTask : datas) {
            taskIds.add(flowTask.getTaskId());
            instIds.add(flowTask.getProcessInstId());
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processMsg = new ArrayList();
        if (ToolUtil.isNotEmpty(datas)) {
            instIds = new ArrayList(new HashSet(instIds));
            instIds.remove(null);
            if (instIds.size() > 0) {
                processMsg = this.flowEventsServiceMapper.getProcessInstMsg(instIds);
            }
            allVariables = this.flowEventsServiceMapper.getAllToDoVariables(taskIds, instIds);
        }
        HashMap<String, Map> processMsgMap = new HashMap<String, Map>();
        for (Map msg : processMsg) {
            processMsgMap.put((String)msg.get("processInstId"), msg);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Variables> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        for (FlowTask flowTask : datas) {
            Map processMap = (Map)processMsgMap.get(flowTask.getProcessInstId());
            if (processMap != null) {
                flowTask.setProcessStartTime((Timestamp)processMap.get("processStartTime"));
                flowTask.setBusinessId((String)processMap.get("businessId"));
            }
            flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList<Variables>() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInstId()) == null ? new ArrayList<Variables>() : (List)processVariablesMap.get(flowTask.getProcessInstId()));
        }
        ArrayList<Map> resultData = new ArrayList<Map>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : datas) {
            Map result = (Map)JSON.parseObject((String)JSON.toJSONString((Object)flowTask), Map.class);
            if (ToolUtil.isNotEmpty(result.get("formKey"))) {
                result.putAll((Map)JSON.parse((String)String.valueOf(result.get("formKey"))));
            }
            result.put("taskVariables", flowTask.getTaskVariableMap());
            result.put("variables", flowTask.getProcessVariableMap());
            if ("1".equals(result.get("isNoticeTask"))) {
                result.put("message", result.get("todoConfiguration"));
            } else {
                result.put("message", ((Map)result.get("taskVariables")).get("todoConfiguration"));
            }
            userIds.add(String.valueOf(result.get("startUserId")));
            result.put("taskSourceFlag", flowTask.getTaskVariableMap().get("taskSourceFlag"));
            result.put("createTime", result.get("startTime") == null ? "" : format.format(result.get("startTime")));
            result.put("processStartTime", result.get("processStartTime") == null ? "" : format.format(result.get("processStartTime")));
            result.put("processInsId", result.get("processInstId"));
            result.put("startUserId", result.get("startUserId"));
            userIds.add(String.valueOf(result.get("startUserId")));
            result.remove("startTime");
            result.remove("processVariables");
            result.remove("todoConfiguartion");
            result.remove("processInstId");
            result.remove("processVariableMap");
            result.remove("taskVariableMap");
            result.remove("sendUser");
            resultData.add(result);
        }
        Map<String, String> finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        for (Map result : resultData) {
            result.put("startUserName", finalUsers.get(result.get("startUserId")));
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("data", resultData);
        data.put("count", Long.valueOf(pages.getTotal()));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult doneList(String userId, String processDefinitionKey, String message, String startUserId, String startTime, String endTime, Integer page, Integer limit, String type, String tenantId, String category, String taskDefKey, String doneStartTime, String doneEndTime) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("todoConfiguration", message);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startUserId", startUserId);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("doneStartTime", doneStartTime);
        map.put("doneEndTime", doneEndTime);
        map.put("state", "0");
        map.put("definitionKey", taskDefKey);
        map.put("category", category);
        String dbType = this.url.split(":")[1];
        map.put("dbType", dbType);
        List<FlowTask> doneList = this.flowEventsServiceMapper.doneList(pages, map);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(flowTask.getTaskId());
            instIds.add(flowTask.getProcessInstId());
        }
        ArrayList<Variables> allVariables = new ArrayList<Variables>();
        List<Object> processMsg = new ArrayList();
        if (ToolUtil.isNotEmpty(doneList)) {
            instIds = new ArrayList(new HashSet(instIds));
            instIds.remove(null);
            if (instIds.size() == 0) {
                instIds = null;
            } else {
                processMsg = this.flowEventsServiceMapper.getProcessInstMsg(instIds);
            }
            if (!taskIds.isEmpty()) {
                allVariables.addAll(this.flowEventsServiceMapper.getAllVariables(taskIds, null));
            }
            if (!instIds.isEmpty()) {
                allVariables.addAll(this.flowEventsServiceMapper.getAllVariables(null, instIds));
            }
        }
        HashMap<String, Map> processMsgMap = new HashMap<String, Map>();
        for (Map msg : processMsg) {
            processMsgMap.put((String)msg.get("processInstId"), msg);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Variables> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        for (FlowTask flowTask : doneList) {
            Map processMap = (Map)processMsgMap.get(flowTask.getProcessInstId());
            if (processMap != null) {
                flowTask.setProcessStartTime((Timestamp)processMap.get("processStartTime"));
                flowTask.setProcessEndTime((Timestamp)processMap.get("processEndTime"));
                flowTask.setBusinessId((String)processMap.get("businessId"));
            }
            flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList<Variables>() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInstId()) == null ? new ArrayList<Variables>() : (List)processVariablesMap.get(flowTask.getProcessInstId()));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", this.hisTasksToMap(doneList, tenantId));
        data.put("count", pages.getTotal());
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    private List<Map<String, Object>> hisTasksToMap(List<FlowTask> lists, String tenantId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashSet<String> processInstanceIds = new HashSet<String>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map<Object, Object> finalUsers = new HashMap();
        List<HistoricProcessInstance> pis = new ArrayList();
        Map<Object, Object> propertiesMap = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                userIds.add(flowTask.getUserId());
                processInstanceIds.add(flowTask.getProcessInstId());
                ids.add(flowTask.getProcessDefinitionId() + flowTask.getTaskDefinitionKey());
            }
            pis = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
            for (HistoricProcessInstance p : pis) {
                userIds.add(p.getStartUserId());
            }
            propertiesMap = this.iSysActExtendPropertiesService.queryList(ids);
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        }
        if (ToolUtil.isNotEmpty(lists)) {
            String processInstId = lists.get(0).getProcessInstId();
            for (FlowTask flowTask : lists) {
                JSONObject object;
                String message;
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                HistoricProcessInstance hpi = this.getHistoricProcessInstance(pis, flowTask.getProcessInstId());
                Map<String, Object> variables = flowTask.getProcessVariableMap();
                Map<String, Object> taskVariables = flowTask.getTaskVariableMap();
                String taskSourceFlagStr = "";
                Object taskSourceFlag = taskVariables.get("taskSourceFlag");
                if (ToolUtil.isNotEmpty((Object)taskSourceFlag)) {
                    taskSourceFlagStr = taskSourceFlag.toString();
                }
                map.put("taskId", flowTask.getTaskId());
                map.put("isNoticeTask", flowTask.getIsNoticeTask());
                map.put("name", flowTask.getName());
                map.put("assigneeId", flowTask.getUserId());
                map.put("assigneeName", finalUsers.get(flowTask.getUserId()));
                map.put("processDefinitionId", flowTask.getProcessDefinitionId());
                map.put("processDefinitionKey", flowTask.getProcessDefinitionKey());
                map.put("processDefinitionName", flowTask.getProcessDefinitionName());
                map.put("taskDefinitionKey", flowTask.getTaskDefinitionKey());
                map.put("processInsId", flowTask.getProcessInstId());
                map.put("startTime", flowTask.getStartTime());
                map.put("endTime", flowTask.getEndTime());
                map.put("processStartTime", flowTask.getProcessStartTime());
                map.put("processEndTime", flowTask.getProcessEndTime());
                map.put("businessId", flowTask.getBusinessId());
                map.put("variables", variables);
                map.put("taskVariables", taskVariables);
                map.put("taskSourceFlag", taskSourceFlag);
                String scope = String.valueOf(taskVariables.get("taskSourceFlag"));
                scope = "reject".equals(scope) ? "\u5df2\u9a73\u56de" : (ToolUtil.isNotEmpty((Object)flowTask.getEndTime()) ? "\u5df2\u5b8c\u6210" : "\u672a\u5b8c\u6210");
                map.put("state", scope);
                if (hpi != null) {
                    map.put("startUserId", hpi.getStartUserId());
                    map.put("startUserName", finalUsers.get(hpi.getStartUserId()));
                }
                if (ToolUtil.isNotEmpty((Object)flowTask.getTodoConfiguration())) {
                    message = flowTask.getTodoConfiguration();
                } else {
                    String string = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
                }
                if (ToolUtil.isNotEmpty((Object)message)) {
                    map.put("message", message);
                }
                map.put("formKey", flowTask.getFormKey());
                String formDetail = (String)propertiesMap.get(flowTask.getProcessDefinitionId() + flowTask.getTaskDefinitionKey());
                if (ToolUtil.isNotEmpty((Object)formDetail) && ToolUtil.isNotEmpty((Object)(object = JSON.parseObject((String)formDetail)))) {
                    for (String key : object.keySet()) {
                        map.put(key, object.getString(key));
                    }
                }
                map.put("formDetailKey", formDetail);
                list.add(map);
            }
        }
        return list;
    }

    private HistoricProcessInstance getHistoricProcessInstance(List<HistoricProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (HistoricProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    public List<Map<String, String>> flowType(String category) {
        return this.flowEventsServiceMapper.flowType(category);
    }

    @Override
    public JSONArray getProcNodeName(String processDefinitonKey) {
        DefinitionModel definitionModel;
        JSONArray result = new JSONArray();
        if (ToolUtil.isNotEmpty((Object)processDefinitonKey) && (definitionModel = this.processDefinitionsService.getMainOrNew(processDefinitonKey)) != null) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(definitionModel.getId());
            for (FlowNode flowNode : bpmnModel.getMainProcess().findFlowElementsOfType(FlowNode.class)) {
                if (!(flowNode instanceof UserTask)) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowNode.getId());
                jsonObject.put("name", (Object)flowNode.getName());
                result.add((Object)jsonObject);
            }
        }
        return result;
    }

    @Override
    public BpmResponseResult revokeTask(String historicTaskId, String userId) {
        BpmResponseResult check = this.taskEngineService.withdrawState(historicTaskId);
        if (check.getCode().equals("0")) {
            return check;
        }
        if (!((Boolean)check.getResult().get(0)).booleanValue()) {
            return InstallResult.getResult("0", "\u5f53\u524d\u8282\u70b9\u4e0d\u80fd\u64a4\u56de", null);
        }
        BpmResponseResult revoke = this.taskEngineService.revokeTask(historicTaskId, userId, "", true, null);
        if (revoke.getCode().equals("0")) {
            return revoke;
        }
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult urgeTask(String processInsId, String userId) {
        if (StringUtils.isEmpty((String)processInsId)) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a\u7a7a", null);
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff0c\u65e0\u6cd5\u50ac\u529e", null);
        }
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).includeProcessVariables()).processInstanceId(processInsId)).list();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        for (Task task : tasks) {
            Set<String> users = this.getAssigneeByTaskId(task.getId());
            if (users.size() <= 0) continue;
            for (String user : users) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setId(IdWorker.get32UUID());
                sysActUrgeTask.setTaskId(task.getId());
                sysActUrgeTask.setProcInstId(task.getProcessInstanceId());
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(user);
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                Map map = task.getTaskLocalVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (list.size() > 0) {
            this.iSysActUrgeTaskService.saveBatch(list);
        }
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public JSONArray processingRecord(JSONArray json) {
        JSONArray newJson = new JSONArray();
        String notShowcounterSignTaskId = "";
        for (Object object : json) {
            Map map = (Map)JSONObject.parseObject((String)JSON.toJSONString(object), Map.class);
            Object taskSourceFlag = map.get("taskSourceFlag");
            if (ToolUtil.isEmpty(taskSourceFlag)) {
                newJson.add(object);
                continue;
            }
            String taskSourceFlagStr = taskSourceFlag.toString();
            if (!taskSourceFlagStr.contains("revoke") && !"cancelEntrust".equals(taskSourceFlagStr)) {
                newJson.add(object);
                continue;
            }
            if (!"completerevoke".equals(taskSourceFlag) && !"rejectrevoke".equals(taskSourceFlag)) continue;
            List<String> sameLevelTaskIdList = this.flowEventsServiceMapper.getSameLevelTaskIdByOperationTaskId(map.get("processInstanceId").toString(), map.get("activityId").toString());
            String sameLevelTaskId = "";
            for (String taskId : sameLevelTaskIdList) {
                if (ToolUtil.isEmpty((Object)sameLevelTaskId)) {
                    sameLevelTaskId = taskId;
                    continue;
                }
                sameLevelTaskId = sameLevelTaskId + "," + taskId;
            }
            if (!ToolUtil.isNotEmpty((Object)sameLevelTaskId)) continue;
            if (ToolUtil.isEmpty((Object)notShowcounterSignTaskId)) {
                notShowcounterSignTaskId = sameLevelTaskId;
                continue;
            }
            notShowcounterSignTaskId = notShowcounterSignTaskId + "," + sameLevelTaskId;
        }
        JSONArray newJsons = new JSONArray();
        if (ToolUtil.isNotEmpty((Object)notShowcounterSignTaskId)) {
            for (Object object : newJson) {
                Map map = (Map)JSONObject.parseObject((String)JSON.toJSONString(object), Map.class);
                if (notShowcounterSignTaskId.contains(map.get("activityId").toString())) continue;
                newJsons.add(object);
            }
        } else {
            newJsons = newJson;
        }
        return newJsons;
    }
}

