/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.bpm.common.utils.GetVariableUtil;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.entrusthi.service.EntrustHiSerive;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ExtendUserTaskActivityBehavior
extends UserTaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendUserTaskActivityBehavior.class);
    private EntrustHiSerive entrustHiSerive = (EntrustHiSerive)SpringContextHolder.getApplicationContext().getBean(EntrustHiSerive.class);
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActCcTaskService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
    private ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private ModelService modelService = (ModelService)SpringContextHolder.getApplicationContext().getBean(ModelService.class);
    private TaskEngineService taskEngineService = (TaskEngineService)SpringContextHolder.getApplicationContext().getBean(TaskEngineService.class);
    @Value(value="${bpm.need-log:false}")
    private boolean needLog = true;

    public ExtendUserTaskActivityBehavior(String userTaskId, TaskDefinition taskDefinition) {
        super(userTaskId, taskDefinition);
    }

    public void execute(ActivityExecution execution) throws Exception {
        Object formKey;
        Object category;
        Object priority;
        Object dueDate;
        Set<Expression> activeCandidateGroupExpressions;
        Set<Expression> activeCandidateUserExpressions;
        Expression activeOwnerExpression;
        Expression activeAssigneeExpression;
        Expression activeFormKeyExpression;
        Expression activeCategoryExpression;
        Expression activePriorityExpression;
        Expression activeDueDateExpression;
        Expression activeDescriptionExpression;
        Expression activeNameExpression;
        long start = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("ExtendUserTaskActivityBehavior\u5f00\u59cb");
            LOGGER.info("ExtendUserTaskActivityBehavior\u5f00\u59cb");
        }
        TaskEntity task = TaskEntity.create((Date)new Date());
        task.insertWithOutTaskQuery((ExecutionEntity)execution);
        task.setExecution((DelegateExecution)execution);
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties((String)this.userTaskId, (String)execution.getProcessDefinitionId());
            activeNameExpression = this.getActiveValue(this.taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
            this.taskDefinition.setNameExpression(activeNameExpression);
            activeDescriptionExpression = this.getActiveValue(this.taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
            this.taskDefinition.setDescriptionExpression(activeDescriptionExpression);
            activeDueDateExpression = this.getActiveValue(this.taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
            this.taskDefinition.setDueDateExpression(activeDueDateExpression);
            activePriorityExpression = this.getActiveValue(this.taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
            this.taskDefinition.setPriorityExpression(activePriorityExpression);
            activeCategoryExpression = this.getActiveValue(this.taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
            this.taskDefinition.setCategoryExpression(activeCategoryExpression);
            activeFormKeyExpression = this.getActiveValue(this.taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
            this.taskDefinition.setFormKeyExpression(activeFormKeyExpression);
            Expression activeSkipExpression = this.getActiveValue(this.taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            this.taskDefinition.setSkipExpression(activeSkipExpression);
            activeAssigneeExpression = this.getActiveValue(this.taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
            this.taskDefinition.setAssigneeExpression(activeAssigneeExpression);
            activeOwnerExpression = this.getActiveValue(this.taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
            this.taskDefinition.setOwnerExpression(activeOwnerExpression);
            activeCandidateUserExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
            this.taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
            activeCandidateGroupExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
            this.taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
        } else {
            activeNameExpression = this.taskDefinition.getNameExpression();
            activeDescriptionExpression = this.taskDefinition.getDescriptionExpression();
            activeDueDateExpression = this.taskDefinition.getDueDateExpression();
            activePriorityExpression = this.taskDefinition.getPriorityExpression();
            activeCategoryExpression = this.taskDefinition.getCategoryExpression();
            activeFormKeyExpression = this.taskDefinition.getFormKeyExpression();
            activeAssigneeExpression = this.taskDefinition.getAssigneeExpression();
            activeOwnerExpression = this.taskDefinition.getOwnerExpression();
            activeCandidateUserExpressions = this.taskDefinition.getCandidateUserIdExpressions();
            activeCandidateGroupExpressions = this.taskDefinition.getCandidateGroupIdExpressions();
        }
        task.setTaskDefinition(this.taskDefinition);
        if (activeNameExpression != null) {
            String name;
            try {
                name = (String)activeNameExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                name = activeNameExpression.getExpressionText();
                LOGGER.warn("property not found in task name expression " + e.getMessage());
            }
            task.setName(name);
        }
        if (activeDescriptionExpression != null) {
            String description;
            try {
                description = (String)activeDescriptionExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                description = activeDescriptionExpression.getExpressionText();
                LOGGER.warn("property not found in task description expression " + e.getMessage());
            }
            task.setDescription(description);
        }
        if (activeDueDateExpression != null && (dueDate = activeDueDateExpression.getValue((VariableScope)execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.taskDefinition.getBusinessCalendarNameExpression().getValue((VariableScope)execution).toString());
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
            }
        }
        if (activePriorityExpression != null && (priority = activePriorityExpression.getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
            }
        }
        if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue((VariableScope)execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
            }
        }
        if (activeFormKeyExpression != null && (formKey = activeFormKeyExpression.getValue((VariableScope)execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
            }
        }
        boolean skipUserTask = this.setAssignments(activeAssigneeExpression, activeOwnerExpression, activeCandidateUserExpressions, activeCandidateGroupExpressions, task, execution);
        task.fireEvent("create");
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        if (skipUserTask) {
            task.setVariableLocal("sendUser", (Object)task.getAssignee());
            task.setVariableLocal("taskSourceFlag", (Object)"skip");
            String todoConfiguration = task.getVariable("todoConfiguration") == null ? "" : task.getVariable("todoConfiguration");
            task.setVariablesLocal(execution.getVariablesLocal());
            task.setVariableLocal("todoConfiguration", (Object)String.valueOf(todoConfiguration));
            task.setVariableLocal("all_prev_node", null);
            task.complete(null, false);
            this.taskEngineService.dataPush((Task)task, "", task.getAssignee(), "skip");
        }
        long end = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("ExtendUserTaskActivityBehavior\u8017\u65f6\uff1a" + (end - start));
            LOGGER.info("ExtendUserTaskActivityBehavior\u8017\u65f6\uff1a" + (end - start));
        }
    }

    private boolean setAssignments(Expression assigneeExpression, Expression ownerExpression, Set<Expression> candidateUserExpressions, Set<Expression> candidateGroupExpressions, TaskEntity task, ActivityExecution execution) {
        Object value;
        Map identityLinks;
        String sendUserId;
        if ("callActivity".equals(execution.getActivity().getProperty("type")) && "parallel".equals(execution.getActivity().getProperty("multiInstance"))) {
            return false;
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)BpmConstant.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(processDefinition.getId());
        if (assigneeExpression != null) {
            Object assigneeExpressionValue = assigneeExpression.getValue((VariableScope)execution);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            task.addCandidateUser(assigneeValue);
        }
        if (ownerExpression != null) {
            Iterator<Expression> ownerExpressionValue = ownerExpression.getValue((VariableScope)execution);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            task.setOwner(ownerValue);
        }
        if (candidateGroupExpressions != null && !candidateGroupExpressions.isEmpty()) {
            for (Expression groupIdExpr : candidateGroupExpressions) {
                Object value2 = groupIdExpr.getValue((VariableScope)execution);
                if (value2 instanceof String) {
                    List<String> candidates = this.extractCandidates((String)value2);
                    task.addCandidateGroups(candidates);
                    continue;
                }
                if (value2 instanceof Collection) {
                    task.addCandidateGroups((Collection)value2);
                    continue;
                }
                throw new ActivitiIllegalArgumentException("Expression did not resolve to a string or collection of strings");
            }
        }
        this.setVariables(task, execution.getVariables());
        Map<String, Object> userMap = AnalyticalModelUtil.getCandidateUserWithSaveEntrustCompleteHi(bm, execution, true, execution.getTenantId());
        Set users = (Set)userMap.get("users");
        if (ToolUtil.isEmpty((Object)users)) {
            long hisSupTaskNum;
            long hisTaskNum = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).count();
            if (hisTaskNum > 0L) {
                throw new PublicClientException(task.getName() + "\u8282\u70b9\u53c2\u4e0e\u8005\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "-1");
            }
            if (ToolUtil.isNotEmpty((Object)((ExecutionEntity)execution).getSuperExecution()) && (hisSupTaskNum = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(((ExecutionEntity)execution).getSuperExecution().getProcessInstanceId())).count()) > 0L) {
                throw new PublicClientException(task.getName() + "\u8282\u70b9\u53c2\u4e0e\u8005\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "-1");
            }
        }
        List addEntrustList = (List)userMap.get("addEntrustList");
        this.entrustHiSerive.saveBatch(addEntrustList);
        FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(execution.getActivity().getId());
        List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
        if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)timeOutStrategy) && ToolUtil.isNotEmpty((Object)((ExtensionElement)timeOutStrategy.get(0)).getAttributes())) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setTaskId(task.getId());
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getDueDate());
            StringBuilder stringBuilder = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)users)) {
                for (String user : users) {
                    stringBuilder.append(user).append(",");
                }
                timeOutModel.setAssignee(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
            }
            timeOutModel.setTimeOutType(((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue());
            timeOutModel.setTenantId(execution.getTenantId());
            if (timeOutModel.getTimeOutType().startsWith("http")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", task.getName());
                map.put("processInstanceId", task.getProcessInstanceId());
                map.put("processDefinitionId", task.getProcessDefinitionId());
                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                map.put("formKey", task.getFormKey());
                map.put("businessKey", execution.getProcessBusinessKey());
                map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
                map.put("category", this.modelService.getCategoryByIdentity(task.getProcessDefinitionId().split(":")[0]));
                map.put("todoConfiguration", task.getVariable("todoConfiguration"));
                map.put("sendUser", task.getVariable("sendUser"));
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                map.put("startUserId", historicProcessInstance.getStartUserId());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                map.put("processStartTime", sdf.format(historicProcessInstance.getStartTime()));
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            this.activityRedisTimer.addTimeOutModel(timeOutModel);
        }
        Set<String> ccUsers = execution.getVariable("cc_user") == null ? new HashSet() : (Set)execution.getVariable("cc_user");
        String string = sendUserId = execution.getVariable("cc_send_user") == null ? "" : (String)execution.getVariable("cc_send_user");
        if (ccUsers != null && ccUsers.size() > 0) {
            execution.removeVariable("cc_user");
            execution.removeVariable("cc_send_user");
            this.ccTask((Task)task, ccUsers, sendUserId, execution);
        } else {
            ccUsers = AnalyticalModelUtil.getCcUser(bm, execution, execution.getTenantId());
            if (ccUsers != null && ccUsers.size() > 0) {
                this.ccTask((Task)task, ccUsers, sendUserId, execution);
            }
        }
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey()).getExtensionElements();
        String skipRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("skiprepetition")).get(0)).getAttributes().get("skiprepetition")).get(0)).getValue();
        if (ToolUtil.isNotEmpty((Object)skipRepetition)) {
            boolean flag = false;
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)BpmConstant.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).orderByHistoricTaskInstanceEndTime().unfinished().desc()).list();
            Map<String, Map<String, Object>> maps = GetVariableUtil.getVariablesMap(hisTaskList.stream().map(TaskInfo::getId).collect(Collectors.toList()), null, 1);
            if (hisTaskList != null && hisTaskList.size() > 0) {
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
                Map map = maps.getOrDefault(historicTaskInstance.getId(), new HashMap());
                if (map != null && map.size() > 0) {
                    boolean bl = flag = map.get("is_normal_commit") == null || (Boolean)map.get("is_normal_commit") != false;
                }
                if (flag) {
                    List<String> skipList = Arrays.asList(skipRepetition.split(","));
                    if (skipList.contains("1") && (users == null || users.size() == 0)) {
                        return true;
                    }
                    if (skipList.contains("2") && ToolUtil.isNotEmpty((Object)hisTaskList)) {
                        String lastAssign = historicTaskInstance.getAssignee();
                        if (users != null && users.contains(lastAssign)) {
                            task.addCandidateUser(lastAssign);
                            return true;
                        }
                    }
                }
            }
        }
        if (users != null && users.size() > 0) {
            task.addCandidateUsers((Collection)users);
        }
        if (candidateUserExpressions != null && !candidateUserExpressions.isEmpty()) {
            for (Expression userIdExpr : candidateUserExpressions) {
                Object value3 = userIdExpr.getValue((VariableScope)execution);
                if (value3 instanceof String) {
                    List<String> candiates = this.extractCandidates((String)value3);
                    task.addCandidateUsers(candiates);
                    continue;
                }
                if (value3 instanceof Collection) {
                    task.addCandidateUsers((Collection)value3);
                    continue;
                }
                throw new ActivitiException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (!this.taskDefinition.getCustomUserIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomUserIdentityLinkExpressions();
            for (String identityLinkType : identityLinks.keySet()) {
                for (Expression idExpression : (Set)identityLinks.get(identityLinkType)) {
                    value = idExpression.getValue((VariableScope)execution);
                    if (value instanceof String) {
                        List<String> userIds = this.extractCandidates((String)value);
                        for (String userId : userIds) {
                            task.addUserIdentityLink(userId, identityLinkType);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator userIdSet = ((Collection)value).iterator();
                        while (userIdSet.hasNext()) {
                            task.addUserIdentityLink((String)userIdSet.next(), identityLinkType);
                        }
                        continue;
                    }
                    throw new ActivitiException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
        if (!this.taskDefinition.getCustomGroupIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomGroupIdentityLinkExpressions();
            for (String identityLinkType : identityLinks.keySet()) {
                for (Expression idExpression : (Set)identityLinks.get(identityLinkType)) {
                    value = idExpression.getValue((VariableScope)execution);
                    if (value instanceof String) {
                        List<String> groupIds = this.extractCandidates((String)value);
                        for (String groupId : groupIds) {
                            task.addGroupIdentityLink(groupId, identityLinkType);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator groupIdSet = ((Collection)value).iterator();
                        while (groupIdSet.hasNext()) {
                            task.addGroupIdentityLink((String)groupIdSet.next(), identityLinkType);
                        }
                        continue;
                    }
                    throw new ActivitiException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
        return false;
    }

    private void setVariables(TaskEntity task, Map<String, Object> variables) {
        task.setVariableLocal("sendUser", variables.get("sendUser"));
        Map<String, String> map = AnalyticalModelUtil.getTodoConfiguration(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (map.size() == 0) {
            return;
        }
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        if (variables == null) {
            variables = new HashMap<String, Object>(16);
        }
        variables.putAll(processMap);
        variables.putAll(taskMap);
        String todo = variables.size() > 0 ? AnalyticalModelUtil.getTodo(variables, map.get("todoConfiguration")) : map.get("todoConfiguration");
        task.setVariableLocal("todoConfiguration", (Object)todo);
    }

    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (!((ExecutionEntity)execution).getTasks().isEmpty()) {
            throw new ActivitiException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    private void ccTask(Task task, Set<String> users, String userId, ActivityExecution execution) {
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        if (processInstance != null) {
            for (String user : users) {
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setId(IdWorker.get32UUID());
                sysActCcTask.setProcInstId(task.getProcessInstanceId());
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(task.getId());
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(task.getFormKey());
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                Map map = ((TaskEntity)task).getVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActCcTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActCcTask);
            }
        }
        if (list.size() > 0) {
            this.iSysActCcTaskService.saveBatch(list);
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Object activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.size() == 0) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }
}

