/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.entrusthi.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.entrusthi.dao.EntrustHiMapper;
import com.jxdinfo.hussar.bpm.entrusthi.model.EntrustHi;
import com.jxdinfo.hussar.bpm.entrusthi.service.EntrustHiSerive;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntrustHiServiceImpl
extends ServiceImpl<EntrustHiMapper, EntrustHi>
implements EntrustHiSerive {
    @Autowired
    EntrustHiMapper entrustHiMapper;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;

    @Override
    public BpmResponseResult entrustHistoryList(String userId, Integer page, Integer limit, String tenantId) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<Map<String, String>> datas = this.entrustHiMapper.getEntrustHistory(pages, userId);
        ArrayList<String> userIds = new ArrayList<String>();
        for (Map<String, String> data : datas) {
            data.put("startTime", format.format(data.get("startTime")));
            if (ToolUtil.isNotEmpty((Object)data.get("endTime"))) {
                data.put("endTime", format.format(data.get("endTime")));
            } else {
                data.put("endTime", "");
            }
            userIds.add(String.valueOf(data.get("sendUser")));
        }
        Map<String, String> finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        for (Map<String, String> result : datas) {
            result.put("sendUserName", finalUsers.get(result.get("sendUser")) == null ? "\u65e0\u529e\u7406\u4eba" : finalUsers.get(result.get("sendUser")));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", datas);
        data.put("count", pages.getTotal());
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public void removeEntrustHistoryByExecutionId(List<String> executionId) {
        if (executionId == null || executionId.size() == 0) {
            return;
        }
        String ids = "'" + executionId.get(0) + "'";
        for (int i = 1; i < executionId.size(); ++i) {
            ids = ids + ",'" + executionId.get(i) + "'";
        }
        this.entrustHiMapper.removeEntrustHistoryByExecutionId(ids);
    }

    @Override
    public void removeMultiRejectRevokeHistoryBytaskId(String taskId) {
        this.entrustHiMapper.removeMultiRejectRevokeHistoryBytaskId(taskId);
    }
}

