/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Map;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class TaskCompleteWithSetAllPrevNodeCmd
extends NeedsActiveTaskCmd<Void> {
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private static Logger LOGGER = LoggerFactory.getLogger(TaskCompleteWithSetAllPrevNodeCmd.class);
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> variables;
    protected boolean localScope;
    private String userId;
    private String comment;
    @Value(value="${bpm.need-log:false}")
    private boolean needLog = true;

    public TaskCompleteWithSetAllPrevNodeCmd(String taskId, Map<String, Object> variables) {
        super(taskId);
        this.variables = variables;
    }

    public TaskCompleteWithSetAllPrevNodeCmd(String taskId, String userId, String comment, Map<String, Object> variables) {
        super(taskId);
        this.userId = userId;
        this.comment = comment;
        this.variables = variables;
    }

    public TaskCompleteWithSetAllPrevNodeCmd(String taskId, Map<String, Object> variables, boolean localScope) {
        super(taskId);
        this.variables = variables;
        this.localScope = localScope;
    }

    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (ToolUtil.isNotEmpty((Object)this.comment)) {
            CommentEntity comment = new CommentEntity();
            comment.setUserId(this.userId);
            comment.setType("complete");
            comment.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            comment.setTaskId(this.taskId);
            comment.setProcessInstanceId(task.getProcessInstanceId());
            comment.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > 1503) {
                eventMessage = eventMessage.substring(0, 1500) + "...";
            }
            comment.setMessage(eventMessage);
            comment.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)comment);
        }
        Map map = task.getVariablesLocal();
        if (task.getDelegationState() != null) {
            task.resolve();
        }
        long start = System.currentTimeMillis();
        task.setVariableLocal("taskSourceFlag", (Object)"complete", true);
        task.getExecution().setVariableLocal("all_prev_node", (Object)("'" + task.getTaskDefinitionKey() + "'"));
        long end2 = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u989d\u5916\u8bbe\u7f6eallPrevNode\u53d8\u91cf\uff1a" + (end2 - start));
            LOGGER.info("\u989d\u5916\u8bbe\u7f6eallPrevNode\u53d8\u91cf\uff1a" + (end2 - start));
        }
        if (this.variables != null) {
            if (this.localScope) {
                task.setVariablesLocal(this.variables);
            } else if (task.getExecutionId() != null) {
                task.setExecutionVariables(this.variables);
            } else {
                task.setVariables(this.variables);
            }
        }
        if (this.needLog) {
            System.out.println("task.complete\u5f00\u59cb\uff1a");
            LOGGER.info("task.complete\u5f00\u59cb\uff1a");
        }
        task.complete(this.variables, this.localScope);
        long end3 = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("task.complete\u8017\u65f6\uff1a" + (end3 - end2));
            LOGGER.info("task.complete\u8017\u65f6\uff1a" + (end3 - end2));
        }
        long timeOutStart = System.currentTimeMillis();
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.taskId);
        }
        long timeOutEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u5904\u7406\u8d85\u65f6\u4efb\u52a1\u8017\u65f6\uff1a" + (timeOutEnd - timeOutStart));
            LOGGER.info("\u5904\u7406\u8d85\u65f6\u4efb\u52a1\u8017\u65f6\uff1a" + (timeOutEnd - timeOutStart));
        }
        return null;
    }

    protected String getSuspendedTaskException() {
        return "Cannot complete a suspended task";
    }
}

