/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang.StringUtils;

public class ParallelJumpTaskCmd
implements Command<Void> {
    protected String userId;
    private String executionId;
    protected String parentId;
    protected String comment;
    protected String type;
    private ActivityImpl desActivity;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);

    public Void execute(CommandContext commandContext) {
        ExecutionEntity propagatingExecution;
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        if (executionEntity.getParent() != null && (executionEntity = executionEntity.getParent()).getParent() != null) {
            executionEntity = executionEntity.getParent();
        }
        executionEntity.setVariables(this.paramvar);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        List taskEntities = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.executionId);
        StringBuilder taskIds = new StringBuilder();
        String deleteReason = "ParallelJumpTaskCmd-Completed";
        if ("revoke".equals(this.type) || "revokeReject".equals(this.type)) {
            deleteReason = "revoke";
        }
        for (Object taskEntity : taskEntities) {
            if (ToolUtil.isNotEmpty((Object)taskEntity.getDueDate())) {
                taskIds.append(",").append(taskEntity.getId());
            }
            taskEntity.fireEvent("complete");
            Context.getCommandContext().getTaskEntityManager().deleteTask((TaskEntity)taskEntity, deleteReason, false);
        }
        List list = executionEntityManager.findChildExecutionsByParentExecutionId(this.parentId);
        for (ExecutionEntity ee : list) {
            List tasks = ee.getTasks();
            if (tasks != null && tasks.size() > 0 && StringUtils.isNotEmpty((String)this.userId)) {
                for (TaskEntity task : tasks) {
                    if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
                        taskIds.append(",").append(task.getId());
                    }
                    task.fireEvent("complete");
                    task.setVariableLocal("taskSourceFlag", (Object)this.type);
                    BpmConstant.taskService.addComment(task.getId(), null, "complete", this.comment);
                    task.setAssignee(this.userId);
                    Context.getCommandContext().getTaskEntityManager().deleteTask(task, deleteReason, false);
                }
            }
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        if (this.desActivity.isScope()) {
            propagatingExecution = executionEntity.createExecution();
            executionEntity.setTransition(null);
            executionEntity.setActivity(null);
            executionEntity.setActive(false);
            if (propagatingExecution.getActivity() == null) {
                propagatingExecution.setActivity(this.desActivity);
            }
            propagatingExecution.initialize();
        } else {
            propagatingExecution = executionEntity;
        }
        propagatingExecution.executeActivity((PvmActivity)this.desActivity);
        return null;
    }

    public ParallelJumpTaskCmd(String userId, String executionId, String parentId, ActivityImpl desActivity, String type, String comment, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.desActivity = desActivity;
        this.comment = comment;
        this.paramvar = paramvar;
        this.type = type;
        this.currentActivity = currentActivity;
        this.parentId = parentId;
    }
}

