/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.common.utils.GetVariableUtil;
import com.jxdinfo.hussar.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;

public class CompleteResultHandleCmd
implements Command<JSONArray> {
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
    private String userId;
    private String processInstanceId;
    private String taskDefinitionKey;

    public CompleteResultHandleCmd(String userId, String processInstanceId, String taskDefinitionKey) {
        this.userId = userId;
        this.processInstanceId = processInstanceId;
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public JSONArray execute(CommandContext commandContext) {
        List instance;
        JSONArray json = new JSONArray();
        ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
        TaskService taskService = configuration.getTaskService();
        HistoryService historyService = configuration.getHistoryService();
        List tasks = ((TaskQuery)taskService.createTaskQuery().processInstanceId(this.processInstanceId)).list();
        int state = 0;
        HistoricProcessInstanceEntity processInstance = new HistoricProcessInstanceEntity();
        if (ToolUtil.isEmpty((Object)tasks)) {
            processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
            List<String> callActivityInstIds = this.taskEngineMapper.getCallActivityInstId(this.processInstanceId);
            if (callActivityInstIds.size() > 0 && ToolUtil.isNotEmpty((Object)(tasks = ((TaskQuery)taskService.createTaskQuery().processInstanceIdIn(callActivityInstIds)).list()))) {
                state = 1;
            }
            if (ToolUtil.isEmpty((Object)tasks) && ToolUtil.isNotEmpty((Object)processInstance.getSuperProcessInstanceId())) {
                tasks = ((TaskQuery)taskService.createTaskQuery().processInstanceId(processInstance.getSuperProcessInstanceId())).list();
                state = 2;
            }
        }
        if (tasks != null && tasks.size() > 0) {
            Map<String, Map<String, Object>> variablesMap = GetVariableUtil.getVariablesMap(tasks.stream().map(TaskInfo::getId).collect(Collectors.toList()), null, 0);
            for (TaskEntity t : tasks) {
                String sendUser;
                String completeType;
                Map map;
                String completeFrom;
                List identityLinkList = t.getIdentityLinks();
                Set users = identityLinkList.stream().filter(item -> item.getType().equals("candidate")).map(IdentityLinkEntity::getUserId).collect(Collectors.toSet());
                if (ToolUtil.isNotEmpty((Object)t.getAssignee())) {
                    users.add(t.getAssignee());
                }
                String string = completeFrom = (map = (Map)variablesMap.getOrDefault(t.getId(), new HashMap())).get("complete_from") == null ? "" : map.get("complete_from").toString();
                if (ToolUtil.isEmpty((Object)completeFrom)) {
                    t.setVariableLocalWithOutQuery("complete_from", (Object)this.taskDefinitionKey, true);
                }
                String string2 = completeType = map.get("complete_type") == null ? "" : map.get("complete_type").toString();
                if (ToolUtil.isEmpty((Object)completeType)) {
                    t.setVariableLocalWithOutQuery("complete_type", (Object)"complete", true);
                }
                String string3 = sendUser = map.get("sendUser") == null ? "" : map.get("sendUser").toString();
                if (ToolUtil.isEmpty((Object)sendUser)) {
                    t.setVariableLocalWithOutQuery("sendUser", (Object)this.userId, true);
                }
                if (state != 0) continue;
                JSONObject object = new JSONObject();
                object.put("processInstanceId", (Object)t.getProcessInstanceId());
                object.put("taskId", (Object)t.getId());
                object.put("userId", users);
                object.put("taskDefinitionKey", (Object)t.getTaskDefinitionKey());
                object.put("taskDefinitionName", (Object)t.getName());
                object.put("formKey", (Object)t.getFormKey());
                json.add((Object)object);
            }
        }
        if (state == 2) {
            instance = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId()).list();
            boolean isEnd = true;
            for (HistoricActivityInstance historicActivityInstance : instance) {
                if (historicActivityInstance.getEndTime() != null) continue;
                isEnd = false;
                JSONObject object = new JSONObject();
                object.put("mainTaskDefinitionName", (Object)historicActivityInstance.getActivityName());
                object.put("taskDefinitionName", BpmConstant.END_NAME);
                object.put("endTime", (Object)new Date());
                json.add((Object)object);
                break;
            }
            if (isEnd) {
                JSONObject object = new JSONObject();
                object.put("mainTaskDefinitionName", BpmConstant.END_NAME);
                object.put("taskDefinitionName", BpmConstant.END_NAME);
                object.put("endTime", (Object)new Date());
                json.add((Object)object);
            }
        } else if (state == 1) {
            instance = historyService.createHistoricActivityInstanceQuery().processInstanceId(this.processInstanceId).list();
            for (HistoricActivityInstance historicActivityInstance : instance) {
                if (historicActivityInstance.getEndTime() != null) continue;
                JSONObject object = new JSONObject();
                object.put("taskDefinitionName", (Object)historicActivityInstance.getActivityName());
                json.add((Object)object);
                break;
            }
        } else if (ToolUtil.isEmpty((Object)tasks)) {
            JSONObject object = new JSONObject();
            object.put("taskDefinitionName", BpmConstant.END_NAME);
            object.put("endTime", (Object)new Date());
            json.add((Object)object);
        }
        return json;
    }
}

