/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import java.util.List;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class CommonPrepareCmd
implements Command<PrepareReturn> {
    private String taskId;
    private String userId;
    private boolean needClaimTask;
    private boolean withOutCheck;

    public CommonPrepareCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
        this.needClaimTask = true;
    }

    public CommonPrepareCmd(String taskId, String userId, boolean needClaimTask) {
        this.taskId = taskId;
        this.userId = userId;
        this.needClaimTask = needClaimTask;
    }

    public CommonPrepareCmd(String taskId, String userId, boolean needClaimTask, boolean withOutCheck) {
        this.taskId = taskId;
        this.userId = userId;
        this.needClaimTask = needClaimTask;
        this.withOutCheck = withOutCheck;
    }

    public PrepareReturn execute(CommandContext commandContext) {
        TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity == null) {
            return new PrepareReturn("\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        if (taskEntity.isSuspended()) {
            return new PrepareReturn("\u4efb\u52a1\u5df2\u6302\u8d77\uff01");
        }
        if (!this.withOutCheck) {
            boolean flag = false;
            if (taskEntity.getAssignee() != null) {
                flag = taskEntity.getAssignee().equals(this.userId);
            } else {
                List identityLinkEntityList = taskEntity.getIdentityLinks();
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
                    if (!"candidate".equals(identityLinkEntity.getType()) || !identityLinkEntity.getUserId().equals(this.userId)) continue;
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                return new PrepareReturn("\u5f53\u524d\u7528\u6237(" + this.userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650");
            }
        }
        if (this.needClaimTask && taskEntity.getAssignee() == null) {
            taskEntity.setAssignee(this.userId);
            commandContext.getHistoryManager().recordTaskClaim(this.taskId);
        }
        return new PrepareReturn(taskEntity);
    }

    public static class PrepareReturn {
        private final boolean isSuccess;
        private final String message;
        private final TaskEntity taskEntity;

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getMessage() {
            return this.message;
        }

        public TaskEntity getTaskEntity() {
            return this.taskEntity;
        }

        private PrepareReturn(TaskEntity taskEntity) {
            this.taskEntity = taskEntity;
            this.isSuccess = true;
            this.message = null;
        }

        private PrepareReturn(String message) {
            this.taskEntity = null;
            this.isSuccess = false;
            this.message = message;
        }
    }
}

