/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.bpm.common.utils.GetVariableUtil;
import com.jxdinfo.hussar.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.engine.util.AddAssigneeCmd;
import com.jxdinfo.hussar.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.bpm.engine.util.CompleteResultHandleCmd;
import com.jxdinfo.hussar.bpm.engine.util.EntrustAssigneeCmd;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.engine.util.MultiInstanceAddAssigneeCmd;
import com.jxdinfo.hussar.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.bpm.engine.util.TaskCompleteWithSetAllPrevNodeCmd;
import com.jxdinfo.hussar.bpm.entrusthi.model.EntrustHi;
import com.jxdinfo.hussar.bpm.entrusthi.service.EntrustHiSerive;
import com.jxdinfo.hussar.bpm.extend.ExtendParallelMultiInstanceBehavior;
import com.jxdinfo.hussar.bpm.flowevents.dao.FlowEventsServiceMapper;
import com.jxdinfo.hussar.bpm.flowevents.model.FlowTask;
import com.jxdinfo.hussar.bpm.flowevents.model.Variables;
import com.jxdinfo.hussar.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.bpm.processcount.dao.ProcessCountMapper;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.util.DataPushUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.InclusiveGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TaskEngineServiceImpl
implements TaskEngineService {
    @Value(value="${spring.datasource.url:}")
    private String url;
    @Value(value="${bpm.need-log:false}")
    private boolean needLog;
    private static Logger LOGGER = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    public static final String CALL_REJECT_PREFIX = "main_process_";
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Resource
    private ProcessCountMapper processCountMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ITenantConfigService iTenantConfigService;
    @Autowired
    private EntrustHiSerive entrustHiSerive;
    @Autowired
    private FlowEventsServiceMapper flowEventsServiceMapper;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    private static final Pattern BPM_NEXT_NODE_REGEX = Pattern.compile("bpm_next_node [!=]= '([^'])*'");

    @Override
    public BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("definitionKey", definitionKey);
        List<FlowTask> datas = this.flowEventsServiceMapper.todoList(null, map);
        if (datas != null) {
            ArrayList<String> taskIds = new ArrayList<String>();
            ArrayList<String> instIds = new ArrayList<String>();
            for (FlowTask flowTask : datas) {
                taskIds.add(flowTask.getTaskId());
                instIds.add(flowTask.getProcessInstId());
            }
            List<Object> allVariables = new ArrayList();
            List<Object> processMsg = new ArrayList();
            if (ToolUtil.isNotEmpty(datas)) {
                instIds = new ArrayList(new HashSet(instIds));
                instIds.remove(null);
                if (instIds.size() > 0) {
                    processMsg = this.flowEventsServiceMapper.getProcessInstMsg(instIds);
                }
                allVariables = this.flowEventsServiceMapper.getAllToDoVariables(taskIds, instIds);
            }
            HashMap<String, Map> processMsgMap = new HashMap<String, Map>();
            for (Map msg : processMsg) {
                processMsgMap.put((String)msg.get("processInstId"), msg);
            }
            HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
            HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
            for (Variables variables : allVariables) {
                List<Variables> list;
                if (variables.getTaskId() == null) {
                    list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                    if (list == null) {
                        list = new ArrayList<Variables>();
                    }
                    list.add(variables);
                    processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list);
                    continue;
                }
                list = (List)taskVariablesMap.get(variables.getTaskId());
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(variables);
                taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
            }
            for (FlowTask flowTask : datas) {
                Map processMap = (Map)processMsgMap.get(flowTask.getProcessInstId());
                if (processMap != null) {
                    flowTask.setProcessStartTime((Timestamp)processMap.get("processStartTime"));
                    flowTask.setBusinessId((String)processMap.get("businessId"));
                    flowTask.setSendUser((String)processMap.get("startUserId"));
                }
                flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList<Variables>() : (List)taskVariablesMap.get(flowTask.getTaskId()));
                flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInstId()) == null ? new ArrayList<Variables>() : (List)processVariablesMap.get(flowTask.getProcessInstId()));
            }
            object.put("data", this.getTodoResultMap(datas));
            object.put("count", (Object)datas.size());
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("definitionKey", definitionKey);
        Page pages = new Page((long)page.intValue(), (long)rows.intValue());
        List<FlowTask> datas = this.flowEventsServiceMapper.todoList(pages, map);
        if (datas != null) {
            ArrayList<String> taskIds = new ArrayList<String>();
            ArrayList<String> instIds = new ArrayList<String>();
            for (FlowTask flowTask : datas) {
                taskIds.add(flowTask.getTaskId());
                instIds.add(flowTask.getProcessInstId());
            }
            List<Object> allVariables = new ArrayList();
            List<Object> processMsg = new ArrayList();
            if (ToolUtil.isNotEmpty(datas)) {
                instIds = new ArrayList(new HashSet(instIds));
                instIds.remove(null);
                if (instIds.size() > 0) {
                    processMsg = this.flowEventsServiceMapper.getProcessInstMsg(instIds);
                }
                allVariables = this.flowEventsServiceMapper.getAllToDoVariables(taskIds, instIds);
            }
            HashMap<String, Map> processMsgMap = new HashMap<String, Map>();
            for (Map msg : processMsg) {
                processMsgMap.put((String)msg.get("processInstId"), msg);
            }
            HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
            HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
            for (Variables variables : allVariables) {
                List<Variables> list;
                if (variables.getTaskId() == null) {
                    list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                    if (list == null) {
                        list = new ArrayList<Variables>();
                    }
                    list.add(variables);
                    processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list);
                    continue;
                }
                list = (List)taskVariablesMap.get(variables.getTaskId());
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(variables);
                taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
            }
            for (FlowTask flowTask : datas) {
                Map processMap = (Map)processMsgMap.get(flowTask.getProcessInstId());
                if (processMap != null) {
                    flowTask.setProcessStartTime((Timestamp)processMap.get("processStartTime"));
                    flowTask.setBusinessId((String)processMap.get("businessId"));
                    flowTask.setSendUser((String)processMap.get("startUserId"));
                }
                flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList<Variables>() : (List)taskVariablesMap.get(flowTask.getTaskId()));
                flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInstId()) == null ? new ArrayList<Variables>() : (List)processVariablesMap.get(flowTask.getProcessInstId()));
            }
            object.put("data", this.getTodoResultMap(datas));
            object.put("count", (Object)pages.getTotal());
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    private List<Map<String, Object>> getTodoResultMap(List<FlowTask> datas) {
        ArrayList<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>();
        for (FlowTask flowTask : datas) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("variables", flowTask.getProcessVariableMap());
            result.put("definitionName", flowTask.getProcessDefinitionName());
            result.put("formKey", flowTask.getFormKey());
            result.put("businessId", flowTask.getBusinessId());
            result.put("sendUser", flowTask.getSendUser());
            result.put("processInsId", flowTask.getProcessInstId());
            result.put("taskDefinitionKey", flowTask.getTaskDefinitionKey());
            result.put("createTime", flowTask.getStartTime());
            result.put("taskVariables", flowTask.getTaskVariableMap());
            result.put("definitionKey", flowTask.getProcessDefinitionKey());
            result.put("taskSourceFlag", flowTask.getTaskVariableMap().get("taskSourceFlag"));
            result.put("taskId", flowTask.getTaskId());
            result.put("definitionId", flowTask.getProcessDefinitionId());
            resultData.add(result);
        }
        return resultData;
    }

    @Override
    public BpmResponseResult queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("definitionKey", definitionKey);
        List<FlowTask> datas = this.flowEventsServiceMapper.doneList(null, map);
        if (datas != null) {
            ArrayList<String> taskIds = new ArrayList<String>();
            ArrayList<String> instIds = new ArrayList<String>();
            for (FlowTask flowTask : datas) {
                taskIds.add(flowTask.getTaskId());
                instIds.add(flowTask.getProcessInstId());
            }
            List<Object> allVariables = new ArrayList();
            List<Object> processMsg = new ArrayList();
            if (ToolUtil.isNotEmpty(datas)) {
                instIds = new ArrayList(new HashSet(instIds));
                instIds.remove(null);
                if (instIds.size() == 0) {
                    instIds = null;
                } else {
                    processMsg = this.flowEventsServiceMapper.getProcessInstMsg(instIds);
                }
                allVariables = this.flowEventsServiceMapper.getAllVariables(taskIds, instIds);
            }
            HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
            HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
            HashMap<String, Map> processMsgMap = new HashMap<String, Map>();
            for (Map msg : processMsg) {
                processMsgMap.put((String)msg.get("processInstId"), msg);
            }
            for (Variables variables : allVariables) {
                List<Variables> list;
                if (variables.getTaskId() == null) {
                    list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                    if (list == null) {
                        list = new ArrayList<Variables>();
                    }
                    list.add(variables);
                    processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list);
                    continue;
                }
                list = (List)taskVariablesMap.get(variables.getTaskId());
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(variables);
                taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
            }
            for (FlowTask flowTask : datas) {
                Map processMap = (Map)processMsgMap.get(flowTask.getProcessInstId());
                if (processMap != null) {
                    flowTask.setProcessStartTime((Timestamp)processMap.get("processStartTime"));
                    flowTask.setProcessEndTime((Timestamp)processMap.get("processEndTime"));
                    flowTask.setBusinessId((String)processMap.get("businessId"));
                }
                flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList<Variables>() : (List)taskVariablesMap.get(flowTask.getTaskId()));
                flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInstId()) == null ? new ArrayList<Variables>() : (List)processVariablesMap.get(flowTask.getProcessInstId()));
            }
            object.put("data", this.getDoneResultMap(datas));
            object.put("count", (Object)datas.size());
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("definitionKey", definitionKey);
        Page pages = new Page((long)page.intValue(), (long)rows.intValue());
        List<FlowTask> datas = this.flowEventsServiceMapper.doneList(pages, map);
        if (datas != null) {
            ArrayList<String> taskIds = new ArrayList<String>();
            ArrayList<String> instIds = new ArrayList<String>();
            for (FlowTask flowTask : datas) {
                taskIds.add(flowTask.getTaskId());
                instIds.add(flowTask.getProcessInstId());
            }
            List<Object> allVariables = new ArrayList();
            List<Object> processMsg = new ArrayList();
            if (ToolUtil.isNotEmpty(datas)) {
                instIds = new ArrayList(new HashSet(instIds));
                instIds.remove(null);
                if (instIds.size() == 0) {
                    instIds = null;
                } else {
                    processMsg = this.flowEventsServiceMapper.getProcessInstMsg(instIds);
                }
                allVariables = this.flowEventsServiceMapper.getAllVariables(taskIds, instIds);
            }
            HashMap<String, Map> processMsgMap = new HashMap<String, Map>();
            for (Map msg : processMsg) {
                processMsgMap.put((String)msg.get("processInstId"), msg);
            }
            HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
            HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
            for (Variables variables : allVariables) {
                List<Variables> list;
                if (variables.getTaskId() == null) {
                    list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                    if (list == null) {
                        list = new ArrayList<Variables>();
                    }
                    list.add(variables);
                    processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list);
                    continue;
                }
                list = (List)taskVariablesMap.get(variables.getTaskId());
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(variables);
                taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
            }
            for (FlowTask flowTask : datas) {
                Map processMap = (Map)processMsgMap.get(flowTask.getProcessInstId());
                if (processMap != null) {
                    flowTask.setProcessStartTime((Timestamp)processMap.get("processStartTime"));
                    flowTask.setProcessEndTime((Timestamp)processMap.get("processEndTime"));
                    flowTask.setBusinessId((String)processMap.get("businessId"));
                }
                flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList<Variables>() : (List)taskVariablesMap.get(flowTask.getTaskId()));
                flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInstId()) == null ? new ArrayList<Variables>() : (List)processVariablesMap.get(flowTask.getProcessInstId()));
            }
            object.put("data", this.getDoneResultMap(datas));
            object.put("count", (Object)pages.getTotal());
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    private List<Map<String, Object>> getDoneResultMap(List<FlowTask> datas) {
        ArrayList<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>();
        for (FlowTask flowTask : datas) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("variables", flowTask.getProcessVariableMap());
            result.put("definitionName", flowTask.getProcessDefinitionName());
            result.put("formKey", flowTask.getFormKey());
            result.put("formDetailKey", flowTask.getTaskVariableMap().get("formDetailKey"));
            result.put("businessId", flowTask.getBusinessId());
            result.put("sendUser", flowTask.getSendUser());
            result.put("processInsId", flowTask.getProcessInstId());
            result.put("taskDefinitionKey", flowTask.getTaskDefinitionKey());
            result.put("taskDefinitionName", flowTask.getName());
            result.put("taskVariables", flowTask.getTaskVariableMap());
            result.put("definitionKey", flowTask.getProcessDefinitionKey());
            result.put("taskSourceFlag", flowTask.getTaskVariableMap().get("taskSourceFlag"));
            result.put("startTime", flowTask.getStartTime());
            result.put("endTime", flowTask.getEndTime());
            result.put("taskId", flowTask.getTaskId());
            result.put("definitionId", flowTask.getProcessDefinitionId());
            resultData.add(result);
        }
        return resultData;
    }

    @Override
    public BpmResponseResult queryUserTaskCount(String userId) {
        List<Map<String, String>> list = this.processCountMapper.getUserTask(userId);
        JSONArray json = new JSONArray();
        json.add(list);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryUserTaskCountByNode(String userId) {
        List<Map<String, String>> list = this.processCountMapper.getUserTaskByNode(userId);
        JSONArray json = new JSONArray();
        json.add(list);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult claimTask(String taskId, String userId) {
        this.taskService.claim(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 0);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult unClaimTask(String taskId) {
        this.taskService.unclaim(taskId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, null, null, 1);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.getResult("0", prepareReturn.getMessage(), null);
        }
        TaskEntity task = prepareReturn.getTaskEntity();
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        String processInstanceId = task.getProcessInstanceId();
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        this.complete((Task)task, userId, null, map);
        this.dataPush((Task)task, "", userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteResultHandleCmd(userId, processInstanceId, task.getTaskDefinitionKey()));
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.getResult("0", prepareReturn.getMessage(), null);
        }
        TaskEntity task = prepareReturn.getTaskEntity();
        if (map == null) {
            map = new HashMap<String, Object>(1);
        }
        String processInstanceId = task.getProcessInstanceId();
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            map.put("appoint_assignee", assigneeMap);
        }
        this.complete((Task)task, userId, null, map);
        this.dataPush((Task)task, "", userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteResultHandleCmd(userId, processInstanceId, task.getTaskDefinitionKey()));
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.getResult("0", prepareReturn.getMessage(), null);
        }
        TaskEntity task = prepareReturn.getTaskEntity();
        if (map == null) {
            map = new HashMap<String, Object>(1);
        }
        String processInstanceId = task.getProcessInstanceId();
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            map.put("appoint_assignee", assigneeMap);
        }
        this.complete((Task)task, userId, comment, map);
        this.dataPush((Task)task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteResultHandleCmd(userId, processInstanceId, task.getTaskDefinitionKey()));
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        long authorityStart = System.currentTimeMillis();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.getResult("0", prepareReturn.getMessage(), null);
        }
        long authorityEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4efb\u52a1\u9274\u6743\u8017\u65f6\uff1a" + (authorityEnd - authorityStart));
            LOGGER.info("\u4efb\u52a1\u9274\u6743\u8017\u65f6\uff1a" + (authorityEnd - authorityStart));
        }
        TaskEntity task = prepareReturn.getTaskEntity();
        if (map == null) {
            map = new HashMap<String, Object>(2);
        }
        String processInstanceId = task.getProcessInstanceId();
        long addCommentEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4efb\u52a1\u6dfb\u52a0\u529e\u7406\u610f\u89c1\u8017\u65f6\uff1a" + (addCommentEnd - authorityEnd));
            LOGGER.info("\u4efb\u52a1\u6dfb\u52a0\u529e\u7406\u610f\u89c1\u8017\u65f6\uff1a" + (addCommentEnd - authorityEnd));
        }
        if (users != null && users.size() > 0) {
            map.put("cc_user", users);
        }
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            map.put("appoint_assignee", assigneeMap);
        }
        this.complete((Task)task, userId, comment, map);
        long pushStart = System.currentTimeMillis();
        this.dataPush((Task)task, comment, userId, "complete");
        long pushEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u529e\u7406\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (pushEnd - pushStart));
            LOGGER.info("\u529e\u7406\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (pushEnd - pushStart));
        }
        long start = System.currentTimeMillis();
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteResultHandleCmd(userId, processInstanceId, task.getTaskDefinitionKey()));
        long end = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u63d0\u4ea4\u8fd4\u56de\u503c\u7ec4\u88c5\uff1a" + (end - start));
            LOGGER.info("\u63d0\u4ea4\u8fd4\u56de\u503c\u7ec4\u88c5\uff1a" + (end - start));
            System.out.println("\u63d0\u4ea4\u603b\u8017\u65f6\uff1a" + (end - authorityStart));
            LOGGER.info("\u63d0\u4ea4\u603b\u8017\u65f6\uff1a" + (end - authorityStart));
        }
        System.out.println("\u63d0\u4ea4\u7ed3\u675f*****************************************");
        LOGGER.info("\u63d0\u4ea4\u7ed3\u675f*****************************************");
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult completeTaskWithOutCheck(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        long authorityStart = System.currentTimeMillis();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, true, true));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.getResult("0", prepareReturn.getMessage(), null);
        }
        long authorityEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4efb\u52a1\u9274\u6743\u8017\u65f6\uff1a" + (authorityEnd - authorityStart));
            LOGGER.info("\u4efb\u52a1\u9274\u6743\u8017\u65f6\uff1a" + (authorityEnd - authorityStart));
        }
        TaskEntity task = prepareReturn.getTaskEntity();
        if (map == null) {
            map = new HashMap<String, Object>(2);
        }
        String processInstanceId = task.getProcessInstanceId();
        long addCommentEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4efb\u52a1\u6dfb\u52a0\u529e\u7406\u610f\u89c1\u8017\u65f6\uff1a" + (addCommentEnd - authorityEnd));
            LOGGER.info("\u4efb\u52a1\u6dfb\u52a0\u529e\u7406\u610f\u89c1\u8017\u65f6\uff1a" + (addCommentEnd - authorityEnd));
        }
        if (users != null && users.size() > 0) {
            map.put("cc_user", users);
        }
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            map.put("appoint_assignee", assigneeMap);
        }
        this.complete((Task)task, userId, comment, map);
        long pushStart = System.currentTimeMillis();
        this.dataPush((Task)task, comment, userId, "complete");
        long pushEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u529e\u7406\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (pushEnd - pushStart));
            LOGGER.info("\u529e\u7406\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (pushEnd - pushStart));
        }
        long start = System.currentTimeMillis();
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteResultHandleCmd(userId, processInstanceId, task.getTaskDefinitionKey()));
        long end = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u63d0\u4ea4\u8fd4\u56de\u503c\u7ec4\u88c5\uff1a" + (end - start));
            LOGGER.info("\u63d0\u4ea4\u8fd4\u56de\u503c\u7ec4\u88c5\uff1a" + (end - start));
            System.out.println("\u63d0\u4ea4\u603b\u8017\u65f6\uff1a" + (end - authorityStart));
            LOGGER.info("\u63d0\u4ea4\u603b\u8017\u65f6\uff1a" + (end - authorityStart));
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.getResult("0", prepareReturn.getMessage(), null);
        }
        TaskEntity task = prepareReturn.getTaskEntity();
        if (map == null) {
            map = new HashMap<String, Object>(2);
        }
        String processInstanceId = task.getProcessInstanceId();
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        this.complete((Task)task, userId, comment, map);
        this.dataPush((Task)task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteResultHandleCmd(userId, processInstanceId, task.getTaskDefinitionKey()));
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.getResult("0", prepareReturn.getMessage(), null);
        }
        TaskEntity task = prepareReturn.getTaskEntity();
        if (map == null) {
            map = new HashMap<String, Object>(16);
        }
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty((Object)subProcesses)) {
            String[] subs = subProcesses.split(",");
            JSONArray jsonArray = new JSONArray();
            for (String sub : subs) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("businessKey", (Object)"");
                jsonObject.put("processDefinitionKey", (Object)sub);
                jsonObject.put("userId", (Object)"");
                jsonArray.add((Object)jsonObject);
            }
            map.put("call_activity_info", jsonArray);
        }
        String processInstanceId = task.getProcessInstanceId();
        this.complete((Task)task, userId, comment, map);
        this.dataPush((Task)task, comment, userId, "complete");
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteResultHandleCmd(userId, processInstanceId, task.getTaskDefinitionKey()));
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.getResult("0", prepareReturn.getMessage(), null);
        }
        TaskEntity task = prepareReturn.getTaskEntity();
        if (map == null) {
            map = new HashMap<String, Object>(6);
        }
        String processInstanceId = task.getProcessInstanceId();
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            map.put("appoint_assignee", assigneeMap);
        }
        Map<String, Object> localVariables = GetVariableUtil.getVariableMap(taskId, null, 0);
        String rejectFrom = "";
        String rejectType = "";
        if (localVariables != null) {
            rejectFrom = localVariables.get("reject_from") == null ? "" : localVariables.get("reject_from").toString();
            rejectType = localVariables.get("complete_type") == null ? "" : localVariables.get("complete_type").toString();
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty((Object)rejectFrom) && "reject".equals(rejectType)) {
            this.addComment(taskId, comment);
            this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
            String processDefinition = task.getProcessDefinitionId();
            ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
            ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(rejectFrom);
            String executionId = task.getExecutionId();
            String parentId = task.getExecutionId();
            ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
            this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, "complete", destinationActivity, map, currentActivity, null, null));
        } else {
            this.complete((Task)task, userId, comment, map);
            this.dataPush((Task)task, comment, userId, "complete");
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteResultHandleCmd(userId, processInstanceId, task.getTaskDefinitionKey()));
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.getResult("0", prepareReturn.getMessage(), null);
        }
        TaskEntity task = prepareReturn.getTaskEntity();
        if (map == null) {
            map = new HashMap<String, Object>(6);
        }
        String processInstanceId = task.getProcessInstanceId();
        Map<String, Object> localVariables = GetVariableUtil.getVariableMap(taskId, null, 0);
        String rejectFrom = "";
        String rejectType = "";
        if (localVariables != null) {
            rejectFrom = localVariables.get("reject_from") == null ? "" : localVariables.get("reject_from").toString();
            String string = rejectType = localVariables.get("complete_type") == null ? "" : localVariables.get("complete_type").toString();
        }
        if (map == null) {
            map = new HashMap<String, Object>(1);
        }
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            map.put("appoint_assignee", assigneeMap);
        }
        if (ToolUtil.isNotEmpty((Object)rejectFrom) && "reject".equals(rejectType)) {
            this.addComment(taskId, comment);
            this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
            String processDefinition = task.getProcessDefinitionId();
            ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
            ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(rejectFrom);
            String executionId = task.getExecutionId();
            String parentId = task.getExecutionId();
            ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
            this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, "complete", destinationActivity, map, currentActivity, null, null));
        } else {
            if (users != null && users.size() > 0) {
                map.put("cc_user", users);
            }
            this.complete((Task)task, userId, comment, map);
            this.dataPush((Task)task, comment, userId, "complete");
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteResultHandleCmd(userId, processInstanceId, task.getTaskDefinitionKey()));
        return InstallResult.getResult("1", "success", json);
    }

    private boolean auditAuthority(String userId, String taskId) {
        boolean flag = false;
        Set<String> users = this.getAssigneeByTaskId(taskId);
        if (users.contains(userId)) {
            flag = true;
        }
        return flag;
    }

    private void complete(Task task, String userId, String comment, Map<String, Object> map) {
        if (this.needLog) {
            System.out.println("\u4efb\u52a1\u529e\u7406\u5f00\u59cb\uff1a");
            LOGGER.info("\u4efb\u52a1\u529e\u7406\u5f00\u59cb\uff1a");
        }
        long hiStart = System.currentTimeMillis();
        this.setSameLevelTaskIdMessage(task.getId(), "complete", task.getProcessInstanceId(), null);
        long hiEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u5386\u53f2\u4efb\u52a1\u4fdd\u5b58\u8017\u65f6\uff1a" + (hiEnd - hiStart));
            LOGGER.info("\u5386\u53f2\u4efb\u52a1\u4fdd\u5b58\u8017\u65f6\uff1a" + (hiEnd - hiStart));
        }
        this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteWithSetAllPrevNodeCmd(task.getId(), userId, comment, map));
        long end = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4efb\u52a1\u529e\u7406\u8017\u65f6\uff1a" + (end - hiEnd));
            LOGGER.info("\u4efb\u52a1\u529e\u7406\u8017\u65f6\uff1a" + (end - hiEnd));
        }
    }

    @Override
    public void dataPush(Task task, String comment, String userId, String operationType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)task.getId());
        List entrustHiList = this.entrustHiSerive.list((Wrapper)queryWrapper);
        Date entrustEndDate = null;
        if (!entrustHiList.isEmpty()) {
            List entrustHis = entrustHiList.stream().filter(o -> "3".equals(o.getState()) || "5".equals(o.getState())).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(entrustHis)) {
                entrustHis.sort((o1, o2) -> o2.getCreateTime().compareTo(o1.getCreateTime()));
                entrustHis.sort((o1, o2) -> o2.getUpdateTime().compareTo(o1.getUpdateTime()));
            }
            ArrayList<String> entrustHiIds = new ArrayList<String>();
            String user = userId;
            for (EntrustHi entrustHi : entrustHis) {
                if (!user.equals(entrustHi.getConsignee())) continue;
                entrustHiIds.add(entrustHi.getId());
                user = entrustHi.getConsignor();
                if (!ToolUtil.isEmpty(entrustEndDate)) continue;
                entrustEndDate = entrustHi.getUpdateTime();
            }
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"task_id", (Object)task.getId());
            queryWrapper.eq((Object)"consignee", (Object)userId);
            queryWrapper.eq((Object)"state", (Object)"1");
            EntrustHi entrustHi = new EntrustHi();
            entrustHi.setState("0");
            this.entrustHiSerive.update((Object)entrustHi, (Wrapper)queryWrapper);
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"task_id", (Object)task.getId());
            queryWrapper.ne((Object)"state", (Object)"0");
            if (ToolUtil.isNotEmpty(entrustHiIds)) {
                queryWrapper.notIn((Object)"id", entrustHiIds);
            }
            this.entrustHiSerive.remove((Wrapper)queryWrapper);
            if (ToolUtil.isNotEmpty(entrustHiIds)) {
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"task_id", (Object)task.getId());
                queryWrapper.in((Object)"id", entrustHiIds);
                queryWrapper.eq((Object)"state", (Object)"5");
                entrustHi.setState("4");
                this.entrustHiSerive.update((Object)entrustHi, (Wrapper)queryWrapper);
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"task_id", (Object)task.getId());
                queryWrapper.eq((Object)"id", entrustHiIds.get(0));
                queryWrapper.eq((Object)"state", (Object)"3");
                entrustHi.setState("2");
                this.entrustHiSerive.update((Object)entrustHi, (Wrapper)queryWrapper);
                if (ToolUtil.isNotEmpty((Object)entrustEndDate)) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    this.taskEngineMapper.updateHiTaskStartTime(task.getId(), format.format(entrustEndDate));
                }
            }
        }
        try {
            String dataPushAddress;
            TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(task.getTenantId());
            if (tenantConfig != null && "1".equals(tenantConfig.getIsDataPush()) && ToolUtil.isNotEmpty((Object)(dataPushAddress = tenantConfig.getDataPushAddress()))) {
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("action", "update");
                data.put("taskId", task.getId());
                data.put("taskName", task.getName());
                data.put("userId", userId);
                data.put("businessKey", historicProcessInstance.getBusinessKey());
                data.put("taskDefinitionKey", task.getTaskDefinitionKey());
                data.put("processDefinitionId", task.getProcessDefinitionId());
                data.put("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                HashMap map = new HashMap();
                data.put("sendUser", map.get("sendUser"));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (ToolUtil.isNotEmpty((Object)entrustEndDate)) {
                    data.put("startDate", simpleDateFormat.format(entrustEndDate));
                } else {
                    data.put("startDate", simpleDateFormat.format(task.getCreateTime()));
                }
                Date date = new Date();
                data.put("endDate", simpleDateFormat.format(date));
                data.put("url", task.getFormKey());
                data.put("description", map.get("todoConfiguration"));
                data.put("comment", comment);
                data.put("processInstanceId", task.getProcessInstanceId());
                if (ToolUtil.isNotEmpty((Object)operationType)) {
                    long hisTaskNum;
                    if ("complete".equals(operationType) && (hisTaskNum = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).count()) == 2L) {
                        operationType = "submit";
                    }
                    data.put("operationType", operationType);
                }
                DataPushUtil.addData(data);
                if (!"skip".equals(data.get("operationType"))) {
                    DataPushUtil.DataPushReal(dataPushAddress);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5b8c\u6210\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u63a8\u9001\u51fa\u9519");
        }
    }

    private void addComment(String taskId, String comment) {
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
    }

    private BpmResponseResult installReturnValue(String userId, String processInstanceId, String taskDefinitionKey, Map<String, Object> variables) {
        List instance;
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).includeProcessVariables()).includeTaskLocalVariables()).list();
        int state = 0;
        HistoricProcessInstanceEntity processInstance = new HistoricProcessInstanceEntity();
        if (ToolUtil.isEmpty((Object)tasks)) {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            List<String> callActivityInstIds = this.taskEngineMapper.getCallActivityInstId(processInstanceId);
            if (callActivityInstIds.size() > 0 && ToolUtil.isNotEmpty((Object)(tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn((List)callActivityInstIds)).includeTaskLocalVariables()).list()))) {
                state = 1;
            }
            if (ToolUtil.isEmpty((Object)tasks) && ToolUtil.isNotEmpty((Object)processInstance.getSuperProcessInstanceId())) {
                tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getSuperProcessInstanceId())).includeTaskLocalVariables()).list();
                state = 2;
            }
        }
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                String sendUser;
                String completeType;
                String completeFrom;
                Set<String> users = this.getAssigneeByTaskId(t.getId());
                Map map = t.getTaskLocalVariables() == null ? new HashMap(16) : t.getTaskLocalVariables();
                String string = completeFrom = map.get("complete_from") == null ? "" : map.get("complete_from").toString();
                if (ToolUtil.isEmpty((Object)completeFrom)) {
                    this.taskService.setVariableLocal(t.getId(), "complete_from", (Object)taskDefinitionKey);
                }
                String string2 = completeType = map.get("complete_type") == null ? "" : map.get("complete_type").toString();
                if (ToolUtil.isEmpty((Object)completeType)) {
                    this.taskService.setVariableLocal(t.getId(), "complete_type", (Object)"complete");
                }
                String string3 = sendUser = map.get("sendUser") == null ? "" : map.get("sendUser").toString();
                if (ToolUtil.isEmpty((Object)sendUser)) {
                    this.taskService.setVariableLocal(t.getId(), "sendUser", (Object)userId);
                }
                if (state != 0) continue;
                JSONObject object = new JSONObject();
                object.put("processInstanceId", (Object)t.getProcessInstanceId());
                object.put("taskId", (Object)t.getId());
                object.put("userId", (Object)users);
                object.put("taskDefinitionKey", (Object)t.getTaskDefinitionKey());
                object.put("taskDefinitionName", (Object)t.getName());
                object.put("formKey", (Object)t.getFormKey());
                json.add((Object)object);
            }
        }
        if (state == 2) {
            instance = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId()).list();
            boolean isEnd = true;
            for (HistoricActivityInstance historicActivityInstance : instance) {
                if (historicActivityInstance.getEndTime() != null) continue;
                isEnd = false;
                JSONObject object = new JSONObject();
                object.put("mainTaskDefinitionName", (Object)historicActivityInstance.getActivityName());
                object.put("taskDefinitionName", BpmConstant.END_NAME);
                object.put("endTime", (Object)new Date());
                json.add((Object)object);
                break;
            }
            if (isEnd) {
                JSONObject object = new JSONObject();
                object.put("mainTaskDefinitionName", BpmConstant.END_NAME);
                object.put("taskDefinitionName", BpmConstant.END_NAME);
                object.put("endTime", (Object)new Date());
                json.add((Object)object);
            }
        } else if (state == 1) {
            instance = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
            for (HistoricActivityInstance historicActivityInstance : instance) {
                if (historicActivityInstance.getEndTime() != null) continue;
                JSONObject object = new JSONObject();
                object.put("taskDefinitionName", (Object)historicActivityInstance.getActivityName());
                json.add((Object)object);
                break;
            }
        } else if (ToolUtil.isEmpty((Object)tasks)) {
            JSONObject object = new JSONObject();
            object.put("taskDefinitionName", BpmConstant.END_NAME);
            object.put("endTime", (Object)new Date());
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    private void setVariables(Task task, Map<String, Object> variables) {
        Map<String, String> map = AnalyticalModelUtil.getTodoConfiguration(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (map.size() == 0) {
            return;
        }
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        if (variables == null) {
            variables = new HashMap<String, Object>(16);
        }
        variables.putAll(processMap);
        variables.putAll(taskMap);
        String todo = variables.size() > 0 ? AnalyticalModelUtil.getTodo(variables, map.get("todoConfiguration")) : map.get("todoConfiguration");
        this.taskService.setVariableLocal(task.getId(), "todoConfiguration", (Object)todo);
    }

    private String getTaskCommitUser(String processInstanceId, String backActivityId) {
        StringBuffer assignee = new StringBuffer();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).finished().orderByHistoricTaskInstanceEndTime().includeTaskLocalVariables()).desc()).list();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            block0: for (int i = 0; i < hisTaskList.size(); ++i) {
                String taskSourceFlag = (String)((HistoricTaskInstance)hisTaskList.get(i)).getTaskLocalVariables().get("taskSourceFlag");
                if ("reject".equals(taskSourceFlag) || "revoke".equals(taskSourceFlag) || "revokeReject".equals(taskSourceFlag) || taskSourceFlag == null) continue;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                Date start = historicTaskInstance.getStartTime();
                assignee.append(historicTaskInstance.getAssignee());
                for (int j = i; j < hisTaskList.size(); ++j) {
                    historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j);
                    if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break block0;
                    assignee.append(",").append(historicTaskInstance.getAssignee());
                }
                break;
            }
        }
        return assignee.toString();
    }

    private boolean canReject(BpmnModel bm, String startNodeId, String nodeId, List<String> nodes, List<String> freeJumpList, boolean isPre) {
        FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(startNodeId);
        ArrayList<String> newNodes = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(nodes)) {
            newNodes.addAll(nodes);
        }
        if (element instanceof ParallelGateway || element instanceof InclusiveGateway) {
            boolean isFreeJump = freeJumpList != null;
            boolean canFreeJump = true;
            for (SequenceFlow sequenceFlow : isPre ? ((Gateway)element).getIncomingFlows() : ((Gateway)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList == null) continue;
                    freeJumpList.add(nodeId);
                    continue;
                }
                newNodes.add(preNode);
                if (this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                if (isFreeJump) {
                    canFreeJump = false;
                    continue;
                }
                return false;
            }
            return canFreeJump;
        }
        if (!(element instanceof StartEvent) && !(element instanceof EndEvent)) {
            for (SequenceFlow sequenceFlow : isPre ? ((FlowNode)element).getIncomingFlows() : ((FlowNode)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList != null) {
                        freeJumpList.add(nodeId);
                    }
                    return true;
                }
                newNodes.add(preNode);
                if (!this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        BpmnModel bm;
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeProcessVariables()).includeTaskLocalVariables()).singleResult();
        String key = task.getTaskDefinitionKey();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        String nowKey = this.getNowKey(taskId);
        String backActivityId = this.getLastActivityId(task);
        if (backActivityId != null && backActivityId.equals(this.getFirstActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            map.put("reject_appoint_assignee", assignees);
        }
        if (isSubmit) {
            assignees = this.getTaskCommitUser(task.getProcessInstanceId(), backActivityId);
            map.put("reject_appoint_assignee", assignees);
        }
        if (backActivityId != null && !this.canReject(bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId()), task.getTaskDefinitionKey(), backActivityId, null, null, true) && !this.canReject(bm, task.getTaskDefinitionKey(), backActivityId, null, null, false)) {
            return InstallResult.getResult("0", "\u7981\u6b62\u9a73\u56de\u81f3\u76ee\u6807\u8282\u70b9\uff01", null);
        }
        Map<String, Object> result = this.backTypes(task, backActivityId, false, userId, comment, "reject");
        int backType = (Integer)result.get("num");
        if (backType == 0) {
            return InstallResult.getResult("0", "\u7981\u6b62\u9a73\u56de\u81f3\u76ee\u6807\u8282\u70b9\uff01", null);
        }
        this.setSameLevelTaskIdMessageOld(taskId, "reject");
        this.rejectTask(userId, task, backActivityId, comment, map, backType, "reject");
        BpmResponseResult bpmResponseResult = this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId, backActivityId, userId, task.getTaskDefinitionKey(), "reject", task.getName());
        JSONArray array = bpmResponseResult.getResult();
        boolean needReject = false;
        String rejectTaskId = "";
        if (ToolUtil.isNotEmpty((Object)array)) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = array.getJSONObject(i);
                if (!object.get((Object)"taskDefinitionKey").equals(backActivityId) || !ToolUtil.isEmpty((Object)object.get((Object)"userId"))) continue;
                needReject = true;
                rejectTaskId = object.get((Object)"taskId") == null ? "" : object.get((Object)"taskId").toString();
                break;
            }
        }
        if (needReject) {
            this.rejectToLastTask(rejectTaskId, userId, comment, assignees, isSubmit, map);
        }
        this.dataPush(task, comment, userId, "reject");
        if (backType == 2) {
            this.entrustHiSerive.removeMultiRejectRevokeHistoryBytaskId(taskId);
        }
        this.setBackToJointlyMessage(taskId, key, nowKey);
        return bpmResponseResult;
    }

    @Override
    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        BpmnModel bm;
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeProcessVariables()).includeTaskLocalVariables()).taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        String firstTaskId = this.getFirstActivityId(taskId);
        String starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            map.put("reject_appoint_assignee", assignees);
        }
        if (isSubmit) {
            assignees = this.getTaskCommitUser(task.getProcessInstanceId(), firstTaskId);
            map.put("reject_appoint_assignee", assignees);
        }
        if (firstTaskId != null && !this.canReject(bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId()), task.getTaskDefinitionKey(), firstTaskId, null, null, true) && !this.canReject(bm, task.getTaskDefinitionKey(), firstTaskId, null, null, false)) {
            return InstallResult.getResult("0", "\u7981\u6b62\u9a73\u56de\u81f3\u76ee\u6807\u8282\u70b9\uff01", null);
        }
        Map<String, Object> result = this.backTypes(task, firstTaskId, false, userId, comment, "reject");
        int backType = (Integer)result.get("num");
        if (backType == 0) {
            return InstallResult.getResult("0", "\u7981\u6b62\u9a73\u56de\u81f3\u76ee\u6807\u8282\u70b9\uff01", null);
        }
        this.setSameLevelTaskIdMessageOld(taskId, "reject");
        List taskList = new ArrayList();
        HashMap<String, String> assigneeMap = new HashMap<String, String>();
        if (backType == 2) {
            taskList = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).list();
            for (Task t : taskList) {
                List identityLinks;
                String assignee = t.getAssignee();
                if (ToolUtil.isEmpty((Object)assignee) && ToolUtil.isNotEmpty((Object)(identityLinks = this.taskService.getIdentityLinksForTask(t.getId())))) {
                    assignee = ((IdentityLink)identityLinks.get(0)).getUserId();
                }
                assigneeMap.put(t.getId(), assignee);
            }
        }
        this.rejectTask(userId, task, firstTaskId, comment, map, backType, "reject");
        if (backType == 2) {
            if (ToolUtil.isNotEmpty(taskList)) {
                for (Task t : taskList) {
                    this.dataPush(t, comment, (String)assigneeMap.get(t.getId()), "multiReject");
                }
            }
        } else {
            this.dataPush(task, comment, userId, "reject");
        }
        return this.installRejectReturnValue(task.getProcessInstanceId(), true, starterUserId, firstTaskId, userId, task.getTaskDefinitionKey(), "reject", task.getName());
    }

    public String getAssigneesByNodeId(String taskId, String nodeId, String tenantId) {
        BpmResponseResult bpmResponseResult = this.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, new HashMap<String, Object>());
        JSONArray arrays = bpmResponseResult.getResult();
        String assignees = "";
        for (int i = 0; i < arrays.size(); ++i) {
            Map mapss = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)arrays.get(i)), Map.class);
            String ids = mapss.get("id").toString();
            assignees = ToolUtil.isNotEmpty((Object)assignees) ? assignees + "," + ids : ids;
        }
        return assignees;
    }

    @Override
    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        BpmnModel bm;
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeProcessVariables()).includeTaskLocalVariables()).taskId(taskId)).singleResult();
        String nowKey = this.getNowKey(taskId);
        String key = task.getTaskDefinitionKey();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        if (backActivityId != null && backActivityId.equals(this.getFirstActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            map.put("reject_appoint_assignee", assignees);
        }
        if (isSubmit) {
            assignees = this.getTaskCommitUser(task.getProcessInstanceId(), backActivityId);
            map.put("reject_appoint_assignee", assignees);
        }
        if (backActivityId != null && !this.canReject(bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId()), task.getTaskDefinitionKey(), backActivityId, null, null, true) && !this.canReject(bm, task.getTaskDefinitionKey(), backActivityId, null, null, false)) {
            return InstallResult.getResult("0", "\u7981\u6b62\u9a73\u56de\u81f3\u76ee\u6807\u8282\u70b9\uff01", null);
        }
        Map<String, Object> result = this.backTypes(task, backActivityId, false, userId, comment, "reject");
        int backType = (Integer)result.get("num");
        if (backType == 0) {
            return InstallResult.getResult("0", "\u7981\u6b62\u9a73\u56de\u81f3\u76ee\u6807\u8282\u70b9\uff01", null);
        }
        this.setSameLevelTaskIdMessageOld(taskId, "reject");
        this.rejectTask(userId, task, backActivityId, comment, map, backType, "reject");
        this.dataPush(task, comment, userId, "reject");
        if (backType == 2) {
            this.entrustHiSerive.removeMultiRejectRevokeHistoryBytaskId(taskId);
        }
        this.setBackToJointlyMessage(taskId, key, nowKey);
        return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId, backActivityId, userId, task.getTaskDefinitionKey(), "reject", task.getName());
    }

    @Override
    public BpmResponseResult queryRejectNode(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm != null) {
            List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
            List<String> hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
            JSONArray json = new JSONArray();
            Process process = bm.getMainProcess();
            UserTask userTask = (UserTask)process.getFlowElement(task.getTaskDefinitionKey());
            HashSet<String> ids = new HashSet<String>();
            ids.add(task.getTaskDefinitionKey());
            this.getPreviousNode(bm, json, userTask.getIncomingFlows(), hisTaskDefinitionKey, ids);
            return InstallResult.getResult("1", "success", json);
        }
        return InstallResult.getResult("0", "\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff01", null);
    }

    private void getPreviousNode(BpmnModel bm, JSONArray json, List<SequenceFlow> incomingFlows, List<String> hisTaskDefinitionKey, Set<String> ids) {
        SequenceFlow sequenceFlow;
        FlowElement flowElement;
        Process process = (Process)bm.getProcesses().get(0);
        Iterator<SequenceFlow> iterator = incomingFlows.iterator();
        while (iterator.hasNext() && !((flowElement = process.getFlowElement((sequenceFlow = iterator.next()).getSourceRef())) instanceof StartEvent)) {
            if (ids.contains(flowElement.getId())) continue;
            if (flowElement instanceof UserTask) {
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                if (!json.contains((Object)object) && hisTaskDefinitionKey.contains(flowElement.getId())) {
                    json.add((Object)object);
                } else {
                    ids.add(flowElement.getId());
                }
                this.getPreviousNode(bm, json, ((UserTask)flowElement).getIncomingFlows(), hisTaskDefinitionKey, ids);
                continue;
            }
            this.getPreviousNode(bm, json, ((FlowNode)flowElement).getIncomingFlows(), hisTaskDefinitionKey, ids);
        }
    }

    private BpmResponseResult installRejectReturnValue(String processInstanceId, boolean isFirst, String starterUserId, String backActivityId, String userId, String taskDefinitionKey, String type, String name) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).includeProcessVariables()).includeTaskLocalVariables()).active().list();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).includeTaskLocalVariables()).includeProcessVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
        if (hisTaskList == null || hisTaskList.size() <= 0) {
            return InstallResult.getResult("0", "error", null);
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                String todo;
                String rejectName;
                String completeType;
                String rejectFrom;
                String completeFrom;
                String sendUser;
                Set<String> users = this.getAssigneeByTaskId(t.getId());
                if (isFirst && t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && users.size() == 0) {
                    this.taskService.setAssignee(t.getId(), starterUserId);
                }
                Map map = t.getTaskLocalVariables() == null ? new HashMap(16) : t.getTaskLocalVariables();
                String string = sendUser = map.get("sendUser") == null ? "" : map.get("sendUser").toString();
                if (ToolUtil.isEmpty((Object)sendUser)) {
                    this.taskService.setVariableLocal(t.getId(), "sendUser", (Object)userId);
                }
                String string2 = completeFrom = map.get("complete_from") == null ? "" : map.get("complete_from").toString();
                if (ToolUtil.isEmpty((Object)completeFrom)) {
                    this.taskService.setVariableLocal(t.getId(), "complete_from", historicTaskInstance.getTaskLocalVariables().get("complete_from"));
                }
                String string3 = rejectFrom = map.get("reject_from") == null ? "" : map.get("reject_from").toString();
                if (ToolUtil.isEmpty((Object)rejectFrom) && ToolUtil.isEmpty((Object)completeFrom)) {
                    this.taskService.setVariableLocal(t.getId(), "reject_from", (Object)taskDefinitionKey);
                }
                String string4 = completeType = map.get("complete_type") == null ? "" : map.get("complete_type").toString();
                if (ToolUtil.isEmpty((Object)completeType)) {
                    this.taskService.setVariableLocal(t.getId(), "complete_type", (Object)type);
                }
                String string5 = rejectName = map.get("reject_name") == null ? "" : map.get("reject_name").toString();
                if (ToolUtil.isEmpty((Object)rejectName)) {
                    this.taskService.setVariableLocal(t.getId(), "reject_name", (Object)name);
                }
                String string6 = todo = map.get("todoConfiguration") == null ? "" : map.get("todoConfiguration").toString();
                if (ToolUtil.isEmpty((Object)todo)) {
                    this.taskService.setVariableLocal(t.getId(), "todoConfiguration", historicTaskInstance.getTaskLocalVariables().get("todoConfiguration"));
                }
                JSONObject object = new JSONObject();
                object.put("processInstanceId", (Object)t.getProcessInstanceId());
                object.put("taskId", (Object)t.getId());
                object.put("userId", users);
                object.put("taskDefinitionKey", (Object)t.getTaskDefinitionKey());
                object.put("taskDefinitionName", (Object)t.getName());
                object.put("formKey", (Object)t.getFormKey());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    private BpmResponseResult installRejectReturnValue(String processInstanceId, String backActivityId, String userId, String taskDefinitionKey, String type, String name) {
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).includeTaskLocalVariables()).includeProcessVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
        if (hisTaskList == null || hisTaskList.size() <= 0) {
            return InstallResult.getResult("0", "error", null);
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
        String assignee = historicTaskInstance.getAssignee();
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).includeProcessVariables()).includeTaskLocalVariables()).active().list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                String sendUser;
                if (t.getTaskDefinitionKey().equals(backActivityId)) {
                    Set<String> userSet = this.getAssigneeByTaskId(t.getId());
                    for (String user : userSet) {
                        this.taskService.deleteCandidateUser(t.getId(), user);
                    }
                    this.taskService.addCandidateUser(t.getId(), assignee);
                }
                Map map = t.getTaskLocalVariables() == null ? new HashMap(16) : t.getTaskLocalVariables();
                String string = sendUser = map.get("sendUser") == null ? "" : map.get("sendUser").toString();
                if (ToolUtil.isEmpty((Object)sendUser)) {
                    String todo;
                    String rejectName;
                    String completeType;
                    String rejectFrom;
                    String completeFrom;
                    this.taskService.setVariableLocal(t.getId(), "sendUser", (Object)userId);
                    String string2 = completeFrom = map.get("complete_from") == null ? "" : map.get("complete_from").toString();
                    if (ToolUtil.isEmpty((Object)completeFrom)) {
                        this.taskService.setVariableLocal(t.getId(), "complete_from", historicTaskInstance.getTaskLocalVariables().get("complete_from"));
                    }
                    String string3 = rejectFrom = map.get("reject_from") == null ? "" : map.get("reject_from").toString();
                    if (ToolUtil.isEmpty((Object)rejectFrom)) {
                        this.taskService.setVariableLocal(t.getId(), "reject_from", (Object)taskDefinitionKey);
                    }
                    String string4 = completeType = map.get("complete_type") == null ? "" : map.get("complete_type").toString();
                    if (ToolUtil.isEmpty((Object)completeType)) {
                        this.taskService.setVariableLocal(t.getId(), "complete_type", (Object)type);
                    }
                    String string5 = rejectName = map.get("reject_name") == null ? "" : map.get("reject_name").toString();
                    if (ToolUtil.isEmpty((Object)rejectName)) {
                        this.taskService.setVariableLocal(t.getId(), "reject_name", (Object)name);
                    }
                    String string6 = todo = map.get("todoConfiguration") == null ? "" : map.get("todoConfiguration").toString();
                    if (ToolUtil.isEmpty((Object)todo)) {
                        this.taskService.setVariableLocal(t.getId(), "todoConfiguration", historicTaskInstance.getTaskLocalVariables().get("todoConfiguration"));
                    }
                }
                JSONObject object = new JSONObject();
                object.put("processInstanceId", (Object)t.getProcessInstanceId());
                object.put("taskId", (Object)t.getId());
                HashSet<String> users = new HashSet<String>();
                users.add(assignee);
                object.put("userId", users);
                object.put("taskDefinitionKey", (Object)t.getTaskDefinitionKey());
                object.put("taskDefinitionName", (Object)t.getName());
                object.put("formKey", (Object)t.getFormKey());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    public List<SysActHiLine> getResult(List<SysActHiLine> list, List<SysActHiLine> result, String startId, String endId) {
        List l1 = list.stream().filter(lineHis -> startId.equals(lineHis.getOutNode())).collect(Collectors.toList());
        if (l1.size() > 0) {
            if (endId.equals(((SysActHiLine)((Object)l1.get(0))).getInNode())) {
                result.add((SysActHiLine)((Object)l1.get(0)));
                return result;
            }
            if (!result.contains(l1.get(0))) {
                result.add((SysActHiLine)((Object)l1.get(0)));
                this.getResult(list, result, ((SysActHiLine)((Object)l1.get(0))).getInNode(), endId);
            }
        }
        return result;
    }

    private void rejectTask(String userId, Task task, String backActivityId, String comment, Map<String, Object> map, int backType, String type) {
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(task.getId(), null, "complete", comment);
        }
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("is_normal_commit", false);
        this.taskService.setVariablesLocal(task.getId(), variables);
        switch (backType) {
            case 2: {
                this.multiInstanceReject(userId, task, backActivityId, type, map);
                break;
            }
            case 3: {
                this.parallelReject(userId, task, backActivityId, type, comment, map);
                break;
            }
            default: {
                this.commonReject(userId, task, backActivityId, type, map);
            }
        }
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(task.getId());
        }
    }

    private void parallelReject(String userId, Task task, String backActivityId, String type, String comment, Map<String, Object> map) {
        if (ToolUtil.isNotEmpty((Object)userId)) {
            this.claimTask(task.getId(), userId);
        }
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId(task.getTaskDefinitionKey()).processInstanceId(task.getProcessInstanceId()).singleResult();
        String parentId = execution.getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, executionId, parentId, destinationActivity, type, comment, map, currentActivity));
    }

    private void commonReject(String userId, Task task, String backActivityId, String type, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.claimTask(task.getId(), userId);
        }
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        String parentId = task.getExecutionId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, type, destinationActivity, map, currentActivity, null, null));
    }

    private void multiInstanceReject(String userId, Task task, String backActivityId, String type, Map<String, Object> map) {
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        List execution = this.runtimeService.createExecutionQuery().processInstanceId(task.getProcessInstanceId()).activityId(task.getTaskDefinitionKey()).list();
        String parentId = ((Execution)execution.get(0)).getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceJumpTaskCmd(userId, executionId, parentId, type, destinationActivity, map, currentActivity, task.getId()));
    }

    private String getLastActivityId(Task task) {
        Map map = task.getTaskLocalVariables() == null ? new HashMap(16) : task.getTaskLocalVariables();
        return map.get("complete_from") == null ? "" : map.get("complete_from").toString();
    }

    private String getFirstActivityId(String taskId) {
        BpmResponseResult allNodeInfo = this.queryHistoryActByTaskId(taskId);
        JSONArray jsonArray = allNodeInfo.getResult();
        JSONObject jsonObject = new JSONObject();
        if (jsonArray != null && jsonArray.size() > 0) {
            jsonObject = jsonArray.getJSONObject(jsonArray.size() - 1);
        }
        return jsonObject.getString("nodeId") == null ? "" : jsonObject.getString("nodeId");
    }

    private String getNextActivityId(String taskId) {
        BpmResponseResult allNodeInfo = this.queryHistoryActByTaskId(taskId);
        JSONArray jsonArray = allNodeInfo.getResult();
        JSONObject jsonObject = new JSONObject();
        if (jsonArray != null && jsonArray.size() > 0) {
            jsonObject = jsonArray.getJSONObject(0);
        }
        return jsonObject.getString("nodeId") == null ? "" : jsonObject.getString("nodeId");
    }

    private String getFirstActivityId(Task task) {
        BpmResponseResult allNodeInfo = this.queryHistoryActByTaskId(task.getId());
        JSONArray jsonArray = allNodeInfo.getResult();
        JSONObject jsonObject = new JSONObject();
        if (jsonArray != null && jsonArray.size() > 0) {
            jsonObject = jsonArray.getJSONObject(jsonArray.size() - 1);
        }
        if (jsonArray != null && jsonArray.size() == 0) {
            return task.getTaskDefinitionKey();
        }
        return jsonObject.getString("nodeId") == null ? "" : jsonObject.getString("nodeId");
    }

    @Override
    public BpmResponseResult delegateTask(String taskId, String userId) {
        this.taskService.delegateTask(taskId, userId);
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"entrust");
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 1);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult entrustTask(String taskId, String userId, String consignee, String comment) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userId, taskId, consignee})) {
            return InstallResult.getResult("0", "\u59d4\u6258\u5931\u8d25\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
        }
        if (userId.equals(consignee)) {
            return InstallResult.getResult("0", "\u88ab\u8f6c\u529e\u4eba\u4e0d\u80fd\u662f\u81ea\u5df1", null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        Map<String, Object> localVariable = GetVariableUtil.getVariableMap(task.getId(), null, 0);
        Set<String> users = this.getAssigneeByTaskId(taskId);
        if (ToolUtil.isEmpty(users) || !users.contains(userId)) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4eba\u5458\u65e0\u6743\u8f6c\u529e", null);
        }
        if (ToolUtil.isNotEmpty(users) && users.contains(consignee)) {
            return InstallResult.getResult("0", "\u88ab\u8f6c\u529e\u4eba\u5df2\u5b58\u5728\u4e8e\u4efb\u52a1\u8282\u70b9", null);
        }
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userId, consignee));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)taskId);
        queryWrapper.eq((Object)"consignee", (Object)userId);
        queryWrapper.eq((Object)"state", (Object)"1");
        this.entrustHiSerive.remove((Wrapper)queryWrapper);
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)taskId);
        queryWrapper.eq((Object)"consignee", (Object)userId);
        queryWrapper.eq((Object)"state", (Object)"3");
        List entrustHis = this.entrustHiSerive.list((Wrapper)queryWrapper);
        Date date = task.getCreateTime();
        for (EntrustHi oldEntrustHi : entrustHis) {
            if (date.before(oldEntrustHi.getUpdateTime())) {
                date = oldEntrustHi.getUpdateTime();
            }
            oldEntrustHi.setState("5");
        }
        this.entrustHiSerive.updateBatchById(entrustHis);
        EntrustHi entrustHi = new EntrustHi(taskId, task.getTaskDefinitionKey(), task.getName(), task.getProcessDefinitionId().split(":")[0], task.getProcessInstanceId(), userId, consignee, date, "3", "");
        entrustHi.setComments(comment);
        entrustHi.setUpdateTime(new Date());
        this.entrustHiSerive.save((Object)entrustHi);
        this.entrustDataPush(task, userId, consignee, comment, date, entrustHi.getUpdateTime(), "entrust", "entrust", localVariable);
        this.activityRedisTimerService.updateTimeOutModel(taskId, consignee, userId, 0);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult cancelEntrustTask(String taskId, String userId, String comment) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userId, taskId})) {
            return InstallResult.getResult("0", "\u59d4\u6258\u5931\u8d25\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        Map<String, Object> localVariable = GetVariableUtil.getVariableMap(task.getId(), null, 0);
        String nodeid = task.getTaskDefinitionKey();
        String consignee = this.getAssigneesByNodeId(taskId, nodeid, task.getTenantId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)taskId);
        queryWrapper.eq((Object)"consignor", (Object)userId);
        queryWrapper.eq((Object)"state", (Object)"3");
        List entrustHisss = this.entrustHiSerive.list((Wrapper)queryWrapper);
        String consignees = userId;
        if (ToolUtil.isNotEmpty((Object)entrustHisss)) {
            consignees = ((EntrustHi)((Object)entrustHisss.get(0))).getConsignee();
        }
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, consignees, userId));
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)taskId);
        queryWrapper.eq((Object)"consignor", (Object)userId);
        queryWrapper.eq((Object)"state", (Object)"1");
        this.entrustHiSerive.remove((Wrapper)queryWrapper);
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)taskId);
        queryWrapper.eq((Object)"consignor", (Object)userId);
        queryWrapper.eq((Object)"state", (Object)"3");
        List entrustHis = this.entrustHiSerive.list((Wrapper)queryWrapper);
        Date date = task.getCreateTime();
        if (ToolUtil.isNotEmpty((Object)entrustHis)) {
            for (EntrustHi oldEntrustHi : entrustHis) {
                if (date.before(oldEntrustHi.getUpdateTime())) {
                    date = oldEntrustHi.getUpdateTime();
                }
                oldEntrustHi.setState("5");
                oldEntrustHi.setType("2");
            }
            this.entrustHiSerive.updateBatchById(entrustHis);
        }
        EntrustHi entrustHi = new EntrustHi(taskId, task.getTaskDefinitionKey(), task.getName(), task.getProcessDefinitionId().split(":")[0], task.getProcessInstanceId(), consignees, userId, date, "3", "1");
        entrustHi.setComments(comment);
        entrustHi.setUpdateTime(new Date());
        this.entrustHiSerive.save((Object)entrustHi);
        this.entrustDataPush(task, userId, consignee, comment, date, entrustHi.getUpdateTime(), "cancelEntrust", "cancelEntrust", localVariable);
        this.activityRedisTimerService.updateTimeOutModel(taskId, consignee, userId, 0);
        return InstallResult.getResult("1", "success", null);
    }

    private void entrustDataPush(Task task, String userId, String consignee, String comment, Date startTime, Date endTime, String type, String operationType, Map<String, Object> localVariable) {
        try {
            String dataPushAddress;
            TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(task.getTenantId());
            if (tenantConfig != null && "1".equals(tenantConfig.getIsDataPush()) && ToolUtil.isNotEmpty((Object)(dataPushAddress = tenantConfig.getDataPushAddress()))) {
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("action", type);
                data.put("taskId", task.getId());
                data.put("taskName", task.getName());
                data.put("userId", consignee);
                data.put("businessKey", historicProcessInstance.getBusinessKey());
                data.put("startUserId", historicProcessInstance.getStartUserId());
                data.put("taskDefinitionKey", task.getTaskDefinitionKey());
                data.put("processDefinitionId", task.getProcessDefinitionId());
                data.put("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                HashMap map = new HashMap();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                data.put("startDate", simpleDateFormat.format(startTime));
                data.put("url", task.getFormKey());
                data.put("description", map.get("todoConfiguration"));
                data.put("sendUser", localVariable.get("sendUser"));
                data.put("processName", historicProcessInstance.getProcessDefinitionName());
                data.put("comment", comment);
                data.put("processInstanceId", task.getProcessInstanceId());
                if (userId != null) {
                    data.put("consignor", userId);
                    data.put("endDate", simpleDateFormat.format(endTime));
                }
                data.put("operationType", operationType);
                HttpUtil.post((String)dataPushAddress, data);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8f6c\u529e\u6570\u636e\u63a8\u9001\u51fa\u9519");
        }
    }

    @Override
    public BpmResponseResult entrustTask(String taskId, String consignee) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{taskId, consignee})) {
            return InstallResult.getResult("0", "\u59d4\u6258\u5931\u8d25\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
        }
        Map<String, Object> localVariable = GetVariableUtil.getVariableMap(task.getId(), null, 0);
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, "", consignee));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)taskId);
        this.entrustHiSerive.remove((Wrapper)queryWrapper);
        Date date = new Date();
        this.entrustDataPush(task, null, consignee, null, task.getCreateTime(), date, "adminEntrust", "adminEntrust", localVariable);
        this.activityRedisTimerService.updateTimeOutModel(taskId, consignee, null, 1);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        List hisTaskList;
        BpmnModel bm;
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeProcessVariables()).includeTaskLocalVariables()).taskId(taskId)).singleResult();
        if (activitiId != null && !this.canReject(bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId()), task.getTaskDefinitionKey(), activitiId, null, null, true) && !this.canReject(bm, task.getTaskDefinitionKey(), activitiId, null, null, false)) {
            return InstallResult.getResult("0", "\u7f51\u5173\u8282\u70b9\u7981\u6b62\u81ea\u7531\u8df3\u8f6c\uff01", null);
        }
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        String processDefinitionId = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinitionId);
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        if (currentActivity.getActivityBehavior() instanceof ExtendParallelMultiInstanceBehavior) {
            return InstallResult.getResult("0", "\u4f1a\u7b7e\u8282\u70b9\u7981\u6b62\u81ea\u7531\u8df3\u8f6c\uff01", null);
        }
        if (StringUtils.isNotEmpty((CharSequence)userId) && task.getAssignee() == null) {
            this.claimTask(taskId, userId);
        }
        this.addComment(taskId, comment);
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"freejump");
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(activitiId);
        String executionId = task.getExecutionId();
        String parentId = task.getExecutionId();
        if ((isSubmit || activitiId.equals(this.getFirstActivityId(task)) && ToolUtil.isEmpty((Object)assignees)) && (hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(activitiId)).includeTaskLocalVariables()).includeProcessVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).list()) != null && hisTaskList.size() > 0) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            assignees = historicTaskInstance.getAssignee();
        }
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("reject_appoint_assignee", assignees);
        map.put("cc_send_user", userId);
        map.put("sendUser", userId);
        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, "freejump", destinationActivity, map, currentActivity, null, null));
        this.dataPush(task, comment, userId, "freejump");
        return this.installReturnValue(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), map);
    }

    @Override
    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        if (assigneeList == null || assigneeList.size() < 1) {
            return InstallResult.getResult("0", "\u6307\u5b9a\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u6302\u8d77\uff01", null);
        }
        int num = this.backType(taskId);
        if (num != 2) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4efb\u52a1\u8282\u70b9\u4e0d\u662f\u4f1a\u7b7e\u8282\u70b9\uff0c\u4e0d\u80fd\u52a0\u7b7e\uff01", null);
        }
        String outTimeType = null;
        long dueTime = 0L;
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
            List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
            if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)timeOutStrategy)) {
                outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
            }
            dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), assigneeList, dueTime, outTimeType));
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        JSONArray json = new JSONArray();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230\uff01", null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        return InstallResult.getResult("0", "\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff01", null);
    }

    @Override
    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        JSONArray json = new JSONArray();
        Set<String> users = this.getAssigneeByTaskId(taskId);
        json.add(users);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult addAssignees(String taskId, String businessKey, String users) {
        if (ToolUtil.isEmpty((Object)users)) {
            return InstallResult.getResult("0", "\u6307\u5b9a\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
        }
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(taskId, users));
            this.activityRedisTimerService.updateTimeOutModel(taskId, users, null, 0);
        } else {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessKey)).list();
            for (Task task : tasks) {
                this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(task.getId(), users));
                this.activityRedisTimerService.updateTimeOutModel(task.getId(), users, null, 0);
            }
        }
        return InstallResult.getResult("1", "\u6dfb\u52a0\u53c2\u4e0e\u8005\u6210\u529f\uff01", null);
    }

    @Override
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        HashSet<String> users;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff01", null);
        }
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if ((users = AnalyticalModelUtil.getNextCandidateUser(task, bm, nodeId, tenantId, map)).size() > 0) {
            jsonArray.addAll(this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processDefinitionKey, String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            return this.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, map);
        }
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                return InstallResult.getResult("0", "\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff01", null);
            }
            JSONArray jsonArray = new JSONArray();
            HashSet<String> users = AnalyticalModelUtil.getNextCandidateUserByModel(processDefinitionId, processDefinitionKey, bpmnModel, nodeId, tenantId, map);
            if (users.size() > 0) {
                jsonArray.addAll(this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
            }
            return InstallResult.getResult("1", "success", jsonArray);
        }
        return InstallResult.getResult("1", "success", null);
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    public BpmResponseResult queryHistoryActByTaskId(String taskId) {
        JSONArray json = new JSONArray();
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task != null) {
                String processInstanceId = task.getProcessInstanceId();
                List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
                if (list != null && list.size() > 0) {
                    for (HistoricTaskInstance historyIns : list) {
                        JSONObject object = new JSONObject();
                        String tId = historyIns.getId();
                        if (tId.equals(taskId)) continue;
                        object.put("nodeId", (Object)historyIns.getTaskDefinitionKey());
                        object.put("nodeName", (Object)historyIns.getName());
                        object.put("taskId", (Object)tId);
                        object.put("count", (Object)list.size());
                        object.put("endTime", historyIns.getEndTime() == null ? null : Long.valueOf(historyIns.getEndTime().getTime()));
                        json.add((Object)object);
                    }
                }
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public BpmResponseResult getProcessDefinitionIdAndNodeId(String processDefinitionKey, String taskId) {
        String processDefinitionId = "";
        String nodeId = "";
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processDefinitionKey);
            if (definitionModel != null) {
                processDefinitionId = definitionModel.getId();
            }
        } else {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task != null) {
                processDefinitionId = task.getProcessDefinitionId();
                nodeId = task.getTaskDefinitionKey();
            }
        }
        JSONArray json = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("result", (Object)(processDefinitionId + nodeId));
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    private List<Map<String, Object>> tasksToMap(List<Task> tasks) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashSet<String> processInstanceIds = new HashSet<String>();
        ArrayList<ProcessInstance> pis = new ArrayList();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                processInstanceIds.add(t.getProcessInstanceId());
            }
            pis = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
        }
        if (tasks != null && tasks.size() > 0) {
            for (Task task : tasks) {
                String message;
                String sendUser;
                HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
                Map variables = task.getProcessVariables();
                Map taskVariables = task.getTaskLocalVariables();
                ProcessInstance pi = this.getProcessInstance(pis, task.getProcessInstanceId());
                taskMap.put("taskId", task.getId());
                taskMap.put("taskDefinitionName", task.getName());
                taskMap.put("definitionKey", pi.getProcessDefinitionKey());
                taskMap.put("definitionId", task.getProcessDefinitionId());
                taskMap.put("definitionName", pi.getProcessDefinitionName());
                taskMap.put("taskDefinitionKey", task.getTaskDefinitionKey());
                taskMap.put("processInsId", task.getProcessInstanceId());
                taskMap.put("createTime", task.getCreateTime());
                taskMap.put("businessId", pi.getBusinessKey());
                taskMap.put("variables", variables);
                taskMap.put("taskVariables", taskVariables);
                taskMap.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
                String string = sendUser = taskVariables.get("sendUser") == null ? "" : taskVariables.get("sendUser").toString();
                if (ToolUtil.isNotEmpty((Object)sendUser)) {
                    taskMap.put("sendUser", sendUser);
                }
                String string2 = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
                if (ToolUtil.isNotEmpty((Object)message)) {
                    taskMap.put("message", message);
                }
                taskMap.put("formKey", task.getFormKey());
                list.add(taskMap);
            }
        }
        return list;
    }

    private ProcessInstance getProcessInstance(List<ProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (ProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    private HistoricProcessInstance getHistoricProcessInstance(List<HistoricProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (HistoricProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    @Override
    public BpmResponseResult queryTaskIdByBusinessKey(String businessId) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        if (tasks != null) {
            for (Task task : tasks) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("name", (Object)task.getName());
                jsonObject.put("processInstanceId", (Object)task.getProcessInstanceId());
                json.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryNextNode(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff01", null);
        }
        UserTask userTask = (UserTask)bm.getFlowElement(task.getTaskDefinitionKey());
        if (userTask == null) {
            return InstallResult.getResult("1", "success", jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        HashMap<String, Object> resultMap = new HashMap();
        if (bm.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            resultMap = CommonCodeUtil.getGodAxeResult(userTask.getId(), historicProcessInstance.getBusinessKey(), task.getProcessDefinitionId());
        }
        HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
        HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
        this.getUserTaskByCondition(jsonArray, bm, sequenceFlows, 0, userTask.getId(), ToolUtil.isNotEmpty(resultMap) ? resultMap : null, nodeMessages, simpleGroupMessages, null);
        JSONArray result = new JSONArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            if (jsonArray.getJSONObject(i).getString("type").contains("Gateway")) continue;
            result.add((Object)jsonArray.getJSONObject(i));
        }
        jsonArray = result;
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult queryNextNode(String processDefinitionKey, String taskId) {
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            return this.queryNextNode(taskId);
        }
        JSONArray jsonArray = new JSONArray();
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            String procDefId = this.processDefinitionsService.getStartProcessDefinitionId(processDefinitionKey);
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !(bpmnModel.getFlowElement(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef()) instanceof UserTask)) continue;
                UserTask userTask = (UserTask)bpmnModel.getFlowElement(firstUserTask);
                List sequenceFlows = userTask.getOutgoingFlows();
                HashMap<String, Object> resultMap = new HashMap();
                if (bpmnModel.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
                    resultMap = CommonCodeUtil.getGodAxeResult(userTask.getId(), "", procDefId);
                }
                HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
                HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
                this.getUserTaskByCondition(jsonArray, bpmnModel, sequenceFlows, 0, userTask.getId(), ToolUtil.isNotEmpty(resultMap) ? resultMap : null, nodeMessages, simpleGroupMessages, null);
                JSONArray result = new JSONArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    if (jsonArray.getJSONObject(i).getString("type").contains("Gateway")) continue;
                    result.add((Object)jsonArray.getJSONObject(i));
                }
                jsonArray = result;
            }
            return InstallResult.getResult("1", "success", jsonArray);
        }
        return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), jsonArray);
    }

    private void getUserTaskByCondition(JSONArray jsonArray, BpmnModel bm, List<SequenceFlow> sfs, int sourceType, String superParentId, Map<String, Object> visitorMap, Map<String, NodeMessage> nodeMessages, Map<String, SimpleGroupMessage> simpleGroupMessages, SimpleGroupMessage oldSimpleGroupMessage) {
        if (sfs != null && !sfs.isEmpty()) {
            String parentId = sfs.get(0).getSourceRef();
            if (superParentId.equals(parentId)) {
                parentId = "";
            }
            for (SequenceFlow sequenceFlow : sfs) {
                boolean required = true;
                if (sfs.size() > 1) {
                    if (sourceType == 1) {
                        required = false;
                    } else if (sourceType == 2 && sequenceFlow.getConditionExpression() != null && sequenceFlow.getConditionExpression().contains("bpm_next_node")) {
                        required = false;
                    }
                }
                FlowElement flowElement = bm.getFlowElement(sequenceFlow.getTargetRef());
                SimpleGroupMessage simpleGroupMessage = oldSimpleGroupMessage;
                if (simpleGroupMessage == null) {
                    simpleGroupMessage = new SimpleGroupMessage();
                    simpleGroupMessage.jsonObjects = new ArrayList<JSONObject>();
                    simpleGroupMessage.childGroupIds = new ArrayList<List<String>>();
                    simpleGroupMessage.groupId = flowElement.getId();
                    simpleGroupMessages.put(simpleGroupMessage.groupId, simpleGroupMessage);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                jsonObject.put("parentId", (Object)parentId);
                NodeMessage nodeMessage = new NodeMessage(sequenceFlow.getTargetRef(), sequenceFlow.getSourceRef(), !required, null, null);
                if (flowElement instanceof Gateway) {
                    Gateway gateway = (Gateway)flowElement;
                    if (gateway instanceof ParallelGateway) {
                        this.getUserTaskByCondition(jsonArray, bm, gateway.getOutgoingFlows(), 3, superParentId, visitorMap, nodeMessages, simpleGroupMessages, simpleGroupMessage);
                        jsonObject.put("type", (Object)"parallelGateway");
                        nodeMessage.getewayType = "parallelGateway";
                        ArrayList<String> childNode = new ArrayList<String>();
                        for (SequenceFlow flow : gateway.getOutgoingFlows()) {
                            childNode.add(flow.getTargetRef());
                        }
                        nodeMessage.childNodes = childNode;
                    } else {
                        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                        SimpleContext context = new SimpleContext();
                        if (visitorMap != null && !visitorMap.isEmpty()) {
                            SequenceFlow flow;
                            flow = visitorMap.keySet().iterator();
                            while (flow.hasNext()) {
                                String k = flow.next();
                                if (visitorMap.get(k.toString()) != null) {
                                    context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), visitorMap.get(k.toString()).getClass()));
                                    continue;
                                }
                                context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), Object.class));
                            }
                        }
                        ArrayList<SequenceFlow> defaultList = new ArrayList<SequenceFlow>();
                        ArrayList<SequenceFlow> allList = new ArrayList<SequenceFlow>();
                        boolean flag = true;
                        List sequenceFlowsList = gateway.getOutgoingFlows();
                        for (SequenceFlow sequenceFlows : sequenceFlowsList) {
                            if (sequenceFlows.getConditionExpression() != null) {
                                boolean isConditionWithNextNode = sequenceFlows.getConditionExpression().contains("bpm_next_node");
                                if (isConditionWithNextNode) {
                                    Matcher matcher = BPM_NEXT_NODE_REGEX.matcher(sequenceFlows.getConditionExpression());
                                    String bpmNextNodeCondition = "";
                                    if (matcher.find()) {
                                        bpmNextNodeCondition = matcher.group();
                                    }
                                    String bpmNextNodeConditionValue = "";
                                    if (bpmNextNodeCondition.contains("==")) {
                                        bpmNextNodeConditionValue = bpmNextNodeCondition.split("'")[1];
                                    }
                                    context.setVariable("bpm_next_node", factory.createValueExpression((Object)bpmNextNodeConditionValue, Object.class));
                                }
                                ValueExpression valueExpression = factory.createValueExpression((ELContext)context, sequenceFlows.getConditionExpression(), Boolean.TYPE);
                                try {
                                    if (!((Boolean)valueExpression.getValue((ELContext)context)).booleanValue()) continue;
                                    allList.add(sequenceFlows);
                                    if (isConditionWithNextNode) continue;
                                    flag = false;
                                }
                                catch (PropertyNotFoundException e) {
                                    allList.add(sequenceFlows);
                                }
                                continue;
                            }
                            defaultList.add(sequenceFlows);
                        }
                        int type = 1;
                        if (gateway instanceof ExclusiveGateway) {
                            jsonObject.put("type", (Object)"exclusiveGateway");
                            nodeMessage.getewayType = "exclusiveGateway";
                        } else if (gateway instanceof InclusiveGateway) {
                            flag = true;
                            type = 2;
                            jsonObject.put("type", (Object)"inclusiveGateway");
                            nodeMessage.getewayType = "inclusiveGateway";
                        }
                        if (flag) {
                            allList.addAll(defaultList);
                        }
                        ArrayList<String> childNode = new ArrayList<String>();
                        for (SequenceFlow flow : allList) {
                            childNode.add(flow.getTargetRef());
                        }
                        nodeMessage.childNodes = childNode;
                        if (gateway instanceof ExclusiveGateway) {
                            simpleGroupMessage.childGroupIds.add(childNode);
                            this.getUserTaskByCondition(jsonArray, bm, allList, type, superParentId, visitorMap, nodeMessages, simpleGroupMessages, null);
                        } else {
                            this.getUserTaskByCondition(jsonArray, bm, allList, type, superParentId, visitorMap, nodeMessages, simpleGroupMessages, simpleGroupMessage);
                        }
                    }
                } else if (flowElement instanceof UserTask) {
                    UserTask u = (UserTask)flowElement;
                    jsonObject.put("type", (Object)"userTask");
                    String allowSetParticipantRepetition = "";
                    if (u.getExtensionElements().get("allowSetParticipant") != null) {
                        allowSetParticipantRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)u.getExtensionElements().get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant")).get(0)).getValue();
                    }
                    jsonObject.put("allowSetParticipant", (Object)allowSetParticipantRepetition);
                } else if (flowElement instanceof EndEvent) {
                    jsonObject.put("type", (Object)"endEvent");
                } else if (flowElement instanceof CallActivity) {
                    jsonObject.put("type", (Object)"callActivity");
                } else if (flowElement instanceof ServiceTask) {
                    jsonObject.put("type", (Object)"serviceTask");
                } else if (flowElement instanceof ReceiveTask) {
                    jsonObject.put("type", (Object)"receiveTask");
                } else if (flowElement instanceof SubProcess) {
                    jsonObject.put("type", (Object)"subProcess");
                }
                simpleGroupMessage.jsonObjects.add(jsonObject);
                nodeMessages.put(sequenceFlow.getTargetRef(), nodeMessage);
                jsonArray.add((Object)jsonObject);
            }
        }
    }

    private void getUserTask(JSONArray jsonArray, Process process, List<SequenceFlow> sfs) {
        if (sfs != null && sfs.size() > 0) {
            for (SequenceFlow sequenceFlow : sfs) {
                List sequenceFlows;
                ExclusiveGateway exclusiveGateway;
                UserTask u;
                JSONObject jsonObject;
                String targetRef = sequenceFlow.getTargetRef();
                if (process.getFlowElement(targetRef) instanceof UserTask) {
                    jsonObject = new JSONObject();
                    u = (UserTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof EndEvent) {
                    jsonObject = new JSONObject();
                    u = (EndEvent)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ExclusiveGateway) {
                    exclusiveGateway = (ExclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof InclusiveGateway) {
                    exclusiveGateway = (InclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof CallActivity) {
                    CallActivity callActivity = (CallActivity)process.getFlowElement(targetRef);
                    JSONObject jsonObject2 = new JSONObject();
                    jsonObject2.put("id", (Object)callActivity.getId());
                    jsonObject2.put("name", (Object)callActivity.getName());
                    jsonArray.add((Object)jsonObject2);
                }
                if (!(process.getFlowElement(targetRef) instanceof ParallelGateway)) continue;
                jsonObject = new JSONObject();
                ParallelGateway p = (ParallelGateway)process.getFlowElement(targetRef);
                jsonObject.put("id", (Object)p.getId());
                jsonObject.put("name", (Object)p.getName());
                jsonArray.add((Object)jsonObject);
            }
        }
    }

    @Override
    public BpmResponseResult withdrawState(String historicTaskId) {
        List executions;
        ProcessInstance instance;
        JSONArray json = new JSONArray();
        boolean result = false;
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult();
        String taskSourceFlag = (String)currTask.getTaskLocalVariables().get("taskSourceFlag");
        if (taskSourceFlag == null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"task_id", (Object)historicTaskId);
            queryWrapper.eq((Object)"state", (Object)"3");
            List entrustHis = this.entrustHiSerive.list((Wrapper)queryWrapper);
            if (ToolUtil.isNotEmpty((Object)entrustHis)) {
                taskSourceFlag = "entrust";
            }
        }
        if ((instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult()) == null) {
            LOGGER.error("\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff01");
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff01", null);
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
        if (definition == null) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230\uff01", null);
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getId())).taskVariableValueEquals("complete_from", (Object)currTask.getTaskDefinitionKey())).list();
        if (tasks == null || tasks.size() == 0) {
            if ("reject".equals(taskSourceFlag) || "entrust".equals(taskSourceFlag)) {
                result = true;
            }
            json.add((Object)result);
            return InstallResult.getResult("1", "success", json);
        }
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(((Task)tasks.get(0)).getExecutionId()).singleResult();
        result = execution.getParentId() == null ? tasks.size() == 1 : (executions = this.runtimeService.createExecutionQuery().parentId(execution.getParentId()).list()).size() <= tasks.size();
        json.add((Object)result);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult withdrawState(String businessKey, String userId, String taskId) {
        List hisTaskList;
        String completeFrom;
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (instance == null) {
            LOGGER.error("\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff01");
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff01", null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            LOGGER.error("\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        Map<String, Object> localVariable = GetVariableUtil.getVariableMap(task.getId(), null, 0);
        String string = completeFrom = localVariable.get("complete_from") == null ? "" : localVariable.get("complete_from").toString();
        if (ToolUtil.isNotEmpty((Object)completeFrom) && (hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)BpmConstant.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(completeFrom)).orderByHistoricTaskInstanceEndTime().finished().desc()).list()) != null && hisTaskList.size() > 0 && ((HistoricTaskInstance)hisTaskList.get(0)).getAssignee().equals(userId)) {
            JSONArray json = new JSONArray();
            json.add((Object)((HistoricTaskInstance)hisTaskList.get(0)).getId());
            return InstallResult.getResult("1", "success", json);
        }
        return InstallResult.getResult("0", "error", null);
    }

    @Override
    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        List taskList;
        String operationType;
        boolean flag;
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult();
        if (currTask.getAssignee() != null && !(flag = currTask.getAssignee().equals(userId))) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        String taskSourceFlag = (String)currTask.getTaskLocalVariables().get("taskSourceFlag");
        if (taskSourceFlag == null) {
            taskSourceFlag = "entrust";
        }
        String string = operationType = "reject".equals(taskSourceFlag) ? "revokeReject" : "revoke";
        if ("revoke".equals(taskSourceFlag)) {
            return InstallResult.getResult("0", "\u5f53\u524d\u8282\u70b9\u7981\u6b62\u64a4\u56de\uff01", null);
        }
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(currTask.getProcessInstanceId())).includeProcessVariables()).includeTaskLocalVariables();
        if (!"entrust".equals(taskSourceFlag)) {
            taskQuery = (TaskQuery)taskQuery.taskVariableValueLike("reject".equals(taskSourceFlag) ? "reject_from" : "complete_from", currTask.getTaskDefinitionKey());
        }
        if ((taskList = taskQuery.list()) != null && taskList.size() > 0) {
            HistoricTaskInstance historicTaskInstance;
            BpmnModel bm;
            String backActivityId;
            int num = 0;
            for (int i = 0; i < taskList.size(); ++i) {
                if (!historicTaskId.equals(((Task)taskList.get(i)).getId())) continue;
                num = i;
                break;
            }
            Task task = (Task)taskList.get(num);
            String taskId = task.getId();
            String tenantId = task.getTenantId();
            if ("entrust".equals(taskSourceFlag)) {
                return this.cancelEntrustTask(taskId, userId, comment);
            }
            task.setAssignee(userId);
            String starterUserId = "";
            if ("reject".equals(taskSourceFlag)) {
                Map variables = task.getTaskLocalVariables() == null ? new HashMap(16) : task.getTaskLocalVariables();
                backActivityId = variables.get("reject_from").toString();
            } else {
                backActivityId = this.getLastActivityId(task);
            }
            boolean isFirst = false;
            if (backActivityId != null && backActivityId.equals(this.getFirstActivityId(taskId))) {
                starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
                isFirst = true;
            }
            this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)operationType);
            if (map == null) {
                map = new HashMap<String, Object>();
                map.put("cc_send_user", userId);
                map.put("sendUser", userId);
            }
            if (isSubmit) {
                String assignees = "reject".equals(taskSourceFlag) ? this.getAssigneesByNodeId(taskId, backActivityId, tenantId) : this.getTaskCommitUser(task.getProcessInstanceId(), backActivityId);
                map.put("reject_appoint_assignee", assignees);
            }
            if (backActivityId != null && !this.canReject(bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId()), task.getTaskDefinitionKey(), backActivityId, null, null, true) && !this.canReject(bm, task.getTaskDefinitionKey(), backActivityId, null, null, false)) {
                return InstallResult.getResult("0", "\u5f53\u524d\u8282\u70b9\u7981\u6b62\u64a4\u56de\uff01", null);
            }
            Map<String, Object> result = this.backTypes(task, backActivityId, false, userId, comment, "reject");
            int backType = (Integer)result.get("num");
            if (backType == 0) {
                return InstallResult.getResult("0", "\u5f53\u524d\u8282\u70b9\u7981\u6b62\u64a4\u56de\uff01", null);
            }
            if ("complete".equals(taskSourceFlag)) {
                this.setSameLevelTaskIdMessageOld(historicTaskId, "revoke");
            }
            this.rejectTask(userId, task, backActivityId, comment, map, backType, operationType);
            if (backType == 2) {
                this.entrustHiSerive.removeMultiRejectRevokeHistoryBytaskId(taskId);
            }
            this.dataPush(task, comment, userId, operationType);
            this.flowEventsServiceMapper.updateTaskFlag(historicTaskId, taskSourceFlag + "revoke");
            List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currTask.getProcessInstanceId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).finished().orderByTaskCreateTime()).desc()).list();
            Date date = currTask.getStartTime();
            ArrayList<String> taskIds = new ArrayList<String>();
            Iterator iterator = tasks.iterator();
            while (iterator.hasNext() && (historicTaskInstance = (HistoricTaskInstance)iterator.next()).getEndTime().after(date)) {
                taskIds.add(historicTaskInstance.getId());
                if (!historicTaskInstance.getCreateTime().before(date)) continue;
                date = historicTaskInstance.getCreateTime();
            }
            this.flowEventsServiceMapper.updateDeleteReason(taskIds);
            return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId, backActivityId, userId, task.getTaskDefinitionKey(), "revoke", task.getName());
        }
        return InstallResult.getResult("0", "\u5f53\u524d\u8282\u70b9\u7981\u6b62\u64a4\u56de\uff01", null);
    }

    private String getTaskStarterUserId(String processInstanceId) {
        String starterUserId = "";
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (hpi != null) {
            starterUserId = hpi.getStartUserId();
        }
        return starterUserId;
    }

    private int backType(String taskId) {
        int num = 1;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).active().singleResult();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        if (instance == null) {
            LOGGER.error("\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff01");
            return 0;
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230\uff01");
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        List incomingTransitions = currActivity.getIncomingTransitions();
        for (PvmTransition pvmTransition : incomingTransitions) {
            PvmActivity pvmActivity = pvmTransition.getSource();
            ActivityBehavior inActivity = ((ActivityImpl)pvmActivity).getActivityBehavior();
            List outPvmTransition = pvmActivity.getOutgoingTransitions();
            if (inActivity instanceof ParallelGatewayActivityBehavior || inActivity instanceof InclusiveGatewayActivityBehavior) {
                num = outPvmTransition.size() > 1 ? 3 : 0;
                return num;
            }
            num = 1;
        }
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        return num;
    }

    private Map<String, Object> backTypes(Task task, String nodeId, boolean isRejectFirst, String userId, String comment, String type) {
        Map<String, Object> result = this.getBackTypeWithTasks(nodeId, task, isRejectFirst, userId, comment, type);
        int num = (Integer)result.get("num");
        if (nodeId.startsWith(CALL_REJECT_PREFIX)) {
            result.put("num", 3);
            return result;
        }
        if (num != 1) {
            return result;
        }
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        if (instance == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessEnd());
            num = 0;
            result.put("num", num);
            return result;
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessNotFound());
            num = 0;
            result.put("num", num);
            return result;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        if (currActivity == null) {
            throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), false);
        }
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (nodeId == null) {
            List incomingTransitions = currActivity.getIncomingTransitions();
            for (PvmTransition pvmTransition : incomingTransitions) {
                PvmActivity pvmActivity = pvmTransition.getSource();
                ActivityBehavior inActivity = ((ActivityImpl)pvmActivity).getActivityBehavior();
                if (!(inActivity instanceof ParallelGatewayActivityBehavior) && !(inActivity instanceof InclusiveGatewayActivityBehavior) || pvmActivity.getIncomingTransitions().size() <= 1) continue;
                num = 0;
                result.put("num", num);
                return result;
            }
        }
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        result.put("num", num);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getBackTypeWithTasks(String nodeId, Task task, boolean isRejectFirst, String userId, String comment, String type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Object> affectedTasks = new ArrayList<String>();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningNodeIds = new HashSet<String>();
        ArrayList<String> finishedNodeIds = new ArrayList<String>();
        HashSet<String> runningActivitiNodeIds = new HashSet<String>();
        String processInstanceId = task.getProcessInstanceId();
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        String taskName = task.getName();
        if (nodeId.startsWith(CALL_REJECT_PREFIX)) {
            nodeId = nodeId.substring(CALL_REJECT_PREFIX.length());
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (processInstance.getSuperProcessInstanceId() == null) {
                throw new PublicClientException("\u8be5\u6d41\u7a0b\u6ca1\u6709\u4e3b\u6d41\u7a0b");
            }
            Iterator list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId()).unfinished().activityType("callActivity").list();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)iterator.next();
                runningActivitiNodeIds.add(historicActivityInstance.getActivityId());
                if (!historicActivityInstance.getCalledProcessInstanceId().equals(processInstanceId)) continue;
                taskDefinitionKey = historicActivityInstance.getActivityId();
                processDefinitionId = historicActivityInstance.getProcessDefinitionId();
                processInstanceId = processInstance.getSuperProcessInstanceId();
                taskName = historicActivityInstance.getActivityName();
                result.put("executionId", historicActivityInstance.getExecutionId());
            }
        } else {
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("callActivity").list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                runningActivitiNodeIds.add(historicActivityInstance.getActivityId());
            }
        }
        result.put("runningActivitiNodeIds", runningActivitiNodeIds);
        result.put("processInstanceId", processInstanceId);
        result.put("processDefinitionId", processDefinitionId);
        result.put("taskDefinitionKey", taskDefinitionKey);
        result.put("taskName", taskName);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (Task runningTask : tasks) {
            runningNodeIds.add(runningTask.getTaskDefinitionKey());
        }
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        ArrayList<String> finishedExcutionIds = new ArrayList<String>();
        for (Execution execution : executions) {
            if (((ExecutionEntity)execution).isScope() || execution.getActivityId() == null) continue;
            if (!runningNodeIds.contains(execution.getActivityId()) && !runningActivitiNodeIds.contains(execution.getActivityId())) {
                finishedExcutionIds.add(execution.getId());
                continue;
            }
            taskIds.add(execution.getActivityId());
        }
        if (finishedExcutionIds.size() > 0) {
            void var22_24;
            List activityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().desc()).list();
            boolean bl = false;
            while (var22_24 < activityInstances.size()) {
                if (finishedExcutionIds.contains(((HistoricActivityInstance)activityInstances.get((int)var22_24)).getExecutionId()) && ("parallelGateway".equals(((HistoricActivityInstance)activityInstances.get((int)var22_24)).getActivityType()) || "inclusiveGateway".equals(((HistoricActivityInstance)activityInstances.get((int)var22_24)).getActivityType()))) {
                    Date date = ((HistoricActivityInstance)activityInstances.get((int)(var22_24 + true))).getStartTime();
                    for (void j = var22_24 + true; j < activityInstances.size(); ++j) {
                        if (((HistoricActivityInstance)activityInstances.get((int)j)).getEndTime() == null || ((HistoricActivityInstance)activityInstances.get((int)j)).getEndTime().getTime() >= ((HistoricActivityInstance)activityInstances.get((int)var22_24)).getStartTime().getTime() || j != var22_24 + true && ((HistoricActivityInstance)activityInstances.get((int)j)).getEndTime().getTime() <= date.getTime()) continue;
                        finishedNodeIds.add(((HistoricActivityInstance)activityInstances.get((int)j)).getActivityId());
                        taskIds.add(((HistoricActivityInstance)activityInstances.get((int)j)).getActivityId());
                        finishedExcutionIds.remove(((HistoricActivityInstance)activityInstances.get((int)var22_24)).getExecutionId());
                        break;
                    }
                    if (finishedExcutionIds.size() == 0) break;
                }
                ++var22_24;
            }
        }
        if ((taskIds = new ArrayList(new HashSet(taskIds))).size() > 1) {
            if (isRejectFirst) {
                result.put("affectedTasks", taskIds);
                result.put("num", 3);
                if (finishedNodeIds.size() > 0) {
                    result.put("num", 4);
                }
                return result;
            }
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            Process process = (Process)bm.getProcesses().get(0);
            if (ToolUtil.isEmpty((Object)process.getFlowElement(nodeId))) {
                throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), false);
            }
            boolean isFindTask = false;
            affectedTasks = this.findAffectedTask(process, nodeId, true, taskIds);
            if (affectedTasks.contains(taskDefinitionKey)) {
                isFindTask = true;
                affectedTasks.remove(taskDefinitionKey);
            }
            if (affectedTasks.size() > 0) {
                newNum = 3;
            }
            if (!isFindTask) {
                List<Object> affetedAllTasks = new ArrayList();
                if (affectedTasks.size() > 0) {
                    affetedAllTasks = affectedTasks;
                }
                if ((affectedTasks = this.findAffectedTask(process, nodeId, false, taskIds)).contains(taskDefinitionKey)) {
                    isFindTask = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (affectedTasks.size() > 0) {
                    newNum = 3;
                }
                if (!isFindTask && affectedTasks.size() + affetedAllTasks.size() > 0) {
                    newNum = -1;
                }
            }
        }
        affectedTasks.add(taskDefinitionKey);
        if (newNum == 3) {
            for (String string : affectedTasks) {
                if (!finishedNodeIds.contains(string)) continue;
                newNum = 4;
                break;
            }
        }
        result.put("affectedTasks", affectedTasks);
        result.put("num", newNum);
        return result;
    }

    private List<String> findAffectedTask(Process process, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        ArrayList<String> affectedTasks = new ArrayList<String>();
        flowElements.add(process.getFlowElement(nodeId));
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                continue;
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(process.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(process.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        return affectedTasks;
    }

    @Override
    public BpmResponseResult getPreviousNodeAssignee(String taskId, String tenantId) {
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeProcessVariables()).includeTaskLocalVariables()).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        String backActivityId = this.getLastActivityId(task);
        if (ToolUtil.isEmpty((Object)backActivityId)) {
            return InstallResult.getResult("0", "\u4e0a\u4e00\u8282\u70b9\u672a\u627e\u5230\uff01", null);
        }
        ArrayList list = new ArrayList();
        ArrayList<String> assignee = new ArrayList<String>();
        ArrayList<String> taskIds = new ArrayList<String>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(backActivityId)).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            Date start = historicTaskInstance.getStartTime();
            for (HistoricTaskInstance taskInstance : hisTaskList) {
                if (!start.before(taskInstance.getEndTime())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("assignee", taskInstance.getAssignee());
                map.put("taskId", taskInstance.getId());
                list.add(map);
                taskIds.add(taskInstance.getId());
                assignee.add(taskInstance.getAssignee());
            }
        }
        List<Map<String, String>> comments = this.taskEngineMapper.getTaskComments(taskIds);
        HashMap<String, String> commentMap = new HashMap<String, String>();
        for (Map<String, String> map : comments) {
            commentMap.put(map.get("id"), map.get("comments"));
        }
        Map<String, String> finalUsers = this.iAssigneeChooseService.getUserListByUserId(assignee, tenantId);
        for (Map map : list) {
            map.put("assigneeName", finalUsers.get(map.get("assignee")));
            map.put("comments", commentMap.get(map.get("taskId")));
        }
        return InstallResult.getResult("1", "success", JSONArray.parseArray((String)JSON.toJSONString(list)));
    }

    @Override
    public BpmResponseResult getTaskNodeAssignee(String taskId, String tenantId) {
        if (taskId == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).unfinished().list();
        ArrayList<String> users = new ArrayList<String>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getAssignee() == null) {
                users.addAll(this.getAssigneeByTaskId(historicTaskInstance.getId()));
                continue;
            }
            users.add(historicTaskInstance.getAssignee());
        }
        users = new ArrayList(new HashSet(users));
        Map<String, String> nameMap = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
        JSONArray json = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("processDefinitionId", (Object)task.getProcessDefinitionId());
        object.put("processInstanceId", (Object)task.getProcessInstanceId());
        object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
        object.put("taskName", (Object)task.getName());
        StringBuilder user = new StringBuilder();
        StringBuilder userName = new StringBuilder();
        for (String id : users) {
            user.append(",").append(id);
            userName.append(",").append(nameMap.get(id));
        }
        if (users.size() > 0) {
            object.put("users", (Object)user.toString().substring(1));
            object.put("userNames", (Object)userName.toString().substring(1));
        }
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult getPreviousDefaultOrConditionAssignee(String taskId, String tenantId, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeTaskLocalVariables()).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff01", null);
        }
        HashSet<String> users = AnalyticalModelUtil.getNextCandidateUser(task, bm, this.getLastActivityId(task), tenantId, map);
        if (users.size() > 0) {
            jsonArray.addAll(this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public Map<String, Integer> updateRejectForm(Map<String, Object> map) {
        List nodeIds = (List)map.get("nodeIds");
        String procDefId = (String)map.get("procDefId");
        List delNodeIds = (List)map.get("delNodeIds");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        List list = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(procDefId).unfinished().orderByActivityId().asc()).list();
        HashSet<String> instanceIds = new HashSet<String>();
        if (list.size() == 0) {
            return result;
        }
        String taskDefKey = ((HistoricActivityInstance)list.get(0)).getActivityId();
        HashSet<String> nodeInstanceId = new HashSet<String>();
        HashSet<String> allInstanceIds = new HashSet<String>();
        int processNumAll = 0;
        for (HistoricActivityInstance activityInstance : list) {
            instanceIds.add(activityInstance.getProcessInstanceId());
            if (!delNodeIds.contains(activityInstance.getActivityId())) continue;
            Object num = (Integer)result.get(activityInstance.getActivityId());
            if (num == null) {
                num = 0;
            }
            if (!taskDefKey.equals(activityInstance.getActivityId())) {
                nodeInstanceId = new HashSet();
                taskDefKey = activityInstance.getActivityId();
            }
            if (nodeInstanceId.add(activityInstance.getProcessInstanceId())) {
                Object object = num;
                Object object2 = num = Integer.valueOf((Integer)num + 1);
                result.put(activityInstance.getActivityId(), (Integer)num);
            }
            if (!allInstanceIds.add(activityInstance.getProcessInstanceId())) continue;
            ++processNumAll;
        }
        if (processNumAll > 0) {
            result.put("", processNumAll);
            return result;
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(new ArrayList(instanceIds))).includeTaskLocalVariables()).orderByProcessInstanceId()).orderByTaskCreateTime()).asc()).list();
        HashMap<String, ArrayList<HistoricTaskInstance>> hisTaskMap = new HashMap<String, ArrayList<HistoricTaskInstance>>();
        for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
            ArrayList<HistoricTaskInstance> hisTasks = (ArrayList<HistoricTaskInstance>)hisTaskMap.get(historicTaskInstance.getProcessInstanceId());
            if (hisTasks == null) {
                hisTasks = new ArrayList<HistoricTaskInstance>();
            }
            hisTasks.add(historicTaskInstance);
            hisTaskMap.put(historicTaskInstance.getProcessInstanceId(), hisTasks);
        }
        HashMap<String, List<String>> finishTaskId = new HashMap<String, List<String>>();
        HashMap<String, List<String>> unFinishTaskId = new HashMap<String, List<String>>();
        for (List hisTasks : hisTaskMap.values()) {
            for (int i = 0; i < hisTasks.size(); ++i) {
                ArrayList<String> taskIds;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTasks.get(i);
                String completeFrom = (String)historicTaskInstance.getTaskLocalVariables().get("complete_from");
                if (!ToolUtil.isNotEmpty((Object)completeFrom) || nodeIds.contains(completeFrom)) continue;
                String newCompleteFrom = completeFrom;
                boolean isDelFrom = i == 0;
                for (int j = i - 1; j > -1; --j) {
                    newCompleteFrom = (String)((HistoricTaskInstance)hisTasks.get(j)).getTaskLocalVariables().get("complete_from");
                    if (ToolUtil.isEmpty((Object)newCompleteFrom)) {
                        isDelFrom = true;
                        break;
                    }
                    if (nodeIds.contains(newCompleteFrom)) break;
                }
                if (isDelFrom) {
                    newCompleteFrom = "";
                }
                if ((taskIds = (ArrayList<String>)finishTaskId.get(newCompleteFrom)) == null) {
                    taskIds = new ArrayList<String>();
                }
                taskIds.add(historicTaskInstance.getId());
                finishTaskId.put(newCompleteFrom, taskIds);
                if (historicTaskInstance.getEndTime() != null) continue;
                ArrayList<String> unFinishTaskIds = (ArrayList<String>)unFinishTaskId.get(newCompleteFrom);
                if (unFinishTaskIds == null) {
                    unFinishTaskIds = new ArrayList<String>();
                }
                unFinishTaskIds.add(historicTaskInstance.getId());
                unFinishTaskId.put(newCompleteFrom, unFinishTaskIds);
            }
        }
        if (finishTaskId.size() > 0) {
            this.taskEngineMapper.updateCompleteFrom(finishTaskId, unFinishTaskId, this.url.split(":")[1]);
        }
        return result;
    }

    public void setSameLevelTaskIdMessageOld(String operationTaskId, String operationType) {
        List<String> idList;
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(operationTaskId)).singleResult();
        String processInstanceId = currTask.getProcessInstanceId();
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId);
        List taskList = taskQuery.list();
        if ("revoke".equals(operationType) && ToolUtil.isNotEmpty(idList = this.flowEventsServiceMapper.getSameLevelTaskIdByOperationTaskId(processInstanceId, operationTaskId))) {
            return;
        }
        if (taskList.size() > 1) {
            String sameLevelTaskId;
            String id;
            String taskDefinitionKey = "";
            if ("revoke".equals(operationType)) {
                taskDefinitionKey = ((Task)taskList.get(0)).getTaskDefinitionKey();
            } else {
                for (Task task : taskList) {
                    if (!task.getId().equals(operationTaskId)) continue;
                    taskDefinitionKey = task.getTaskDefinitionKey();
                    break;
                }
            }
            ArrayList<Task> counterSignTaskList = new ArrayList<Task>();
            ArrayList<Task> gatewayTaskList = new ArrayList<Task>();
            if (ToolUtil.isNotEmpty((Object)taskDefinitionKey)) {
                for (Task task : taskList) {
                    if (taskDefinitionKey.equals(task.getTaskDefinitionKey())) {
                        counterSignTaskList.add(task);
                        continue;
                    }
                    gatewayTaskList.add(task);
                }
            }
            if (ToolUtil.isNotEmpty(counterSignTaskList) && counterSignTaskList.size() > 1) {
                id = IdWorker.get32UUID();
                sameLevelTaskId = "";
                for (Task task : counterSignTaskList) {
                    if (ToolUtil.isEmpty((Object)sameLevelTaskId)) {
                        sameLevelTaskId = task.getId();
                        continue;
                    }
                    sameLevelTaskId = sameLevelTaskId + "," + task.getId();
                }
                List<String> oldTaskIdList = this.flowEventsServiceMapper.getSameLevelTaskIdBySameLevelTaskId(processInstanceId, operationTaskId);
                String oldTaskId = "";
                if (ToolUtil.isNotEmpty(oldTaskIdList)) {
                    for (String s : oldTaskIdList) {
                        if (s.length() <= oldTaskId.length()) continue;
                        oldTaskId = s;
                    }
                }
                if (oldTaskId.length() > sameLevelTaskId.length()) {
                    sameLevelTaskId = oldTaskId;
                }
                this.flowEventsServiceMapper.setSameLevelTaskId(id, processInstanceId, operationTaskId, sameLevelTaskId, "0");
            }
            if (ToolUtil.isNotEmpty(gatewayTaskList)) {
                id = IdWorker.get32UUID();
                sameLevelTaskId = "";
                for (Task task : gatewayTaskList) {
                    if (ToolUtil.isEmpty((Object)sameLevelTaskId)) {
                        sameLevelTaskId = task.getId();
                        continue;
                    }
                    sameLevelTaskId = sameLevelTaskId + "," + task.getId();
                }
                this.flowEventsServiceMapper.setSameLevelTaskId(id, processInstanceId, operationTaskId, sameLevelTaskId, "1");
            }
        }
        if (taskList.size() == 1) {
            String id = IdWorker.get32UUID();
            List<String> oldTaskIdList = this.flowEventsServiceMapper.getSameLevelTaskIdBySameLevelTaskId(processInstanceId, operationTaskId);
            if (ToolUtil.isNotEmpty(oldTaskIdList)) {
                String oldTaskId = "";
                if (ToolUtil.isNotEmpty(oldTaskIdList)) {
                    for (String s : oldTaskIdList) {
                        if (s.length() <= oldTaskId.length()) continue;
                        oldTaskId = s;
                    }
                }
                this.flowEventsServiceMapper.setSameLevelTaskId(id, processInstanceId, operationTaskId, oldTaskId, "0");
            }
        }
    }

    public void setSameLevelTaskIdMessage(String operationTaskId, String operationType, String processInstanceId, List<HistoricTaskInstance> historicTaskInstances) {
        List<String> idList;
        List taskList = historicTaskInstances != null ? historicTaskInstances.stream().filter(o -> o.getEndTime() == null).collect(Collectors.toList()) : ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().unfinished().processInstanceId(processInstanceId)).list();
        if ("revoke".equals(operationType) && ToolUtil.isNotEmpty(idList = this.flowEventsServiceMapper.getSameLevelTaskIdByOperationTaskId(processInstanceId, operationTaskId))) {
            return;
        }
        if (taskList.size() > 1) {
            String sameLevelTaskId;
            String id;
            String taskDefinitionKey = "";
            if ("revoke".equals(operationType)) {
                taskDefinitionKey = ((HistoricTaskInstance)taskList.get(0)).getTaskDefinitionKey();
            } else {
                for (HistoricTaskInstance task : taskList) {
                    if (!task.getId().equals(operationTaskId)) continue;
                    taskDefinitionKey = task.getTaskDefinitionKey();
                    break;
                }
            }
            ArrayList<HistoricTaskInstance> counterSignTaskList = new ArrayList<HistoricTaskInstance>();
            ArrayList<HistoricTaskInstance> gatewayTaskList = new ArrayList<HistoricTaskInstance>();
            if (ToolUtil.isNotEmpty((Object)taskDefinitionKey)) {
                for (HistoricTaskInstance task : taskList) {
                    if (taskDefinitionKey.equals(task.getTaskDefinitionKey())) {
                        counterSignTaskList.add(task);
                        continue;
                    }
                    gatewayTaskList.add(task);
                }
            }
            if (ToolUtil.isNotEmpty(counterSignTaskList) && counterSignTaskList.size() > 1) {
                id = IdWorker.get32UUID();
                sameLevelTaskId = "";
                for (HistoricTaskInstance task : counterSignTaskList) {
                    if (ToolUtil.isEmpty((Object)sameLevelTaskId)) {
                        sameLevelTaskId = task.getId();
                        continue;
                    }
                    sameLevelTaskId = sameLevelTaskId + "," + task.getId();
                }
                List<String> oldTaskIdList = this.flowEventsServiceMapper.getSameLevelTaskIdBySameLevelTaskId(processInstanceId, operationTaskId);
                String oldTaskId = "";
                if (ToolUtil.isNotEmpty(oldTaskIdList)) {
                    for (String s : oldTaskIdList) {
                        if (s.length() <= oldTaskId.length()) continue;
                        oldTaskId = s;
                    }
                }
                if (oldTaskId.length() > sameLevelTaskId.length()) {
                    sameLevelTaskId = oldTaskId;
                }
                this.flowEventsServiceMapper.setSameLevelTaskId(id, processInstanceId, operationTaskId, sameLevelTaskId, "0");
            }
            if (ToolUtil.isNotEmpty(gatewayTaskList)) {
                id = IdWorker.get32UUID();
                sameLevelTaskId = "";
                for (HistoricTaskInstance task : gatewayTaskList) {
                    if (ToolUtil.isEmpty((Object)sameLevelTaskId)) {
                        sameLevelTaskId = task.getId();
                        continue;
                    }
                    sameLevelTaskId = sameLevelTaskId + "," + task.getId();
                }
                this.flowEventsServiceMapper.setSameLevelTaskId(id, processInstanceId, operationTaskId, sameLevelTaskId, "1");
            }
        }
        if (taskList.size() == 1) {
            String id = IdWorker.get32UUID();
            List<String> oldTaskIdList = this.flowEventsServiceMapper.getSameLevelTaskIdBySameLevelTaskId(processInstanceId, operationTaskId);
            if (ToolUtil.isNotEmpty(oldTaskIdList)) {
                String oldTaskId = "";
                if (ToolUtil.isNotEmpty(oldTaskIdList)) {
                    for (String s : oldTaskIdList) {
                        if (s.length() <= oldTaskId.length()) continue;
                        oldTaskId = s;
                    }
                }
                this.flowEventsServiceMapper.setSameLevelTaskId(id, processInstanceId, operationTaskId, oldTaskId, "0");
            }
        }
    }

    public void setBackToJointlyMessage(String taskId, String key, String nowKey) {
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        String processInstanceId = currTask.getProcessInstanceId();
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId);
        List taskList = taskQuery.list();
        taskList = taskList.stream().filter(o -> !key.equals(o.getTaskDefinitionKey())).collect(Collectors.toList());
        List<Object> taskList2 = new ArrayList();
        Date date = null;
        for (Task task : taskList) {
            if (nowKey.contains(task.getTaskDefinitionKey())) continue;
            boolean flag1 = false;
            if (ToolUtil.isEmpty(date)) {
                date = task.getCreateTime();
                flag1 = true;
            } else if (task.getCreateTime().after(date)) {
                date = task.getCreateTime();
                flag1 = true;
            }
            if (!flag1) continue;
            String realKey = task.getTaskDefinitionKey();
            List taskList1 = taskList.stream().filter(o -> realKey.equals(o.getTaskDefinitionKey())).collect(Collectors.toList());
            if (taskList1.size() <= 1) continue;
            taskList2 = taskList1;
        }
        if (taskList2.size() > 0) {
            String id = IdWorker.get32UUID();
            String sameLevelTaskId = "";
            for (Task task : taskList2) {
                if (ToolUtil.isEmpty((Object)sameLevelTaskId)) {
                    sameLevelTaskId = task.getId();
                    continue;
                }
                sameLevelTaskId = sameLevelTaskId + "," + task.getId();
            }
            this.flowEventsServiceMapper.setSameLevelTaskId(id, processInstanceId, taskId, sameLevelTaskId, "0");
        }
    }

    public String getNowKey(String taskId) {
        String nowKey = "";
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        String processInstanceId = currTask.getProcessInstanceId();
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId);
        List taskList = taskQuery.list();
        for (Task task : taskList) {
            if (ToolUtil.isEmpty((Object)nowKey)) {
                nowKey = task.getTaskDefinitionKey();
                continue;
            }
            nowKey = nowKey + "," + task.getTaskDefinitionKey();
        }
        return nowKey;
    }

    private static class SimpleGroupMessage {
        String groupId;
        List<JSONObject> jsonObjects;
        List<List<String>> childGroupIds;

        private SimpleGroupMessage() {
        }
    }

    private static class NodeMessage {
        String nodeId;
        String parentNode;
        boolean conditionWithNextNode;
        String getewayType;
        List<String> childNodes;

        public NodeMessage(String nodeId, String parentNode, boolean conditionWithNextNode, String gatewayType, List<String> childNodes) {
            this.nodeId = nodeId;
            this.parentNode = parentNode;
            this.conditionWithNextNode = conditionWithNextNode;
            this.getewayType = gatewayType;
            this.childNodes = childNodes;
        }
    }
}

