/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.engine.util.StartResultHandleCmd;
import com.jxdinfo.hussar.bpm.entrusthi.service.EntrustHiSerive;
import com.jxdinfo.hussar.bpm.flowevents.dao.FlowEventsServiceMapper;
import com.jxdinfo.hussar.bpm.notice.service.SysActTaskNoticeService;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.bsp.procpath.service.ISysActProcPathService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.util.DataPushUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class InstanceEngineServiceImpl
implements InstanceEngineService {
    private static Logger LOGGER = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private TaskEngineService taskEngineService;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Resource
    private FlowEventsServiceMapper flowEventsServiceMapper;
    @Autowired
    private ITenantConfigService iTenantConfigService;
    @Autowired
    private EntrustHiSerive entrustHiSerive;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    SysActTaskNoticeService sysActTaskNoticeService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    @Autowired
    ISysActProcPathService sysActProcPathService;
    private static final Map<String, String> TASK_SOURCE_FLAG = new HashMap<String, String>();
    private static final String FINISH_STATE = "finish";
    private static final String NOW_STATE = "complete";
    @Value(value="${bpm.need-log:false}")
    private boolean needLog;

    @Override
    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessKey, String tenantId, Map<String, Object> variables) {
        TenantConfig tenantConfig;
        List<String> users;
        long businessStart = System.currentTimeMillis();
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessKey) > 0L) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4e1a\u52a1\u5df2\u542f\u52a8\u6d41\u7a0b\uff01", null);
        }
        long businessEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4e1a\u52a1\u4e3b\u952e\u552f\u4e00\u6821\u9a8c\u8017\u65f6\uff1a" + (businessEnd - businessStart));
            LOGGER.info("\u4e1a\u52a1\u4e3b\u952e\u552f\u4e00\u6821\u9a8c\u8017\u65f6\uff1a" + (businessEnd - businessStart));
        }
        if (ToolUtil.isNotEmpty(users = this.validateAuthority(userId, processDefinitionId, tenantId, businessKey, variables)) && !users.contains(userId)) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4eba\u5458\u65e0\u6743\u542f\u52a8\u6d41\u7a0b\uff01", null);
        }
        long authorityEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4efb\u52a1\u9274\u6743\u8017\u65f6\uff1a" + (authorityEnd - businessEnd));
            LOGGER.info("\u4efb\u52a1\u9274\u6743\u8017\u65f6\uff1a" + (authorityEnd - businessEnd));
        }
        this.identityService.setAuthenticatedUserId(userId);
        variables = this.installVariables(processDefinitionId, variables);
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (users == null) {
            users = new ArrayList<String>();
        }
        if (users.isEmpty()) {
            users.add(userId);
        }
        HashMap<String, String> appointAssignee = new HashMap<String, String>();
        appointAssignee.put("static_appoint_assignee", String.join((CharSequence)",", users));
        variables.put("appoint_assignee", appointAssignee);
        variables.put("startUser", userId);
        variables.put("sendUser", userId);
        variables.put("cc_send_user", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessKey, variables);
        long end = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u542f\u52a8\u6d41\u7a0b\u8017\u65f6\uff1a" + (end - authorityEnd));
            LOGGER.info("\u542f\u52a8\u6d41\u7a0b\u8017\u65f6\uff1a" + (end - authorityEnd));
        }
        if ((tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId)) != null && "1".equals(tenantConfig.getIsDataPush())) {
            String dataPushAddress = tenantConfig.getDataPushAddress();
            DataPushUtil.DataPushReal(dataPushAddress);
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartResultHandleCmd(processInstance.getProcessInstanceId(), userId));
        long paramEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u7ec4\u88c5\u8fd4\u56de\u503c\u8017\u65f6\uff1a" + (paramEnd - end));
            LOGGER.info("\u7ec4\u88c5\u8fd4\u56de\u503c\u8017\u65f6\uff1a" + (paramEnd - end));
            System.out.println("\u542f\u52a8\u603b\u8017\u65f6\uff1a" + (paramEnd - businessStart));
            LOGGER.info("\u542f\u52a8\u603b\u8017\u65f6\uff1a" + (paramEnd - businessStart));
            System.out.println("\u542f\u52a8\u7ed3\u675f*****************************************");
            LOGGER.info("\u542f\u52a8\u7ed3\u675f*****************************************");
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, String tenantId, Map<String, Object> variables) {
        TenantConfig tenantConfig;
        String processDefinitionId;
        List<String> users;
        long businessStart = System.currentTimeMillis();
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessKey) > 0L) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4e1a\u52a1\u5df2\u542f\u52a8\u6d41\u7a0b\uff01", null);
        }
        long businessEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4e1a\u52a1\u4e3b\u952e\u552f\u4e00\u6821\u9a8c\u8017\u65f6\uff1a" + (businessEnd - businessStart));
            LOGGER.info("\u4e1a\u52a1\u4e3b\u952e\u552f\u4e00\u6821\u9a8c\u8017\u65f6\uff1a" + (businessEnd - businessStart));
        }
        if (ToolUtil.isNotEmpty(users = this.validateAuthority(userId, processDefinitionId = this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId(), tenantId, businessKey, variables)) && !users.contains(userId)) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4eba\u5458\u65e0\u6743\u542f\u52a8\u6d41\u7a0b\uff01", null);
        }
        long authorityEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4efb\u52a1\u9274\u6743\u8017\u65f6\uff1a" + (authorityEnd - businessEnd));
            LOGGER.info("\u4efb\u52a1\u9274\u6743\u8017\u65f6\uff1a" + (authorityEnd - businessEnd));
        }
        this.identityService.setAuthenticatedUserId(userId);
        variables = this.installVariables(processDefinitionId, variables);
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (users == null) {
            users = new ArrayList<String>();
        }
        if (users.isEmpty()) {
            users.add(userId);
        }
        HashMap<String, String> appointAssignee = new HashMap<String, String>();
        appointAssignee.put("static_appoint_assignee", String.join((CharSequence)",", users));
        variables.put("appoint_assignee", appointAssignee);
        variables.put("startUser", userId);
        variables.put("sendUser", userId);
        variables.put("cc_send_user", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessKey, variables);
        long end = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u542f\u52a8\u6d41\u7a0b\u8017\u65f6\uff1a" + (end - authorityEnd));
            LOGGER.info("\u542f\u52a8\u6d41\u7a0b\u8017\u65f6\uff1a" + (end - authorityEnd));
        }
        if ((tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId)) != null && "1".equals(tenantConfig.getIsDataPush())) {
            String dataPushAddress = tenantConfig.getDataPushAddress();
            DataPushUtil.DataPushReal(dataPushAddress);
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartResultHandleCmd(processInstance.getProcessInstanceId(), userId));
        long paramEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u7ec4\u88c5\u8fd4\u56de\u503c\u8017\u65f6\uff1a" + (paramEnd - end));
            LOGGER.info("\u7ec4\u88c5\u8fd4\u56de\u503c\u8017\u65f6\uff1a" + (paramEnd - end));
            System.out.println("\u542f\u52a8\u603b\u8017\u65f6\uff1a" + (paramEnd - businessStart));
            LOGGER.info("\u542f\u52a8\u603b\u8017\u65f6\uff1a" + (paramEnd - businessStart));
            System.out.println("\u542f\u52a8\u7ed3\u675f*****************************************");
            LOGGER.info("\u542f\u52a8\u7ed3\u675f*****************************************");
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, String processCode, String tenantId, Map<String, Object> variables, boolean isCheck) {
        TenantConfig tenantConfig;
        long businessStart = System.currentTimeMillis();
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessKey) > 0L) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4e1a\u52a1\u5df2\u542f\u52a8\u6d41\u7a0b\uff01", null);
        }
        long businessEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u4e1a\u52a1\u4e3b\u952e\u552f\u4e00\u6821\u9a8c\u8017\u65f6\uff1a" + (businessEnd - businessStart));
            LOGGER.info("\u4e1a\u52a1\u4e3b\u952e\u552f\u4e00\u6821\u9a8c\u8017\u65f6\uff1a" + (businessEnd - businessStart));
        }
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId();
        List<Object> users = new ArrayList();
        if (isCheck && ToolUtil.isNotEmpty(users = this.validateAuthority(userId, processDefinitionId, tenantId, businessKey, variables)) && !users.contains(userId)) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4eba\u5458\u65e0\u6743\u542f\u52a8\u6d41\u7a0b\uff01", null);
        }
        long start = System.currentTimeMillis();
        this.identityService.setAuthenticatedUserId(userId);
        variables = this.installVariables(processDefinitionId, variables);
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (isCheck) {
            if (users == null) {
                users = new ArrayList();
            }
            if (users.isEmpty()) {
                users.add(userId);
            }
            HashMap<String, String> appointAssignee = new HashMap<String, String>();
            appointAssignee.put("static_appoint_assignee", String.join((CharSequence)",", users));
            variables.put("appoint_assignee", appointAssignee);
        }
        variables.put("startUser", userId);
        variables.put("sendUser", userId);
        variables.put("cc_send_user", userId);
        if (ToolUtil.isNotEmpty((Object)processCode)) {
            variables.put("lcdp_bpm_process_code", processCode);
        }
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessKey, variables);
        long end = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u542f\u52a8\u6d41\u7a0b\u8017\u65f6\uff1a" + (end - start));
            LOGGER.info("\u542f\u52a8\u6d41\u7a0b\u8017\u65f6\uff1a" + (end - start));
        }
        if ((tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId)) != null && "1".equals(tenantConfig.getIsDataPush())) {
            String dataPushAddress = tenantConfig.getDataPushAddress();
            DataPushUtil.DataPushReal(dataPushAddress);
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartResultHandleCmd(processInstance.getProcessInstanceId(), userId));
        long paramEnd = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u7ec4\u88c5\u8fd4\u56de\u503c\u8017\u65f6\uff1a" + (paramEnd - end));
            LOGGER.info("\u7ec4\u88c5\u8fd4\u56de\u503c\u8017\u65f6\uff1a" + (paramEnd - end));
            System.out.println("\u542f\u52a8\u603b\u8017\u65f6\uff1a" + (paramEnd - businessStart));
            LOGGER.info("\u542f\u52a8\u603b\u8017\u65f6\uff1a" + (paramEnd - businessStart));
            System.out.println("\u542f\u52a8\u7ed3\u675f*****************************************");
            LOGGER.info("\u542f\u52a8\u7ed3\u675f*****************************************");
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult checkProcessInstByBusinessKey(String businessKey) {
        List instance = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).list();
        if (instance != null && instance.size() > 0) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4e1a\u52a1\u5df2\u542f\u52a8\u6d41\u7a0b\uff01", null);
        }
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult validateEditAuthority(String businessKey) {
        JSONArray jsonArray = new JSONArray();
        JSONObject object = new JSONObject();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessKey)).list();
        if (tasks != null && tasks.size() > 0) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).list();
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                object.put("processDefinitionKey", (Object)task.getProcessDefinitionId().substring(0, 21));
                object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                object.put("businessKey", (Object)businessKey);
                object.put("taskId", (Object)task.getId());
                jsonArray.add((Object)object);
                return InstallResult.getResult("1", "success", jsonArray);
            }
            return InstallResult.getResult("0", "\u5f53\u524d\u4e1a\u52a1\u5df2\u542f\u52a8\u6d41\u7a0b\uff01", null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (ToolUtil.isNotEmpty((Object)historicProcessInstance)) {
            return InstallResult.getResult("0", "\u5f53\u524d\u4e1a\u52a1\u5df2\u542f\u52a8\u6d41\u7a0b\uff01", null);
        }
        jsonArray.add((Object)object);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    private List<String> validateAuthority(String userId, String processDefinitionId, String tenantId, String businessKey, Map<String, Object> variables) {
        long start = System.currentTimeMillis();
        String sql = AnalyticalModelUtil.queryFirstNodeAssigneeConfig(userId, tenantId, processDefinitionId, businessKey, variables);
        if (ToolUtil.isEmpty((Object)sql)) {
            return new ArrayList<String>();
        }
        long end = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u83b7\u53d6\u7b5b\u9009\u53c2\u4e0e\u8005\u6761\u4ef6\u8017\u65f6\uff1a" + (end - start));
            LOGGER.info("\u83b7\u53d6\u7b5b\u9009\u53c2\u4e0e\u8005\u6761\u4ef6\u8017\u65f6\uff1a" + (end - start));
        }
        String procPath = this.sysActProcPathService.getProcPath(processDefinitionId.split(":")[0]);
        long end1 = System.currentTimeMillis();
        if (this.needLog) {
            System.out.println("\u83b7\u53d6\u9879\u76ee\u5730\u5740\u8017\u65f6\uff1a" + (end1 - end));
            LOGGER.info("\u83b7\u53d6\u9879\u76ee\u5730\u5740\u8017\u65f6\uff1a" + (end1 - end));
        }
        List<String> users = this.iAssigneeChooseService.getCandidateUser(procPath, sql, tenantId);
        return users;
    }

    @Override
    public BpmResponseResult validateDeleteByBusinessKey(String businessKey) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessKey)).list();
        JSONArray jsonArray = new JSONArray();
        if (tasks != null && tasks.size() > 0) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).list();
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                jsonArray.add((Object)"1");
                return InstallResult.getResult("1", "success", jsonArray);
            }
            jsonArray.add((Object)"2");
            return InstallResult.getResult("1", "\u5f53\u524d\u4e1a\u52a1\u5df2\u542f\u52a8\u6d41\u7a0b\uff01", jsonArray);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (ToolUtil.isNotEmpty((Object)historicProcessInstance)) {
            jsonArray.add((Object)"2");
            return InstallResult.getResult("1", "\u5f53\u524d\u4e1a\u52a1\u5df2\u542f\u52a8\u6d41\u7a0b\uff01", jsonArray);
        }
        jsonArray.add((Object)"0");
        return InstallResult.getResult("1", "success", jsonArray);
    }

    public Map<String, Object> installVariables(String processDefinitionId, Map<String, Object> variables) {
        if (ToolUtil.isEmpty((Object)processDefinitionId)) {
            return variables;
        }
        Map<String, String> map = AnalyticalModelUtil.getTodoConfiguration(processDefinitionId, null);
        if (map.size() == 0) {
            return variables;
        }
        if (variables == null) {
            variables = new HashMap<String, Object>(16);
        }
        variables.put("todoConfiguration", map.get("todoConfiguration"));
        return variables;
    }

    private JSONArray installJson(String processInstanceId, String userId, Map<String, Object> variables) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).includeProcessVariables()).processInstanceId(processInstanceId)).active().list();
        for (Task task : tasks) {
            String todo;
            String completeType;
            String sendUser;
            List<String> users = this.getAssigneeByTaskId(task.getId());
            if (users.size() == 0) {
                this.taskService.setAssignee(task.getId(), userId);
            }
            Map map = task.getTaskLocalVariables() == null ? new HashMap(16) : task.getTaskLocalVariables();
            String string = sendUser = map.get("sendUser") == null ? "" : map.get("sendUser").toString();
            if (ToolUtil.isEmpty((Object)sendUser)) {
                this.taskService.setVariableLocal(task.getId(), "sendUser", (Object)userId);
            }
            String string2 = completeType = map.get("complete_type") == null ? "" : map.get("complete_type").toString();
            if (ToolUtil.isEmpty((Object)completeType)) {
                this.taskService.setVariableLocal(task.getId(), "complete_type", (Object)NOW_STATE);
            }
            String string3 = todo = map.get("todoConfiguration") == null ? "" : map.get("todoConfiguration").toString();
            if (ToolUtil.isEmpty((Object)todo)) {
                this.setVariables(task, variables);
            }
            object.put("processInstanceId", (Object)processInstanceId);
            object.put("taskId", (Object)task.getId());
            object.put("userId", new HashSet<String>(this.getAssigneeByTaskId(task.getId())));
            object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
            object.put("taskDefinitionName", (Object)task.getName());
            object.put("formKey", (Object)task.getFormKey());
            json.add((Object)object);
        }
        return json;
    }

    private void setVariables(Task task, Map<String, Object> variables) {
        Map<String, String> map = AnalyticalModelUtil.getTodoConfiguration(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (map.size() == 0) {
            return;
        }
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        if (variables == null) {
            variables = new HashMap<String, Object>(16);
        }
        variables.putAll(processMap);
        variables.putAll(taskMap);
        String todo = variables.size() > 0 ? AnalyticalModelUtil.getTodo(variables, map.get("todoConfiguration")) : map.get("todoConfiguration");
        this.taskService.setVariableLocal(task.getId(), "todoConfiguration", (Object)todo);
    }

    @Override
    public BpmResponseResult suspendProcessInstanceById(String processInstanceId) {
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult activateProcessInstanceById(String processInstanceId) {
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult deleteProcessInstance(String processInstanceId, String reason) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (historicProcessInstance != null) {
            String dataPushAddress;
            if (historicProcessInstance.getEndTime() != null) {
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            } else {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
                StringBuilder taskIds = new StringBuilder();
                for (Task task : tasks) {
                    if (!ToolUtil.isNotEmpty((Object)task.getDueDate())) continue;
                    taskIds.append(",").append(task.getId());
                }
                if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                    this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
                }
                this.runtimeService.deleteProcessInstance(historicProcessInstance.getId(), "");
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            }
            QueryWrapper ccQueryWrapper = new QueryWrapper();
            ccQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstanceId);
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            QueryWrapper urgeQueryWrapper = new QueryWrapper();
            urgeQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstanceId);
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"process_inst_id", (Object)historicProcessInstance.getId());
            this.entrustHiSerive.remove((Wrapper)queryWrapper);
            QueryWrapper queryWrapperNotice = new QueryWrapper();
            queryWrapperNotice.eq((Object)"process_inst_id", (Object)historicProcessInstance.getId());
            this.sysActTaskNoticeService.remove((Wrapper)queryWrapperNotice);
            TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(historicProcessInstance.getTenantId());
            if (tenantConfig != null && "1".equals(tenantConfig.getIsDataPush()) && ToolUtil.isNotEmpty((Object)(dataPushAddress = tenantConfig.getDataPushAddress()))) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("action", "delete");
                data.put("businessKey", historicProcessInstance.getBusinessKey());
                data.put("processInstanceId", historicProcessInstance.getId());
                HttpUtil.post((String)dataPushAddress, data);
            }
        } else {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff01", null);
        }
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult deleteFinishedProcessInstance(String processInstanceId) {
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        QueryWrapper ccQueryWrapper = new QueryWrapper();
        ccQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstanceId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        QueryWrapper urgeQueryWrapper = new QueryWrapper();
        urgeQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstanceId);
        this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"process_inst_id", (Object)processInstanceId);
        this.entrustHiSerive.remove((Wrapper)queryWrapper);
        QueryWrapper queryWrapperNotice = new QueryWrapper();
        queryWrapperNotice.eq((Object)"process_inst_id", (Object)processInstanceId);
        this.sysActTaskNoticeService.remove((Wrapper)queryWrapperNotice);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult deleteProcessInstanceByBusinessKey(String businessKey) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (historicProcessInstance != null) {
            if (historicProcessInstance.getEndTime() != null) {
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            } else {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(historicProcessInstance.getId())).list();
                StringBuilder taskIds = new StringBuilder();
                for (Task task : tasks) {
                    if (!ToolUtil.isNotEmpty((Object)task.getDueDate())) continue;
                    taskIds.append(",").append(task.getId());
                }
                if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                    this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
                }
                this.runtimeService.deleteProcessInstance(historicProcessInstance.getId(), "");
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            }
        } else {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff01", null);
        }
        this.flowEventsServiceMapper.deleteHistTasksBypProcInstId(historicProcessInstance.getId());
        QueryWrapper ccQueryWrapper = new QueryWrapper();
        ccQueryWrapper.eq((Object)"PROC_INST_ID", (Object)historicProcessInstance.getId());
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        QueryWrapper urgeQueryWrapper = new QueryWrapper();
        urgeQueryWrapper.eq((Object)"PROC_INST_ID", (Object)historicProcessInstance.getId());
        this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"process_inst_id", (Object)historicProcessInstance.getId());
        this.entrustHiSerive.remove((Wrapper)queryWrapper);
        QueryWrapper queryWrapperNotice = new QueryWrapper();
        queryWrapperNotice.eq((Object)"process_inst_id", (Object)historicProcessInstance.getId());
        this.sysActTaskNoticeService.remove((Wrapper)queryWrapperNotice);
        this.flowEventsServiceMapper.deleteGroupId(historicProcessInstance.getId());
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult queryFinishedProcessInstance(String processDefinitionKey, String businessKey, int page, int rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        Long count = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).processDefinitionKey(processDefinitionKey).finished().count();
        List insts = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).processDefinitionKey(processDefinitionKey).finished().listPage((page - 1) * rows, rows);
        object.put("data", (Object)insts);
        object.put("count", (Object)count);
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessInstanceCompleteState(String processInstanceId) {
        JSONArray json = new JSONArray();
        boolean isEnded = true;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null && !processInstance.isEnded()) {
            isEnded = false;
        }
        json.add((Object)isEnded);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessKey) {
        JSONArray json = new JSONArray();
        boolean isEnded = true;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (processInstance != null && !processInstance.isEnded()) {
            isEnded = false;
        }
        json.add((Object)isEnded);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult getProcessTrace(String processInstanceId, String tenantId) {
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("userTask").orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        List<String> userList = new ArrayList<String>();
        if (hisList != null && hisList.size() > 0) {
            userList = hisList.stream().map(HistoricActivityInstance::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (ActivityImpl activity : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("id", (Object)activity.getId());
            List taskList = null;
            if (tasks != null && tasks.size() > 0) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && taskList.size() > 0) {
                List<String> user = this.getAssigneeByTaskId(((Task)taskList.get(0)).getId());
                if (user.size() > 0) {
                    String assignee = this.iAssigneeChooseService.getUserNames(user, tenantId);
                    object.put("assignee", (Object)assignee);
                    object.put("assigneeId", (Object)String.join((CharSequence)",", user));
                } else {
                    object.put("assignee", (Object)"\u65e0\u4efb\u52a1\u63a5\u6536\u4eba");
                    object.put("assigneeId", (Object)"");
                }
                object.put("state", (Object)NOW_STATE);
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && hisList.size() > 0) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getActivityId().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.size() <= 0) continue;
                hisActivitList.sort(Comparator.comparing(HistoricActivityInstance::getStartTime));
                JSONArray json = new JSONArray();
                for (HistoricActivityInstance historicActivityInstance : hisActivitList) {
                    List comments;
                    JSONObject o = new JSONObject();
                    String user = "";
                    String userId = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = finalUsersMap.get(historicActivityInstance.getAssignee());
                        userId = historicActivityInstance.getAssignee();
                    }
                    if ((comments = this.taskService.getTaskComments(historicActivityInstance.getTaskId(), NOW_STATE)) != null && comments.size() > 0) {
                        o.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? "" : ((Comment)comments.get(0)).getFullMessage()));
                    } else {
                        o.put("comments", (Object)"");
                    }
                    o.put("assignee", (Object)user);
                    o.put("assigneeId", (Object)userId);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult getAllProcessTrace(String processInstanceId, String tenantId) {
        List<String> callInstId = this.taskEngineMapper.getCallActivityInstId(processInstanceId);
        String mainInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getSuperProcessInstanceId();
        boolean isGetCall = ToolUtil.isNotEmpty(callInstId);
        if (!isGetCall) {
            callInstId = new ArrayList<String>();
        }
        callInstId.add(processInstanceId);
        if (ToolUtil.isNotEmpty((Object)mainInstanceId)) {
            callInstId.add(mainInstanceId);
        }
        List<Map<String, String>> callCompleteLists = this.flowEventsServiceMapper.getCompleteList(callInstId);
        HashMap<String, ArrayList<Map<String, String>>> callMap = new HashMap<String, ArrayList<Map<String, String>>>();
        for (Map<String, String> map : callCompleteLists) {
            ArrayList<Map<String, String>> callCompleteList = (ArrayList<Map<String, String>>)callMap.get(map.get("processInstanceId"));
            if (callCompleteList == null) {
                callCompleteList = new ArrayList<Map<String, String>>();
            }
            callCompleteList.add(map);
            callMap.put(map.get("processInstanceId"), callCompleteList);
        }
        List completeList = (List)callMap.get(processInstanceId);
        List mainCompleteList = (List)callMap.get(mainInstanceId);
        callMap.remove(mainInstanceId);
        callMap.remove(processInstanceId);
        if (isGetCall) {
            ArrayList indexList = new ArrayList();
            for (List list : callMap.values()) {
                long time = ((Timestamp)((Map)list.get(0)).get("startTime")).getTime();
                int index = completeList.size();
                for (int i = 0; i < completeList.size(); ++i) {
                    if (time >= ((Timestamp)((Map)completeList.get(i)).get("startTime")).getTime()) continue;
                    index = i;
                    break;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("index", String.valueOf(index));
                map.put("processInstanceId", (String)((Map)list.get(0)).get("processInstanceId"));
                indexList.add(map);
            }
            indexList.sort((o1, o2) -> Integer.parseInt((String)o2.get("index")) - Integer.parseInt((String)o1.get("index")));
            for (Map map : indexList) {
                completeList.addAll(Integer.parseInt((String)map.get("index")), (Collection)callMap.get(map.get("processInstanceId")));
            }
        }
        if (ToolUtil.isNotEmpty((Object)mainInstanceId)) {
            int n;
            long time = ((Timestamp)((Map)completeList.get(0)).get("startTime")).getTime();
            int n2 = mainCompleteList.size();
            for (int i = 0; i < mainCompleteList.size(); ++i) {
                if (time >= ((Timestamp)((Map)mainCompleteList.get(i)).get("startTime")).getTime()) continue;
                n = i;
                break;
            }
            mainCompleteList.addAll(n, completeList);
            completeList = mainCompleteList;
        }
        JSONArray json = new JSONArray();
        ArrayList<String> userList = new ArrayList<String>();
        if (completeList != null && completeList.size() > 0) {
            for (Map map : completeList) {
                if (map.get("assigneeId") != null && ((String)map.get("assigneeId")).indexOf(":") > -1) {
                    userList.addAll(Arrays.asList(((String)map.get("assigneeId")).split(":")));
                    continue;
                }
                userList.add((String)map.get("assigneeId"));
            }
        }
        Map<String, String> map = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (completeList != null && completeList.size() > 0) {
            for (Map map2 : completeList) {
                String user;
                JSONObject object = new JSONObject();
                String userId = "";
                if (map2.get("assigneeId") != null) {
                    if (((String)map2.get("assigneeId")).indexOf(":") > -1) {
                        user = map.get(((String)map2.get("assigneeId")).split(":")[0]) == null ? "\u65e0\u529e\u7406\u4eba" : map.get(((String)map2.get("assigneeId")).split(":")[0]);
                        String consignorName = map.get(((String)map2.get("assigneeId")).split(":")[1]);
                        if ("0".equals(map2.get("state"))) {
                            user = user + (consignorName == null ? "" : "(\u59d4\u6258\u4eba\uff1a" + consignorName + ")");
                            userId = ((String)map2.get("assigneeId")).split(":")[0] + (((String)map2.get("assigneeId")).split(":")[1] == null ? "" : "(\u59d4\u6258\u4eba\uff1a" + ((String)map2.get("assigneeId")).split(":")[1] + ")");
                        } else if (!user.equals(consignorName)) {
                            user = user + (consignorName == null ? "" : "(\u8f6c\u529e\u4eba\uff1a" + consignorName + ")");
                            userId = ((String)map2.get("assigneeId")).split(":")[0] + (((String)map2.get("assigneeId")).split(":")[1] == null ? "" : "(\u8f6c\u529e\u4eba\uff1a" + ((String)map2.get("assigneeId")).split(":")[1] + ")");
                        }
                    } else {
                        user = map.get(map2.get("assigneeId")) == null ? "\u65e0\u529e\u7406\u4eba" : map.get(map2.get("assigneeId"));
                        userId = map2.get("assigneeId") == null ? "" : (String)map2.get("assigneeId");
                    }
                } else {
                    user = "\u65e0\u529e\u7406\u4eba";
                }
                object.put("comments", (Object)(ToolUtil.isEmpty(map2.get("comments")) ? "" : map2.get("comments")));
                object.put("startTime", map2.get("startTime"));
                object.put("activityName", map2.get("activityName"));
                object.put("activityId", map2.get("activityId"));
                object.put("taskDefinitionKey", map2.get("taskDefinitionKey"));
                object.put("processDefinitionId", map2.get("processDefinitionId"));
                object.put("processName", map2.get("processName"));
                object.put("processInstanceId", map2.get("processInstanceId"));
                HashMap variables = new HashMap();
                variables.put("taskSourceFlag", map2.get("taskSourceFlag"));
                object.put("variables", variables);
                object.put("taskSourceFlag", map2.get("taskSourceFlag"));
                if ("notice".equals(map2.get("taskType"))) {
                    object.put("assignee", (Object)user);
                    object.put("assigneeId", (Object)userId);
                    if (ToolUtil.isNotEmpty(map2.get("endTime"))) {
                        object.put("comments", map2.get("comments"));
                        object.put("endTime", map2.get("endTime"));
                    } else {
                        object.put("endTime", (Object)"");
                        object.put("comments", (Object)"");
                    }
                    json.add((Object)object);
                    continue;
                }
                if (ToolUtil.isNotEmpty(map2.get("endTime"))) {
                    object.put("assignee", (Object)user);
                    object.put("assigneeId", (Object)userId);
                    object.put("endTime", map2.get("endTime"));
                    json.add((Object)object);
                    continue;
                }
                object.put("endTime", (Object)"");
                List<String> users = this.getAssigneeByTaskId((String)map2.get("activityId"));
                if (users != null && users.size() > 0) {
                    String assignee = this.iAssigneeChooseService.getUserNames(users, tenantId);
                    object.put("assignee", (Object)assignee);
                    object.put("assigneeId", (Object)String.join((CharSequence)",", users));
                }
                object.put("comments", (Object)"");
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessKey, String tenantId, int page, int size) {
        Long count = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessKey)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).count();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessKey)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).listPage((page - 1) * size, size);
        BpmResponseResult bpmResponseResult = this.getResult(hisTaskList, tenantId);
        bpmResponseResult.setMsg(String.valueOf(count));
        return bpmResponseResult;
    }

    private BpmResponseResult getResult(List<HistoricTaskInstance> hisTaskList, String tenantId) {
        JSONArray json = new JSONArray();
        List<String> userList = new ArrayList<String>();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? "\u65e0\u529e\u7406\u4eba" : finalUsersMap.get(hsi.getAssignee())) : "\u65e0\u529e\u7406\u4eba";
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && comments.size() > 0) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? "" : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)"");
                }
                Map variables = hsi.getTaskLocalVariables();
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("activityName", (Object)hsi.getName());
                object.put("userId", (Object)hsi.getAssignee());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInstanceId", (Object)hsi.getProcessInstanceId());
                object.put("variables", (Object)variables);
                if (variables != null && ToolUtil.isNotEmpty(variables.get("taskSourceFlag"))) {
                    object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                } else {
                    object.put("taskSourceFlag", (Object)"");
                }
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                    json.add((Object)object);
                    continue;
                }
                object.put("endTime", (Object)"");
                List<String> users = this.getAssigneeByTaskId(hsi.getId());
                if (user != null && users.size() > 0) {
                    String assignee = this.iAssigneeChooseService.getUserNames(users, tenantId);
                    object.put("assignee", (Object)assignee);
                }
                object.put("comments", (Object)"");
                list.add(object);
            }
            json.addAll(list);
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult getAllProcessTraceByMicroApp(String processInstanceId, String tenantId) {
        JSONArray json = new JSONArray();
        List<String> userList = new ArrayList<String>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        hisTaskList.addAll(nullList);
        if (hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList.size() > 0) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? "\u65e0\u529e\u7406\u4eba" : finalUsersMap.get(hsi.getAssignee())) : "\u65e0\u529e\u7406\u4eba";
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && comments.size() > 0) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? "" : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)"");
                }
                Map variables = hsi.getTaskLocalVariables();
                if (ToolUtil.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && users.size() > 0) {
                        String assignee = this.iAssigneeChooseService.getUserNames(users, tenantId);
                        object.put("assignee", (Object)assignee);
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInstanceId", (Object)hsi.getProcessInstanceId());
                object.put("variables", (Object)variables);
                if (ToolUtil.isNotEmpty(variables.get("taskSourceFlag"))) {
                    object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                } else {
                    object.put("taskSourceFlag", (Object)"");
                }
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult getDoneProcessTrace(String businessKey, String tenantId) {
        JSONArray json = new JSONArray();
        List<String> userList = new ArrayList<String>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessKey)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? "\u65e0\u529e\u7406\u4eba" : finalUsersMap.get(hsi.getAssignee())) : "\u65e0\u529e\u7406\u4eba";
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && comments.size() > 0) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? "" : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)"");
                }
                Map variables = hsi.getTaskLocalVariables();
                if (ToolUtil.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("assignee", (Object)user);
                object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                object.put("time", (Object)(hsi.getEndTime().getTime() - hsi.getStartTime().getTime()));
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInstanceId", (Object)hsi.getProcessInstanceId());
                object.put("variables", (Object)variables);
                if (variables != null) {
                    object.put("error", (Object)TASK_SOURCE_FLAG.get(variables.get("error")));
                } else {
                    object.put("error", (Object)"");
                }
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInstanceId) {
        JSONArray json = new JSONArray();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        processDefinitionModel.setKey(processDefinition.getKey());
        processDefinitionModel.setDescription(processDefinition.getDescription());
        processDefinitionModel.setVersion(String.valueOf(processDefinition.getVersion()));
        processDefinitionModel.setResourceName(processDefinition.getResourceName());
        processDefinitionModel.setDeploymentId(processDefinition.getDeploymentId());
        processDefinitionModel.setDiagramResourceName(processDefinition.getDiagramResourceName());
        processDefinitionModel.setHasStartFormKey(String.valueOf(processDefinition.hasStartFormKey()));
        processDefinitionModel.setHasGraphicalNotation(String.valueOf(processDefinition.hasGraphicalNotation()));
        processDefinitionModel.setIsSuspended(String.valueOf(processDefinition.isSuspended()));
        processDefinitionModel.setTenantId(processDefinition.getTenantId());
        json.add((Object)processDefinitionModel);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeProcessVariables()).includeTaskLocalVariables()).taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        this.taskService.addComment(taskId, null, NOW_STATE, reason);
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"endProcess");
        ActivityImpl destinationActivity = null;
        ActivityImpl currentActivity = null;
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(task.getProcessDefinitionId());
        for (ActivityImpl activityImpl : processDefinition.getActivities()) {
            List pvmTransitionList = activityImpl.getOutgoingTransitions();
            if (pvmTransitionList.isEmpty()) {
                destinationActivity = activityImpl;
            }
            if (!activityImpl.getId().equals(task.getTaskDefinitionKey())) continue;
            currentActivity = activityImpl;
        }
        if (destinationActivity == null) {
            return InstallResult.getResult("0", "\u672a\u627e\u5230\u7ed3\u675f\u8282\u70b9\uff01", null);
        }
        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(task.getExecutionId(), task.getExecutionId(), "endProcess", destinationActivity, null, currentActivity, userId, taskId));
        this.taskEngineService.dataPush(task, reason, userId, "");
        return InstallResult.getResult("1", "success", null);
    }

    private List<String> getAssigneeByTaskId(String taskId) {
        ArrayList<String> users = new ArrayList<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    public BpmResponseResult getCommentMessages(String businessKey, String tenantId) {
        List<Map<String, String>> comments = this.instanceEngineMapper.getCommentMessages(businessKey);
        JSONArray jsonArray = new JSONArray();
        if (ToolUtil.isNotEmpty(comments)) {
            HashMap<String, HashSet<String>> taskAssigneeMap = new HashMap<String, HashSet<String>>();
            ArrayList<String> userIds = new ArrayList<String>();
            for (int i = comments.size() - 1; i > -1; --i) {
                Map<String, String> comment = comments.get(i);
                HashSet<String> assignee = (HashSet<String>)taskAssigneeMap.get(comment.get("taskDefKey"));
                if (assignee == null) {
                    assignee = new HashSet<String>();
                }
                if (assignee.add(comment.get("userId"))) {
                    taskAssigneeMap.put(comment.get("taskDefKey"), assignee);
                    userIds.add(comment.get("userId"));
                    continue;
                }
                comments.remove(i);
            }
            Map<String, String> userNames = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            for (Map<String, String> comment : comments) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("userId", (Object)comment.get("userId"));
                jsonObject.put("userName", (Object)userNames.get(comment.get("userId")));
                jsonObject.put("time", (Object)comment.get("time"));
                jsonObject.put("taskDefKey", (Object)comment.get("taskDefKey"));
                jsonObject.put("taskDefName", (Object)comment.get("taskDefName"));
                jsonObject.put("comment", (Object)comment.get("message"));
                jsonObject.put("procDefId", (Object)comment.get("procDefId"));
                jsonObject.put("procDefName", (Object)comment.get("procDefName"));
                jsonArray.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }

    static {
        TASK_SOURCE_FLAG.put(NOW_STATE, "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("skip", "\u8df3\u8fc7");
        TASK_SOURCE_FLAG.put("reject", "\u9a73\u56de");
        TASK_SOURCE_FLAG.put("entrust", "\u59d4\u6258");
        TASK_SOURCE_FLAG.put("freejump", "\u81ea\u7531\u8df3\u8f6c");
        TASK_SOURCE_FLAG.put("endProcess", "\u5b8c\u6210");
    }
}

