/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.annontion.InterfaceLog;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task"})
public class TaskEngineController {
    private final TaskEngineService taskEngineService;
    private final InstanceEngineService instanceEngineService;

    @Autowired
    public TaskEngineController(TaskEngineService taskEngineService, InstanceEngineService instanceEngineService) {
        this.taskEngineService = taskEngineService;
        this.instanceEngineService = instanceEngineService;
    }

    @RequestMapping(value={"/queryToDoTaskList"})
    @InterfaceLog(key="/task/queryToDoTaskList", value="\u67e5\u8be2\u4ee3\u529e\u5217\u8868", type="\u67e5\u8be2")
    public BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey) {
        return this.taskEngineService.queryToDoTaskList(userId, processDefinitionKey, definitionKey);
    }

    @RequestMapping(value={"/queryToDoTaskListByPage"})
    @InterfaceLog(key="/task/queryToDoTaskListByPage", value="\u67e5\u8be2\u4ee3\u529e\u5217\u8868", type="\u67e5\u8be2")
    public BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        return this.taskEngineService.queryToDoTaskList(userId, processDefinitionKey, definitionKey, page, rows);
    }

    @RequestMapping(value={"/queryFinishedTaskList"})
    @InterfaceLog(key="/task/queryFinishedTaskList", value="\u67e5\u8be2\u5df2\u529e\u5217\u8868", type="\u67e5\u8be2")
    public BpmResponseResult queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey) {
        return this.taskEngineService.queryFinishedTaskList(userId, processDefinitionKey, definitionKey);
    }

    @RequestMapping(value={"/queryFinishedTaskListByPage"})
    @InterfaceLog(key="/task/queryFinishedTaskListByPage", value="\u67e5\u8be2\u5df2\u529e\u5217\u8868", type="\u67e5\u8be2")
    public BpmResponseResult queryFinishedTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        return this.taskEngineService.queryFinishedTaskList(userId, processDefinitionKey, definitionKey, page, rows);
    }

    @RequestMapping(value={"/queryUserTaskCount"})
    @InterfaceLog(key="/task/queryUserTaskCount", value="\u67e5\u8be2\u5404\u4e2a\u6d41\u7a0b\u4ee3\u529e\u6570\u91cf", type="\u67e5\u8be2")
    public BpmResponseResult queryUserTaskCount(String userId) {
        return this.taskEngineService.queryUserTaskCount(userId);
    }

    @RequestMapping(value={"/queryUserTaskCountByNode"})
    @InterfaceLog(key="/task/queryUserTaskCountByNode", value="\u67e5\u8be2\u5404\u4e2a\u8282\u70b9\u4ee3\u529e\u6570\u91cf", type="\u67e5\u8be2")
    public BpmResponseResult queryUserTaskCountByNode(String userId) {
        return this.taskEngineService.queryUserTaskCountByNode(userId);
    }

    @RequestMapping(value={"/claimTask"})
    @InterfaceLog(key="/task/claimTask", value="\u7b7e\u6536\u4efb\u52a1", type="\u7b7e\u6536")
    public BpmResponseResult claimTask(String taskId, String userId) {
        return this.taskEngineService.claimTask(taskId, userId);
    }

    @RequestMapping(value={"/unClaimTask"})
    @InterfaceLog(key="/task/unClaimTask", value="\u53d6\u6d88\u7b7e\u6536", type="\u53d6\u6d88\u7b7e\u6536")
    public BpmResponseResult unClaimTask(String taskId) {
        return this.taskEngineService.unClaimTask(taskId);
    }

    @RequestMapping(value={"/completeTask1"})
    @InterfaceLog(key="/task/completeTask1", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult completeTask(String taskId, String userId, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.completeTask(taskId, userId, variable);
    }

    @RequestMapping(value={"/completeTask2"})
    @InterfaceLog(key="/task/completeTask2", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult completeTask(String taskId, String userId, String assigneeMap, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        return this.taskEngineService.completeTask(taskId, userId, assigneeVariable, (Map<String, Object>)variable);
    }

    @RequestMapping(value={"/completeTask3"})
    @InterfaceLog(key="/task/completeTask3", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult completeTask(String taskId, String userId, String assigneeMap, String comment, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        return this.taskEngineService.completeTask(taskId, userId, assigneeVariable, comment, (Map<String, Object>)variable);
    }

    @RequestMapping(value={"/completeTask4"})
    @InterfaceLog(key="/task/completeTask4", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult completeTask4(String taskId, String userId, String comment, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.completeTask(taskId, userId, comment, (Map<String, Object>)variable);
    }

    @RequestMapping(value={"/completeTask5"})
    @InterfaceLog(key="/task/completeTask5", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult completeTask5(String taskId, String userId, String comment, String subProcesses, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.completeTask(taskId, userId, comment, subProcesses, (Map<String, Object>)variable);
    }

    @RequestMapping(value={"/completeTask6"})
    @InterfaceLog(key="/task/completeTask6", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult completeTask(String taskId, String userId, String assigneeMap, String users, String comment, String map) {
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        Set users1 = (Set)JSON.parseObject((String)users, Set.class);
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.completeTask(taskId, userId, assigneeVariable, users1, comment, variable);
    }

    @RequestMapping(value={"/completeTaskWithOutCheck"})
    @InterfaceLog(key="/task/completeTaskWithOutCheck", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult completeTaskWithOutCheck(String taskId, String userId, String assigneeMap, String users, String comment, String map) {
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        Set users1 = (Set)JSON.parseObject((String)users, Set.class);
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.completeTaskWithOutCheck(taskId, userId, assigneeVariable, users1, comment, variable);
    }

    @RequestMapping(value={"/startAndCompleteTask"})
    @Transactional(rollbackFor={PublicClientException.class})
    @InterfaceLog(key="/task/startAndCompleteTask", value="\u542f\u52a8\u5e76\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult startAndCompleteTask(String processDefinitionKey, String userId, String businessKey, String variables, String tenantId, String assigneeMap, String users, String comment, String map) {
        String taskId = "";
        Map variablesMap = (Map)JSON.parseObject((String)variables, HashMap.class);
        BpmResponseResult startResult = this.instanceEngineService.startProcessInstanceByKey(processDefinitionKey, userId, businessKey, null, tenantId, variablesMap, true);
        if (!"1".equals(startResult.getCode())) {
            return InstallResult.getResult("0", "error", null);
        }
        taskId = (String)startResult.getResult().getJSONObject(0).get((Object)"taskId");
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        Set users1 = (Set)JSON.parseObject((String)users, Set.class);
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.completeTask(taskId, userId, assigneeVariable, users1, comment, variable);
    }

    @RequestMapping(value={"/completeLeapTask"})
    @InterfaceLog(key="/task/completeLeapTask", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult completeLeapTask(String taskId, String userId, String assigneeMap, String comment, String map) {
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.completeLeapTask(taskId, userId, assigneeVariable, comment, variable);
    }

    @RequestMapping(value={"/completeLeapTask1"})
    @InterfaceLog(key="/task/completeLeapTask1", value="\u4efb\u52a1\u529e\u7406", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult completeLeapTask(String taskId, String userId, String assigneeMap, String users, String comment, String map) {
        Set user = (Set)JSON.parseObject((String)users, Set.class);
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        return this.taskEngineService.completeLeapTask(taskId, userId, assigneeVariable, user, comment, variable);
    }

    @RequestMapping(value={"/rejectToLastTask"})
    @InterfaceLog(key="/task/rejectToLastTask", value="\u4efb\u52a1\u9a73\u56de\u81f3\u4e0a\u4e00\u4e2a\u8282\u70b9", type="\u4efb\u52a1\u9a73\u56de")
    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.rejectToLastTask(taskId, userId, comment, assignees, isSubmit, variable);
    }

    @RequestMapping(value={"/rejectToFirstTask"})
    @InterfaceLog(key="/task/rejectToFirstTask", value="\u4efb\u52a1\u9a73\u56de\u81f3\u7b2c\u4e00\u4e2a\u8282\u70b9", type="\u4efb\u52a1\u9a73\u56de")
    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.rejectToFirstTask(taskId, userId, comment, assignees, isSubmit, variable);
    }

    @RequestMapping(value={"/rejectToAnyTask"})
    @InterfaceLog(key="/task/rejectToAnyTask", value="\u4efb\u52a1\u9a73\u56de\u81f3\u4efb\u610f\u8282\u70b9", type="\u4efb\u52a1\u9a73\u56de")
    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, assignees, isSubmit, variable);
    }

    @RequestMapping(value={"/queryRejectNode"})
    @InterfaceLog(key="/task/queryRejectNode", value="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9", type="\u67e5\u8be2")
    public BpmResponseResult queryRejectNode(String taskId) {
        return this.taskEngineService.queryRejectNode(taskId);
    }

    @RequestMapping(value={"/delegateTask"})
    @InterfaceLog(key="/task/delegateTask", value="\u4efb\u52a1\u59d4\u6258", type="\u4efb\u52a1\u59d4\u6258")
    public BpmResponseResult delegateTask(String taskId, String userId) {
        return this.taskEngineService.delegateTask(taskId, userId);
    }

    @RequestMapping(value={"/entrustTask"})
    @InterfaceLog(key="/task/entrustTask", value="\u4efb\u52a1\u8f6c\u529e", type="\u4efb\u52a1\u59d4\u6258")
    public BpmResponseResult entrustTask(String taskId, String userId, String consignee, String comment) {
        return this.taskEngineService.entrustTask(taskId, userId, consignee, comment);
    }

    @RequestMapping(value={"/entrustTaskByTaskId"})
    @InterfaceLog(key="/task/entrustTaskByTaskId", value="\u4efb\u52a1\u59d4\u6258", type="\u4efb\u52a1\u59d4\u6258")
    public BpmResponseResult entrustTask(String taskId, String consignee) {
        return this.taskEngineService.entrustTask(taskId, consignee);
    }

    @RequestMapping(value={"/freeJump"})
    @InterfaceLog(key="/task/freeJump", value="\u81ea\u7531\u8df3\u8f6c", type="\u4efb\u52a1\u529e\u7406")
    public BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.freeJump(taskId, activitiId, userId, assignees, isSubmit, comment, variable);
    }

    @RequestMapping(value={"/multiInstanceAddAssignee"})
    @InterfaceLog(key="/task/multiInstanceAddAssignee", value="\u4f1a\u7b7e\u8282\u70b9\u589e\u52a0\u529e\u7406\u4eba", type="\u65b0\u589e")
    public BpmResponseResult multiInstanceAddAssignee(String taskId, String assigneeList) {
        List list = (List)JSON.parseObject((String)assigneeList, List.class);
        return this.taskEngineService.multiInstanceAddAssignee(taskId, list);
    }

    @RequestMapping(value={"/queryAssigneeByTaskId"})
    @InterfaceLog(key="/task/queryAssigneeByTaskId", value="\u67e5\u8be2\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005", type="\u67e5\u8be2")
    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        return this.taskEngineService.queryAssigneeByTaskId(taskId);
    }

    @RequestMapping(value={"/addAssignees"})
    @InterfaceLog(key="/task/addAssignees", value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u6216\u8005\u662f\u4efb\u52a1id\u7ed9\u4efb\u52a1\u6dfb\u52a0\u53c2\u4e0e\u8005", type="\u67e5\u8be2")
    public BpmResponseResult addAssignees(String taskId, String businessKey, String users) {
        return this.taskEngineService.addAssignees(taskId, businessKey, users);
    }

    @RequestMapping(value={"/queryProcessNodeByTaskId"})
    @InterfaceLog(key="/task/queryProcessNodeByTaskId", value="\u67e5\u8be2\u6d41\u7a0b\u8282\u70b9", type="\u67e5\u8be2")
    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        return this.taskEngineService.queryProcessNodeByTaskId(taskId);
    }

    @RequestMapping(value={"/queryNextAssigneeByTaskIdAndNodeId"})
    @InterfaceLog(key="/task/queryNextAssigneeByTaskIdAndNodeId", value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", type="\u67e5\u8be2")
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String tenantId, String nodeId, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, variable);
    }

    @RequestMapping(value={"/queryNextAssignee"})
    @InterfaceLog(key="/task/queryNextAssignee", value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", type="\u67e5\u8be2")
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processDefinitionKey, String taskId, String tenantId, String nodeId, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(processDefinitionKey, taskId, nodeId, tenantId, variable);
    }

    @RequestMapping(value={"/queryHistoryActByTaskId"})
    @InterfaceLog(key="/task/queryHistoryActByTaskId", value="\u67e5\u8be2\u5386\u53f2\u8282\u70b9\u4fe1\u606f", type="\u67e5\u8be2")
    public BpmResponseResult queryHistoryActByTaskId(String taskId) {
        return this.taskEngineService.queryHistoryActByTaskId(taskId);
    }

    @RequestMapping(value={"/getProcessDefinitionIdAndNodeId"})
    @InterfaceLog(key="/task/getProcessDefinitionIdAndNodeId", value="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u6216\u8005taskId\u83b7\u53d6\u6d41\u7a0b\u7248\u672cID\u548c\u8282\u70b9id", type="\u67e5\u8be2")
    public BpmResponseResult getProcessDefinitionIdAndNodeId(String processDefinitionKey, String taskId) {
        return this.taskEngineService.getProcessDefinitionIdAndNodeId(processDefinitionKey, taskId);
    }

    @RequestMapping(value={"/queryTaskIdByBusinessKey"})
    @InterfaceLog(key="/task/queryTaskIdByBusinessKey", value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u67e5\u8be2\u4efb\u52a1ID", type="\u67e5\u8be2")
    public BpmResponseResult queryTaskIdByBusinessKey(String businessId) {
        return this.taskEngineService.queryTaskIdByBusinessKey(businessId);
    }

    @RequestMapping(value={"/queryNextNodeByTaskId"})
    @InterfaceLog(key="/task/queryNextNodeByTaskId", value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9", type="\u67e5\u8be2")
    public BpmResponseResult queryNextNode(String taskId) {
        return this.taskEngineService.queryNextNode(taskId);
    }

    @RequestMapping(value={"/queryNextNode"})
    @InterfaceLog(key="/task/queryNextNode", value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9", type="\u67e5\u8be2")
    public BpmResponseResult queryNextNode(String processDefinitionKey, String taskId) {
        return this.taskEngineService.queryNextNode(processDefinitionKey, taskId);
    }

    @RequestMapping(value={"/withdrawState"})
    @InterfaceLog(key="/task/withdrawState", value="\u67e5\u8be2\u80fd\u5426\u64a4\u56de", type="\u67e5\u8be2")
    public BpmResponseResult withdrawState(String historicTaskId) {
        return this.taskEngineService.withdrawState(historicTaskId);
    }

    @RequestMapping(value={"/withdrawStateByBusinessKey"})
    @InterfaceLog(key="/task/withdrawStateByBusinessKey", value="\u67e5\u8be2\u80fd\u5426\u64a4\u56de", type="\u67e5\u8be2")
    public BpmResponseResult withdrawState(String businessKey, String userId, String taskId) {
        return this.taskEngineService.withdrawState(businessKey, userId, taskId);
    }

    @RequestMapping(value={"/revokeTask"})
    @InterfaceLog(key="/task/revokeTask", value="\u4efb\u52a1\u64a4\u56de", type="\u64a4\u56de")
    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.revokeTask(historicTaskId, userId, comment, isSubmit, variable);
    }

    @RequestMapping(value={"/getPreviousNodeAssignee"})
    @InterfaceLog(key="/task/getPreviousNodeAssignee", value="\u83b7\u53d6\u4e0a\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u7b49\u76f8\u5173\u4fe1\u606f", type="\u67e5\u8be2")
    public BpmResponseResult getPreviousNodeAssignee(String taskId, String tenantId) {
        return this.taskEngineService.getPreviousNodeAssignee(taskId, tenantId);
    }

    @RequestMapping(value={"/getTaskNodeAssignee"})
    @InterfaceLog(key="/task/getTaskNodeAssignee", value="\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005\u7b49\u76f8\u5173\u4fe1\u606f", type="\u67e5\u8be2")
    public BpmResponseResult getTaskNodeAssignee(String taskId, String tenantId) {
        return this.taskEngineService.getTaskNodeAssignee(taskId, tenantId);
    }

    @RequestMapping(value={"/getPreviousDefaultOrConditionAssignee"})
    @InterfaceLog(key="/task/getPreviousDefaultOrConditionAssignee", value="\u83b7\u53d6\u4e0a\u4e00\u8282\u70b9\u914d\u7f6e\u7684\u53c2\u4e0e\u8005", type="\u67e5\u8be2")
    public BpmResponseResult getPreviousDefaultOrConditionAssignee(String taskId, String tenantId, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return this.taskEngineService.getPreviousDefaultOrConditionAssignee(taskId, tenantId, variable);
    }
}

