/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.definition.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class ProcessDefinitionsServiceImpl
implements ProcessDefinitionsService {
    @Value(value="${spring.datasource.url:}")
    private String url;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    TaskService taskService;
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    ModelService modelService;
    @Autowired
    ProcessDefinitionsMapper processDefinitionsMapper;

    @Override
    public Map<String, Object> queryProcessDefinitionsList(String definitionName, Integer page, Integer limit) {
        List<Object> instList = new ArrayList();
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        instList = this.processDefinitionsMapper.getList((Page<DefinitionModel>)pages, definitionName);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("count", pages.getTotal());
        dataMap.put("data", instList);
        return dataMap;
    }

    @Override
    @Cacheable(value={"workflowMainOrNewMessage"}, key="'workflowMainOrNewMessage:'+#processDefKey")
    public DefinitionModel getMainOrNew(String processDefKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processDefKey);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @CacheEvict(cacheNames={"workflowMainOrNewMessage"}, allEntries=true)
    public int setMain(String processDefKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processDefKey, null) + this.processDefinitionsMapper.setMain(id);
        num += this.processDefinitionsMapper.setModelMain(id);
        if ("oracle".equals(this.url.split(":")[1])) {
            this.processDefinitionsMapper.setNameOracle(processDefKey);
        } else {
            this.processDefinitionsMapper.setNameNotOracle(processDefKey);
        }
        return num;
    }

    @Override
    @CacheEvict(cacheNames={"workflowMainOrNewMessage"}, allEntries=true)
    public int cancelMain(String processDefKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processDefKey, id);
        if ("oracle".equals(this.url.split(":")[1])) {
            this.processDefinitionsMapper.setNameOracle(processDefKey);
        } else {
            this.processDefinitionsMapper.setNameNotOracle(processDefKey);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadXml(HttpServletRequest request, HttpServletResponse response) {
        OutputStream out = null;
        InputStream in = null;
        String deploymentId = request.getParameter("deploymentId") == null ? "" : request.getParameter("deploymentId");
        String resourceName = request.getParameter("resourceName") == null ? "" : request.getParameter("resourceName");
        try {
            int len;
            in = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(deploymentId, resourceName);
            byte[] b = new byte[1024];
            out = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(resourceName.getBytes("GBK"), StandardCharsets.ISO_8859_1));
            response.setContentType("application/octet-stream");
            while ((len = in.read(b, 0, 1024)) != -1) {
                out.write(b, 0, len);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    @Override
    public void editTemporaryDefId(String defId, String instId, String version) {
        if ("mysql".equals(this.url.split(":")[1]) || "oscar".equals(this.url.split(":")[1])) {
            this.processDefinitionsMapper.editTemporaryDefIdMySql(defId, instId, version);
        } else {
            this.processDefinitionsMapper.editTemporaryDefIdOracle(defId, instId, version);
        }
    }

    @Override
    public void downloadFiles(String tenantId, HttpServletRequest request, HttpServletResponse response) {
        String deploymentId = request.getParameter("deploymentId") == null ? "" : request.getParameter("deploymentId");
        String resourceName = request.getParameter("resourceName") == null ? "" : request.getParameter("resourceName");
        DefinitionModel processDefinitionModel = this.processDefinitionsMapper.getById(deploymentId);
        String key = processDefinitionModel.getId();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        ZipOutputStream zipOutputStream = null;
        ByteArrayInputStream in = null;
        try {
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
            response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
            HashMap fileMap = new HashMap();
            ArrayList files = new ArrayList();
            zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            fileMap.put(processDefinitionModel.getName(), files);
            in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(deploymentId, resourceName);
            String filename = processDefinitionModel.getName() + "_" + key.split(":")[0] + "/" + key.replace(":", "_") + ".bpmn20.xml";
            ZipEntry zipEntry = new ZipEntry(filename);
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            in.close();
            this.modelService.toFileZip(tenantId, null, key, zipOutputStream);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getStartProcessDefinitionId(String processKey) {
        List<String> list = this.processDefinitionsMapper.getProcessDefinitionIdList(processKey);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new PublicClientException("\u6d41\u7a0b\u6807\u8bc6\u53c2\u6570\u9519\u8bef", false);
    }
}

