/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.mutidatasource.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.jxdinfo.hussar.bpm.common.constant.DatabaseType;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.core.mutidatasource.DataSourceContextHolder;
import com.jxdinfo.hussar.core.mutidatasource.DynamicDataSource;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.encrypt.util.SM4Util;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ChangeDatasource {
    public void change(SysUser sysUser) {
        if ("admin".equals(sysUser.getUserAccount())) {
            DataSourceContextHolder.setDataSource("master");
            return;
        }
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)SpringContextHolder.getBean(DynamicDataSource.class));
        Map<Object, Object> map = dynamicDataSource.getDynamicTargetDataSources();
        if (map != null && ToolUtil.isNotEmpty((Object)map.get(sysUser.getTenantId()))) {
            DataSourceContextHolder.setDataSource(sysUser.getTenantId());
            return;
        }
        this.changeSavedDateBase(sysUser.getTenantId(), sysUser);
        DataSourceContextHolder.setDataSource(sysUser.getTenantId());
    }

    public void changeSavedDateBase(String tenantId, SysUser sysUser) {
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)SpringContextHolder.getBean(DynamicDataSource.class));
        DruidDataSource dataSource = new DruidDataSource();
        String ip = SM4Util.decrypt((String)sysUser.getConnectionIp(), (String)"admin#$%^kopoiuy");
        String port = SM4Util.decrypt((String)sysUser.getConnectionPort(), (String)"admin#$%^kopoiuy");
        String name = SM4Util.decrypt((String)sysUser.getConnectionName(), (String)"admin#$%^kopoiuy");
        String pass = SM4Util.decrypt((String)sysUser.getConnectionPass(), (String)"admin#$%^kopoiuy");
        String dbName = SM4Util.decrypt((String)sysUser.getDbName(), (String)"admin#$%^kopoiuy");
        String type = sysUser.getDbType();
        String url = "";
        if (DatabaseType.MYSQL.getName().equals(type)) {
            url = DatabaseType.MYSQL.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.MYSQL.getSuffix();
            dataSource.setDriverClassName(DatabaseType.MYSQL.getDriver());
        } else if (DatabaseType.ORACLE.getName().equals(type)) {
            url = DatabaseType.ORACLE.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.ORACLE.getSuffix();
            dataSource.setDriverClassName(DatabaseType.ORACLE.getDriver());
        } else if (DatabaseType.DM.getName().equals(type)) {
            url = DatabaseType.DM.getPrefix() + ip + ":" + port + "/" + dbName + DatabaseType.DM.getSuffix();
            dataSource.setDriverClassName(DatabaseType.DM.getDriver());
        }
        dataSource.setUrl(url);
        dataSource.setUsername(name);
        dataSource.setPassword(pass);
        if (ToolUtil.isNotEmpty((Object)dynamicDataSource.getDynamicTargetDataSources().get(tenantId))) {
            dynamicDataSource.delDatasources(tenantId);
        }
        dynamicDataSource.createDataSource(tenantId, dataSource);
    }

    public void change() {
        DataSourceContextHolder.setDataSource("master");
    }
}

