/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.rabbitmq.sender;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="mq", name={"use"}, havingValue="true")
public class MqSendService {
    @Value(value="${mq.exchange.exchange}")
    String EXCHANGE;
    @Value(value="${mq.exchange.queue}")
    String QUEUE;
    @Value(value="${mq.exchange.routekey}")
    String ROUTE_KEY;
    @Autowired
    private AmqpTemplate amqpTemplate;
    @Autowired
    private AmqpAdmin amqpAdmin;

    public void sendStringMessage(Object object, String msg) {
        JSONObject sendObject = new JSONObject();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd :hh:mm:ss");
        sendObject.put("time", (Object)dateFormat.format(new Date()));
        sendObject.put("data", object);
        sendObject.put("failReason", (Object)msg);
        this.amqpTemplate.convertAndSend(this.EXCHANGE, this.ROUTE_KEY, (Object)sendObject);
    }

    @PostConstruct
    private void init() {
        this.amqpAdmin.declareExchange((Exchange)new DirectExchange(this.EXCHANGE));
        this.amqpAdmin.declareQueue(new Queue(this.QUEUE, true));
        this.amqpAdmin.declareBinding(new Binding(this.QUEUE, Binding.DestinationType.QUEUE, this.EXCHANGE, this.ROUTE_KEY, null));
    }
}

