/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.rabbitmq.receiver;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.rabbitmq.sender.MqSendService;
import com.jxdinfo.hussar.bsp.rabbitmq.service.IHussarBpmOrganService;
import com.jxdinfo.hussar.bsp.rabbitmq.service.IHussarBpmRoleService;
import com.jxdinfo.hussar.bsp.rabbitmq.service.IHussarBpmUserRoleService;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.mutidatasource.util.ChangeDatasource;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="mq", name={"use"}, havingValue="true")
@EnableRabbit
public class ClientListenerReceiver {
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ChangeDatasource changeDatasource;
    @Autowired
    private IHussarBpmOrganService organService;
    @Autowired
    private IHussarBpmRoleService roleService;
    @Autowired
    private IHussarBpmUserRoleService userRoleService;
    @Autowired
    MqSendService mqSendService;
    @Autowired
    private AmqpAdmin amqpAdmin;
    public static final String DATA_ORGAN = "organ";
    public static final String DATA_ROLE = "role";
    public static final String DATA_USER_ROLE = "userRole";
    public static final String OPERATION_ADD = "add";
    public static final String OPERATION_UPDATE = "update";
    public static final String OPERATION_DELETE = "delete";
    public static final String OPERATION_DELETE_BY_USERID = "deleteByUserId";
    public static final String OPERATION_DELETE_BY_ROLEID = "deleteByRoleId";
    public static final String TENANT_FALSE = "\u79df\u6237\u4fe1\u606f\u9519\u8bef";
    public static final String DATA_TYPE_FALSE = "\u6570\u636e\u7c7b\u578b\u9519\u8bef";
    public static final String OPERTAION_TYPE_FALSE = "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef";
    public static final String SQL_TYPE_FALSE = "\u6570\u636e\u9519\u8bef\u6216mqSql\u670d\u52a1\u5668\u5f02\u5e38";
    @Value(value="${mq.exchange.queue-get}")
    String QUEUE_GET;

    @PostConstruct
    private void init() {
        this.amqpAdmin.declareQueue(new Queue(this.QUEUE_GET, true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RabbitListener(queues={"${mq.exchange.queue-get}"})
    public void receiveMqModelMessage(Message message, Channel channel) {
        Map model = (Map)JSONObject.parse((String)new String(message.getBody()));
        Map map = (Map)model.get("data");
        String tenantId = (String)map.get("tenantId");
        String tenantCipher = (String)map.get("tenantCipher");
        String dataType = (String)map.get("dataType");
        String operationType = (String)map.get("operationType");
        Object listTextObject = map.get("data");
        try {
            block26: {
                block28: {
                    block27: {
                        if (ToolUtil.isEmpty(listTextObject)) {
                            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                            return;
                        }
                        if (ToolUtil.isEmpty((Object)tenantId) || ToolUtil.isEmpty((Object)tenantCipher)) {
                            this.mqSendService.sendStringMessage(map, TENANT_FALSE);
                            channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
                            return;
                        }
                        SysUser sysUser = this.sysUserService.queryTenantByTenantId(tenantId, tenantCipher);
                        if (ToolUtil.isEmpty((Object)sysUser)) {
                            this.mqSendService.sendStringMessage(map, TENANT_FALSE);
                            channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
                            return;
                        }
                        this.changeDatasource.change(sysUser);
                        if (!DATA_ORGAN.equals(dataType)) break block27;
                        if (OPERATION_DELETE.equals(operationType)) {
                            String listText = (String)listTextObject;
                            List<String> list = Arrays.asList(listText.split(","));
                            this.organService.removeByIds(list);
                            break block26;
                        } else if (OPERATION_UPDATE.equals(operationType)) {
                            List list = (List)listTextObject;
                            this.organService.updateBatchById(list);
                            break block26;
                        } else {
                            if (!OPERATION_ADD.equals(operationType)) {
                                this.mqSendService.sendStringMessage(map, OPERTAION_TYPE_FALSE);
                                channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
                                return;
                            }
                            List list = (List)listTextObject;
                            this.organService.saveBatch(list);
                        }
                        break block26;
                    }
                    if (!DATA_ROLE.equals(dataType)) break block28;
                    if (OPERATION_DELETE.equals(operationType)) {
                        String listText = (String)listTextObject;
                        List<String> list = Arrays.asList(listText.split(","));
                        this.roleService.removeByIds(list);
                        break block26;
                    } else if (OPERATION_UPDATE.equals(operationType)) {
                        List list = (List)listTextObject;
                        this.roleService.updateBatchById(list);
                        break block26;
                    } else {
                        if (!OPERATION_ADD.equals(operationType)) {
                            this.mqSendService.sendStringMessage(map, OPERTAION_TYPE_FALSE);
                            channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
                            return;
                        }
                        List lists = (List)listTextObject;
                        for (Map data : lists) {
                            if (!ToolUtil.isEmpty(data.get("sort"))) continue;
                            data.put("sort", "0");
                        }
                        List list = (List)listTextObject;
                        this.roleService.saveBatch(list);
                    }
                    break block26;
                }
                if (!DATA_USER_ROLE.equals(dataType)) {
                    this.mqSendService.sendStringMessage(map, DATA_TYPE_FALSE);
                    channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
                    return;
                }
                if (OPERATION_DELETE.equals(operationType)) {
                    List list = (List)listTextObject;
                    this.userRoleService.removeByListUserRole(list);
                } else if (OPERATION_DELETE_BY_USERID.equals(operationType)) {
                    List<String> list = Arrays.asList(((String)listTextObject).split(","));
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.in((Object)"user_id", list);
                    this.userRoleService.remove((Wrapper)queryWrapper);
                } else if (OPERATION_DELETE_BY_ROLEID.equals(operationType)) {
                    List<String> list = Arrays.asList(((String)listTextObject).split(","));
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.in((Object)"granted_role", list);
                    this.userRoleService.remove((Wrapper)queryWrapper);
                } else {
                    if (!OPERATION_ADD.equals(operationType)) {
                        this.mqSendService.sendStringMessage(map, OPERTAION_TYPE_FALSE);
                        channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
                        return;
                    }
                    List list = (List)listTextObject;
                    this.userRoleService.saveBatch(list);
                }
            }
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            return;
        }
        catch (Exception e) {
            this.mqSendService.sendStringMessage(map, SQL_TYPE_FALSE);
            try {
                channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
                return;
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }
}

