/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.timeouthandle.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.listener.ActivityCompletedListener;
import com.jxdinfo.hussar.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bpm.timeouthandle.util.HussarEhcacheManager;
import com.jxdinfo.hussar.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.mutidatasource.DataSourceContextHolder;
import com.jxdinfo.hussar.core.mutidatasource.util.ChangeDatasource;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.crazycake.shiro.RedisManager;
import org.springframework.amqp.utils.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class ActivityRedisTimerServiceImpl
implements ApplicationRunner,
ActivityRedisTimerService {
    private ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("example-schedule-pool-%d").daemon(true).build());
    private static Logger logger = LogManager.getLogger(ActivityCompletedListener.class);
    private static final String BPM_ACTIVITY_TIMER_SCORE_LIST = "bpm_activity:timer:score_list";
    private static final String BPM_ACTIVITY_TIMER_TASK_MESSAGE = "bpm_activity:timer:task_Message:";
    private static final String BPM_TIMER_ACTIVITY = "bpm_timer_activity";
    @Resource
    LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private TaskEngineService taskEngineService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private HussarEhcacheManager hussarEhcacheManager;
    @Autowired
    private ActivityRedisTimerMapper activityRedisTimerMapper;
    private static RedisManager redisManager;
    private static boolean isGetList;
    private static Set<String> errorSysUsers;
    private static List<Long> timeOutList;
    private static Map<Long, String> timeOutMap;
    private static List<Long> getListTimeAddModel;
    private static List<String> getListTimeDelModel;
    private static boolean isUseRedis;
    @Value(value="${bpm.use-redis:false}")
    private boolean useRedis;

    @PostConstruct
    private void init() {
        isUseRedis = this.useRedis;
    }

    private Jedis getJedits() {
        if (redisManager == null) {
            redisManager = new RedisManager();
        }
        if (redisManager.getJedisPool() == null) {
            redisManager.setJedisPool(new JedisPool());
        }
        return redisManager.getJedisPool().getResource();
    }

    public void run(ApplicationArguments args) {
        this.executorService.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ActivityRedisTimerServiceImpl.this.handleAllTimeOutTask(System.currentTimeMillis());
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void getList() {
        try {
            DataSourceContextHolder.setDataSource("master");
            List sysUsers = this.sysUserService.list();
            for (SysUser sysUser : sysUsers) {
                if ("admin".equals(sysUser.getUserAccount()) || !"2".equals(sysUser.getTenantType())) continue;
                try {
                    ChangeDatasource changeDatasource = new ChangeDatasource();
                    changeDatasource.changeSavedDateBase(sysUser.getTenantId(), sysUser);
                    DataSourceContextHolder.setDataSource(sysUser.getTenantId());
                    if (!this.sysUserService.testConn(sysUser.getTenantId())) {
                        logger.error("\u79df\u6237" + sysUser.getUserAccount() + "\u8fde\u63a5\u5bf9\u5e94\u79df\u6237\u5e93\u5931\u8d25\uff0ctenantId:" + sysUser.getTenantId());
                        continue;
                    }
                    List timeOutModels = this.activityRedisTimerMapper.selectList(null);
                    for (TimeOutModel timeOutModel : timeOutModels) {
                        this.hussarEhcacheManager.setObject(BPM_TIMER_ACTIVITY, timeOutModel.getTaskId(), (Object)timeOutModel);
                        Long time = timeOutModel.getDueTime().getTime();
                        timeOutList.add(time);
                        timeOutMap.put(time, timeOutMap.get(time) == null ? timeOutModel.getTaskId() : timeOutMap.get(time) + "," + timeOutModel.getTaskId());
                    }
                }
                catch (Exception e) {
                    logger.error("\u79df\u6237" + sysUser.getUserAccount() + "\u79df\u6237\u5e93\u83b7\u53d6\u8d85\u65f6\u4fe1\u606f\u51fa\u9519\uff1a" + e.getMessage());
                }
            }
            if (getListTimeDelModel.size() > 0) {
                this.hussarEhcacheManager.delcache(BPM_TIMER_ACTIVITY, getListTimeDelModel);
            }
            timeOutList.sort((o1, o2) -> (int)(o1 - o2));
            while (getListTimeAddModel.size() > 0) {
                int index = timeOutList.size();
                for (int i = 0; i < timeOutList.size() && timeOutList.get(i) < getListTimeAddModel.get(0); ++i) {
                    index = i + 1;
                }
                timeOutList.add(index, getListTimeAddModel.get(0));
                getListTimeAddModel.remove(0);
            }
        }
        catch (Exception e) {
            logger.error("\u8d85\u65f6\u5904\u7406\u4fe1\u606f\u7f13\u5b58\u540c\u6b65\u5931\u8d25" + e.getMessage());
        }
        isGetList = false;
    }

    private void timeOutTaskHandler(TimeOutModel timeOutModel, boolean isDelTimeOutTableMessage) {
        if (errorSysUsers.contains(timeOutModel.getTenantId())) {
            return;
        }
        try {
            DataSourceContextHolder.setDataSource("master");
            SysUser sysUser = this.sysUserService.getUserByTenantId(timeOutModel.getTenantId());
            if (ToolUtil.isEmpty((Object)sysUser)) {
                errorSysUsers.add(timeOutModel.getTenantId());
                return;
            }
            ChangeDatasource changeDatasource = new ChangeDatasource();
            changeDatasource.changeSavedDateBase(sysUser.getTenantId(), sysUser);
            DataSourceContextHolder.setDataSource(timeOutModel.getTenantId());
            if (!this.sysUserService.testConn(timeOutModel.getTenantId())) {
                logger.error("\u8fde\u63a5\u5bf9\u5e94\u79df\u6237\u5e93\u5931\u8d25\uff0ctenantId:" + timeOutModel.getTenantId());
                return;
            }
            if (isDelTimeOutTableMessage) {
                this.activityRedisTimerMapper.deleteById((Serializable)((Object)timeOutModel.getTaskId()));
            }
        }
        catch (Exception e) {
            logger.error("\u8fde\u63a5\u5207\u6362\u81f3\u8d85\u65f6\u4efb\u52a1\u6240\u5728\u79df\u6237\u5e93\u5931\u8d25" + e.getMessage());
            return;
        }
        if ("autoHandle".equals(timeOutModel.getTimeOutType())) {
            String assignee = "";
            if (ToolUtil.isNotEmpty((Object)timeOutModel.getAssignee())) {
                String[] assignees;
                for (String user : assignees = timeOutModel.getAssignee().split(",")) {
                    if ("".equals(user)) continue;
                    assignee = user;
                    break;
                }
            }
            try {
                this.taskEngineService.completeTask(timeOutModel.getTaskId(), assignee, null);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a" + e.getMessage());
            }
        } else if ("urging".equals(timeOutModel.getTimeOutType())) {
            try {
                this.iSysActUrgeTaskService.urgeTaskByTaskId(timeOutModel.getTaskId());
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u50ac\u529e\u5931\u8d25\uff1a" + e.getMessage());
            }
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("taskId", timeOutModel.getTaskId());
            map.put("assignee", timeOutModel.getAssignee());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            map.put("startTime", sdf.format(timeOutModel.getCreateTime()));
            map.put("dueTime", sdf.format(timeOutModel.getDueTime()));
            if (ToolUtil.isNotEmpty((Object)timeOutModel.getMap())) {
                map.putAll((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class));
            }
            try {
                logger.info("\u8d85\u65f6\u5904\u7406\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f00\u59cb");
                System.out.println("\u8d85\u65f6\u5904\u7406\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f00\u59cb");
                Long start = System.currentTimeMillis();
                HttpUtil.get((String)timeOutModel.getTimeOutType(), map, (int)this.lcdpBpmProperties.getDataPushTimeOut());
                Long end = System.currentTimeMillis();
                logger.info("\u8d85\u65f6\u5904\u7406\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7ed3\u675f");
                System.out.println("\u8d85\u65f6\u5904\u7406\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7ed3\u675f");
                logger.info("\u8d85\u65f6\u5904\u7406\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8017\u65f6\uff1a" + (end - start) + "s");
                System.out.println("\u8d85\u65f6\u5904\u7406\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8017\u65f6\uff1a" + (end - start) + "s");
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private void handleAllTimeOutTask(long time) {
        if (isUseRedis) {
            try (Jedis jedits = this.getJedits();){
                Set tasksList = jedits.zrangeByScore(BPM_ACTIVITY_TIMER_SCORE_LIST, 0.0, (double)time);
                if (ToolUtil.isNotEmpty((Object)tasksList)) {
                    StringBuilder taskIds = new StringBuilder();
                    for (String tasks : tasksList) {
                        taskIds.append(",").append(tasks);
                        for (String str : tasks.split(",")) {
                            byte[] model = jedits.get((BPM_ACTIVITY_TIMER_TASK_MESSAGE + str).getBytes());
                            if (!ToolUtil.isNotEmpty((Object)model)) continue;
                            this.timeOutTaskHandler((TimeOutModel)((Object)SerializationUtils.deserialize((byte[])model)), false);
                        }
                    }
                    if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                        this.delTimeOutModel(taskIds.toString().substring(1));
                    }
                    this.removeScourList(time);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u83b7\u53d6\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25" + e.toString());
            }
            return;
        }
        if (isGetList) {
            this.getList();
        }
        while (timeOutList.size() > 0 && time > timeOutList.get(0)) {
            if (timeOutMap.get(timeOutList.get(0)) == null) continue;
            List<String> keys = Arrays.asList(timeOutMap.get(timeOutList.get(0)).split(","));
            for (String key : keys) {
                TimeOutModel timeOutModel = (TimeOutModel)((Object)this.hussarEhcacheManager.getObject(BPM_TIMER_ACTIVITY, key));
                if (timeOutModel == null) continue;
                this.timeOutTaskHandler(timeOutModel, true);
                this.hussarEhcacheManager.delete(BPM_TIMER_ACTIVITY, key);
            }
            timeOutMap.remove(timeOutList.get(0));
            timeOutList.remove(0);
        }
    }

    @Override
    public void addTimeOutModel(TimeOutModel timeOutModel) {
        if (isUseRedis) {
            try (Jedis jedits = this.getJedits();){
                jedits.set((BPM_ACTIVITY_TIMER_TASK_MESSAGE + timeOutModel.getTaskId()).getBytes(), SerializationUtils.serialize((Object)((Object)timeOutModel)));
                Set oldTask = jedits.zrangeByScore(BPM_ACTIVITY_TIMER_SCORE_LIST, (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                if (ToolUtil.isEmpty((Object)oldTask)) {
                    jedits.zadd(BPM_ACTIVITY_TIMER_SCORE_LIST, (double)timeOutModel.getDueTime().getTime(), timeOutModel.getTaskId());
                } else {
                    jedits.zadd(BPM_ACTIVITY_TIMER_SCORE_LIST, (double)timeOutModel.getDueTime().getTime(), (String)new ArrayList(oldTask).get(0) + "," + timeOutModel.getTaskId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u5b58\u50a8\u4efb\u52a1\u8d85\u65f6\u65b9\u6848\u4fe1\u606f\u5931\u8d25[taskId:" + timeOutModel.getTaskId() + "]-->" + e.toString());
            }
            return;
        }
        this.activityRedisTimerMapper.insert((Object)timeOutModel);
        this.hussarEhcacheManager.setObject(BPM_TIMER_ACTIVITY, timeOutModel.getTaskId(), (Object)timeOutModel);
        Long time = timeOutModel.getDueTime().getTime();
        if (isGetList) {
            getListTimeAddModel.add(time);
        } else {
            int index = timeOutList.size();
            for (int i = 0; i < timeOutList.size() && timeOutList.get(i) < time; ++i) {
                index = i + 1;
            }
            timeOutList.add(index, time);
        }
        timeOutMap.put(time, timeOutMap.get(time) == null ? timeOutModel.getTaskId() : timeOutMap.get(time) + "," + timeOutModel.getTaskId());
    }

    private void removeScourList(long startTime) {
        try (Jedis jedits = this.getJedits();){
            jedits.zremrangeByScore(BPM_ACTIVITY_TIMER_SCORE_LIST, 0.0, (double)startTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("redis\u5220\u9664\u5df2\u8d85\u65f6\u4efb\u52a1id\u5e8f\u5217\u5931\u8d25[key:bpm_activity:timer:score_list]-->" + e.toString());
        }
    }

    @Override
    public void delTimeOutModel(String taskId) {
        if (isUseRedis) {
            try (Jedis jedits = this.getJedits();){
                if (taskId.contains(",")) {
                    String[] list = taskId.split(",");
                    for (int i = 0; i < list.length; ++i) {
                        list[i] = BPM_ACTIVITY_TIMER_TASK_MESSAGE + list[i];
                    }
                    jedits.del(list);
                } else {
                    jedits.del(BPM_ACTIVITY_TIMER_TASK_MESSAGE + taskId);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u5220\u9664\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25[key:bpm_activity:timer:task_Message:" + taskId + "]-->" + e.toString());
            }
            return;
        }
        List<String> taskIds = Arrays.asList(taskId.split(","));
        this.activityRedisTimerMapper.deleteBatchIds(taskIds);
        this.hussarEhcacheManager.delcache(BPM_TIMER_ACTIVITY, taskIds);
        if (isGetList) {
            getListTimeDelModel.addAll(taskIds);
        }
    }

    @Override
    public void updateTimeOutModel(String taskId, String assignee, String userId, int type) {
        if (isUseRedis) {
            try (Jedis jedits = this.getJedits();){
                byte[] model = jedits.get((BPM_ACTIVITY_TIMER_TASK_MESSAGE + taskId).getBytes());
                if (ToolUtil.isNotEmpty((Object)model)) {
                    jedits.set((BPM_ACTIVITY_TIMER_TASK_MESSAGE + taskId).getBytes(), SerializationUtils.serialize((Object)((Object)this.getTimeOutAssignee((TimeOutModel)((Object)SerializationUtils.deserialize((byte[])model)), assignee, userId, type))));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u66f4\u65b0\u4efb\u52a1\u8d85\u65f6\u65b9\u6848\u4fe1\u606f\u53c2\u4e0e\u8005\u5931\u8d25[taskId:" + taskId + "]-->" + e.toString());
            }
            return;
        }
        TimeOutModel timeOutModel = (TimeOutModel)((Object)this.hussarEhcacheManager.getObject(BPM_TIMER_ACTIVITY, taskId));
        if (timeOutModel != null) {
            this.activityRedisTimerMapper.updateById((Object)this.getTimeOutAssignee(timeOutModel, assignee, userId, type));
            this.hussarEhcacheManager.setObject(BPM_TIMER_ACTIVITY, taskId, (Object)timeOutModel);
        }
    }

    private TimeOutModel getTimeOutAssignee(TimeOutModel timeOutModel, String assignee, String userId, int type) {
        String users;
        String string = users = timeOutModel.getAssignee() == null ? "" : timeOutModel.getAssignee();
        if (type == 0) {
            ArrayList<String> userList = new ArrayList<String>(Arrays.asList(users.split(",")));
            if (userId != null) {
                userList.remove(userId);
            }
            if (assignee != null) {
                userList.addAll(new ArrayList<String>(Arrays.asList(assignee.split(","))));
            }
            userList = new ArrayList<String>(new HashSet<String>(userList));
            timeOutModel.setAssignee(String.join((CharSequence)",", userList));
        } else {
            timeOutModel.setAssignee(assignee);
        }
        return timeOutModel;
    }

    static {
        isGetList = true;
        errorSysUsers = new HashSet<String>();
        timeOutList = new ArrayList<Long>();
        timeOutMap = new HashMap<Long, String>();
        getListTimeAddModel = new ArrayList<Long>();
        getListTimeDelModel = new ArrayList<String>();
    }
}

