/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.notice.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.flowevents.dao.FlowEventsServiceMapper;
import com.jxdinfo.hussar.bpm.flowevents.model.Variables;
import com.jxdinfo.hussar.bpm.notice.dao.SysActTaskNoticeMapper;
import com.jxdinfo.hussar.bpm.notice.model.SysActTaskNotice;
import com.jxdinfo.hussar.bpm.notice.service.SysActTaskNoticeService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActTaskNoticeServiceImpl
extends ServiceImpl<SysActTaskNoticeMapper, SysActTaskNotice>
implements SysActTaskNoticeService {
    private static Logger LOGGER = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    @Resource
    SysActTaskNoticeMapper sysActTaskNoticeMapper;
    @Autowired
    private ITenantConfigService iTenantConfigService;
    @Autowired
    TaskService taskService;
    @Autowired
    HistoryService historyService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private FlowEventsServiceMapper flowEventsServiceMapper;

    @Override
    public BpmResponseResult read(String userId, String taskId, String comments, String tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)taskId);
        queryWrapper.eq((Object)"user_id", (Object)userId);
        List sysActTaskNotices = this.sysActTaskNoticeMapper.selectList((Wrapper)queryWrapper);
        for (SysActTaskNotice sysActTaskNotice : sysActTaskNotices) {
            sysActTaskNotice.setState("0");
            sysActTaskNotice.setComments(comments);
            sysActTaskNotice.setUpdateTime(new Date());
            this.sysActTaskNoticeMapper.updateById((Object)sysActTaskNotice);
            this.finishDataPush(tenantId, sysActTaskNotice, "read");
        }
        if (ToolUtil.isEmpty((Object)sysActTaskNotices)) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public List<Variables> getTodoConfiguration(String taskId, String instanceId) {
        ArrayList<String> taskIds = new ArrayList<String>();
        taskIds.add(taskId);
        ArrayList<String> instanceIds = new ArrayList<String>();
        instanceIds.add(instanceId);
        return this.flowEventsServiceMapper.getAllVariables(taskIds, instanceIds);
    }

    @Override
    public void dataPushWithTask(HistoricTaskInstance task, Map<String, Date> noticeMap, String sendUser, String nodeName, Map<String, String> noticeIdMap, String todoConfiguration) {
        String dataPushAddress;
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(task.getTenantId());
        if (tenantConfig != null && "1".equals(tenantConfig.getIsDataPush()) && ToolUtil.isNotEmpty((Object)(dataPushAddress = tenantConfig.getDataPushAddress()))) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            for (String userId : noticeMap.keySet()) {
                try {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("action", "add");
                    data.put("taskId", noticeIdMap.get(userId));
                    data.put("taskName", nodeName);
                    data.put("userId", userId);
                    data.put("businessKey", historicProcessInstance.getBusinessKey());
                    data.put("taskDefinitionKey", task.getTaskDefinitionKey());
                    data.put("processDefinitionId", task.getProcessDefinitionId());
                    data.put("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                    data.put("sendUser", sendUser);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    data.put("startDate", noticeMap.get(userId));
                    Date date = new Date();
                    data.put("endDate", simpleDateFormat.format(date));
                    data.put("url", task.getFormKey());
                    data.put("description", todoConfiguration);
                    data.put("processName", ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getProcessDefinitionName());
                    data.put("processInstanceId", task.getProcessInstanceId());
                    LOGGER.info("\u6570\u636e\u63a8\u9001\u5f00\u59cb");
                    System.out.println("\u6570\u636e\u63a8\u9001\u5f00\u59cb");
                    LOGGER.info("\u6570\u636e\u63a8\u9001\u5730\u5740\uff1a" + dataPushAddress);
                    System.out.println("\u6570\u636e\u63a8\u9001\u5730\u5740\uff1a" + dataPushAddress);
                    Long start = System.currentTimeMillis();
                    LOGGER.info("\u53c2\u6570\u4fe1\u606f\uff1a" + JSON.toJSONString(data));
                    HttpUtil.post((String)dataPushAddress, data, (int)this.lcdpBpmProperties.getDataPushTimeOut());
                    Long end = System.currentTimeMillis();
                    LOGGER.info("\u6570\u636e\u63a8\u9001\u7ed3\u675f");
                    System.out.println("\u6570\u636e\u63a8\u9001\u7ed3\u675f");
                    LOGGER.info("\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start) + "s");
                    System.out.println("\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start) + "s");
                }
                catch (Exception e) {
                    throw new PublicClientException("\u6dfb\u52a0\u901a\u77e5\u6570\u636e\u63a8\u9001\u51fa\u9519");
                }
            }
        }
    }

    @Override
    public void dataPushWithOutTask(Map<String, Date> noticeMap, String sendUser, String message, String tenantId, String nodeName, HistoricProcessInstance processInstance, Map<String, String> noticeIdMap, String category, String type, String formKey) {
        String dataPushAddress;
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig != null && "1".equals(tenantConfig.getIsDataPush()) && ToolUtil.isNotEmpty((Object)(dataPushAddress = tenantConfig.getDataPushAddress()))) {
            for (String userId : noticeMap.keySet()) {
                try {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("action", "add");
                    data.put("taskId", noticeIdMap.get(userId));
                    data.put("taskName", nodeName);
                    data.put("userId", userId);
                    data.put("sendUser", sendUser);
                    data.put("startDate", noticeMap.get(userId));
                    data.put("description", message);
                    data.put("category", category);
                    data.put("type", type);
                    data.put("url", formKey);
                    if (processInstance != null) {
                        data.put("processInstanceId", processInstance.getId());
                        data.put("processDefinitionId", processInstance.getProcessDefinitionId());
                        data.put("processDefinitionKey", processInstance.getProcessDefinitionId().split(":")[0]);
                        data.put("processName", processInstance.getProcessDefinitionName());
                    }
                    LOGGER.info("\u6570\u636e\u63a8\u9001\u5f00\u59cb");
                    System.out.println("\u6570\u636e\u63a8\u9001\u5f00\u59cb");
                    LOGGER.info("\u6570\u636e\u63a8\u9001\u5730\u5740\uff1a" + dataPushAddress);
                    System.out.println("\u6570\u636e\u63a8\u9001\u5730\u5740\uff1a" + dataPushAddress);
                    Long start = System.currentTimeMillis();
                    LOGGER.info("\u53c2\u6570\u4fe1\u606f\uff1a" + JSON.toJSONString(data));
                    HttpUtil.post((String)dataPushAddress, data, (int)this.lcdpBpmProperties.getDataPushTimeOut());
                    Long end = System.currentTimeMillis();
                    LOGGER.info("\u6570\u636e\u63a8\u9001\u7ed3\u675f");
                    System.out.println("\u6570\u636e\u63a8\u9001\u7ed3\u675f");
                    LOGGER.info("\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start) + "s");
                    System.out.println("\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start) + "s");
                }
                catch (Exception e) {
                    throw new PublicClientException("\u6dfb\u52a0\u901a\u77e5\u6570\u636e\u63a8\u9001\u51fa\u9519");
                }
            }
        }
    }

    private void finishDataPush(String tenantId, SysActTaskNotice sysActTaskNotice, String operationType) {
        String dataPushAddress;
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig != null && "1".equals(tenantConfig.getIsDataPush()) && ToolUtil.isNotEmpty((Object)(dataPushAddress = tenantConfig.getDataPushAddress()))) {
            try {
                HistoricTaskInstance task;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("action", "update");
                data.put("userId", sysActTaskNotice.getUserId());
                data.put("endDate", sysActTaskNotice.getUpdateTime());
                data.put("comment", sysActTaskNotice.getComments());
                data.put("taskName", sysActTaskNotice.getTaskDefinitionName());
                data.put("description", sysActTaskNotice.getTodoConfiguration());
                data.put("taskId", sysActTaskNotice.getId());
                if (ToolUtil.isNotEmpty((Object)operationType)) {
                    data.put("operationType", operationType);
                }
                if ((task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(sysActTaskNotice.getTaskId())).singleResult()) != null) {
                    HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                    data.put("businessKey", historicProcessInstance.getBusinessKey());
                    data.put("taskDefinitionKey", task.getTaskDefinitionKey());
                    data.put("processDefinitionId", task.getProcessDefinitionId());
                    data.put("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                    List<Variables> list = this.getTodoConfiguration(task.getId(), task.getProcessInstanceId());
                    String sendUser = "";
                    if (list != null) {
                        String taskSendUser = "";
                        String instanceSendUser = "";
                        for (Variables variables : list) {
                            if (!"sendUser".equals(variables.getName())) continue;
                            if (ToolUtil.isNotEmpty((Object)variables.getTaskId())) {
                                taskSendUser = variables.getTextValue();
                                continue;
                            }
                            instanceSendUser = variables.getTextValue();
                        }
                        if (ToolUtil.isNotEmpty((Object)taskSendUser)) {
                            sendUser = taskSendUser;
                        } else if (ToolUtil.isNotEmpty((Object)instanceSendUser)) {
                            sendUser = instanceSendUser;
                        }
                    }
                    data.put("sendUser", sendUser);
                    data.put("url", task.getFormKey());
                    data.put("processInstanceId", task.getProcessInstanceId());
                } else {
                    data.put("category", sysActTaskNotice.getCategory());
                    data.put("url", sysActTaskNotice.getFormKey());
                }
                LOGGER.info("\u6570\u636e\u63a8\u9001\u5f00\u59cb");
                System.out.println("\u6570\u636e\u63a8\u9001\u5f00\u59cb");
                LOGGER.info("\u6570\u636e\u63a8\u9001\u5730\u5740\uff1a" + dataPushAddress);
                System.out.println("\u6570\u636e\u63a8\u9001\u5730\u5740\uff1a" + dataPushAddress);
                Long start = System.currentTimeMillis();
                LOGGER.info("\u53c2\u6570\u4fe1\u606f\uff1a" + JSON.toJSONString(data));
                HttpUtil.post((String)dataPushAddress, data, (int)this.lcdpBpmProperties.getDataPushTimeOut());
                Long end = System.currentTimeMillis();
                LOGGER.info("\u6570\u636e\u63a8\u9001\u7ed3\u675f");
                System.out.println("\u6570\u636e\u63a8\u9001\u7ed3\u675f");
                LOGGER.info("\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start) + "s");
                System.out.println("\u6570\u636e\u63a8\u9001\u8017\u65f6\uff1a" + (end - start) + "s");
            }
            catch (Exception e) {
                throw new PublicClientException("\u9605\u8bfb\u901a\u77e5\u6570\u636e\u63a8\u9001\u51fa\u9519");
            }
        }
    }
}

