/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.bpm.entrusthi.model.EntrustHi;
import com.jxdinfo.hussar.bpm.entrusthi.service.EntrustHiSerive;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.el.JuelExpression;
import org.activiti.engine.impl.el.ParsingElContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;

public class ExtendParallelMultiInstanceBehavior
extends ParallelMultiInstanceBehavior {
    private static final String VARIABLE_NAME = "multiInstanceAssignee";
    private HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
    private EntrustHiSerive entrustHiSerive = (EntrustHiSerive)SpringContextHolder.getBean(EntrustHiSerive.class);
    public static final String CC_USER_MESSAGE = "ccUserMessage";
    public static final String MULT_START_FLAG = "multStartFlag";
    public static final String MULT_START_COLLECTION = "multStartCollection";
    public static final String MULT_START_CATEGORY = "multStartCategory";
    public static final String ENTRUST_MESSAGE = "entrustMessage";
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActCcTaskService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private ModelService modelService = (ModelService)SpringContextHolder.getApplicationContext().getBean(ModelService.class);

    public ExtendParallelMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    protected void createInstances(ActivityExecution execution) throws Exception {
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances < 0) {
            throw new ActivitiIllegalArgumentException("Invalid number of instances: must be non-negative integer value, but was " + nrOfInstances);
        }
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ActivityExecution concurrentExecution = execution.createExecution();
            concurrentExecution.setActive(true);
            concurrentExecution.setConcurrent(true);
            concurrentExecution.setScope(false);
            if (this.isExtraScopeNeeded()) {
                ActivityExecution extraScopedExecution = concurrentExecution.createExecution();
                extraScopedExecution.setActive(true);
                extraScopedExecution.setConcurrent(false);
                extraScopedExecution.setScope(true);
                concurrentExecution = extraScopedExecution;
            }
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        Map<String, Object> map = AnalyticalModelUtil.getCcUserMulti(execution, execution.getTenantId());
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ActivityExecution concurrentExecution = (ActivityExecution)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, this.getCollectionElementIndexVariable(), loopCounter);
            if (loopCounter == 0) {
                concurrentExecution.setVariable(CC_USER_MESSAGE, map);
            }
            this.executeOriginalBehavior(concurrentExecution, loopCounter);
        }
        execution.removeVariable(MULT_START_FLAG);
        execution.removeVariable(MULT_START_COLLECTION);
        execution.removeVariable("TimeOutStrategy");
        execution.removeVariable(MULT_START_CATEGORY);
        if (!concurrentExecutions.isEmpty()) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            executionEntity.setActive(false);
        }
    }

    protected void executeOriginalBehavior(ActivityExecution execution, int loopCounter) throws Exception {
        Iterator<Object> it;
        Collection<Object> collection = new ArrayList();
        Object value = null;
        boolean flag = false;
        Map entrustHi = new HashMap();
        if (execution.getVariable(MULT_START_FLAG) == null) {
            BpmnModel bm = this.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
            FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(execution.getActivity().getId());
            List timeOutElement = (List)element.getExtensionElements().get("TimeOutStrategy");
            if (ToolUtil.isNotEmpty((Object)timeOutElement) && ToolUtil.isNotEmpty((Object)((ExtensionElement)timeOutElement.get(0)).getAttributes())) {
                execution.setVariable("TimeOutStrategy", (Object)((ExtensionAttribute)((List)((ExtensionElement)timeOutElement.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue());
            }
            if ("callActivity".equals(execution.getActivity().getProperty("type")) && "parallel".equals(execution.getActivity().getProperty("multiInstance"))) {
                Object allCallActivityInfos;
                flag = true;
                JSONArray callActivityInfos = null;
                Object object = allCallActivityInfos = execution.getVariable("call_activity_info") == null ? null : (JSONArray)execution.getVariable("call_activity_info");
                if (ToolUtil.isNotEmpty((Object)allCallActivityInfos)) {
                    callActivityInfos = this.getRightActivity((JSONArray)allCallActivityInfos, execution);
                }
                if (ToolUtil.isNotEmpty(callActivityInfos)) {
                    for (Object object2 : callActivityInfos) {
                        collection.add("");
                    }
                } else {
                    CallActivity callActivity = (CallActivity)((Process)bm.getProcesses().get(0)).getFlowElement(((ExecutionEntity)execution).getActivityId());
                    String processDefinitionJson = callActivity.getCalledElement();
                    if (ToolUtil.isNotEmpty((Object)processDefinitionJson)) {
                        List<String> list = Arrays.asList(processDefinitionJson.split(","));
                        for (int i = 0; i < list.size(); ++i) {
                            collection.add("");
                        }
                    }
                }
            } else {
                Map<String, Object> result = AnalyticalModelUtil.resolveAssignee(execution, execution.getTenantId());
                collection = (Collection)result.get("users");
                entrustHi = (Map)result.get("entrustHi");
            }
            StringBuilder assignee = new StringBuilder();
            for (Object e : collection) {
                assignee.append(e).append(",");
            }
            String collections = assignee.length() > 0 ? assignee.toString().substring(0, assignee.length() - 1) : null;
            execution.setVariable(MULT_START_COLLECTION, collections);
            execution.setVariable(MULT_START_FLAG, (Object)flag);
            execution.setVariable(ENTRUST_MESSAGE, entrustHi);
            execution.setVariable(MULT_START_CATEGORY, (Object)this.modelService.getCategoryByIdentity(execution.getProcessDefinitionId().split(":")[0]));
        } else {
            String assignee;
            flag = (Boolean)execution.getVariable(MULT_START_FLAG);
            String string = assignee = execution.getVariable(MULT_START_COLLECTION) == null ? null : String.valueOf(execution.getVariable(MULT_START_COLLECTION));
            if (assignee != null) {
                collection = Arrays.asList(assignee.split(","));
            }
            entrustHi = (Map)execution.getVariable(ENTRUST_MESSAGE);
        }
        if (collection != null && collection.size() > 0) {
            it = collection.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
            this.setLoopVariable(execution, VARIABLE_NAME, value);
        } else if (this.usesCollection() && this.collectionElementVariable != null) {
            if (this.collectionExpression != null) {
                collection = (Collection)this.collectionExpression.getValue((VariableScope)execution);
            } else if (this.collectionVariable != null) {
                collection = (Collection)execution.getVariable(this.collectionVariable);
            }
            if (collection == null) {
                collection = new ArrayList();
            }
            it = collection.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
            this.setLoopVariable(execution, this.collectionElementVariable, value);
        }
        if (loopCounter == 0) {
            this.callCustomActivityStartListeners(execution);
            if (flag) {
                this.innerActivityBehavior.execute(execution);
            } else {
                this.insertTask(execution, Objects.requireNonNull(value).toString(), true);
            }
        } else if (flag) {
            execution.executeActivity((PvmActivity)this.activity);
        } else {
            this.insertTask(execution, Objects.requireNonNull(value).toString(), false);
        }
        if (!"callActivity".equals(execution.getActivity().getProperty("type"))) {
            List taskEntities = ((ExecutionEntity)execution).getTasks();
            TaskEntity taskEntity = new TaskEntity();
            if (taskEntities.size() > 1) {
                for (TaskEntity task : taskEntities) {
                    if (!((ExecutionEntity)execution).getActivityId().equals(task.getTaskDefinitionKey())) continue;
                    taskEntity = task;
                    break;
                }
            } else {
                taskEntity = (TaskEntity)taskEntities.get(0);
            }
            if (taskEntity.getAssignee() != null && entrustHi != null && entrustHi.get(taskEntity.getAssignee()) != null) {
                String taskId = taskEntity.getId();
                String nodeId = taskEntity.getTaskDefinitionKey();
                String nodeName = taskEntity.getName();
                String string = ((ExecutionEntity)execution).getProcessDefinitionKey();
                String processId = taskEntity.getProcessInstanceId();
                Date createTime = new Date();
                this.entrustHiSerive.save((Object)new EntrustHi(taskId, nodeId, nodeName, string, processId, (String)entrustHi.get(taskEntity.getAssignee()), taskEntity.getAssignee(), createTime, "1", ""));
            }
        }
    }

    private void ccTask(Task task, Set<String> users, String userId, ActivityExecution execution) {
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        if (processInstance != null) {
            for (String user : users) {
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setId(IdWorker.get32UUID());
                sysActCcTask.setProcInstId(task.getProcessInstanceId());
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(task.getId());
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(task.getFormKey());
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                Map map = ((TaskEntity)task).getVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActCcTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActCcTask);
            }
        }
        if (list.size() > 0) {
            this.iSysActCcTaskService.saveBatch(list);
        }
    }

    private JSONArray getRightActivity(JSONArray allCallActivityInfos, ActivityExecution execution) {
        JSONArray callActivityInfos = new JSONArray();
        for (Object allCallActivityInfo : allCallActivityInfos) {
            JSONObject object = (JSONObject)allCallActivityInfo;
            if (!ToolUtil.isEmpty((Object)object.get((Object)"taskDefinitionKey")) && !((ExecutionEntity)execution).getActivityId().equals(object.get((Object)"taskDefinitionKey"))) continue;
            callActivityInfos.add((Object)object);
        }
        return callActivityInfos;
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    protected <T> T getSession(Class<T> sessionClass) {
        return (T)Context.getCommandContext().getSession(sessionClass);
    }

    private void insertTask(ActivityExecution execution, String userId, boolean flag) {
        Object ccUserMessage;
        boolean skipUserTask;
        Object formKey;
        Object category;
        Object priority;
        Object dueDate;
        TaskEntity task = TaskEntity.createAndInsert((ActivityExecution)execution);
        task.setExecution((DelegateExecution)execution);
        TaskDefinition taskDefinition = (TaskDefinition)execution.getActivity().getProperty("taskDefinition");
        Expression activeNameExpression = null;
        Expression activeDescriptionExpression = null;
        Expression activeDueDateExpression = null;
        Expression activePriorityExpression = null;
        Expression activeCategoryExpression = null;
        Expression activeFormKeyExpression = null;
        Expression activeSkipExpression = null;
        Expression activeAssigneeExpression = null;
        Expression activeOwnerExpression = null;
        Set<Expression> activeCandidateUserExpressions = null;
        Set<Expression> activeCandidateGroupExpressions = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties((String)execution.getActivity().getId(), (String)execution.getProcessDefinitionId());
            activeNameExpression = this.getActiveValue(taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
            taskDefinition.setNameExpression(activeNameExpression);
            activeDescriptionExpression = this.getActiveValue(taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
            taskDefinition.setDescriptionExpression(activeDescriptionExpression);
            activeDueDateExpression = this.getActiveValue(taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
            taskDefinition.setDueDateExpression(activeDueDateExpression);
            activePriorityExpression = this.getActiveValue(taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
            taskDefinition.setPriorityExpression(activePriorityExpression);
            activeCategoryExpression = this.getActiveValue(taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
            taskDefinition.setCategoryExpression(activeCategoryExpression);
            activeFormKeyExpression = this.getActiveValue(taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
            taskDefinition.setFormKeyExpression(activeFormKeyExpression);
            activeSkipExpression = this.getActiveValue(taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            taskDefinition.setSkipExpression(activeSkipExpression);
            activeAssigneeExpression = this.getActiveValue(taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
            taskDefinition.setAssigneeExpression(activeAssigneeExpression);
            activeOwnerExpression = this.getActiveValue(taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
            taskDefinition.setOwnerExpression(activeOwnerExpression);
            activeCandidateUserExpressions = this.getActiveValueSet(taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
            taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
            activeCandidateGroupExpressions = this.getActiveValueSet(taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
            taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
        } else {
            activeNameExpression = taskDefinition.getNameExpression();
            activeDescriptionExpression = taskDefinition.getDescriptionExpression();
            activeDueDateExpression = taskDefinition.getDueDateExpression();
            activePriorityExpression = taskDefinition.getPriorityExpression();
            activeCategoryExpression = taskDefinition.getCategoryExpression();
            activeFormKeyExpression = taskDefinition.getFormKeyExpression();
            activeSkipExpression = taskDefinition.getSkipExpression();
        }
        task.setTaskDefinition(taskDefinition);
        if (activeNameExpression != null) {
            String name = null;
            try {
                name = (String)activeNameExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                name = activeNameExpression.getExpressionText();
                LOGGER.warn("property not found in task name expression " + e.getMessage());
            }
            task.setName(name);
        }
        if (activeDescriptionExpression != null) {
            String description = null;
            try {
                description = (String)activeDescriptionExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                description = activeDescriptionExpression.getExpressionText();
                LOGGER.warn("property not found in task description expression " + e.getMessage());
            }
            task.setDescription(description);
        }
        if (activeDueDateExpression != null && (dueDate = activeDueDateExpression.getValue((VariableScope)execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(taskDefinition.getBusinessCalendarNameExpression().getValue((VariableScope)execution).toString());
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
            }
        }
        if (activePriorityExpression != null && (priority = activePriorityExpression.getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.parseInt((String)priority));
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
            }
        }
        if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue((VariableScope)execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
            }
        }
        if (activeFormKeyExpression != null && (formKey = activeFormKeyExpression.getValue((VariableScope)execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
            }
        }
        boolean bl = skipUserTask = SkipExpressionUtil.isSkipExpressionEnabled((ActivityExecution)execution, (Expression)activeSkipExpression) && SkipExpressionUtil.shouldSkipFlowElement((ActivityExecution)execution, (Expression)activeSkipExpression);
        if (!skipUserTask && StringUtils.isNotEmpty((CharSequence)userId)) {
            task.setAssignee(userId, true, false);
        }
        task.fireEvent("create");
        this.setVariables(task, execution.getVariables());
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        if (ToolUtil.isNotEmpty((Object)(ccUserMessage = execution.getVariable(CC_USER_MESSAGE)))) {
            String sendUserId;
            Map map = (Map)ccUserMessage;
            Set ccUsers = (Set)map.get("ccUser");
            if (!ToolUtil.isOneEmpty((Object[])new Object[]{ccUsers, sendUserId = (String)map.get("ccSendUser")})) {
                this.ccTask((Task)task, ccUsers, sendUserId, execution);
            }
            execution.removeVariable(CC_USER_MESSAGE);
        }
        if (skipUserTask) {
            task.complete(null, false);
        } else if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)execution.getVariable("TimeOutStrategy"))) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setTaskId(task.getId());
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getDueDate());
            timeOutModel.setAssignee(task.getAssignee());
            timeOutModel.setTimeOutType((String)execution.getVariable("TimeOutStrategy"));
            timeOutModel.setTenantId(execution.getTenantId());
            if (timeOutModel.getTimeOutType().startsWith("http")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", task.getName());
                map.put("processInstanceId", task.getProcessInstanceId());
                map.put("processDefinitionId", task.getProcessDefinitionId());
                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                map.put("formKey", task.getFormKey());
                map.put("businessKey", execution.getProcessBusinessKey());
                map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
                map.put("category", execution.getVariable(MULT_START_CATEGORY));
                map.put("todoConfiguration", task.getVariable("todoConfiguration"));
                map.put("sendUser", task.getVariable("sendUser"));
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                map.put("startUserId", historicProcessInstance.getStartUserId());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                map.put("processStartTime", sdf.format(historicProcessInstance.getStartTime()));
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            this.activityRedisTimer.addTimeOutModel(timeOutModel);
        }
        if (flag) {
            this.insertActHiActinst(execution, userId, task);
        }
    }

    private void setVariables(TaskEntity task, Map<String, Object> variables) {
        task.setVariableLocal("sendUser", variables.get("sendUser"));
        Map<String, String> map = AnalyticalModelUtil.getTodoConfiguration(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (map.size() == 0) {
            return;
        }
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        if (variables != null) {
            newVariables.putAll(variables);
        }
        newVariables.putAll(processMap);
        newVariables.putAll(taskMap);
        String todo = newVariables.size() > 0 ? AnalyticalModelUtil.getTodo(newVariables, map.get("todoConfiguration")) : map.get("todoConfiguration");
        task.setVariableLocal("todoConfiguration", (Object)todo);
    }

    public void leave(ActivityExecution execution) {
        this.callActivityEndListeners(execution);
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        if (nrOfInstances == 0) {
            super.leave(execution);
        } else {
            ExecutionEntity executionEntity;
            int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
            int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
            int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
            ActivityExecution newExecution = execution;
            if (this.isExtraScopeNeeded()) {
                executionEntity = (ExecutionEntity)execution;
                newExecution = execution.getParent();
                executionEntity.remove();
            }
            if (newExecution.getParent() != null) {
                this.setLoopVariable(newExecution.getParent(), "nrOfCompletedInstances", nrOfCompletedInstances);
                this.setLoopVariable(newExecution.getParent(), "nrOfActiveInstances", nrOfActiveInstances);
            }
            this.logLoopDetails(newExecution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
            executionEntity = (ExecutionEntity)newExecution;
            if (executionEntity.getParent() != null) {
                executionEntity.inactivate();
                executionEntity.getParent().forceUpdate();
                List joinedExecutions = executionEntity.findInactiveConcurrentExecutions(newExecution.getActivity());
                if (joinedExecutions.size() >= nrOfInstances || this.completionConditionSatisfied(newExecution)) {
                    execution.removeVariable("reject_appoint_assignee");
                    ArrayList<ExecutionEntity> executionsToRemove = new ArrayList<ExecutionEntity>();
                    Iterator var9 = executionEntity.getParent().getExecutions().iterator();
                    ArrayList<String> executionIds = new ArrayList<String>();
                    while (var9.hasNext()) {
                        ActivityExecution childExecution = (ActivityExecution)var9.next();
                        if (!childExecution.isActive()) continue;
                        executionsToRemove.add((ExecutionEntity)childExecution);
                        executionIds.add(childExecution.getId());
                    }
                    StringBuilder taskIds = new StringBuilder();
                    for (ExecutionEntity executionToRemove : executionsToRemove) {
                        if (!ToolUtil.isNotEmpty((Object)executionToRemove.getTasks()) || !ToolUtil.isNotEmpty((Object)((TaskEntity)executionToRemove.getTasks().get(0)).getDueDate())) continue;
                        taskIds.append(",").append(((TaskEntity)executionToRemove.getTasks().get(0)).getId());
                    }
                    if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                        this.activityRedisTimer.delTimeOutModel(taskIds.toString().substring(1));
                    }
                    for (ActivityExecution activityExecution : joinedExecutions) {
                        executionIds.remove(activityExecution.getId());
                    }
                    this.entrustHiSerive.removeEntrustHistoryByExecutionId(executionIds);
                    for (ExecutionEntity executionToRemove : executionsToRemove) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Execution {} still active, but multi-instance is completed. Removing this execution.", (Object)executionToRemove);
                        }
                        executionToRemove.inactivate();
                        executionToRemove.deleteCascade("multi-instance completed");
                    }
                    executionEntity.takeAll(executionEntity.getActivity().getOutgoingTransitions(), joinedExecutions);
                }
            } else {
                super.leave((ActivityExecution)executionEntity);
            }
        }
    }

    protected boolean completionConditionSatisfied(ActivityExecution execution) {
        ExpressionFactoryImpl expressionFactory = new ExpressionFactoryImpl();
        Object multiType = execution.getVariable("multi_type");
        if (ToolUtil.isNotEmpty((Object)multiType)) {
            String condition = "";
            if ("0".equals(multiType.toString())) {
                condition = "${nrOfCompletedInstances/nrOfInstances >=" + Double.parseDouble(String.valueOf(execution.getVariable("multi_finish_condition"))) / 100.0 + "}";
            }
            if ("1".equals(multiType.toString())) {
                condition = "${nrOfCompletedInstances == " + Integer.parseInt(String.valueOf(execution.getVariable("multi_finish_condition"))) + " }";
            }
            ValueExpression valueExpression = expressionFactory.createValueExpression((ELContext)new ParsingElContext(), condition, Object.class);
            this.completionConditionExpression = new JuelExpression(valueExpression, condition);
        }
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue((VariableScope)execution);
            if (!(value instanceof Boolean)) {
                throw new ActivitiIllegalArgumentException("completionCondition '" + this.completionConditionExpression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    private void insertActHiActinst(ActivityExecution execution, String userId, TaskEntity task) {
        IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInstanceId = execution.getProcessInstanceId();
        String executionId = execution.getId();
        HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
        historicActivityInstance.setId(idGenerator.getNextId());
        historicActivityInstance.setProcessDefinitionId(processDefinitionId);
        historicActivityInstance.setProcessInstanceId(processInstanceId);
        historicActivityInstance.setExecutionId(executionId);
        historicActivityInstance.setActivityId(execution.getActivity().getId());
        historicActivityInstance.setActivityName((String)execution.getActivity().getProperty("name"));
        historicActivityInstance.setActivityType((String)execution.getActivity().getProperty("type"));
        historicActivityInstance.setStartTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        historicActivityInstance.setAssignee(userId);
        historicActivityInstance.setTaskId(task.getId());
        if (execution.getTenantId() != null) {
            historicActivityInstance.setTenantId(execution.getTenantId());
        }
        this.getDbSqlSession().insert((PersistentObject)historicActivityInstance);
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Object activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.size() == 0) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    protected int resolveNrOfInstances(ActivityExecution execution) {
        if ("callActivity".equals(execution.getActivity().getProperty("type")) && "parallel".equals(execution.getActivity().getProperty("multiInstance"))) {
            JSONArray allCallActivityInfos;
            JSONArray callActivityInfos = null;
            JSONArray jSONArray = allCallActivityInfos = execution.getVariable("call_activity_info") == null ? null : (JSONArray)execution.getVariable("call_activity_info");
            if (ToolUtil.isNotEmpty((Object)allCallActivityInfos)) {
                callActivityInfos = this.getRightActivity(allCallActivityInfos, execution);
            }
            if (ToolUtil.isNotEmpty(callActivityInfos)) {
                return callActivityInfos.size();
            }
            BpmnModel bm = this.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
            CallActivity callActivity = (CallActivity)((Process)bm.getProcesses().get(0)).getFlowElement(((ExecutionEntity)execution).getActivityId());
            String processDefinitionJson = callActivity.getCalledElement();
            List<Object> list = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)processDefinitionJson)) {
                list = Arrays.asList(processDefinitionJson.split(","));
            }
            return list.size();
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        int nrOfInstances = -1;
        nrOfInstances = AnalyticalModelUtil.resolveNrOfInstances(execution, execution.getTenantId());
        if (nrOfInstances != 0) {
            return nrOfInstances;
        }
        long hisTaskNum = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).count();
        if (hisTaskNum > 0L) {
            String nodeName = ((Process)bm.getProcesses().get(0)).getFlowElement(((ExecutionEntity)execution).getActivityId()).getName();
            throw new PublicClientException(nodeName + "\u8282\u70b9\u53c2\u4e0e\u8005\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "-1");
        }
        return nrOfInstances;
    }
}

