/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.engine.util.AddAssigneeSaveTaskCmd;
import com.jxdinfo.hussar.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;

public class MultiInstanceAddAssigneeCmd
implements Command<Void> {
    protected String executionId;
    protected List<String> assigneeList;
    private long dueTime;
    private String outTimeType;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
    private ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);

    public MultiInstanceAddAssigneeCmd(String executionId, List<String> assigneeList, long dueTime, String outTimeType) {
        this.executionId = executionId;
        this.assigneeList = assigneeList;
        this.dueTime = dueTime;
        this.outTimeType = outTimeType;
    }

    public Void execute(CommandContext commandContext) {
        if (this.assigneeList == null || this.assigneeList.size() < 1) {
            return null;
        }
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        TaskService taskService = pec.getTaskService();
        IdGenerator idGenerator = pec.getIdGenerator();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        ExecutionEntity parent = ee.getParent();
        Task newTask = (Task)((TaskQuery)((TaskQuery)taskService.createTaskQuery().executionId(this.executionId)).includeTaskLocalVariables()).singleResult();
        for (String user : this.assigneeList) {
            TaskEntity t = (TaskEntity)newTask;
            ExecutionEntity newExecution = parent.createExecution();
            newExecution.setActive(true);
            newExecution.setConcurrent(true);
            newExecution.setScope(false);
            TaskEntity taskEntity = new TaskEntity();
            taskEntity.setCreateTime(new Date());
            taskEntity.setTaskDefinition(t.getTaskDefinition());
            taskEntity.setProcessDefinitionId(t.getProcessDefinitionId());
            taskEntity.setTaskDefinitionKey(t.getTaskDefinitionKey());
            taskEntity.setFormKey(t.getFormKey());
            taskEntity.setProcessInstanceId(t.getProcessInstanceId());
            taskEntity.setExecutionId(newExecution.getId());
            taskEntity.setName(newTask.getName());
            String taskId = idGenerator.getNextId();
            taskEntity.setId(taskId);
            taskEntity.setExecution(newExecution);
            taskEntity.setAssignee(user);
            if (ToolUtil.isNotEmpty((Object)newTask.getTaskLocalVariables())) {
                for (String key : newTask.getTaskLocalVariables().keySet()) {
                    taskEntity.setVariableLocal(key, newTask.getTaskLocalVariables().get(key));
                }
            }
            if (this.dueTime != 0L && this.outTimeType != null) {
                taskEntity.setDueDate(new Date(taskEntity.getCreateTime().getTime() + this.dueTime));
                TimeOutModel timeOutModel = new TimeOutModel();
                timeOutModel.setTaskId(taskId);
                timeOutModel.setCreateTime(taskEntity.getCreateTime());
                timeOutModel.setDueTime(taskEntity.getDueDate());
                timeOutModel.setAssignee(user);
                timeOutModel.setTimeOutType(this.outTimeType);
                timeOutModel.setTenantId(execution.getTenantId());
                if (timeOutModel.getTimeOutType().startsWith("http")) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("name", taskEntity.getName());
                    map.put("processInstanceId", taskEntity.getProcessInstanceId());
                    map.put("processDefinitionId", taskEntity.getProcessDefinitionId());
                    map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    map.put("formKey", taskEntity.getFormKey());
                    ExecutionEntity entity = parent;
                    while (entity.getParent() != null) {
                        entity = entity.getParent();
                    }
                    map.put("businessKey", entity.getProcessBusinessKey());
                    map.put("processName", entity.getProcessDefinition().getName());
                    map.put("category", this.modelService.getCategoryByIdentity(taskEntity.getProcessDefinitionId().split(":")[0]));
                    map.put("todoConfiguration", taskEntity.getVariable("todoConfiguration"));
                    map.put("sendUser", taskEntity.getVariable("sendUser"));
                    HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(taskEntity.getProcessInstanceId()).singleResult();
                    map.put("startUserId", historicProcessInstance.getStartUserId());
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    map.put("processStartTime", sdf.format(historicProcessInstance.getStartTime()));
                    timeOutModel.setMap(JSON.toJSONString(map));
                }
                this.activityRedisTimerService.addTimeOutModel(timeOutModel);
            }
            BpmConstant.processEngine.getManagementService().executeCommand((Command)new AddAssigneeSaveTaskCmd((Task)taskEntity, (Execution)taskEntity.getExecution()));
            int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(newExecution, "nrOfInstances");
            int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(newExecution, "nrOfActiveInstances");
            MultiInstancePercentUtils.setLoopVariable(newExecution, "nrOfInstances", nrOfInstances + 1);
            MultiInstancePercentUtils.setLoopVariable(newExecution, "nrOfActiveInstances", nrOfActiveInstances + 1);
        }
        return null;
    }
}

