/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Arrays;
import java.util.Set;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;

public class EntrustAssigneeCmd
implements Command<Void> {
    protected String taskId;
    protected String userId;
    protected String consignee;

    public EntrustAssigneeCmd(String taskId, String userId, String consignee) {
        this.taskId = taskId;
        this.userId = userId;
        this.consignee = consignee;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity.getAssignee() != null) {
            taskEntity.setAssignee(null);
        }
        Set identityLinks = taskEntity.getCandidates();
        if (ToolUtil.isNotEmpty((Object)this.userId)) {
            taskEntity.deleteCandidateUser(this.userId);
            taskEntity.addCandidateUsers(Arrays.asList(this.consignee.split(",")));
        } else {
            for (IdentityLink identityLink : identityLinks) {
                taskEntity.deleteCandidateUser(identityLink.getUserId());
            }
            taskEntity.addCandidateUsers(Arrays.asList(this.consignee.split(",")));
        }
        return null;
    }
}

