/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.DefinitionEngineService;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class DefinitionEngineServiceImpl
implements DefinitionEngineService {
    private static Logger LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private ModelMapper modelMapper;

    @Override
    public BpmResponseResult queryProcessDefListOfMainVersion(String processName) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        List deployments = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + processName + "%").latestVersion().orderByProcessDefinitionName().desc()).list();
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinition deployment : deployments) {
            ProcessDefinitionModel item = new ProcessDefinitionModel();
            item.setId(deployment.getId());
            item.setProcessName(deployment.getName());
            item.setVersion(Integer.toString(deployment.getVersion()));
            item.setIsSuspended(Boolean.toString(deployment.isSuspended()));
            item.setDescription(deployment.getDescription());
            item.setCategory(deployment.getCategory());
            item.setDeploymentId(deployment.getDeploymentId());
            if (deployment.getResourceName() != null) {
                String[] sourceArr = deployment.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (deployment.getDiagramResourceName() != null) {
                String[] diagramArr = deployment.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStr = sdf.format(deploymentTime.getDeploymentTime());
            item.setDeploymentTime(timeStr);
            result.add(item);
        }
        object.put("data", result);
        object.put("count", (Object)result.size());
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessDefList(String processName) {
        JSONArray json = new JSONArray();
        List deployments = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + processName + "%").orderByProcessDefinitionName().desc()).list();
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinition deployment : deployments) {
            ProcessDefinitionModel item = new ProcessDefinitionModel();
            item.setId(deployment.getId());
            item.setProcessName(deployment.getName());
            item.setVersion(Integer.toString(deployment.getVersion()));
            item.setIsSuspended(Boolean.toString(deployment.isSuspended()));
            item.setDescription(deployment.getDescription());
            item.setCategory(deployment.getCategory());
            item.setDeploymentId(deployment.getDeploymentId());
            if (deployment.getResourceName() != null) {
                String[] sourceArr = deployment.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (deployment.getDiagramResourceName() != null) {
                String[] diagramArr = deployment.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStr = sdf.format(deploymentTime.getDeploymentTime());
            item.setDeploymentTime(timeStr);
            result.add(item);
        }
        json.add(result);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult activateProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult suspendProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult deleteProcessDefinition(String processDefinitionId) {
        if (processDefinitionId == null) {
            return InstallResult.getResult("0", "\u975e\u7a7a\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(String.valueOf(processDefinitionId)).singleResult();
        if (ToolUtil.isEmpty((Object)processDefinition)) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230\uff01", null);
        }
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefinitionId))) {
            this.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
            return InstallResult.getResult("1", "success", null);
        }
        return InstallResult.getResult("0", "\u5f53\u524d\u6d41\u7a0b\u6a21\u578b\u5b58\u5728\u8fd0\u884c\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u5220\u9664\u5931\u8d25\uff01", null);
    }

    @Override
    public BpmResponseResult queryProcess() {
        JSONArray json = new JSONArray();
        List models = ((ModelQuery)this.repositoryService.createModelQuery().deployed().orderByLastUpdateTime().desc()).list();
        if (models != null) {
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            for (Model model : models) {
                JSONObject object = new JSONObject();
                byte[] arg0 = this.repositoryService.getModelEditorSource(model.getId());
                try {
                    String temp = new String(arg0, StandardCharsets.UTF_8).replace("undefined", "");
                    JsonNode editorNode = new ObjectMapper().readTree(temp.getBytes(StandardCharsets.UTF_8));
                    BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
                    Process process = bpmnModel.getMainProcess();
                    object.put("id", (Object)process.getId());
                    object.put("name", (Object)process.getName());
                    json.add((Object)object);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessLink(String processDefinitionKey) {
        JSONArray json = new JSONArray();
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).latestVersion().singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230\uff01", null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        return InstallResult.getResult("0", "\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728\uff01", null);
    }

    @Override
    public BpmResponseResult queryStartFormUrl(String processDefinitionKey) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId());
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            String formUrl = ((StartEvent)flowElement).getFormKey();
            jsonObject.put("formUrl", (Object)formUrl);
            jsonArray.add((Object)jsonObject);
            break;
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }
}

