/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.common.utils;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.procpath.service.ISysActProcPathService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.RepositoryService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonCodeUtil {
    public static final String ADD_CUSTOM_NODE_ID_PREFIX = "jxd_bpm_custom_node";
    public static final String PARALLEL_NODE = "parallel_node";
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
    private static ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private static final String GodAxePath = "/GodAxeVariables";
    private static ITenantConfigService iTenantConfigService = (ITenantConfigService)SpringContextHolder.getBean(ITenantConfigService.class);
    private static ISysActProcPathService sysActProcPathService = (ISysActProcPathService)SpringContextHolder.getBean(ISysActProcPathService.class);
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private static Logger LOGGER = LogManager.getLogger(CommonCodeUtil.class);

    public static String getVisitorNodeId(String id, BpmnModel bm) {
        Process process = (Process)bm.getProcesses().get(0);
        int num = process.getFlowElements().size();
        while (id.startsWith(ADD_CUSTOM_NODE_ID_PREFIX)) {
            id = id.contains(PARALLEL_NODE) ? id.split(PARALLEL_NODE)[1] : ((SequenceFlow)((FlowNode)process.getFlowElement(id)).getIncomingFlows().get(0)).getSourceRef();
            if (--num >= 0) continue;
            throw new PublicClientException("\u6d41\u7a0b\u56fe\u5f02\u5e38");
        }
        return id;
    }

    public static Map<String, Object> getGodAxeResult(String nodeId, String businessId, String procDefId) {
        TenantConfig tenantConfig = iTenantConfigService.getTenantConfig(HttpKit.getRequest().getParameter("tenantId"));
        String procDefKey = procDefId.split(":")[0];
        String realVersion = String.valueOf(modelService.getRealVersion(procDefId));
        BpmnModel bm = repositoryService.getBpmnModel(procDefId);
        String beanId = procDefKey + ":" + realVersion + CommonCodeUtil.getVisitorNodeId(nodeId, bm);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("beanId", beanId);
        map.put("businessId", businessId);
        Map<String, Object> variable = new HashMap<String, Object>();
        String procPath = sysActProcPathService.getProcPath(procDefKey);
        if ("1".equals(tenantConfig.getIsGodAxe())) {
            String path = tenantConfig.getProjectAddress();
            if (ToolUtil.isNotEmpty((Object)procPath) && !"null".equals(procPath)) {
                path = procPath;
            }
            LOGGER.info("CommonCodeUtil\u5f00\u59cb");
            System.out.println("CommonCodeUtil\u5f00\u59cb");
            LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + path + GodAxePath);
            System.out.println("\u8def\u5f84\u4fe1\u606f" + path + GodAxePath);
            Long start = System.currentTimeMillis();
            String result = HttpUtil.get((String)(path + GodAxePath), map, (int)lcdpBpmProperties.getDataPushTimeOut());
            Long end = System.currentTimeMillis();
            LOGGER.info("CommonCodeUtil\u7ed3\u675f");
            System.out.println("CommonCodeUtil\u7ed3\u675f");
            LOGGER.info("CommonCodeUtil\uff1a" + (end - start) + "s");
            System.out.println("CommonCodeUtil\uff1a" + (end - start) + "s");
            if (ToolUtil.isNotEmpty((Object)result)) {
                variable = (Map)JSON.parseObject((String)result, HashMap.class);
            }
        }
        CommonCodeUtil.handleVariables(variable);
        return variable;
    }

    public static void handleVariables(Map<String, Object> variable) {
        for (Map.Entry<String, Object> k : variable.entrySet()) {
            Object date;
            if (k.getValue() == null) continue;
            String className = k.getValue().getClass().getName();
            if ("java.lang.String".equals(className) && ToolUtil.isNotEmpty((Object)(date = CommonCodeUtil.isValidDate(k.getValue().toString())))) {
                variable.put(k.getKey(), date);
            }
            if (!"java.math.BigDecimal".equals(className)) continue;
            BigDecimal bigDecimal = (BigDecimal)k.getValue();
            if (new BigDecimal(bigDecimal.longValue()).compareTo(bigDecimal) == 0) {
                variable.put(k.getKey(), bigDecimal.longValue());
                continue;
            }
            variable.put(k.getKey(), bigDecimal.doubleValue());
        }
    }

    private static Object isValidDate(String str) {
        SimpleDateFormat format;
        String yMdhmsRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0[1-9]|1[0-2])([-/]?)(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        String yMdRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0?[1-9]|1[0-2])\\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\\1(?:29|30)|(?:0?[13578]|1[02])\\1(?:31))|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-/]?)0?2\\2(?:29))$";
        String yMRegex = "^\\d{4}([-/]?)(0[1-9]|1[0-2])$";
        String hmsRegex = "([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        if (str.length() == 7) {
            if (!str.matches(yMRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM");
        } else if (str.length() == 10) {
            if (!str.matches(yMdRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd");
        } else if (str.length() == 8) {
            if (!str.matches(hmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("HH:mm:ss");
        } else {
            if (!str.matches(yMdhmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        try {
            format.setLenient(false);
            return format.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

