/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.common.utils;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.bpm.entrusthi.model.EntrustHi;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.model.service.impl.ModelServiceImpl;
import com.jxdinfo.hussar.bpm.processentrust.service.SysActEntrustService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.procpath.service.ISysActProcPathService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class AnalyticalModelUtil {
    private static IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
    private static ITenantConfigService iTenantConfigService = (ITenantConfigService)SpringContextHolder.getBean(ITenantConfigService.class);
    private static SysActEntrustService sysActEntrustService = (SysActEntrustService)SpringContextHolder.getBean(SysActEntrustService.class);
    private static HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
    private static ISysActProcPathService sysActProcPathService = (ISysActProcPathService)SpringContextHolder.getBean(ISysActProcPathService.class);
    private static Logger LOGGER = LoggerFactory.getLogger(ModelServiceImpl.class);
    private static final String STARTER = "starter";
    private static final String GOD_AXE_PATH = "/GodAxeVariables";
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);

    public static int resolveNrOfInstances(ActivityExecution execution, String tenantId) {
        Collection collection = (Collection)AnalyticalModelUtil.resolveAssignee(execution, tenantId).get("users");
        if (collection != null) {
            return collection.size();
        }
        return 0;
    }

    public static Map<String, Object> resolveAssignee(ActivityExecution execution, String tenantId) {
        Map<String, Object> result = new HashMap<String, Object>();
        String activityId = execution.getActivity().getId();
        Map map = execution.getVariable("appoint_assignee") == null ? new HashMap() : (Map)execution.getVariable("appoint_assignee");
        String assignee = (String)map.get(activityId);
        if (ToolUtil.isEmpty((Object)assignee)) {
            String string = assignee = execution.getVariable("reject_appoint_assignee") == null ? null : String.valueOf(execution.getVariable("reject_appoint_assignee"));
        }
        if (ToolUtil.isNotEmpty((Object)assignee)) {
            result.put("users", new HashSet<String>(Arrays.asList(assignee.split(","))));
            return result;
        }
        BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        if (bm != null) {
            result = AnalyticalModelUtil.getCandidateUser(bm, execution, false, tenantId);
        }
        return result;
    }

    public static Map<String, Object> getCcUserMulti(ActivityExecution execution, String tenantId) {
        String sendUserId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set ccUsers = execution.getVariable("cc_user") == null ? new HashSet() : (Set)execution.getVariable("cc_user");
        String string = sendUserId = execution.getVariable("cc_send_user") == null ? "" : (String)execution.getVariable("cc_send_user");
        if (ccUsers != null && ccUsers.size() > 0) {
            execution.removeVariable("cc_user");
            execution.removeVariable("cc_send_user");
        } else {
            BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
            ccUsers = AnalyticalModelUtil.getCcUser(bm, execution, tenantId);
        }
        map.put("ccUser", ccUsers);
        map.put("ccSendUser", sendUserId);
        return map;
    }

    public static Map<String, Object> getCandidateUser(BpmnModel bm, ActivityExecution execution, boolean flag, String tenantId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("users", new HashSet());
        map.put("addEntrustList", new ArrayList());
        HashSet<String> users = AnalyticalModelUtil.getConfigUser(bm, execution, flag, tenantId);
        if (ToolUtil.isEmpty(users)) {
            return map;
        }
        String processDefinitionKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        ArrayList<String> result = new ArrayList<String>(users);
        Object companyCode = execution.getVariable("company_code");
        Map<String, String> userMap = sysActEntrustService.queryByUsers(result, processDefinitionKey, companyCode != null ? String.valueOf(companyCode) : null);
        if (result.size() > 0) {
            users = new HashSet();
            HashMap<String, String> entrustHi = new HashMap<String, String>();
            for (String id : result) {
                if (ToolUtil.isNotEmpty((Object)userMap.get(id))) {
                    users.add(userMap.get(id));
                    entrustHi.put(userMap.get(id), id);
                    continue;
                }
                users.add(id);
            }
            map.put("entrustHi", entrustHi);
            map.put("users", users);
        }
        return map;
    }

    public static Map<String, Object> getCandidateUserWithSaveEntrustCompleteHi(BpmnModel bm, ActivityExecution execution, boolean flag, String tenantId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("users", new HashSet());
        map.put("addEntrustList", new ArrayList());
        HashSet<String> users = AnalyticalModelUtil.getConfigUser(bm, execution, flag, tenantId);
        if (ToolUtil.isEmpty(users)) {
            return map;
        }
        String processDefinitionKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        ArrayList<String> result = new ArrayList<String>(users);
        Object companyCode = execution.getVariable("company_code");
        Map<String, String> userMap = sysActEntrustService.queryByUsers(result, processDefinitionKey, companyCode != null ? String.valueOf(companyCode) : null);
        if (result.size() > 0) {
            ArrayList<EntrustHi> addEntrustList = new ArrayList<EntrustHi>();
            List taskEntities = ((ExecutionEntity)execution).getTasks();
            TaskEntity taskEntity = new TaskEntity();
            if (taskEntities.size() > 1) {
                for (TaskEntity task : taskEntities) {
                    if (!((ExecutionEntity)execution).getActivityId().equals(task.getTaskDefinitionKey())) continue;
                    taskEntity = task;
                    break;
                }
            } else {
                taskEntity = (TaskEntity)taskEntities.get(0);
            }
            String taskId = taskEntity.getId();
            String nodeId = taskEntity.getTaskDefinitionKey();
            String nodeName = taskEntity.getName();
            String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
            String processId = taskEntity.getProcessInstanceId();
            Date createTime = new Date();
            users = new HashSet();
            for (String id : result) {
                if (ToolUtil.isNotEmpty((Object)userMap.get(id))) {
                    if (result.contains(userMap.get(id)) && ToolUtil.isEmpty((Object)userMap.get(userMap.get(id)))) {
                        users.add(userMap.get(id));
                        continue;
                    }
                    addEntrustList.add(new EntrustHi(taskId, nodeId, nodeName, processKey, processId, id, userMap.get(id), createTime, "1", ""));
                    users.add(userMap.get(id));
                    continue;
                }
                users.add(id);
            }
            map.put("addEntrustList", addEntrustList);
        }
        map.put("users", users);
        return map;
    }

    private static HashSet<String> getConfigUser(BpmnModel bm, ActivityExecution execution, boolean flag, String tenantId) {
        String appointAssignees;
        String activityId = execution.getActivity().getId();
        HashSet<String> users = new HashSet();
        Map map = execution.getVariableLocal("appoint_assignee") == null ? new HashMap() : (Map)execution.getVariableLocal("appoint_assignee");
        boolean isLocal = true;
        if (ToolUtil.isEmpty(map) && execution.getVariable("appoint_assignee") != null) {
            isLocal = false;
            map = (Map)execution.getVariable("appoint_assignee");
        }
        if (ToolUtil.isNotEmpty((Object)(appointAssignees = (String)map.get(activityId)))) {
            if (isLocal) {
                execution.removeVariableLocal("appoint_assignee");
            }
            users = new HashSet<String>(Arrays.asList(appointAssignees.split(",")));
            return users;
        }
        String staticAppointAssignees = (String)map.get("static_appoint_assignee");
        if (ToolUtil.isNotEmpty((Object)staticAppointAssignees)) {
            if (isLocal) {
                execution.removeVariableLocal("appoint_assignee");
            }
            users = new HashSet<String>(Arrays.asList(staticAppointAssignees.split(",")));
            return users;
        }
        String rejectAssignees = execution.getVariableLocal("reject_appoint_assignee") == null ? "" : (String)execution.getVariableLocal("reject_appoint_assignee");
        isLocal = true;
        if (ToolUtil.isEmpty((Object)rejectAssignees) && execution.getVariable("reject_appoint_assignee") != null) {
            isLocal = false;
            rejectAssignees = (String)execution.getVariable("reject_appoint_assignee");
        }
        if (ToolUtil.isNotEmpty((Object)rejectAssignees)) {
            if (isLocal) {
                execution.removeVariableLocal("reject_appoint_assignee");
            } else {
                execution.removeVariable("reject_appoint_assignee");
            }
            users = new HashSet<String>(Arrays.asList(rejectAssignees.split(",")));
            return users;
        }
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getExtensionElements();
        boolean flowStarter = Boolean.parseBoolean(((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("flowStarter")).get(0)).getAttributes().get("flowStarter")).get(0)).getValue());
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        if (flowStarter) {
            users.add(userId);
            return users;
        }
        String defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
        JSONObject inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
        HashMap<String, Object> assignmentNodeMap = new HashMap();
        if (!ToolUtil.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
            assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, execution.getProcessInstanceId());
        }
        users = AnalyticalModelUtil.getAssigneeByConfiguration(tenantId, execution, userId, defaultAssign, inExpressions, assignmentNodeMap);
        return users;
    }

    private static Map<String, Object> getAssignmentNodeMap(BpmnModel bm, String activityId, String processInstanceId) {
        ArrayList<String> list;
        HashMap<String, Object> assignmentNodeMap = new HashMap<String, Object>();
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getExtensionElements();
        if (ToolUtil.isEmpty((Object)extensionElementsNode)) {
            return assignmentNodeMap;
        }
        String assignmentNode = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("assignmentnode")).get(0)).getAttributes().get("assignmentnode")).get(0)).getValue();
        if (ToolUtil.isNotEmpty((Object)assignmentNode) && (list = new ArrayList<String>(new HashSet<String>(Arrays.asList(assignmentNode.split(","))))).size() > 0) {
            for (String node : list) {
                if (processInstanceId == null) {
                    assignmentNodeMap.put(node, "");
                    continue;
                }
                List hisActivitList = ((HistoricActivityInstanceQuery)BpmConstant.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId(node).orderByHistoricActivityInstanceStartTime().desc()).list();
                StringBuilder assignee = new StringBuilder();
                if (hisActivitList != null && hisActivitList.size() > 0) {
                    HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)hisActivitList.get(0);
                    Date start = historicActivityInstance.getStartTime();
                    assignee.append(historicActivityInstance.getAssignee());
                    for (int i = 1; i < hisActivitList.size() && start.before((historicActivityInstance = (HistoricActivityInstance)hisActivitList.get(i)).getEndTime()); ++i) {
                        assignee.append("','").append(historicActivityInstance.getAssignee());
                    }
                }
                if (ToolUtil.isNotEmpty((Object)assignee.toString())) {
                    assignmentNodeMap.put(node, assignee.toString());
                    continue;
                }
                assignmentNodeMap.put(node, "");
            }
        }
        return assignmentNodeMap;
    }

    private static JSONObject getConditionAssign(BpmnModel bm, String activityId, String type) {
        JSONObject inExpressions = new JSONObject();
        Map extensionAttribute = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getAttributes();
        List inCandidate = (List)extensionAttribute.get(type);
        if (inCandidate != null && inCandidate.size() > 0) {
            inExpressions = ((ExtensionAttribute)inCandidate.get(0)).getValue() == null ? null : (JSONObject)JSONObject.parse((String)((ExtensionAttribute)inCandidate.get(0)).getValue());
        }
        return inExpressions;
    }

    private static String getDefaultAssign(BpmnModel bm, String activityId, String type) {
        String defaultAssign = "";
        Map extensionAttribute = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getAttributes();
        List defaultCandidate = (List)extensionAttribute.get(type);
        if (defaultCandidate != null && defaultCandidate.size() > 0) {
            defaultAssign = ((ExtensionAttribute)defaultCandidate.get(0)).getValue() == null ? "" : ((ExtensionAttribute)defaultCandidate.get(0)).getValue();
        }
        return defaultAssign;
    }

    private static String getFlowStarter(ActivityExecution execution) {
        HistoricProcessInstance historicProcessInstance;
        String userId = "";
        List identityLink = ((ExecutionEntity)execution).getIdentityLinks();
        for (IdentityLinkEntity il : identityLink) {
            if (!STARTER.equals(il.getType())) continue;
            userId = il.getUserId() == null ? "" : il.getUserId();
            break;
        }
        if ("".equals(userId) && ToolUtil.isNotEmpty((Object)(historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(execution.getProcessInstanceId()).singleResult())) && ToolUtil.isNotEmpty((Object)historicProcessInstance.getStartUserId())) {
            userId = historicProcessInstance.getStartUserId();
        }
        return userId;
    }

    public static HashSet<String> getCcUser(BpmnModel bm, ActivityExecution execution, String tenantId) {
        String activityId = execution.getActivity().getId();
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        String defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultCcAssign");
        JSONObject inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionCcAssign");
        HashMap<String, Object> assignmentNodeMap = new HashMap();
        if (!ToolUtil.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
            assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, execution.getProcessInstanceId());
        }
        HashSet<String> users = AnalyticalModelUtil.getAssigneeByConfiguration(tenantId, execution, userId, defaultAssign, inExpressions, assignmentNodeMap);
        return users;
    }

    private static HashSet<String> getAssigneeByConfiguration(String tenantId, ActivityExecution execution, String userId, String defaultAssign, JSONObject conditionAssign, Map<String, Object> assignmentNodeMap) {
        Map<String, Object> formData = execution.getVariables();
        if (formData != null && formData.size() > 0) {
            formData.putAll(assignmentNodeMap);
        } else {
            formData = assignmentNodeMap;
        }
        String getProcessDefinitionKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        return AnalyticalModelUtil.getNextAssigneeByConfiguration(tenantId, getProcessDefinitionKey, userId, defaultAssign, conditionAssign, formData);
    }

    public static Map<String, String> getTodoConfiguration(String processDefinitionId, String taskDefinitionKey) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String todo = "";
        BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(processDefinitionId);
        if (ToolUtil.isNotEmpty((Object)taskDefinitionKey)) {
            Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(taskDefinitionKey).getExtensionElements();
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
            map.put("todoConfiguration", todo);
        }
        Map extensionElements = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        if (ToolUtil.isEmpty((Object)todo)) {
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElements.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
            if (ToolUtil.isNotEmpty((Object)todo)) {
                map.put("todoConfiguration", todo);
            } else {
                map.put("todoConfiguration", "");
            }
        }
        return map;
    }

    public static String getTodo(Map<String, Object> variables, String todoConfig) {
        if (ToolUtil.isEmpty((Object)todoConfig)) {
            return "";
        }
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(variables);
        ValueExpression valueExpression = factory.createValueExpression((ELContext)context, todoConfig, String.class);
        return valueExpression.getValue((ELContext)context) == null ? "" : valueExpression.getValue((ELContext)context).toString();
    }

    public static HashSet<String> getNextCandidateUser(Task task, BpmnModel bm, String activityId, String tenantId, Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        HashSet<String> users = new HashSet<String>();
        FlowElement flowElement = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId);
        if (flowElement == null) {
            throw new PublicClientException("\u76ee\u6807\u8282\u70b9\u672a\u627e\u5230\uff01", false);
        }
        Map extensionElementsNode = flowElement.getExtensionElements();
        if (extensionElementsNode.size() > 0) {
            TenantConfig tenantConfig;
            JSONObject inExpressions;
            String defaultAssign;
            Map<String, Object> assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, task.getProcessInstanceId());
            boolean flowStarter = Boolean.parseBoolean(((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("flowStarter")).get(0)).getAttributes().get("flowStarter")).get(0)).getValue());
            HistoricProcessInstance hpi = (HistoricProcessInstance)BpmConstant.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String startUserId = "";
            if (hpi != null) {
                startUserId = hpi.getStartUserId();
            }
            if (flowStarter) {
                users.add(startUserId);
                return users;
            }
            if (map != null) {
                newMap.putAll(map);
            }
            if (!ToolUtil.isAllEmpty((Object[])new Object[]{defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign"), inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign")})) {
                Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, task.getProcessInstanceId());
                newMap.putAll(nodeMap);
            }
            if (AnalyticalModelUtil.isGetVisitor(defaultAssign, inExpressions) && "1".equals((tenantConfig = iTenantConfigService.getTenantConfig(tenantId)).getIsGodAxe())) {
                String id = activityId;
                String[] ids = task.getProcessDefinitionId().split(":");
                HashMap<String, String> requestMap = new HashMap<String, String>();
                requestMap.put("beanId", ids[0] + ":" + modelService.getRealVersion(task.getProcessDefinitionId()) + CommonCodeUtil.getVisitorNodeId(id, bm));
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                requestMap.put("businessId", historicProcessInstance.getBusinessKey());
                try {
                    String path = tenantConfig.getProjectAddress();
                    String procPath = sysActProcPathService.getProcPath(ids[0]);
                    if (ToolUtil.isNotEmpty((Object)procPath) && !"null".equals(procPath)) {
                        path = procPath;
                    }
                    LOGGER.info("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u5904\u7406\u4eba\u5f00\u59cb");
                    System.out.println("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u5904\u7406\u4eba\u5f00\u59cb");
                    LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + tenantConfig.getProjectAddress() + GOD_AXE_PATH);
                    System.out.println("\u8def\u5f84\u4fe1\u606f" + tenantConfig.getProjectAddress() + GOD_AXE_PATH);
                    Long start = System.currentTimeMillis();
                    String result = HttpUtil.get((String)(path + GOD_AXE_PATH), requestMap, (int)lcdpBpmProperties.getDataPushTimeOut());
                    Long end = System.currentTimeMillis();
                    LOGGER.info("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u5904\u7406\u4eba\u7ed3\u675f");
                    System.out.println("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u5904\u7406\u4eba\u7ed3\u675f");
                    LOGGER.info("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u5904\u7406\u4eba\u8017\u65f6\uff1a" + (end - start) + "s");
                    System.out.println("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u5904\u7406\u4eba\u8017\u65f6\uff1a" + (end - start) + "s");
                    if (ToolUtil.isNotEmpty((Object)result)) {
                        Map variable = (Map)JSON.parseObject((String)result, HashMap.class);
                        newMap.putAll(variable);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u6570\u636e\u8bf7\u6c42\u5931\u8d25");
                }
            }
            newMap.putAll(assignmentNodeMap);
            assert (hpi != null);
            users = AnalyticalModelUtil.getNextAssigneeByConfiguration(tenantId, hpi.getProcessDefinitionKey(), startUserId, defaultAssign, inExpressions, newMap);
        }
        return users;
    }

    private static HashSet<String> getNextAssigneeByConfiguration(String tenantId, String processDefinitionKey, String userId, String defaultAssign, JSONObject conditionAssign, Map<String, Object> map) {
        HashSet<String> users = new HashSet<String>();
        boolean condition = false;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        StringBuilder sql = new StringBuilder();
        boolean isGetFlowStarterDept = false;
        if (defaultAssign.contains("flow_starter_dept")) {
            isGetFlowStarterDept = true;
        } else if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_starter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_starter_dept")) continue;
                isGetFlowStarterDept = true;
                break;
            }
        }
        if (isGetFlowStarterDept) {
            map.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId, tenantId));
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (ToolUtil.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return users;
            }
        }
        String realSql = sql.toString();
        String procPath = sysActProcPathService.getProcPath(processDefinitionKey);
        List<String> list = iAssigneeChooseService.getCandidateUser(procPath, AnalyticalModelUtil.replaceNextBuiltinVariable(realSql, userId, tenantId, map), tenantId);
        if (list == null || list.size() == 0) {
            return users;
        }
        return new HashSet<String>(list);
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map != null && map.size() > 0) {
            for (String k : map.keySet()) {
                if (map.get(k.toString()) == null) continue;
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
            }
        }
        return context;
    }

    private static String replaceNextBuiltinVariable(String sql, String starterUserId, String tenantId, Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        ValueExpression e = factory.createValueExpression((ELContext)context, sql, String.class);
        String finalSql = e.getValue((ELContext)context).toString();
        return "and (" + finalSql.replaceFirst("and", "") + ")";
    }

    public static String queryFirstNodeAssigneeConfig(String userId, String tenantId, String processDefinitionId, String businessKey, Map<String, Object> variables) {
        HashMap<String, Object> newVariables;
        List sequenceFlowList;
        String targetRef;
        FlowElement flowElement;
        StringBuilder sql = new StringBuilder();
        String taskDefinitionKey = "";
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        boolean condition = false;
        BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(processDefinitionId);
        Process process = bm.getMainProcess();
        Collection flowElements = process.getFlowElements();
        StartEvent startEvent = new StartEvent();
        for (FlowElement flowElement2 : flowElements) {
            if (!(flowElement2 instanceof StartEvent)) continue;
            startEvent = (StartEvent)flowElement2;
            break;
        }
        if ((flowElement = process.getFlowElement(targetRef = ((SequenceFlow)(sequenceFlowList = startEvent.getOutgoingFlows()).get(0)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = flowElement.getId();
        }
        if (flowElement instanceof ExclusiveGateway) {
            taskDefinitionKey = AnalyticalModelUtil.getFirstNode(flowElement, process, variables);
        }
        if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
            return "";
        }
        String defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, taskDefinitionKey, "defaultAssign");
        JSONObject conditionAssign = AnalyticalModelUtil.getConditionAssign(bm, taskDefinitionKey, "conditionAssign");
        if (ToolUtil.isEmpty((Object)defaultAssign) && ToolUtil.isEmpty((Object)conditionAssign)) {
            return "";
        }
        TenantConfig tenantConfig = iTenantConfigService.getTenantConfig(tenantId);
        boolean isGetFlowStarterDept = false;
        boolean isRequestVisit = false;
        boolean isGodAxe = "1".equals(tenantConfig.getIsGodAxe());
        if (isGodAxe && defaultAssign.contains("$")) {
            isRequestVisit = true;
        }
        if (defaultAssign.contains("flow_starter_dept")) {
            isGetFlowStarterDept = true;
        }
        if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (isGetFlowStarterDept && (!isGodAxe || isRequestVisit)) break;
                if (isGodAxe && !isRequestVisit && (k.toString().contains("$") || ((String)conditionAssign.get((Object)k.toString())).contains("$"))) {
                    isRequestVisit = true;
                }
                if (isGetFlowStarterDept || !k.toString().contains("flow_starter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_starter_dept")) continue;
                isGetFlowStarterDept = true;
            }
        }
        HashMap<String, Object> hashMap = newVariables = variables == null ? new HashMap<String, Object>() : variables;
        if (!ToolUtil.isAllEmpty((Object[])new Object[]{defaultAssign, conditionAssign})) {
            Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, taskDefinitionKey, null);
            newVariables.putAll(nodeMap);
        }
        if (isRequestVisit) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            String[] ids = processDefinitionId.split(":");
            newMap.put("beanId", ids[0] + ":" + modelService.getRealVersion(processDefinitionId) + CommonCodeUtil.getVisitorNodeId(taskDefinitionKey, bm));
            newMap.put("businessId", businessKey);
            try {
                String path = tenantConfig.getProjectAddress();
                String procPath = sysActProcPathService.getProcPath((String)ids[0]);
                if (ToolUtil.isNotEmpty((Object)procPath) && !"null".equals(procPath)) {
                    path = procPath;
                }
                LOGGER.info("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u914d\u7f6e\u5f00\u59cb");
                System.out.println("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u914d\u7f6e\u5f00\u59cb");
                LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + tenantConfig.getProjectAddress() + GOD_AXE_PATH);
                System.out.println("\u8def\u5f84\u4fe1\u606f" + tenantConfig.getProjectAddress() + GOD_AXE_PATH);
                Long start = System.currentTimeMillis();
                String result = HttpUtil.get((String)(path + GOD_AXE_PATH), newMap, (int)lcdpBpmProperties.getDataPushTimeOut());
                Long end = System.currentTimeMillis();
                LOGGER.info("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u914d\u7f6e\u7ed3\u675f");
                System.out.println("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u914d\u7f6e\u7ed3\u675f");
                LOGGER.info("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u914d\u7f6e\u8017\u65f6\uff1a" + (end - start) + "s");
                System.out.println("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u914d\u7f6e\u8017\u65f6\uff1a" + (end - start) + "s");
                if (ToolUtil.isNotEmpty((Object)result)) {
                    Map variable = (Map)JSON.parseObject((String)result, HashMap.class);
                    if (variables == null) {
                        variables = new HashMap();
                    }
                    newVariables.putAll(variable);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u6570\u636e\u8bf7\u6c42\u5931\u8d25");
            }
        }
        if (isGetFlowStarterDept) {
            newVariables.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId, tenantId));
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newVariables);
        if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (ToolUtil.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return "";
            }
        }
        String finalSql = "";
        if (ToolUtil.isNotEmpty((Object)sql)) {
            finalSql = AnalyticalModelUtil.replaceNextBuiltinVariable(sql.toString(), userId, tenantId, newVariables);
        }
        return finalSql;
    }

    private static boolean getResultByELAndFormData(String el, Map<String, Object> formData) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        for (Map.Entry<String, Object> k : formData.entrySet()) {
            if (k.getValue() == null) continue;
            context.setVariable(k.getKey(), factory.createValueExpression(k.getValue(), k.getValue().getClass()));
        }
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE);
        return (Boolean)e.getValue((ELContext)context);
    }

    private static String getFirstNode(FlowElement flowElement, Process process, Map<String, Object> variables) {
        SequenceFlow sequenceFlow;
        String targetRef;
        FlowElement fe;
        String taskDefinitionKey = "";
        ExclusiveGateway exclusiveGateway = (ExclusiveGateway)flowElement;
        String flow = exclusiveGateway.getDefaultFlow();
        List sf = exclusiveGateway.getOutgoingFlows();
        for (SequenceFlow s : sf) {
            String ce = s.getConditionExpression();
            if (!ToolUtil.isNotEmpty((Object)ce) || !AnalyticalModelUtil.getResultByELAndFormData(ce, variables)) continue;
            flow = s.getId();
            break;
        }
        if (ToolUtil.isNotEmpty((Object)flow) && (fe = process.getFlowElement(targetRef = (sequenceFlow = (SequenceFlow)process.getFlowElement(flow)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = fe.getId();
        }
        return taskDefinitionKey;
    }

    public static HashSet<String> getNextCandidateUserByModel(String processDefinitionId, String processDefinitionKey, BpmnModel bm, String activityId, String tenantId, Map<String, Object> map) {
        HashSet<String> users = new HashSet<String>();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getExtensionElements();
        if (extensionElementsNode.size() > 0) {
            TenantConfig tenantConfig;
            String defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
            JSONObject inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
            if (map != null) {
                newMap.putAll(map);
            }
            if (AnalyticalModelUtil.isGetVisitor(defaultAssign, inExpressions) && "1".equals((tenantConfig = iTenantConfigService.getTenantConfig(tenantId)).getIsGodAxe())) {
                String id = activityId;
                String[] ids = processDefinitionId.split(":");
                HashMap<String, String> requestMap = new HashMap<String, String>();
                requestMap.put("beanId", ids[0] + ":" + ids[1] + id);
                String path = tenantConfig.getProjectAddress();
                String procPath = sysActProcPathService.getProcPath(ids[0]);
                if (ToolUtil.isNotEmpty((Object)procPath) && !"null".equals(procPath)) {
                    path = procPath;
                }
                LOGGER.info("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u5f00\u59cb");
                System.out.println("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u5f00\u59cb");
                LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + tenantConfig.getProjectAddress() + GOD_AXE_PATH);
                System.out.println("\u8def\u5f84\u4fe1\u606f" + tenantConfig.getProjectAddress() + GOD_AXE_PATH);
                Long start = System.currentTimeMillis();
                String result = HttpUtil.get((String)(path + GOD_AXE_PATH), requestMap, (int)lcdpBpmProperties.getDataPushTimeOut());
                Long end = System.currentTimeMillis();
                LOGGER.info("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u7ed3\u675f");
                System.out.println("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u7ed3\u675f");
                LOGGER.info("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u8017\u65f6\uff1a" + (end - start) + "s");
                System.out.println("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\u8017\u65f6\uff1a" + (end - start) + "s");
                if (ToolUtil.isNotEmpty((Object)result)) {
                    Map variable = (Map)JSON.parseObject((String)result, HashMap.class);
                    newMap.putAll(variable);
                }
            }
            if (!ToolUtil.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
                Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, null);
                newMap.putAll(nodeMap);
            }
            String userId = ToolUtil.isEmpty(newMap.get("userId")) ? "" : (String)newMap.get("userId");
            users = AnalyticalModelUtil.getNextAssigneeByConfiguration(tenantId, processDefinitionKey, userId, defaultAssign, inExpressions, newMap);
        }
        return users;
    }

    private static boolean isGetVisitor(String defaultAssign, JSONObject conditionAssign) {
        if (defaultAssign.contains("$")) {
            return true;
        }
        if (conditionAssign != null && conditionAssign.size() > 0) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("$") && !((String)conditionAssign.get((Object)k.toString())).contains("$")) continue;
                return true;
            }
        }
        return false;
    }
}

