/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.taskmanager.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.assignee.service.impl.AssigneeChooseServiceImpl;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bsp.taskmanager.dao.TaskManagerMapper;
import com.jxdinfo.hussar.bsp.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.bsp.taskmanager.service.TaskManagerService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TaskManagerServiceImpl
implements TaskManagerService {
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    TaskManagerMapper taskManagerMapper;
    @Resource
    AssigneeChooseServiceImpl assigneeChooseService;
    @Value(value="${spring.datasource.url}")
    private String url;

    @Override
    public int count(String userId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateTime = dateFormat.format(new Date());
        return this.taskManagerMapper.count(dateTime, this.url.split(":")[1], userId);
    }

    @Override
    public List<TaskManager> getTask(Page<TaskManager> pages, Map<String, Object> map) {
        String dbType = this.url.split(":")[1];
        map.put("dbType", dbType);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateTime = dateFormat.format(new Date());
        List<TaskManager> list = this.taskManagerMapper.getTask(pages, map, dateTime);
        ArrayList<String> users = new ArrayList<String>();
        for (TaskManager taskManager : list) {
            ArrayList<String> receiver = new ArrayList<String>();
            if (taskManager.getReceivers() != null) {
                receiver = new ArrayList<String>(new HashSet<String>(Arrays.asList(taskManager.getReceivers().split(","))));
            }
            receiver.remove("");
            if (taskManager.getFirstReceiver() != null) {
                receiver.add(0, taskManager.getFirstReceiver());
            }
            users.addAll(receiver);
        }
        HashSet userSet = new HashSet(users);
        userSet.remove(null);
        users.clear();
        users.addAll(userSet);
        Map<String, String> userMap = this.assigneeChooseService.getUserListByUserId(users, String.valueOf(map.get("tenantId")));
        if (userMap == null) {
            userMap = new HashMap<String, String>();
        }
        for (TaskManager taskManager : list) {
            ArrayList<Object> receiver = new ArrayList<String>();
            if (taskManager.getReceivers() != null) {
                receiver = new ArrayList<String>(new HashSet<String>(Arrays.asList(taskManager.getReceivers().split(","))));
            }
            receiver.remove("");
            if (taskManager.getFirstReceiver() != null) {
                receiver.add(0, taskManager.getFirstReceiver());
            }
            if (receiver.size() > 0) {
                taskManager.setFirstReceiver((String)receiver.get(0));
            }
            ArrayList<String> name = new ArrayList<String>();
            for (String string : receiver) {
                name.add(userMap.get(string));
            }
            taskManager.setReceiverName(name);
        }
        return list;
    }

    @Override
    public ApiResponse<Map<String, Object>> suspendTaskById(String processInstanceId) {
        try {
            this.runtimeService.suspendProcessInstanceById(processInstanceId);
            return ApiResponse.success("\u6302\u8d77\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ApiResponse.fail("\u6302\u8d77\u5931\u8d25\uff01");
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> activateTaskById(String processInstanceId) {
        try {
            this.runtimeService.activateProcessInstanceById(processInstanceId);
            return ApiResponse.success("\u6fc0\u6d3b\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return ApiResponse.fail("\u6fc0\u6d3b\u5931\u8d25\uff01");
        }
    }

    @Override
    public String getFileByTaskId(String taskId) {
        return this.taskManagerMapper.getFileByTaskId(taskId);
    }
}

