/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processfile.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;

@Service
public class SysActProcessFileServiceImpl
extends ServiceImpl<SysActProcessFileMapper, SysActProcessFile>
implements SysActProcessFileService {
    @Resource
    SysActProcessFileMapper sysActProcessFileMapper;

    @Override
    @Transactional
    public void updateFile(WorkFlow workFlow, String tenantId) {
        List list = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_key", (Object)workFlow.getIdentity())).eq((Object)"tenant_id", (Object)tenantId)).eq((Object)"version", (Object)0));
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            metaFile = sysActProcessFile;
        }
        wfdFile.setContent(workFlow.getData());
        wfdFile.setModelId(workFlow.getModelId());
        this.sysActProcessFileMapper.updateById((Object)wfdFile);
        metaFile.setModelId(workFlow.getModelId());
        workFlow.setData(null);
        metaFile.setContent(JSONObject.toJSONString((Object)workFlow));
        this.sysActProcessFileMapper.updateById((Object)metaFile);
    }

    @Override
    @Transactional
    public void addFile(WorkFlow workFlow, String tenantId, Integer latestVersion) {
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        if (ToolUtil.isEmpty((Object)latestVersion)) {
            latestVersion = this.sysActProcessFileMapper.selectLatestVersion(workFlow.getIdentity(), tenantId) + 1;
        }
        SysActProcessFile file = new SysActProcessFile();
        file.setFileId(null);
        file.setCreateTime(ts);
        file.setVersion(latestVersion);
        if (ToolUtil.isNotEmpty((Object)workFlow.getProcDefId()) && Integer.parseInt(workFlow.getProcDefId().split(":")[1]) < 1) {
            file.setVersion(-1);
        }
        file.setProcessKey(workFlow.getIdentity());
        file.setModelId(workFlow.getModelId());
        file.setProcessId(workFlow.getProcDefId());
        file.setTenantId(tenantId);
        file.setType("wfd");
        file.setContent(workFlow.getData());
        this.sysActProcessFileMapper.insert((Object)file);
        file.setFileId(null);
        file.setType("meta");
        workFlow.setData(null);
        file.setContent(JSONObject.toJSONString((Object)workFlow));
        this.sysActProcessFileMapper.insert((Object)file);
    }

    @Override
    public WorkFlow getFileByProcessKey(String processKey, String tenantId, Integer version) {
        if (ToolUtil.isEmpty((Object)version)) {
            version = this.sysActProcessFileMapper.selectLatestVersion(processKey, tenantId);
        }
        List list = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_key", (Object)processKey)).eq((Object)"tenant_id", (Object)tenantId)).eq((Object)"version", (Object)version));
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            metaFile = sysActProcessFile;
        }
        String wfdInfo = null;
        if (ToolUtil.isNotEmpty((Object)((Object)wfdFile))) {
            wfdInfo = wfdFile.getContent();
        }
        String metaInfo = null;
        if (ToolUtil.isNotEmpty((Object)((Object)metaFile))) {
            metaInfo = metaFile.getContent();
        }
        if (ToolUtil.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            return workFlow;
        }
        return null;
    }

    @Override
    public WorkFlow getFileByProcessKeyAndProcessId(String processKey, String processId, String tenantId) {
        List list;
        String wfdInfo = null;
        String metaInfo = null;
        if (ToolUtil.isNotEmpty((Object)processId)) {
            list = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_id", (Object)tenantId)).eq((Object)"process_id", (Object)processId));
            for (SysActProcessFile sysActProcessFile : list) {
                if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    wfdInfo = sysActProcessFile.getContent();
                    continue;
                }
                metaInfo = sysActProcessFile.getContent();
            }
        } else if (ToolUtil.isNotEmpty((Object)processKey)) {
            list = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_key", (Object)processKey)).eq((Object)"tenant_id", (Object)tenantId)).eq((Object)"version", (Object)0));
            for (SysActProcessFile sysActProcessFile : list) {
                if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    wfdInfo = sysActProcessFile.getContent();
                    continue;
                }
                metaInfo = sysActProcessFile.getContent();
            }
        }
        if (ToolUtil.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject(metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            return workFlow;
        }
        return null;
    }

    @Override
    public List<SysActProcessFile> getBaseFileList(String processKey, String tenantId) {
        return this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_key", (Object)processKey)).eq((Object)"tenant_id", (Object)tenantId)).eq((Object)"version", (Object)0));
    }

    @Override
    public boolean copyFiles(String processDefKey, String id, String tenantId) {
        WorkFlow workFlow = ToolUtil.isNotEmpty((Object)id) ? this.getFileByProcessKeyAndProcessId(processDefKey, id, tenantId) : this.getFileByProcessKey(processDefKey, tenantId, 0);
        this.updateFile(workFlow, tenantId);
        return true;
    }

    @Override
    public List<SysActProcessFile> exportFileList(List<String> modelIds, String tenantId) {
        return this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_id", (Object)tenantId)).in((Object)"model_id", modelIds)).eq((Object)"version", (Object)0));
    }

    @Override
    public List<SysActProcessFile> exportFile(String procId, String tenantId) {
        return this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_id", (Object)tenantId)).in((Object)"process_id", new Object[]{procId}));
    }

    @Override
    public void updateMetaByIdentity(String identity, String name, String category, String tenantId) {
        int lastVersion = this.sysActProcessFileMapper.selectLatestVersion(identity, tenantId);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(lastVersion);
        List sysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_key", (Object)identity)).eq((Object)"tenant_id", (Object)tenantId)).in((Object)"version", list)).eq((Object)"type", (Object)"meta"));
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)sysActProcessFile.getContent(), WorkFlow.class);
            if (ToolUtil.isNotEmpty((Object)name)) {
                workFlow.setName(name);
            }
            workFlow.setCategory(category);
            sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow));
            this.sysActProcessFileMapper.updateById((Object)sysActProcessFile);
        }
    }
}

