/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processcount.service.impl;

import com.jxdinfo.hussar.bpm.processcount.dao.ProcessCountMapper;
import com.jxdinfo.hussar.bpm.processcount.service.ProcessCountService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProcessCountServiceImpl
implements ProcessCountService {
    public static int DAY = 6;
    @Resource
    private ProcessCountMapper processCountMapper;
    @Value(value="${spring.datasource.url}")
    private String url;

    @Override
    public List<Map<String, String>> getAllTaskCount(String type, String userId) {
        String time = ProcessCountServiceImpl.getStartTime(type);
        return this.processCountMapper.getTask(time, this.url.split(":")[1], userId);
    }

    @Override
    public List<Map<String, String>> getAllInstanceCount(String type, String userId) {
        String time = ProcessCountServiceImpl.getStartTime(type);
        return this.processCountMapper.getInstance(time, this.url.split(":")[1], userId);
    }

    @Override
    public List<Map<String, String>> getTaskDone(String userId) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("startTime", ProcessCountServiceImpl.getPastDate(DAY));
        query.put("endTime", ProcessCountServiceImpl.getPastDate(-1));
        List<String> list = this.processCountMapper.getTaskDone(query, this.url.split(":")[1], userId);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String str : list) {
            String date = str.substring(0, 10);
            int i = 1;
            if (map.get(date) != null) {
                i = (Integer)map.get(date) + 1;
            }
            map.put(date, i);
        }
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= DAY; ++i) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            if (map.get(ProcessCountServiceImpl.getPastDate(DAY - i)) == null) {
                resultMap.put("DATE", ProcessCountServiceImpl.getPastDate(DAY - i));
                resultMap.put("COUNTNUM", "0");
                resultList.add(resultMap);
                continue;
            }
            resultMap.put("DATE", ProcessCountServiceImpl.getPastDate(DAY - i));
            resultMap.put("COUNTNUM", ((Integer)map.get(ProcessCountServiceImpl.getPastDate(DAY - i))).toString());
            resultList.add(resultMap);
        }
        return resultList;
    }

    @Override
    public List<Map<String, String>> getTaskTodo(String userId) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("startTime", ProcessCountServiceImpl.getPastDate(6));
        query.put("endTime", ProcessCountServiceImpl.getPastDate(-1));
        List<String> list = this.processCountMapper.getTaskTodo(query, this.url.split(":")[1], userId);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String str : list) {
            String date = str.substring(0, 10);
            int i = 1;
            if (map.get(date) != null) {
                i = (Integer)map.get(date) + 1;
            }
            map.put(date, i);
        }
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= DAY; ++i) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            if (map.get(ProcessCountServiceImpl.getPastDate(DAY - i)) == null) {
                resultMap.put("DATE", ProcessCountServiceImpl.getPastDate(DAY - i));
                resultMap.put("COUNTNUM", "0");
                resultList.add(resultMap);
                continue;
            }
            resultMap.put("DATE", ProcessCountServiceImpl.getPastDate(DAY - i));
            resultMap.put("COUNTNUM", ((Integer)map.get(ProcessCountServiceImpl.getPastDate(DAY - i))).toString());
            resultList.add(resultMap);
        }
        return resultList;
    }

    public static String getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(calendar.getTime());
    }

    public static String getStartTime(String type) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        if (type.equals("week")) {
            date.setHours(0);
            date.setMinutes(0);
            date.setSeconds(0);
            cal.setTime(date);
            int dayofweek = cal.get(7);
            if (dayofweek == 1) {
                dayofweek += 7;
            }
            cal.add(5, 2 - dayofweek);
            return formatter.format(cal.getTime());
        }
        if (type.equals("month")) {
            cal.set(date.getYear() + 1900, date.getMonth(), 1, 0, 0, 0);
            return formatter.format(cal.getTime());
        }
        if (type.equals("year")) {
            cal.set(date.getYear() + 1900, 0, 1, 0, 0, 0);
            return formatter.format(cal.getTime());
        }
        return null;
    }
}

