/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.flowevents.controller;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.flowevents.service.FlowEventsService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowEvents"})
public class FlowEventsController {
    @Autowired
    FlowEventsService flowEventsService;

    @RequestMapping(value={"/todoList"})
    public BpmResponseResult todoList(@RequestParam(required=false) String processDefinitionKey, @RequestParam(required=false) String message, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime, @RequestParam(required=false) String userId, @RequestParam(required=false) String startUserId, @RequestParam(required=false) String tenantId, @RequestParam(required=false) String category, @RequestParam(required=false) String taskDefKey, @RequestParam(required=false, defaultValue="") String type, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="10") Integer limit) {
        return this.flowEventsService.todoList(userId, processDefinitionKey, message, startUserId, startTime, endTime, page, limit, type, tenantId, category, taskDefKey);
    }

    @RequestMapping(value={"/doneList"})
    public BpmResponseResult doneList(@RequestParam(required=false) String processDefinitionKey, @RequestParam(required=false) String message, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime, @RequestParam(required=false) String userId, @RequestParam(required=false) String startUserId, @RequestParam(required=false) String tenantId, @RequestParam(required=false) String category, @RequestParam(required=false) String taskDefKey, @RequestParam(required=false) String doneStartTime, @RequestParam(required=false) String doneEndTime, @RequestParam(required=false, defaultValue="") String type, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="10") Integer limit) {
        return this.flowEventsService.doneList(userId, processDefinitionKey, message, startUserId, startTime, endTime, page, limit, type, tenantId, category, taskDefKey, doneStartTime, doneEndTime);
    }

    @RequestMapping(value={"/flowType"})
    public BpmResponseResult flowType(String category) {
        List<Map<String, String>> definitions = this.flowEventsService.flowType(category);
        JSONArray jsonArray = new JSONArray();
        if (definitions != null) {
            for (Map<String, String> tmp : definitions) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", tmp.get("id"));
                tmpMap.put("name", tmp.get("name"));
                jsonArray.add(tmpMap);
            }
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @RequestMapping(value={"/getProcNodeName"})
    public BpmResponseResult getProcNodeName(String processDefinitionKey) {
        return InstallResult.getResult("1", "success", this.flowEventsService.getProcNodeName(processDefinitionKey));
    }

    @RequestMapping(value={"/revokeTask"})
    public BpmResponseResult revokeTask(String historicTaskId, String userId) {
        return this.flowEventsService.revokeTask(historicTaskId, userId);
    }

    @RequestMapping(value={"/urgeTask"})
    public BpmResponseResult urgeTask(String processInsId, String userId) {
        return this.flowEventsService.urgeTask(processInsId, userId);
    }
}

