/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.extend;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;

public class ExtendCallActivityBehavior
extends CallActivityBehavior {
    private HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
    private ProcessDefinitionsService processDefinitionsService = (ProcessDefinitionsService)SpringContextHolder.getBean(ProcessDefinitionsService.class);
    private IdentityService identityService = (IdentityService)SpringContextHolder.getBean(IdentityService.class);
    protected String processDefinitonKey;
    private List<AbstractDataAssociation> dataInputAssociations = new ArrayList<AbstractDataAssociation>();
    private List<AbstractDataAssociation> dataOutputAssociations = new ArrayList<AbstractDataAssociation>();
    private Expression processDefinitionExpression;
    protected List<MapExceptionEntry> mapExceptions;
    protected boolean inheritVariables;
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getApplicationContext().getBean(TaskEngineMapper.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);

    public ExtendCallActivityBehavior(String processDefinitionKey, List<MapExceptionEntry> mapExceptions) {
        super(processDefinitionKey, mapExceptions);
    }

    public ExtendCallActivityBehavior(Expression processDefinitionExpression, List<MapExceptionEntry> mapExceptions) {
        super(processDefinitionExpression, mapExceptions);
    }

    public void addDataInputAssociation(AbstractDataAssociation dataInputAssociation) {
        this.dataInputAssociations.add(dataInputAssociation);
    }

    public void addDataOutputAssociation(AbstractDataAssociation dataOutputAssociation) {
        this.dataOutputAssociations.add(dataOutputAssociation);
    }

    public void setInheritVariables(boolean inheritVariables) {
        this.inheritVariables = inheritVariables;
    }

    public void execute(ActivityExecution execution) throws Exception {
        block19: {
            String processDefinitionKey;
            JSONArray allCallActivityInfos;
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(execution.getProcessInstanceId()).singleResult();
            if (ToolUtil.isNotEmpty((Object)historicProcessInstance)) {
                this.identityService.setAuthenticatedUserId(historicProcessInstance.getStartUserId());
            }
            int loopCounter = execution.getVariablesLocal().get("loopCounter") == null ? 0 : (Integer)execution.getVariablesLocal().get("loopCounter");
            ActivityExecution parent = execution.getParent();
            ExecutionEntity entity = null;
            JSONArray callActivityInfos = null;
            JSONArray jSONArray = allCallActivityInfos = execution.getVariable("call_activity_info") == null ? null : (JSONArray)execution.getVariable("call_activity_info");
            if (ToolUtil.isNotEmpty((Object)allCallActivityInfos)) {
                callActivityInfos = this.getRightActivity(allCallActivityInfos, execution);
                if (loopCounter == 0) {
                    ArrayList<String> businesskeys = new ArrayList<String>();
                    for (Object object : callActivityInfos) {
                        businesskeys.add(((JSONObject)object).get((Object)"businessKey") == null ? "" : (String)((JSONObject)object).get((Object)"businessKey"));
                    }
                    if (businesskeys.size() > 0 && this.taskEngineMapper.isBusinessKeyExist(businesskeys) > 0) {
                        throw new PublicClientException("\u542f\u52a8\u5b50\u6d41\u7a0b\u6240\u4f20businessKey\u5df2\u5b58\u5728!", false);
                    }
                }
            }
            String businessKey = "";
            String userId = "";
            String customProcessDefinition = null;
            if (ToolUtil.isNotEmpty((Object)callActivityInfos)) {
                JSONObject jsonObject = (JSONObject)callActivityInfos.get(loopCounter);
                businessKey = jsonObject.get((Object)"businessKey") == null ? "" : (String)jsonObject.get((Object)"businessKey");
                customProcessDefinition = jsonObject.get((Object)"processDefinitionKey") == null ? "" : (String)jsonObject.get((Object)"processDefinitionKey");
                String string = userId = jsonObject.get((Object)"userId") == null ? "" : (String)jsonObject.get((Object)"userId");
            }
            if (null != parent) {
                if (ToolUtil.isEmpty((Object)businessKey)) {
                    businessKey = "CallActivity" + ((ExecutionEntity)execution).getActivityId() + loopCounter + parent.getProcessBusinessKey();
                }
                entity = (ExecutionEntity)execution;
                entity.setBusinessKey(businessKey);
            }
            ExecutionEntity newExecution = entity;
            if (ToolUtil.isEmpty(customProcessDefinition)) {
                BpmnModel bm = this.repositoryService.getBpmnModel(newExecution.getProcessDefinitionId());
                CallActivity callActivity = (CallActivity)((Process)bm.getProcesses().get(0)).getFlowElement(newExecution.getActivityId());
                String processDefinitionJson = callActivity.getCalledElement();
                if (this.processDefinitionExpression != null) {
                    processDefinitionJson = (String)this.processDefinitionExpression.getValue((VariableScope)newExecution);
                }
                List<String> processDefinitionList = Arrays.asList(processDefinitionJson.split(","));
                processDefinitionKey = processDefinitionList.get(loopCounter);
            } else {
                processDefinitionKey = customProcessDefinition;
            }
            DeploymentManager deploymentManager = Context.getProcessEngineConfiguration().getDeploymentManager();
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processDefinitionKey);
            if (ToolUtil.isEmpty((Object)definitionModel)) {
                return;
            }
            String processDefinitionId = definitionModel.getId();
            ProcessDefinitionEntity processDefinition = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
            if (deploymentManager.isProcessDefinitionSuspended(processDefinition.getId())) {
                throw new ActivitiException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
            }
            PvmProcessInstance subProcessInstance = newExecution.createSubProcessInstance((PvmProcessDefinition)processDefinition);
            ((ExecutionEntity)subProcessInstance).setBusinessKey(businessKey);
            Map variables = newExecution.getVariables();
            variables.remove("TimeOutStrategy");
            variables.remove("multStartFlag");
            variables.remove("multStartCollection");
            variables.remove("multStartCategory");
            variables.remove("ccUserMessage");
            for (Map.Entry entry : variables.entrySet()) {
                subProcessInstance.setVariable((String)entry.getKey(), entry.getValue());
            }
            if (ToolUtil.isNotEmpty((Object)userId)) {
                ((ExecutionEntity)subProcessInstance).setVariable("startUser", (Object)userId);
            }
            for (AbstractDataAssociation dataInputAssociation : this.dataInputAssociations) {
                Object value = dataInputAssociation.getSourceExpression() != null ? dataInputAssociation.getSourceExpression().getValue((VariableScope)newExecution) : newExecution.getVariable(dataInputAssociation.getSource());
                subProcessInstance.setVariable(dataInputAssociation.getTarget(), value);
            }
            try {
                subProcessInstance.start();
                List taskEntity = ((ExecutionEntity)subProcessInstance).getTasks();
                if (ToolUtil.isNotEmpty((Object)userId)) {
                    ((TaskEntity)taskEntity.get(0)).addCandidateUsers(Arrays.asList(userId.split(",")));
                }
            }
            catch (Exception e) {
                if (ErrorPropagation.mapException((Exception)e, (ActivityExecution)newExecution, this.mapExceptions, (boolean)true)) break block19;
                throw e;
            }
        }
    }

    private JSONArray getRightActivity(JSONArray allCallActivityInfos, ActivityExecution execution) {
        JSONArray callActivityInfos = new JSONArray();
        for (int i = 0; i < allCallActivityInfos.size(); ++i) {
            JSONObject object = (JSONObject)allCallActivityInfos.get(i);
            if (!ToolUtil.isEmpty((Object)object.get((Object)"taskDefinitionKey")) && !((ExecutionEntity)execution).getActivityId().equals(object.get((Object)"taskDefinitionKey"))) continue;
            callActivityInfos.add((Object)object);
        }
        return callActivityInfos;
    }

    public void setProcessDefinitonKey(String processDefinitonKey) {
        this.processDefinitonKey = processDefinitonKey;
    }

    public String getProcessDefinitonKey() {
        return this.processDefinitonKey;
    }

    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        for (AbstractDataAssociation dataOutputAssociation : this.dataOutputAssociations) {
            Object value = null;
            value = dataOutputAssociation.getSourceExpression() != null ? dataOutputAssociation.getSourceExpression().getValue((VariableScope)subProcessInstance) : subProcessInstance.getVariable(dataOutputAssociation.getSource());
            execution.setVariable(dataOutputAssociation.getTarget(), value);
        }
    }

    public void completed(ActivityExecution execution) throws Exception {
        this.leave(execution);
    }
}

