/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import com.jxdinfo.hussar.bpm.interfacelog.annontion.InterfaceLog;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/instance"})
public class InstanceEngineController {
    private final InstanceEngineService instanceEngineService;

    @Autowired
    public InstanceEngineController(InstanceEngineService instanceEngineService) {
        this.instanceEngineService = instanceEngineService;
    }

    @RequestMapping(value={"/startProcessInstanceById"})
    @InterfaceLog(key="/instance/startProcessInstanceById", value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u542f\u52a8\u6d41\u7a0b", type="\u542f\u52a8\u6d41\u7a0b")
    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessKey, String tenantId, String variables) {
        Map map = (Map)JSON.parseObject((String)variables, HashMap.class);
        return this.instanceEngineService.startProcessInstanceById(processDefinitionId, userId, businessKey, tenantId, map);
    }

    @RequestMapping(value={"/startProcessInstanceByKey"})
    @InterfaceLog(key="/instance/startProcessInstanceByKey", value="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u542f\u52a8\u6d41\u7a0b", type="\u542f\u52a8\u6d41\u7a0b")
    public BpmResponseResult startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, String processCode, String tenantId, String variables) {
        Map map = (Map)JSON.parseObject((String)variables, HashMap.class);
        return this.instanceEngineService.startProcessInstanceByKey(processDefinitionKey, userId, businessKey, processCode, tenantId, map, true);
    }

    @RequestMapping(value={"/startProcessInstanceByKeyWithOutCheck"})
    @InterfaceLog(key="/instance/startProcessInstanceByKeyWithOutCheck", value="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u542f\u52a8\u6d41\u7a0b", type="\u542f\u52a8\u6d41\u7a0b")
    public BpmResponseResult startProcessInstanceByKeyWithOutCheck(String processDefinitionKey, String userId, String businessKey, String processCode, String tenantId, String variables) {
        Map map = (Map)JSON.parseObject((String)variables, HashMap.class);
        return this.instanceEngineService.startProcessInstanceByKey(processDefinitionKey, userId, businessKey, processCode, tenantId, map, false);
    }

    @RequestMapping(value={"/suspendProcessInstanceById"})
    @InterfaceLog(key="/instance/suspendProcessInstanceById", value="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b", type="\u6302\u8d77")
    public BpmResponseResult suspendProcessInstanceById(String processInstanceId) {
        return this.instanceEngineService.suspendProcessInstanceById(processInstanceId);
    }

    @RequestMapping(value={"/activateProcessInstanceById"})
    @InterfaceLog(key="/instance/activateProcessInstanceById", value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b", type="\u6fc0\u6d3b")
    public BpmResponseResult activateProcessInstanceById(String processInstanceId) {
        return this.instanceEngineService.activateProcessInstanceById(processInstanceId);
    }

    @RequestMapping(value={"/deleteProcessInstance"})
    @InterfaceLog(key="/instance/deleteProcessInstance", value="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public BpmResponseResult deleteProcessInstance(String processInstanceId, String reason) {
        return this.instanceEngineService.deleteProcessInstance(processInstanceId, reason);
    }

    @RequestMapping(value={"/deleteFinishedProcessInstance"})
    @InterfaceLog(key="/instance/deleteFinishedProcessInstance", value="\u5220\u9664\u5df2\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public BpmResponseResult deleteFinishedProcessInstance(String processInstanceId) {
        return this.instanceEngineService.deleteFinishedProcessInstance(processInstanceId);
    }

    @RequestMapping(value={"/deleteProcessInstanceByBusinessKey"})
    @InterfaceLog(key="/instance/deleteProcessInstanceByBusinessKey", value="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", type="\u5220\u9664")
    public BpmResponseResult deleteProcessInstanceByBusinessKey(String businessKey) {
        return this.instanceEngineService.deleteProcessInstanceByBusinessKey(businessKey);
    }

    @RequestMapping(value={"/queryFinishedProcessInstance"})
    @InterfaceLog(key="/instance/queryFinishedProcessInstance", value="\u83b7\u53d6\u5df2\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", type="\u67e5\u8be2")
    public BpmResponseResult queryFinishedProcessInstance(String processDefinitionKey, String businessKey, int page, int rows) {
        return this.instanceEngineService.queryFinishedProcessInstance(processDefinitionKey, businessKey, page, rows);
    }

    @RequestMapping(value={"/queryProcessInstanceCompleteState"})
    @InterfaceLog(key="/instance/queryProcessInstanceCompleteState", value="\u67e5\u8be2\u5f53\u524d\u6d41\u7a0b\u662f\u5426\u5df2\u5b8c\u6210", type="\u67e5\u8be2")
    public BpmResponseResult queryProcessInstanceCompleteState(String processInstanceId) {
        return this.instanceEngineService.queryProcessInstanceCompleteState(processInstanceId);
    }

    @RequestMapping(value={"/queryProcessInstanceCompleteStateByBusinessKey"})
    @InterfaceLog(key="/instance/queryProcessInstanceCompleteStateByBusinessKey", value="\u67e5\u8be2\u5f53\u524d\u6d41\u7a0b\u662f\u5426\u5df2\u5b8c\u6210", type="\u67e5\u8be2")
    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessKey) {
        return this.instanceEngineService.queryProcessInstanceCompleteStateByBusinessKey(businessKey);
    }

    @RequestMapping(value={"/getProcessTrace"})
    @InterfaceLog(key="/instance/getProcessTrace", value="\u67e5\u8be2\u6d41\u7a0b\u56fe\u5404\u8282\u70b9\u7684\u4fe1\u606f", type="\u67e5\u8be2")
    public BpmResponseResult getProcessTrace(String processInstanceId, String tenantId) {
        return this.instanceEngineService.getProcessTrace(processInstanceId, tenantId);
    }

    @RequestMapping(value={"/getAllProcessTrace"})
    @InterfaceLog(key="/instance/getAllProcessTrace", value="\u67e5\u8be2\u6d41\u7a0b\u56fe\u5404\u8282\u70b9\u529e\u7406\u4fe1\u606f", type="\u67e5\u8be2")
    public BpmResponseResult getAllProcessTrace(String processInstanceId, String tenantId) {
        return this.instanceEngineService.getAllProcessTrace(processInstanceId, tenantId);
    }

    @RequestMapping(value={"/getAllProcessTraceByBusinessKey"})
    @InterfaceLog(key="/instance/getAllProcessTraceByBusinessKey", value="\u67e5\u8be2\u6d41\u7a0b\u56fe\u5404\u8282\u70b9\u529e\u7406\u4fe1\u606f", type="\u67e5\u8be2")
    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessKey, String tenantId, int page, int size) {
        return this.instanceEngineService.getAllProcessTraceByBusinessKey(businessKey, tenantId, page, size);
    }

    @RequestMapping(value={"/queryProcessDefinitionByInstanceId"})
    @InterfaceLog(key="/instance/queryProcessDefinitionByInstanceId", value="\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f", type="\u67e5\u8be2")
    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInstanceId) {
        return this.instanceEngineService.queryProcessDefinitionByInstanceId(processInstanceId);
    }

    @RequestMapping(value={"/endProcess"})
    @InterfaceLog(key="/instance/endProcess", value="\u7ec8\u7ed3\u6d41\u7a0b\u5b9e\u4f8b", type="\u7ec8\u7ed3\u6d41\u7a0b")
    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        return this.instanceEngineService.endProcess(taskId, userId, reason);
    }

    @RequestMapping(value={"/checkProcessInstByBusinessKey"})
    @InterfaceLog(key="/instance/checkProcessInstByBusinessKey", value="\u67e5\u8be2\u6d41\u7a0b\u662f\u5426\u542f\u52a8", type="\u67e5\u8be2")
    public BpmResponseResult checkProcessInstByBusinessKey(String businessKey) {
        return this.instanceEngineService.checkProcessInstByBusinessKey(businessKey);
    }

    @RequestMapping(value={"/validateEditAuthority"})
    @InterfaceLog(key="/instance/validateEditAuthority", value="\u67e5\u8be2\u80fd\u5426\u4fee\u6539\u6d41\u7a0b\u8868\u5355", type="\u67e5\u8be2")
    public BpmResponseResult validateEditAuthority(String businessKey) {
        return this.instanceEngineService.validateEditAuthority(businessKey);
    }

    @RequestMapping(value={"/validateDeleteByBusinessKey"})
    @InterfaceLog(key="/instance/validateDeleteByBusinessKey", value="\u67e5\u8be2\u80fd\u5426\u5220\u9664\u6d41\u7a0b\u8868\u5355", type="\u67e5\u8be2")
    public BpmResponseResult validateDeleteByBusinessKey(String businessKey) {
        return this.instanceEngineService.validateDeleteByBusinessKey(businessKey);
    }

    @RequestMapping(value={"/getCommentMessages"})
    @InterfaceLog(key="/instance/getCommentMessages", value="\u67e5\u8be2\u6d41\u7a0b\u529e\u7406\u610f\u89c1", type="\u67e5\u8be2")
    public BpmResponseResult getCommentMessages(String businessKey, String tenantId) {
        return this.instanceEngineService.getCommentMessages(businessKey, tenantId);
    }
}

