/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.assignee.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.bpm.assignee.dao.AssigneeChooseMapper;
import com.jxdinfo.hussar.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.util.HussarBpmSM4Util;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Resource
    AssigneeChooseMapper assigneeChooseMapper;
    private static Logger LOGGER = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    @Resource
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private ITenantConfigService iTenantConfigService;
    private static final String USER_TREE_URL = "/assignee/user";
    private static final String DEPT_TREE_URL = "/assignee/dept";
    private static final String ROLE_TREE_URL = "/assignee/role";
    private static final String USER_DETAIL_URL = "/assignee/userDetail";
    private static final String CANDIDATE_USER_URL = "/assignee/getCandidateUser";
    private static final String REAL_CANDIDATE_URL = "/assignee/getRealCondition";
    private static final String IS_MQ_USE = "1";
    private static final String DEFAULT_PARENTID = "11";

    @Override
    public List<BpmTreeModel> userTree(String id, String tenantId) {
        if (StringUtils.isEmpty((Object)id)) {
            id = DEFAULT_PARENTID;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (IS_MQ_USE.equals(tenantConfig.getIsMqUse())) {
            return this.assigneeChooseMapper.getUser(id);
        }
        try {
            LOGGER.info("\u52a0\u8f7d\u7528\u6237\u6811\u5f00\u59cb");
            System.out.println("\u52a0\u8f7d\u7528\u6237\u6811\u5f00\u59cb");
            LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            System.out.println("\u8def\u5f84\u4fe1\u606f" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            Long start = System.currentTimeMillis();
            String result = HttpUtil.get((String)(tenantConfig.getProjectAddress() + USER_TREE_URL), map, (int)this.lcdpBpmProperties.getDataPushTimeOut());
            Long end = System.currentTimeMillis();
            LOGGER.info("\u52a0\u8f7d\u7528\u6237\u6811\u7ed3\u675f");
            System.out.println("\u52a0\u8f7d\u7528\u6237\u6811\u7ed3\u675f");
            LOGGER.info("\u52a0\u8f7d\u7528\u6237\u6811\u8017\u65f6\uff1a" + (end - start) + "s");
            System.out.println("\u52a0\u8f7d\u7528\u6237\u6811\u8017\u65f6\uff1a" + (end - start) + "s");
            return JSONArray.parseArray((String)result, BpmTreeModel.class);
        }
        catch (Exception e) {
            return new ArrayList<BpmTreeModel>();
        }
    }

    @Override
    public List<BpmTreeModel> deptTree(String id, String tenantId) {
        if (StringUtils.isEmpty((Object)id)) {
            id = DEFAULT_PARENTID;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (IS_MQ_USE.equals(tenantConfig.getIsMqUse())) {
            return this.assigneeChooseMapper.getOrgan(id);
        }
        try {
            LOGGER.info("\u52a0\u8f7d\u90e8\u95e8\u6811\u5f00\u59cb");
            System.out.println("\u52a0\u8f7d\u90e8\u95e8\u6811\u5f00\u59cb");
            LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            System.out.println("\u8def\u5f84\u4fe1\u606f" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            Long start = System.currentTimeMillis();
            String result = HttpUtil.get((String)(tenantConfig.getProjectAddress() + DEPT_TREE_URL), map, (int)this.lcdpBpmProperties.getDataPushTimeOut());
            Long end = System.currentTimeMillis();
            LOGGER.info("\u52a0\u8f7d\u90e8\u95e8\u6811\u7ed3\u675f");
            System.out.println("\u52a0\u8f7d\u90e8\u95e8\u6811\u7ed3\u675f");
            LOGGER.info("\u52a0\u8f7d\u90e8\u95e8\u6811\u8017\u65f6\uff1a" + (end - start) + "s");
            System.out.println("\u52a0\u8f7d\u90e8\u95e8\u6811\u8017\u65f6\uff1a" + (end - start) + "s");
            return JSONArray.parseArray((String)result, BpmTreeModel.class);
        }
        catch (Exception e) {
            return new ArrayList<BpmTreeModel>();
        }
    }

    @Override
    public List<BpmTreeModel> roleTree(String tenantId) {
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (IS_MQ_USE.equals(tenantConfig.getIsMqUse())) {
            return this.assigneeChooseMapper.getRole();
        }
        try {
            LOGGER.info("\u52a0\u8f7d\u89d2\u8272\u6811\u5f00\u59cb");
            System.out.println("\u52a0\u8f7d\u89d2\u8272\u6811\u5f00\u59cb");
            LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            System.out.println("\u8def\u5f84\u4fe1\u606f" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            Long start = System.currentTimeMillis();
            String result = HttpUtil.get((String)(tenantConfig.getProjectAddress() + ROLE_TREE_URL), (int)this.lcdpBpmProperties.getDataPushTimeOut());
            Long end = System.currentTimeMillis();
            LOGGER.info("\u52a0\u8f7d\u89d2\u8272\u6811\u7ed3\u675f");
            System.out.println("\u52a0\u8f7d\u89d2\u8272\u6811\u7ed3\u675f");
            LOGGER.info("\u52a0\u8f7d\u89d2\u8272\u6811\u8017\u65f6\uff1a" + (end - start) + "s");
            System.out.println("\u52a0\u8f7d\u89d2\u8272\u6811\u8017\u65f6\uff1a" + (end - start) + "s");
            return JSONArray.parseArray((String)result, BpmTreeModel.class);
        }
        catch (Exception e) {
            return new ArrayList<BpmTreeModel>();
        }
    }

    @Override
    public List<BpmTreeModel> userDetail(List<String> userIds, String tenantId) {
        if (ToolUtil.isEmpty(userIds)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userIds", String.join((CharSequence)",", userIds));
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (IS_MQ_USE.equals(tenantConfig.getIsMqUse())) {
            return this.assigneeChooseMapper.getUserMessage(userIds);
        }
        List<BpmTreeModel> message = new ArrayList<BpmTreeModel>();
        try {
            LOGGER.info("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5f00\u59cb");
            System.out.println("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5f00\u59cb");
            LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            System.out.println("\u8def\u5f84\u4fe1\u606f" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            Long start = System.currentTimeMillis();
            String result = HttpUtil.get((String)(tenantConfig.getProjectAddress() + USER_DETAIL_URL), map, (int)this.lcdpBpmProperties.getDataPushTimeOut());
            Long end = System.currentTimeMillis();
            LOGGER.info("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u7ed3\u675f");
            System.out.println("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u7ed3\u675f");
            LOGGER.info("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u8017\u65f6\uff1a" + (end - start) + "s");
            System.out.println("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u8017\u65f6\uff1a" + (end - start) + "s");
            message = JSONArray.parseArray((String)result, BpmTreeModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    @Override
    public String getStarterDept(String userIds, String tenantId) {
        String startDept = "";
        List<BpmTreeModel> list = this.userDetail(Collections.singletonList(userIds), tenantId);
        if (list != null && list.size() > 0) {
            BpmTreeModel bpmTreeModel = list.get(0);
            startDept = bpmTreeModel.getParentId();
        }
        return startDept;
    }

    @Override
    public String getUserNames(List<String> userIds, String tenantId) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId);
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    @Override
    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList, String tenantId) {
        List<BpmTreeModel> list = this.userDetail(userList, tenantId);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    @Override
    public Map<String, String> getUserListByUserId(List<String> userIds, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId);
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        return map;
    }

    @Override
    public List<String> getCandidateUser(String procPath, String condition, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("condition", HussarBpmSM4Util.encrypt(condition, "admin#$%^kopoiuy"));
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        String path = tenantConfig.getProjectAddress();
        if (ToolUtil.isNotEmpty((Object)procPath) && !"null".equals(procPath)) {
            path = procPath;
        }
        if (IS_MQ_USE.equals(tenantConfig.getIsMqUse())) {
            if (!condition.contains("@{")) {
                return this.assigneeChooseMapper.getCandidateUser(condition);
            }
            try {
                LOGGER.info("\u83b7\u53d6\u53c2\u4e0e\u8005\u51fd\u6570\u6761\u4ef6\u5f00\u59cb");
                System.out.println("\u83b7\u53d6\u53c2\u4e0e\u8005\u51fd\u6570\u6761\u4ef6\u5f00\u59cb");
                LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + tenantConfig.getProjectAddress() + USER_TREE_URL);
                System.out.println("\u8def\u5f84\u4fe1\u606f" + tenantConfig.getProjectAddress() + USER_TREE_URL);
                Long start = System.currentTimeMillis();
                String result = HttpUtil.get((String)(path + REAL_CANDIDATE_URL), map, (int)this.lcdpBpmProperties.getDataPushTimeOut());
                Long end = System.currentTimeMillis();
                LOGGER.info("\u83b7\u53d6\u53c2\u4e0e\u8005\u51fd\u6570\u6761\u4ef6\u7ed3\u675f");
                System.out.println("\u83b7\u53d6\u53c2\u4e0e\u8005\u51fd\u6570\u6761\u4ef6\u7ed3\u675f");
                LOGGER.info("\u83b7\u53d6\u53c2\u4e0e\u8005\u51fd\u6570\u6761\u4ef6\u8017\u65f6\uff1a" + (end - start) + "s");
                System.out.println("\u83b7\u53d6\u53c2\u4e0e\u8005\u51fd\u6570\u6761\u4ef6\u8017\u65f6\uff1a" + (end - start) + "s");
                return this.assigneeChooseMapper.getCandidateUser(result);
            }
            catch (Exception e) {
                return new ArrayList<String>();
            }
        }
        try {
            LOGGER.info("\u83b7\u53d6\u53c2\u4e0e\u8005\u5f00\u59cb");
            System.out.println("\u83b7\u53d6\u53c2\u4e0e\u8005\u5f00\u59cb");
            LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            System.out.println("\u8def\u5f84\u4fe1\u606f" + tenantConfig.getProjectAddress() + USER_TREE_URL);
            Long start = System.currentTimeMillis();
            String result = HttpUtil.get((String)(path + CANDIDATE_USER_URL), map, (int)this.lcdpBpmProperties.getDataPushTimeOut());
            Long end = System.currentTimeMillis();
            LOGGER.info("\u83b7\u53d6\u53c2\u4e0e\u8005\u7ed3\u675f");
            System.out.println("\u83b7\u53d6\u53c2\u4e0e\u8005\u7ed3\u675f");
            LOGGER.info("\u83b7\u53d6\u53c2\u4e0e\u8005\u8017\u65f6\uff1a" + (end - start) + "s");
            System.out.println("\u83b7\u53d6\u53c2\u4e0e\u8005\u8017\u65f6\uff1a" + (end - start) + "s");
            return JSONArray.parseArray((String)result, String.class);
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }
}

