/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.exception;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.impl.DefinitionEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.bsp.datapush.WeChatDataPush;
import com.jxdinfo.hussar.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.exception.TenantLackInfoException;
import com.jxdinfo.hussar.bsp.exception.TenantLockException;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.el.PropertyNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0x7FFFFFFD)
public class BpmExceptionHander {
    private static WeChatDataPush weChatDataPush;
    private static ISysUserService sysUserService;
    private static ITenantConfigService tenantConfigService;
    private static BpmConstantProperties bpmConstantProperties;
    private static Logger LOGGER;

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(HttpServletRequest a, PublicClientException a2) {
        Object object;
        Object object2;
        Serializable serializable = a2.getStackTrace()[0];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(a2.getReason());
        stringBuilder.append(HttpRequestUtil.implements("\u5f7a\u5e76\u7c03\u5443\uff62")).append(((StackTraceElement)serializable).getClassName());
        stringBuilder.append(TenantLackInfoException.while("\u5f3b\u5e1f\u6580\u6cf2\u5434\uff3d")).append(((StackTraceElement)serializable).getMethodName());
        stringBuilder.append(HttpRequestUtil.implements("C\u5f4c\u5e40\u65c9\u4e8e\u5443\uff62")).append(((StackTraceElement)serializable).getFileName());
        stringBuilder.append(TenantLackInfoException.while("\u5f25\u5e01\u886b\u6549\uff3d")).append(((StackTraceElement)serializable).getLineNumber());
        stringBuilder.append(HttpRequestUtil.implements("\u8b8f\u6c0c\u8d97\u5fca\uff62")).append(a.getRequestURL()).append(TenantLackInfoException.while("\u001c"));
        serializable = new HashMap(a.getParameterMap());
        serializable.remove(HttpRequestUtil.implements(":\u001d \u0019 \f\r\u0011>\u0010+\n"));
        HashMap<String, String> hashMap = serializable.entrySet().iterator();
        while (hashMap.hasNext()) {
            object2 = hashMap.next();
            object = (String[])object2.getValue();
            if (((String[])object).length == 0) {
                serializable.put(object2.getKey(), null);
                continue;
            }
            if (((String[])object).length != 1) continue;
            serializable.put(object2.getKey(), object[0]);
        }
        if (ToolUtil.isNotEmpty((Object)serializable)) {
            stringBuilder.append(TenantLackInfoException.while("\u8bd0\u6c7b\u53e5\u6549\uff3d")).append(JSONObject.toJSONString((Object)serializable)).append(HttpRequestUtil.implements("C"));
        }
        if (a2.getIsSaveLogger().booleanValue()) {
            hashMap = new HashMap<String, String>();
            hashMap.put("userId", HttpKit.getIp());
            hashMap.put("userAccount", HttpKit.getIp());
            hashMap.put(TenantLackInfoException.while("PW"), HttpKit.getIp());
            hashMap.put(HttpRequestUtil.implements(">\u0017<\f"), HttpKit.getPort());
            hashMap.put(TenantLackInfoException.while("QHJS"), HttpKit.getHost());
            hashMap.put(HttpRequestUtil.implements("\u0014!\u001b/\u0014\u0007\b"), HttpKit.getLocalIp());
            hashMap.put(TenantLackInfoException.while("KVDXKiHKS"), HttpKit.getLocalPort());
            hashMap.put(HttpRequestUtil.implements("\u0014!\u001b/\u0014\u0006\u0017=\f"), HttpKit.getLocalHost());
            hashMap.put(TenantLackInfoException.while("T\\TJNVIpC"), HttpKit.getSeesionId());
            hashMap.put("tenantId", a.getParameter("tenantId"));
            hashMap.put(HttpRequestUtil.implements(":\u001d \u0019 \f\r\u0011>\u0010+\n"), a.getParameter(TenantLackInfoException.while("MBWFWSzNIO\\U")));
            InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.exceptionLog(hashMap, stringBuilder.toString()));
            LOGGER.error(stringBuilder.toString());
            a2.printStackTrace();
        }
        if ((object2 = tenantConfigService.getTenantConfig((String)((Object)(hashMap = a.getParameter("tenantId"))))) != null && "1".equals(((TenantConfig)((Object)object2)).getIsDataPush())) {
            object = sysUserService.getUserByTenantId((String)((Object)hashMap));
            a = new StringBuilder().insert(0, HttpRequestUtil.implements("\u8d5e\u53b9\uff62")).append(((SysUser)object).getUserAccount()).append(TenantLackInfoException.while("\uff35\u8d01\u53ce\u542a\u79c9\uff3d")).append(((SysUser)object).getUserName()).append(HttpRequestUtil.implements("\uff42\u4ef6")).append(new SimpleDateFormat(TenantLackInfoException.while("^@^@\ntj\u0014C]\u0007qo\u0003JT\u001dJT")).format(new Date())).append(HttpRequestUtil.implements("\u63dd\u53ad\u8c7b\u7566\u5f7a\u5e76T\u65ab\u5faf\u4e74\uff62")).append((CharSequence)stringBuilder);
            weChatDataPush.dataPush((TenantConfig)((Object)object2), ((StringBuilder)a).toString());
        }
        return InstallResult.getResult("0", a2.getReason(), a2.getResult());
    }

    @ExceptionHandler(value={TenantLockException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLockException a) {
        return ApiResponse.fail(BpmEnum.USER_HAS_BEEN_DISABLED.getCode(), BpmEnum.USER_HAS_BEEN_DISABLED.getMessage());
    }

    static {
        LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
        bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
        weChatDataPush = (WeChatDataPush)SpringContextHolder.getBean(WeChatDataPush.class);
        sysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);
        tenantConfigService = (ITenantConfigService)SpringContextHolder.getBean(ITenantConfigService.class);
    }

    @ExceptionHandler(value={PropertyNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(PropertyNotFoundException a) {
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getPropertyNotFound(), null);
    }

    @ExceptionHandler(value={TenantException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantException a) {
        return ApiResponse.fail(BpmEnum.ERROR_TENANT_INFORMATION.getCode(), BpmEnum.ERROR_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(TenantLackInfoException.while("dXIWHM\u0007JBM\u0007JRJW\\IJNVI\u0019TMFMB\u0019\u0000JRJW\\I]B]\u0000\u0019AVU\u0019wKHZBJT}B_NWNMNVI|IMNM^"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(HttpRequestUtil.implements("\r\u0019 \u0016!\fn\u000b+\fn\u000b;\u000b>\u001d \u000b'\u0017 X=\f/\f+Xi\u0019-\f'\u000e+_n\u001e!\nn(<\u0017-\u001d=\u000b\n\u001d(\u0011 \u0011:\u0011!\u0016\u000b\u0016:\u0011:\u0001"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(TenantLackInfoException.while("dXIWHM\u0007JBM\u0007JRJW\\IJNVI\u0019TMFMB\u0019\u0000JRJW\\I]B]\u0000\u0019AVU\u0019wKHZBJTpIJSXIZB"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(HttpRequestUtil.implements("\r\u0019 \u0016!\fn\u000b+\fn\u000b;\u000b>\u001d \u000b'\u0017 X=\f/\f+Xi\u0019-\f'\u000e+_n\u001e!\nn(<\u0017-\u001d=\u000b\u0007\u0016=\f/\u0016-\u001d"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(TenantLackInfoException.while("iUVD\\TJ\u0007PIJSXIZB\u0019NJ\u0007JSPKU\u0007KRWIPI^\u000b\u0019DXIWHM\u0007]BUBMB\u0019OPTMHKNZ\u0007IUVD\\TJ\u0007PIJSXIZB"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessInstanceIsNotEnd(), null);
        }
        if (HttpRequestUtil.implements(";/\u0016 \u0017:X-\u0014/\u0011#X/X=\r=\b+\u0016*\u001d*X:\u0019=\u0013").equals(a.getMessage())) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskIsSuspended(), null);
        }
        if (a.getMessage().startsWith(TenantLackInfoException.while("wH\u0019HLS^HPI^\u0007JBHR\\IZB\u0019AUHN\u0007VA"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getNoOutgoingSequence(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExceptionHandler(value={GodAxeRequestException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(GodAxeRequestException a) {
        LOGGER.error(bpmConstantProperties.getHttpRequestError());
        switch (a.getRequestErrorType()) {
            case 0: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorProjectAddress(), null);
            }
            case 1: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorGodaxeVisitor(), null);
            }
        }
        return InstallResult.getResult("0", bpmConstantProperties.getErrorViewRequest(), null);
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiIllegalArgumentException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().contains(HttpRequestUtil.implements("X \r\"\u0014"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiTaskAlreadyClaimedException a) {
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getTaskAlreadyClaimed(), null);
    }

    public BpmExceptionHander() {
        BpmExceptionHander a;
    }

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiObjectNotFoundException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(HttpRequestUtil.implements(";/\u0016 \u0017:X(\u0011 \u001cn\f/\u000b%X9\u0011:\u0010n\u0011*X"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskNotFound(), null);
        }
        if (a.getMessage().startsWith(TenantLackInfoException.while("zFWIVS\u0019API]\u0007IUVD\\TJ\u0007]B_NWNMNVI\u0019AVU\u0019N]\u0007")) || a.getMessage().startsWith(HttpRequestUtil.implements(" \u0017n\u001c+\b\"\u00177\u001d*X>\n!\u001b+\u000b=X*\u001d(\u0011 \u0011:\u0011!\u0016n\u001e!\r \u001cn\u000f'\f&X'\u001c"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getModelNotFound(), null);
        }
        if (a.getMessage().startsWith(TenantLackInfoException.while("zFWIVS\u0019API]\u0007IUVD\\TJnWTMFWD\\\u0007_HK\u0007PC")) || a.getMessage().startsWith(HttpRequestUtil.implements("\u0000\u0017n\b<\u0017-\u001d=\u000bn\u0011 \u000b:\u0019 \u001b+X(\u0017;\u0016*X(\u0017<X'\u001c")) || a.getMessage().startsWith(TenantLackInfoException.while("wH\u0019OPTMHKNZ\u0007IUVD\\TJ\u0007PIJSXIZB\u0019AVRWC\u0019PPSQ\u0007PC"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessNotFound(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    @ExceptionHandler(value={TenantLackInfoException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLackInfoException a) {
        return ApiResponse.fail(BpmEnum.INCOMPLETE_TENANT_INFORMATION.getCode(), BpmEnum.INCOMPLETE_TENANT_INFORMATION.getMessage());
    }
}

