/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.tenant.service.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bsp.tenant.dao.SysUserMapper;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.mutidatasource.DynamicDataSource;
import com.jxdinfo.hussar.core.mutidatasource.util.ChangeDatasource;
import com.jxdinfo.hussar.core.util.HussarBpmSM4Util;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Service;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    @Autowired
    ChangeDatasource changeDatasource;
    @Resource
    private SysUserMapper sysUserMapper;

    @Override
    public boolean getMysqlUser(String userAccount, String dbType) {
        boolean flag = false;
        if (this.sysUserMapper.getMysqlUser(userAccount, dbType).size() != 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean getOracleUser(String userAccount, String dbType) {
        boolean flag = false;
        if (this.sysUserMapper.getOracleUser(userAccount, dbType) != null) {
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean validationTenantIsExist(String tenantId, String tenantCipher) {
        boolean flag = false;
        if (this.sysUserMapper.getTenantByIdAndCipher(tenantId, tenantCipher) != null) {
            flag = true;
        }
        return flag;
    }

    @Override
    public Integer deleteTenantList(List<JSONObject> tenantList) {
        return this.sysUserMapper.deleteTenantList(tenantList);
    }

    @Override
    public SysUser user(String account) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"USER_ACCOUNT", (Object)account);
        return (SysUser)super.getOne((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> queryTenantList(String userName, Integer page, Integer limit) {
        HashMap<String, Object> tenantListMap = new HashMap<String, Object>(5);
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        List<SysUser> list = this.sysUserMapper.getTenantList((Page<SysUser>)pages, userName);
        for (SysUser s : list) {
            s.setDbName(HussarBpmSM4Util.encrypt(HussarBpmSM4Util.decrypt(s.getDbName(), "admin#$%^kopoiuy"), "frontkey"));
            s.setConnectionIp(HussarBpmSM4Util.encrypt(HussarBpmSM4Util.decrypt(s.getConnectionIp(), "admin#$%^kopoiuy"), "frontkey"));
            s.setConnectionPort(HussarBpmSM4Util.encrypt(HussarBpmSM4Util.decrypt(s.getConnectionPort(), "admin#$%^kopoiuy"), "frontkey"));
            s.setConnectionName(HussarBpmSM4Util.encrypt(HussarBpmSM4Util.decrypt(s.getConnectionName(), "admin#$%^kopoiuy"), "frontkey"));
            s.setConnectionPass(HussarBpmSM4Util.encrypt(HussarBpmSM4Util.decrypt(s.getConnectionPass(), "admin#$%^kopoiuy"), "frontkey"));
        }
        tenantListMap.put("count", pages.getTotal());
        tenantListMap.put("data", list);
        tenantListMap.put("code", 0);
        return tenantListMap;
    }

    @Override
    public SysUser getUserByTenantId(String tenantId) {
        ChangeDatasource changeDatasource = new ChangeDatasource();
        changeDatasource.change();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TENANT_ID", (Object)tenantId);
        return (SysUser)super.getOne((Wrapper)queryWrapper);
    }

    @Override
    public SysUser queryTenantByTenantId(String tenantId, String tenantCipher) {
        ChangeDatasource changeDatasource = new ChangeDatasource();
        changeDatasource.change();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"TENANT_ID", (Object)tenantId)).eq((Object)"TENANT_CIPHER", (Object)tenantCipher);
        return (SysUser)super.getOne((Wrapper)queryWrapper);
    }

    @Override
    public ApiResponse<?> createDatabase(String userAccount, String connectionName, String connectionPass, boolean userExist, String url) {
        block17: {
            StringBuilder sb = new StringBuilder();
            if ("mysql".equals(url.split(":")[1])) {
                if (this.sysUserMapper.getDatabase(userAccount) != null) {
                    return ApiResponse.fail(BpmEnum.ERROR_EXIST_DATABASE.getCode(), BpmEnum.ERROR_EXIST_DATABASE.getMessage());
                }
                if (userExist) {
                    sb.append("CREATE DATABASE IF NOT EXISTS ").append(userAccount).append(" default charset utf8 COLLATE utf8_general_ci;");
                    sb.append("GRANT SELECT,INSERT,UPDATE,DELETE,CREATE,DROP,REFERENCES,ALTER ON `").append(userAccount).append("`.* TO '").append(connectionName).append("'@'%';");
                } else {
                    sb.append("CREATE USER  '").append(connectionName).append("'@'%' IDENTIFIED BY  '").append(connectionPass).append("';");
                    sb.append("CREATE DATABASE IF NOT EXISTS ").append(userAccount).append(" default charset utf8 COLLATE utf8_general_ci;");
                    sb.append("GRANT SELECT,INSERT,UPDATE,DELETE,CREATE,DROP,REFERENCES,ALTER ON `").append(userAccount).append("`.* TO '").append(connectionName).append("'@'%';");
                }
                sb.append("flush privileges;");
            } else if ("oracle".equals(url.split(":")[1]) || "dm".equals(url.split(":")[1])) {
                if (userExist) {
                    return null;
                }
                if ("dm".equals(url.split(":")[1]) && this.sysUserMapper.getDmSchema(connectionName.toUpperCase()) != null) {
                    return ApiResponse.fail(BpmEnum.ERROR_EXIST_SCHEMA.getCode(), BpmEnum.ERROR_EXIST_SCHEMA.getMessage());
                }
                sb.append("begin execute immediate 'CREATE USER ").append(connectionName).append(" IDENTIFIED BY ").append(connectionPass).append("';");
                if ("dm".equals(url.split(":")[1])) {
                    sb.append("execute immediate 'GRANT DBA TO ").append(connectionName).append("';end;");
                } else {
                    sb.append("execute immediate 'GRANT CONNECT,RESOURCE TO ").append(connectionName).append("';end;");
                }
            } else if ("oscar".equals(url.split(":")[1])) {
                if (userExist) {
                    return ApiResponse.fail(BpmEnum.ERROR_EXIST_DATABASE_USER.getCode(), BpmEnum.ERROR_EXIST_DATABASE_USER.getMessage());
                }
                if (this.sysUserMapper.getOscarSchema(connectionName.toUpperCase()) != null) {
                    return ApiResponse.fail(BpmEnum.ERROR_EXIST_SCHEMA.getCode(), BpmEnum.ERROR_EXIST_SCHEMA.getMessage());
                }
                sb.append("SET MIN_PASSWORD_LEN = 0 ; CREATE USER ").append(connectionName).append(" WITH  DEFAULT TABLESPACE SYSTEM PASSWORD '").append(connectionPass).append("';");
            } else {
                return null;
            }
            try {
                this.sysUserMapper.createDatabase(sb.toString());
            }
            catch (UncategorizedSQLException u) {
                if (u.getMessage() == null || !u.getMessage().contains("Your password does not satisfy the current policy requirements")) break block17;
                return ApiResponse.fail(BpmEnum.INCONFORMITY_TO_DATABASE_PASSWORD_POLICY.getCode(), BpmEnum.INCONFORMITY_TO_DATABASE_PASSWORD_POLICY.getMessage());
            }
        }
        return null;
    }

    @Override
    public String removeDatabase(String userAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"USER_ACCOUNT", (Object)userAccount);
        SysUser sysUser = (SysUser)this.sysUserMapper.selectOne((Wrapper)queryWrapper);
        String connectionName = HussarBpmSM4Util.decrypt(sysUser.getConnectionName(), "admin#$%^kopoiuy");
        String dbName = HussarBpmSM4Util.decrypt(sysUser.getDbName(), "admin#$%^kopoiuy");
        String dbType = sysUser.getDbType();
        if ("Mysql".equals(dbType)) {
            this.sysUserMapper.removeDatabaseMysql(dbName, connectionName);
        } else if ("Oracle".equals(dbType)) {
            List<Map<String, String>> list = this.sysUserMapper.getUserAccountConn(connectionName.toUpperCase());
            this.sysUserMapper.removeDatabaseOracle(list, connectionName);
        } else if ("Dm".equals(dbType)) {
            this.sysUserMapper.removeDatabaseDm(connectionName);
        } else if ("Oscar".equals(dbType)) {
            List<Map<String, String>> list = this.sysUserMapper.getUserAccountConn(connectionName.toUpperCase());
            if (list.size() != 0) {
                this.sysUserMapper.killSessionOscar(list);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
            this.sysUserMapper.removeDatabaseOscar(connectionName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void getModel(InputStream in, HttpServletResponse response) {
        OutputStream out = null;
        try {
            response.addHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5168\u91cf\u540c\u6b65\u8868\u683c\u6a21\u677f", "utf-8"));
            out = response.getOutputStream();
            byte[] b = new byte[4096];
            int size = in.read(b);
            while (size > 0) {
                out.write(b, 0, size);
                size = in.read(b);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public boolean updateDbMessage(boolean state, SysUser sysUser) {
        SysUser oldSysUser = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)sysUser.getUserId()));
        String tenantId = oldSysUser.getTenantId();
        this.changeDatasource.changeSavedDateBase(tenantId, sysUser);
        if (this.testConn(tenantId)) {
            if (state) {
                this.removeDatabase(oldSysUser.getUserAccount());
            }
            this.sysUserMapper.updateById(sysUser);
            return true;
        }
        this.changeDatasource.changeSavedDateBase(tenantId, oldSysUser);
        return false;
    }

    @Override
    public boolean testConn(String tenantId) {
        Connection conn = null;
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)SpringContextHolder.getBean(DynamicDataSource.class));
        DruidDataSource dataSource = (DruidDataSource)dynamicDataSource.getDynamicTargetDataSources().get(tenantId);
        String url = dataSource.getUrl();
        String driverClass = dataSource.getDriverClassName();
        String connectionName = dataSource.getUsername();
        String connectionPass = dataSource.getPassword();
        try {
            Class.forName(driverClass);
            conn = DriverManager.getConnection(url, connectionName, connectionPass);
            conn.setAutoCommit(false);
            conn.close();
        }
        catch (ClassNotFoundException | SQLException e) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            return false;
        }
        return true;
    }
}

