/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.taskmanager.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.assignee.service.impl.AssigneeChooseServiceImpl;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.bsp.taskmanager.dao.TaskManagerMapper;
import com.jxdinfo.hussar.bsp.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TaskManagerServiceImpl
implements TaskManagerService {
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private TaskManagerMapper taskManagerMapper;
    @Resource
    private AssigneeChooseServiceImpl assigneeChooseService;
    @Resource
    SysActProcessFileMapper sysActProcessFileMapper;
    @Value(value="${spring.datasource.url:}")
    private String url;

    @Override
    public int count() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateTime = dateFormat.format(new Date());
        return this.taskManagerMapper.count(dateTime, this.url.split(":")[1]);
    }

    @Override
    public List<TaskManager> getTask(Page<TaskManager> pages, Map<String, Object> map) {
        String dbType = this.url.split(":")[1];
        map.put("dbType", dbType);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateTime = dateFormat.format(new Date());
        if (ToolUtil.isNotEmpty((Object)map.get("processDefinitionKey"))) {
            List<String> processDefinitionKeies = Arrays.asList(((String)map.get("processDefinitionKey")).split(","));
            map.put("processDefinitionKey", processDefinitionKeies);
        }
        List<TaskManager> list = this.taskManagerMapper.getTask(pages, map, dateTime);
        ArrayList<String> users = new ArrayList<String>();
        for (TaskManager taskManager : list) {
            ArrayList<Object> receiver = new ArrayList<String>();
            if (ToolUtil.isNotEmpty(taskManager.getReceivers())) {
                receiver = new ArrayList<String>(new HashSet<String>(taskManager.getReceivers()));
            }
            if (ToolUtil.isNotEmpty((Object)taskManager.getFirstReceiver())) {
                receiver.add(0, taskManager.getFirstReceiver());
            }
            if (ToolUtil.isNotEmpty((Object)taskManager.getSendUser())) {
                receiver.add(0, taskManager.getSendUser());
            }
            users.addAll(receiver);
        }
        HashSet userSet = new HashSet(users);
        userSet.remove(null);
        users.clear();
        users.addAll(userSet);
        Map<String, String> userMap = this.assigneeChooseService.getUserListByUserId(users, String.valueOf(map.get("tenantId")));
        if (userMap == null) {
            userMap = new HashMap<String, String>();
        }
        for (TaskManager taskManager : list) {
            ArrayList<String> receiver = new ArrayList<String>();
            if (taskManager.getReceivers() != null) {
                receiver = new ArrayList<String>(new HashSet<String>(taskManager.getReceivers()));
            }
            if (taskManager.getFirstReceiver() != null) {
                receiver.add(0, taskManager.getFirstReceiver());
            }
            if (receiver.size() > 0) {
                taskManager.setFirstReceiver((String)receiver.get(0));
            }
            taskManager.setReceivers(receiver);
            ArrayList<String> name = new ArrayList<String>();
            for (String id : receiver) {
                name.add(userMap.get(id));
            }
            taskManager.setReceiverName(name);
            taskManager.setSendUserName(userMap.get(taskManager.getSendUser()));
        }
        return list;
    }

    @Override
    public ApiResponse<Map<String, Object>> suspendTaskById(String processInstanceId) {
        try {
            this.runtimeService.suspendProcessInstanceById(processInstanceId);
            return ApiResponse.success(BpmEnum.HANGUP_SUCCESS.getCode(), BpmEnum.HANGUP_SUCCESS.getMessage());
        }
        catch (Exception e) {
            return ApiResponse.fail(BpmEnum.HANGUP_FAIL.getCode(), BpmEnum.HANGUP_FAIL.getMessage());
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> activateTaskById(String processInstanceId) {
        try {
            this.runtimeService.activateProcessInstanceById(processInstanceId);
            return ApiResponse.success(BpmEnum.ACTIVE_SUCCESS.getCode(), BpmEnum.ACTIVE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            return ApiResponse.fail(BpmEnum.ACTIVE_FAIL.getCode(), BpmEnum.ACTIVE_FAIL.getMessage());
        }
    }

    @Override
    public Map<String, String> getFileByTaskId(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.inSql((Object)"PROCESS_ID", "SELECT PROC_DEF_ID_ FROM ACT_RU_TASK WHERE ID_ = '" + taskId + "'");
        queryWrapper.eq((Object)"TYPE", (Object)"wfd");
        SysActProcessFile sysActProcessFile = (SysActProcessFile)((Object)this.sysActProcessFileMapper.selectOne((Wrapper)queryWrapper));
        String file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent());
        map.put("main", file);
        queryWrapper = new QueryWrapper();
        queryWrapper.inSql((Object)"PROCESS_ID", "SELECT A.PROC_DEF_ID_ FROM ACT_HI_PROCINST A LEFT JOIN ACT_HI_PROCINST B ON A.PROC_INST_ID_ = B.SUPER_PROCESS_INSTANCE_ID_ LEFT JOIN ACT_RU_TASK C ON B.PROC_INST_ID_ = C.PROC_INST_ID_ WHERE C.ID_ = '" + taskId + "'");
        queryWrapper.eq((Object)"TYPE", (Object)"wfd");
        sysActProcessFile = (SysActProcessFile)((Object)this.sysActProcessFileMapper.selectOne((Wrapper)queryWrapper));
        file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent());
        map.put("call", file);
        return map;
    }
}

