/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.exception;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.impl.DefinitionEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.exception.TenantLackInfoException;
import com.jxdinfo.hussar.bsp.exception.TenantLockException;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0x7FFFFFFD)
public class BpmExceptionHander {
    private static Logger LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    @ExceptionHandler(value={TenantException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantException e) {
        return ApiResponse.fail(BpmEnum.ERROR_TENANT_INFORMATION.getCode(), BpmEnum.ERROR_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={TenantLackInfoException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLackInfoException e) {
        return ApiResponse.fail(BpmEnum.INCOMPLETE_TENANT_INFORMATION.getCode(), BpmEnum.INCOMPLETE_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={TenantLockException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLockException e) {
        return ApiResponse.fail(BpmEnum.USER_HAS_BEEN_DISABLED.getCode(), BpmEnum.USER_HAS_BEEN_DISABLED.getMessage());
    }

    @ExceptionHandler(value={PropertyNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(PropertyNotFoundException e) {
        LOGGER.error(e.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getPropertyNotFound(), null);
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiIllegalArgumentException e) {
        LOGGER.error(e.getMessage());
        if (e.getMessage().contains(" null")) {
            return InstallResult.getResult("0", bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        return InstallResult.getResult("0", e.getMessage(), null);
    }

    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiTaskAlreadyClaimedException e) {
        LOGGER.error(e.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getTaskAlreadyClaimed(), null);
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiException e) {
        LOGGER.error(e.getMessage());
        if (e.getMessage().startsWith("Cannot set suspension state 'suspended' for ProcessDefinitionEntity")) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessDefinitionEntityError(), null);
        }
        if (e.getMessage().startsWith("Cannot set suspension state 'active' for ProcessDefinitionEntity")) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessDefinitionEntityError(), null);
        }
        if (e.getMessage().startsWith("Cannot set suspension state 'suspended' for ProcessInstance")) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessProcessInstanceError(), null);
        }
        if (e.getMessage().startsWith("Cannot set suspension state 'active' for ProcessInstance")) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessProcessInstanceError(), null);
        }
        if (e.getMessage().startsWith("Process instance is still running, cannot delete historic process instance")) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessInstanceIsNotEnd(), null);
        }
        if ("Cannot claim a suspended task".equals(e.getMessage())) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskIsSuspended(), null);
        }
        if (e.getMessage().startsWith("No outgoing sequence flow of")) {
            return InstallResult.getResult("0", bpmConstantProperties.getNoOutgoingSequence(), null);
        }
        return InstallResult.getResult("0", e.getMessage(), null);
    }

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiObjectNotFoundException e) {
        LOGGER.error(e.getMessage());
        if (e.getMessage().startsWith("Cannot find task with id ")) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskNotFound(), null);
        }
        if (e.getMessage().startsWith("Cannot find process definition for id ") || e.getMessage().startsWith("no deployed process definition found with id")) {
            return InstallResult.getResult("0", bpmConstantProperties.getModelNotFound(), null);
        }
        if (e.getMessage().startsWith("Cannot find processInstance for id") || e.getMessage().startsWith("No process instance found for id") || e.getMessage().startsWith("No historic process instance found with id")) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessNotFound(), null);
        }
        return InstallResult.getResult("0", e.getMessage(), null);
    }

    @ExceptionHandler(value={GodAxeRequestException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(GodAxeRequestException e) {
        LOGGER.error(bpmConstantProperties.getHttpRequestError());
        switch (e.getRequestErrorType()) {
            case 0: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorProjectAddress(), null);
            }
            case 1: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorGodaxeVisitor(), null);
            }
            case 2: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorViewRequest(), null);
            }
        }
        return InstallResult.getResult("0", bpmConstantProperties.getErrorRequest(), null);
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(HttpServletRequest req, PublicClientException e) {
        if (e.getIsSaveLogger().booleanValue()) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            StringBuilder sb = new StringBuilder();
            sb.append(e.getReason());
            sb.append("\u5f02\u5e38\u7c7b\u540d\uff1a").append(stackTraceElement.getClassName());
            sb.append("\u5f02\u5e38\u65b9\u6cd5\u540d\uff1a").append(stackTraceElement.getMethodName());
            sb.append(";\u5f02\u5e38\u6587\u4ef6\u540d\uff1a").append(stackTraceElement.getFileName());
            sb.append("\u5f02\u5e38\u884c\u6570\uff1a").append(stackTraceElement.getLineNumber());
            sb.append("\u8bf7\u6c42\u8def\u5f84\uff1a").append(req.getRequestURL()).append(";");
            HashMap map = new HashMap(req.getParameterMap());
            map.remove("tenantCipher");
            for (Map.Entry k : map.entrySet()) {
                String[] message = (String[])k.getValue();
                if (message.length == 0) {
                    map.put(k.getKey(), null);
                    continue;
                }
                if (message.length != 1) continue;
                map.put(k.getKey(), message[0]);
            }
            if (ToolUtil.isNotEmpty(map)) {
                sb.append("\u8bf7\u6c42\u53c2\u6570\uff1a").append(JSONObject.toJSONString(map)).append(";");
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("userId", HttpKit.getIp());
            info.put("userAccount", HttpKit.getIp());
            info.put("ip", HttpKit.getIp());
            info.put("port", HttpKit.getPort());
            info.put("host", HttpKit.getHost());
            info.put("localIp", HttpKit.getLocalIp());
            info.put("localPort", HttpKit.getLocalPort());
            info.put("localHost", HttpKit.getLocalHost());
            info.put("sessionId", HttpKit.getSeesionId());
            info.put("tenantId", req.getParameter("tenantId"));
            info.put("tenantCipher", req.getParameter("tenantCipher"));
            InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.exceptionLog(info, sb.toString()));
            LOGGER.error(sb.toString());
            e.printStackTrace();
        }
        return InstallResult.getResult("0", e.getReason(), e.getResult());
    }
}

