/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.urgetask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActUrgeTaskServiceImpl
extends ServiceImpl<SysActUrgeTaskMapper, SysActUrgeTask>
implements ISysActUrgeTaskService {
    @Resource
    SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Resource
    IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    RuntimeService runtimeService;
    @Autowired
    TaskService taskService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    @Override
    public List<SysActUrgeTask> query(Page<SysActUrgeTask> pages, String userId, String processDefinitionKey, String sendUser, String startTime, String endTime, String tenantId) {
        List<SysActUrgeTask> sysActUrgeTasks = this.sysActUrgeTaskMapper.query(pages, userId, processDefinitionKey, sendUser, startTime, endTime);
        if (sysActUrgeTasks != null && sysActUrgeTasks.size() > 0) {
            List<String> users = sysActUrgeTasks.stream().map(SysActUrgeTask::getSendUser).collect(Collectors.toList());
            Map<String, String> map = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
            for (SysActUrgeTask sysActUrgeTask : sysActUrgeTasks) {
                String userName = map.get(sysActUrgeTask.getSendUser());
                sysActUrgeTask.setSendUserName(userName);
                String formKey = sysActUrgeTask.getFormKey();
                if (!ToolUtil.isNotEmpty((Object)formKey)) continue;
                JSONObject object = JSON.parseObject((String)formKey);
                sysActUrgeTask.setWeb(object.getString("web"));
                sysActUrgeTask.setMobile(object.getString("mobile"));
            }
        }
        return sysActUrgeTasks;
    }

    @Override
    public String urgeTask(String processInstId, String userId) {
        if (ToolUtil.isEmpty((Object)processInstId)) {
            return this.bpmConstantProperties.getProcessInstIdNull();
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstId).singleResult();
        if (processInstance == null) {
            return this.bpmConstantProperties.getProcessEndUrgeFail();
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).processInstanceId(processInstId)).list();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        for (Task task : tasks) {
            Set<String> users = this.getAssigneeByTaskId(task.getId());
            if (users.size() <= 0) continue;
            for (String user : users) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setId(IdWorker.get32UUID());
                sysActUrgeTask.setTaskId(task.getId());
                sysActUrgeTask.setProcInstId(task.getProcessInstanceId());
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(user);
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                Map map = task.getTaskLocalVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (list.size() > 0) {
            this.saveBatch(list);
        }
        return this.bpmConstantProperties.getUrgeSuccess();
    }

    @Override
    public String urgeTaskByTaskId(String taskId) {
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskId(taskId)).singleResult();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        Set<String> users = this.getAssigneeByTaskId(task.getId());
        if (users.size() > 0) {
            for (String user : users) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setId(IdWorker.get32UUID());
                sysActUrgeTask.setTaskId(task.getId());
                sysActUrgeTask.setProcInstId(task.getProcessInstanceId());
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(null);
                sysActUrgeTask.setReceiveUser(user);
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                Map map = task.getTaskLocalVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (list.size() > 0) {
            this.saveBatch(list);
        }
        return this.bpmConstantProperties.getUrgeSuccess();
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }
}

