/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.timeouthandle.service.impl;

import com.jxdinfo.hussar.bpm.listener.ActivityCompletedListener;
import com.jxdinfo.hussar.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bpm.timeouthandle.util.HussarEhcacheManager;
import com.jxdinfo.hussar.bpm.timeouthandle.util.TimeOutHandleUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.crazycake.shiro.RedisManager;
import org.springframework.amqp.utils.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class ActivityRedisTimerServiceImpl
implements ActivityRedisTimerService {
    private static Logger logger = LogManager.getLogger(ActivityCompletedListener.class);
    @Autowired
    private HussarEhcacheManager hussarEhcacheManager;
    @Autowired
    private ActivityRedisTimerMapper activityRedisTimerMapper;
    private static RedisManager redisManager;

    private Jedis getJedits() {
        if (redisManager == null) {
            redisManager = new RedisManager();
        }
        if (redisManager.getJedisPool() == null) {
            redisManager.setJedisPool(new JedisPool());
        }
        return redisManager.getJedisPool().getResource();
    }

    @Override
    public void addTimeOutModel(TimeOutModel timeOutModel) {
        if (TimeOutHandleUtil.isUseRedis) {
            try (Jedis jedits = this.getJedits();){
                jedits.set(("bpm_activity:timer:task_Message:" + timeOutModel.getTaskId()).getBytes(), SerializationUtils.serialize((Object)((Object)timeOutModel)));
                Set oldTask = jedits.zrangeByScore("bpm_activity:timer:score_list", (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                if (ToolUtil.isEmpty((Object)oldTask)) {
                    jedits.zadd("bpm_activity:timer:score_list", (double)timeOutModel.getDueTime().getTime(), timeOutModel.getTaskId());
                } else {
                    jedits.zadd("bpm_activity:timer:score_list", (double)timeOutModel.getDueTime().getTime(), (String)new ArrayList(oldTask).get(0) + "," + timeOutModel.getTaskId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u5b58\u50a8\u4efb\u52a1\u8d85\u65f6\u65b9\u6848\u4fe1\u606f\u5931\u8d25[taskId:" + timeOutModel.getTaskId() + "]-->" + e.toString());
            }
            return;
        }
        this.activityRedisTimerMapper.insert((Object)timeOutModel);
        this.hussarEhcacheManager.setObject("bpm_timer_activity", timeOutModel.getTaskId(), (Object)timeOutModel);
        Long time = timeOutModel.getDueTime().getTime();
        if (TimeOutHandleUtil.isGetList) {
            TimeOutHandleUtil.getListTimeAddModel.add(time);
        } else {
            int index = TimeOutHandleUtil.timeOutList.size();
            for (int i = 0; i < TimeOutHandleUtil.timeOutList.size() && TimeOutHandleUtil.timeOutList.get(i) < time; ++i) {
                index = i + 1;
            }
            TimeOutHandleUtil.timeOutList.add(index, time);
        }
        TimeOutHandleUtil.timeOutMap.put(time, TimeOutHandleUtil.timeOutMap.get(time) == null ? timeOutModel.getTaskId() : TimeOutHandleUtil.timeOutMap.get(time) + "," + timeOutModel.getTaskId());
    }

    @Override
    public void delTimeOutModel(String taskId) {
        if (TimeOutHandleUtil.isUseRedis) {
            try (Jedis jedits = this.getJedits();){
                if (taskId.contains(",")) {
                    String[] list = taskId.split(",");
                    for (int i = 0; i < list.length; ++i) {
                        list[i] = "bpm_activity:timer:task_Message:" + list[i];
                    }
                    jedits.del(list);
                } else {
                    jedits.del("bpm_activity:timer:task_Message:" + taskId);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u5220\u9664\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25[key:bpm_activity:timer:task_Message:" + taskId + "]-->" + e.toString());
            }
            return;
        }
        List<String> taskIds = Arrays.asList(taskId.split(","));
        this.activityRedisTimerMapper.deleteBatchIds(taskIds);
        this.hussarEhcacheManager.delcache("bpm_timer_activity", taskIds);
        if (TimeOutHandleUtil.isGetList) {
            TimeOutHandleUtil.getListTimeDelModel.addAll(taskIds);
        }
    }

    @Override
    public void updateTimeOutModel(String taskId, String assignee, String userId, int type) {
        if (TimeOutHandleUtil.isUseRedis) {
            try (Jedis jedits = this.getJedits();){
                byte[] model = jedits.get(("bpm_activity:timer:task_Message:" + taskId).getBytes());
                if (ToolUtil.isNotEmpty((Object)model)) {
                    jedits.set(("bpm_activity:timer:task_Message:" + taskId).getBytes(), SerializationUtils.serialize((Object)((Object)this.getTimeOutAssignee((TimeOutModel)((Object)SerializationUtils.deserialize((byte[])model)), assignee, userId, type))));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u66f4\u65b0\u4efb\u52a1\u8d85\u65f6\u65b9\u6848\u4fe1\u606f\u53c2\u4e0e\u8005\u5931\u8d25[taskId:" + taskId + "]-->" + e.toString());
            }
            return;
        }
        TimeOutModel timeOutModel = (TimeOutModel)((Object)this.hussarEhcacheManager.getObject("bpm_timer_activity", taskId));
        if (timeOutModel != null) {
            this.activityRedisTimerMapper.updateById((Object)this.getTimeOutAssignee(timeOutModel, assignee, userId, type));
            this.hussarEhcacheManager.setObject("bpm_timer_activity", taskId, (Object)timeOutModel);
        }
    }

    private TimeOutModel getTimeOutAssignee(TimeOutModel timeOutModel, String assignee, String userId, int type) {
        String users;
        String string = users = timeOutModel.getAssignee() == null ? "" : timeOutModel.getAssignee();
        if (type == 0) {
            ArrayList<String> userList = new ArrayList<String>(Arrays.asList(users.split(",")));
            if (userId != null) {
                userList.remove(userId);
            }
            if (assignee != null) {
                userList = new ArrayList<String>(userList);
                userList.addAll(new ArrayList<String>(Arrays.asList(assignee.split(","))));
            }
            userList = new ArrayList<String>(new HashSet<String>(userList));
            timeOutModel.setAssignee(String.join((CharSequence)",", userList));
        } else {
            timeOutModel.setAssignee(assignee);
        }
        return timeOutModel;
    }
}

