/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processinst.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProcessInstServiceImpl
implements ProcessInstService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessInstMapper processInstMapper;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Value(value="${spring.datasource.url:}")
    private String url;

    @Override
    public Map<String, Object> getProcessList(Map<String, Object> map) {
        map.put("dbType", this.url.split(":")[1]);
        Page pages = new Page((long)Integer.parseInt((String)map.get("page")), (long)Integer.parseInt((String)map.get("limit")));
        if (map.get("dbType") != "oracle" && ToolUtil.isNotEmpty((Object)map.get("startTime"))) {
            map.put("startTime", map.get("startTime") + ".000");
        }
        if (map.get("dbType") != "oracle" && ToolUtil.isNotEmpty((Object)map.get("startTimeEnd"))) {
            map.put("startTimeEnd", map.get("startTimeEnd") + ".999");
        }
        List<ProcessInst> instList = this.processInstMapper.getListMySql((Page<ProcessInst>)pages, map);
        for (ProcessInst processInst : instList) {
            List<String> nodeNames = processInst.getNodeNames();
            if (nodeNames == null) continue;
            nodeNames.remove(null);
            if (nodeNames.size() <= 0) continue;
            processInst.setNames(String.join((CharSequence)",", nodeNames));
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("count", pages.getTotal());
        dataMap.put("data", instList);
        return dataMap;
    }

    @Override
    public ApiResponse<Map<String, Object>> suspendProcessInstanceById(String processInstCode) {
        try {
            this.runtimeService.suspendProcessInstanceById(processInstCode);
            return ApiResponse.success(BpmEnum.HANGUP_SUCCESS.getCode(), BpmEnum.HANGUP_SUCCESS.getMessage());
        }
        catch (Exception e) {
            return ApiResponse.fail(BpmEnum.HANGUP_FAIL.getCode(), BpmEnum.HANGUP_FAIL.getMessage());
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> activateProcessById(String processInstCode) {
        try {
            this.runtimeService.activateProcessInstanceById(processInstCode);
            return ApiResponse.success(BpmEnum.ACTIVE_SUCCESS.getCode(), BpmEnum.ACTIVE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            return ApiResponse.fail(BpmEnum.ACTIVE_FAIL.getCode(), BpmEnum.ACTIVE_FAIL.getMessage());
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> deleteProcessInstance(String processInstCode) {
        try {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstCode)).list();
            StringBuilder taskIds = new StringBuilder();
            for (Task task : tasks) {
                taskIds.append(",").append(task.getId());
            }
            if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
            }
            this.runtimeService.deleteProcessInstance(processInstCode, "");
            return ApiResponse.success(BpmEnum.DELETE_SUCCESS.getCode(), BpmEnum.DELETE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            return ApiResponse.fail(BpmEnum.DELETE_FAIL.getCode(), BpmEnum.DELETE_FAIL.getMessage());
        }
    }

    @Override
    public ApiResponse<?> deleteFinishedProcessInstance(String processInstCode) {
        try {
            this.historyService.deleteHistoricProcessInstance(processInstCode);
            QueryWrapper ccQueryWrapper = new QueryWrapper();
            ccQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstCode);
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            QueryWrapper urgeQueryWrapper = new QueryWrapper();
            urgeQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstCode);
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            return ApiResponse.success(BpmEnum.DELETE_SUCCESS.getCode(), BpmEnum.DELETE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            return ApiResponse.fail(BpmEnum.DELETE_FAIL.getCode(), BpmEnum.DELETE_FAIL.getMessage());
        }
    }
}

