/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processfile.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;

@Service
public class SysActProcessFileServiceImpl
extends ServiceImpl<SysActProcessFileMapper, SysActProcessFile>
implements SysActProcessFileService {
    @Resource
    SysActProcessFileMapper sysActProcessFileMapper;

    @Override
    @Transactional
    public void updateFile(WorkFlow workFlow, String tenantId) {
        List list = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROCESS_KEY", (Object)workFlow.getIdentity())).eq((Object)"TENANT_ID", (Object)tenantId)).eq((Object)"VERSION", (Object)0));
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            metaFile = sysActProcessFile;
        }
        wfdFile.setContent(workFlow.getData().getBytes());
        wfdFile.setModelId(workFlow.getModelId());
        this.sysActProcessFileMapper.updateById((Object)wfdFile);
        metaFile.setModelId(workFlow.getModelId());
        String data = workFlow.getData();
        workFlow.setData(null);
        metaFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes());
        this.sysActProcessFileMapper.updateById((Object)metaFile);
        workFlow.setData(data);
    }

    @Override
    @Transactional
    public void addFile(WorkFlow workFlow, String tenantId, Integer latestVersion) {
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        Integer realLatestVersion = latestVersion;
        if (ToolUtil.isEmpty((Object)latestVersion)) {
            realLatestVersion = this.sysActProcessFileMapper.selectLatestVersion(workFlow.getIdentity(), tenantId) + 1;
        }
        SysActProcessFile file = new SysActProcessFile();
        file.setFileId(null);
        file.setCreateTime(ts);
        file.setVersion(realLatestVersion);
        if (ToolUtil.isNotEmpty((Object)workFlow.getProcDefId()) && Integer.parseInt(workFlow.getProcDefId().split(":")[1]) < 1) {
            file.setVersion(-1);
        }
        file.setProcessKey(workFlow.getIdentity());
        file.setModelId(workFlow.getModelId());
        file.setProcessId(workFlow.getProcDefId());
        file.setTenantId(tenantId);
        file.setType("wfd");
        file.setContent(workFlow.getData().getBytes());
        this.sysActProcessFileMapper.insert((Object)file);
        file.setFileId(null);
        file.setType("meta");
        String data = workFlow.getData();
        workFlow.setData(null);
        file.setContent(JSONObject.toJSONString((Object)workFlow).getBytes());
        this.sysActProcessFileMapper.insert((Object)file);
        workFlow.setData(data);
    }

    @Override
    public WorkFlow getFileByProcessKey(String processKey, String tenantId, Integer version) {
        Integer lastVersion = version;
        if (ToolUtil.isEmpty((Object)version)) {
            lastVersion = this.sysActProcessFileMapper.selectLatestVersion(processKey, tenantId);
        }
        List list = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROCESS_KEY", (Object)processKey)).eq((Object)"TENANT_ID", (Object)tenantId)).eq((Object)"VERSION", (Object)lastVersion));
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            metaFile = sysActProcessFile;
        }
        String wfdInfo = null;
        if (ToolUtil.isNotEmpty((Object)((Object)wfdFile))) {
            wfdInfo = wfdFile.getContent() == null ? null : new String(wfdFile.getContent());
        }
        String metaInfo = null;
        if (ToolUtil.isNotEmpty((Object)((Object)metaFile))) {
            String string = metaInfo = metaFile.getContent() == null ? null : new String(metaFile.getContent());
        }
        if (ToolUtil.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            return workFlow;
        }
        return null;
    }

    @Override
    public WorkFlow getFileByProcessKeyAndProcessId(String processKey, String processId, String tenantId) {
        List list;
        String wfdInfo = null;
        String metaInfo = null;
        if (ToolUtil.equals((Object)processId, (Object)processKey)) {
            list = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROCESS_KEY", (Object)processKey)).eq((Object)"TENANT_ID", (Object)tenantId)).eq((Object)"VERSION", (Object)0));
            for (SysActProcessFile sysActProcessFile : list) {
                if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    wfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent());
                    continue;
                }
                metaInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent());
            }
        } else {
            list = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROCESS_KEY", (Object)processKey)).eq((Object)"TENANT_ID", (Object)tenantId)).eq((Object)"PROCESS_ID", (Object)processId));
            for (SysActProcessFile sysActProcessFile : list) {
                if (ToolUtil.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    wfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent());
                    continue;
                }
                metaInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent());
            }
        }
        if (ToolUtil.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject(metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            return workFlow;
        }
        return null;
    }

    @Override
    public List<SysActProcessFile> getBaseFileList(String processKey, String tenantId) {
        return this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROCESS_KEY", (Object)processKey)).eq((Object)"TENANT_ID", (Object)tenantId)).eq((Object)"VERSION", (Object)0));
    }

    @Override
    public boolean copyFiles(String processDefKey, String id, String tenantId) {
        WorkFlow workFlow = ToolUtil.isNotEmpty((Object)id) ? this.getFileByProcessKeyAndProcessId(processDefKey, id, tenantId) : this.getFileByProcessKey(processDefKey, tenantId, 0);
        this.updateFile(workFlow, tenantId);
        return true;
    }

    @Override
    public List<SysActProcessFile> exportFileList(List<String> modelIds, String tenantId) {
        return this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TENANT_ID", (Object)tenantId)).in((Object)"MODEL_ID", modelIds)).eq((Object)"VERSION", (Object)0));
    }

    @Override
    public List<SysActProcessFile> exportFile(String procId, String tenantId) {
        return this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TENANT_ID", (Object)tenantId)).in((Object)"PROCESS_ID", new Object[]{procId}));
    }

    @Override
    public void updateMetaByIdentity(String identity, String name, String category, String tenantId) {
        int lastVersion = this.sysActProcessFileMapper.selectLatestVersion(identity, tenantId);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(lastVersion);
        List sysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROCESS_KEY", (Object)identity)).eq((Object)"TENANT_ID", (Object)tenantId)).in((Object)"VERSION", list)).eq((Object)"TYPE", (Object)"meta"));
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((byte[])sysActProcessFile.getContent(), WorkFlow.class, (Feature[])new Feature[0]);
            if (ToolUtil.isNotEmpty((Object)name)) {
                workFlow.setName(name);
            }
            sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes());
            this.sysActProcessFileMapper.updateById((Object)sysActProcessFile);
        }
    }
}

