/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processentrust.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.annontion.InterfaceLog;
import com.jxdinfo.hussar.bpm.processentrust.model.SysActEntrust;
import com.jxdinfo.hussar.bpm.processentrust.service.SysActEntrustService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysActEntrust"})
public class SysActEntrustController
extends BaseController {
    @Autowired
    private SysActEntrustService sysActEntrustService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    @RequestMapping(value={"/list"})
    @InterfaceLog(key="/sysActEntrust/list", value="\u67e5\u8be2\u59d4\u6258\u7684\u50ac\u529e", type="\u67e5\u8be2")
    public BpmResponseResult list(@RequestParam(required=false) String userId, @RequestParam(required=false) String processId, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="10") Integer size) {
        if (ToolUtil.isEmpty((Object)userId)) {
            return InstallResult.getResult("0", "\u7528\u6237ID\u4e3a\u7a7a", null);
        }
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        QueryWrapper ew = new QueryWrapper();
        ew.like(ToolUtil.isNotEmpty((Object)processId), (Object)"process_id", (Object)processId);
        ew.eq((Object)"consignor", (Object)userId);
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        List list = ((Page)this.sysActEntrustService.page((IPage)pages, (Wrapper)ew)).getRecords();
        result.put("count", (Object)pages.getTotal());
        result.put("data", (Object)list);
        jsonArray.add((Object)result);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @RequestMapping(value={"/add"})
    @InterfaceLog(key="/sysActEntrust/add", value="\u6dfb\u52a0\u59d4\u6258", type="\u65b0\u589e")
    public BpmResponseResult add(String processId, String processName, String consignor, String consignee, String consigneeName, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust1 = SysActEntrustController.getSysActEntrust(IdWorker.get32UUID(), processId, processName, consignor, consignee, consigneeName, state, startTime, endTime);
        QueryWrapper ew = new QueryWrapper();
        ((QueryWrapper)ew.eq((Object)"consignor", (Object)sysActEntrust1.getConsignor())).eq((Object)"process_id", (Object)sysActEntrust1.getProcessId());
        List list = this.sysActEntrustService.list((Wrapper)ew);
        if (list.size() >= 1) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getExistConsignee(), null);
        }
        this.sysActEntrustService.save((Object)sysActEntrust1);
        return InstallResult.getResult("1", this.bpmConstantProperties.getSuccessSave(), null);
    }

    @RequestMapping(value={"/addBatch"})
    @InterfaceLog(key="/sysActEntrust/addBatch", value="\u6dfb\u52a0\u59d4\u6258", type="\u65b0\u589e")
    public BpmResponseResult addBatch(String processId, String processName, String consignor, String consignee, String consigneeName, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust = null;
        ArrayList<SysActEntrust> tt = new ArrayList<SysActEntrust>();
        String[] ids = null;
        ids = processId.split(",");
        String[] names = null;
        names = processName.split(",");
        List list = null;
        int isRight = 0;
        for (int i = 0; i < ids.length; ++i) {
            String id = String.valueOf(ids[i]);
            String name = String.valueOf(names[i]);
            sysActEntrust = SysActEntrustController.getSysActEntrust(IdWorker.get32UUID(), id, name, consignor, consignee, consigneeName, state, startTime, endTime);
            QueryWrapper ew = new QueryWrapper();
            ((QueryWrapper)ew.eq((Object)"consignor", (Object)sysActEntrust.getConsignor())).eq((Object)"process_id", (Object)sysActEntrust.getProcessId());
            list = this.sysActEntrustService.list((Wrapper)ew);
            if (list.size() >= 1) continue;
            sysActEntrust = SysActEntrustController.getSysActEntrust(IdWorker.get32UUID(), id, name, consignor, consignee, consigneeName, state, startTime, endTime);
            tt.add(sysActEntrust);
            ++isRight;
        }
        if (isRight == 0) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getExistConsignee(), null);
        }
        this.sysActEntrustService.saveBatch(tt, ids.length);
        return InstallResult.getResult("1", this.bpmConstantProperties.getSuccessSave(), null);
    }

    @RequestMapping(value={"/delete"})
    @InterfaceLog(key="/sysActEntrust/delete", value="\u5220\u9664\u59d4\u6258", type="\u5220\u9664")
    public BpmResponseResult delete(@RequestParam String tEntrustId) {
        this.sysActEntrustService.removeByIds(Arrays.asList(tEntrustId.split(",")));
        return InstallResult.getResult("1", this.bpmConstantProperties.getDeleteSuccess(), null);
    }

    @RequestMapping(value={"/update"})
    @InterfaceLog(key="/sysActEntrust/update", value="\u4fee\u6539\u59d4\u6258", type="\u4fee\u6539")
    public BpmResponseResult update(String id, String consignee, String consigneeName, String startTime, String endTime) {
        try {
            SysActEntrust sysActEntrust = SysActEntrustController.getSysActEntrust(id, null, null, null, consignee, consigneeName, null, startTime, endTime);
            this.sysActEntrustService.updateById((Object)sysActEntrust);
            return InstallResult.getResult("1", this.bpmConstantProperties.getSuccessUpdate(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return InstallResult.getResult("0", this.bpmConstantProperties.getErrorUpdate(), null);
        }
    }

    @RequestMapping(value={"/detail"})
    @InterfaceLog(key="/sysActEntrust/detail", value="\u67e5\u8be2\u59d4\u6258\u7684\u8be6\u60c5", type="\u67e5\u8be2")
    public BpmResponseResult detail(String tEntrustId) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(this.sysActEntrustService.getById((Serializable)((Object)tEntrustId)));
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @RequestMapping(value={"/updateState"})
    @InterfaceLog(key="/sysActEntrust/updateState", value="\u4fee\u6539\u59d4\u6258\u72b6\u6001", type="\u4fee\u6539")
    public BpmResponseResult updateState(@RequestParam String tEntrustId, @RequestParam String state) {
        this.sysActEntrustService.updataState(tEntrustId, state);
        if ("1".equals(state)) {
            return InstallResult.getResult("1", this.bpmConstantProperties.getSuccessStart(), null);
        }
        return InstallResult.getResult("1", this.bpmConstantProperties.getSuccessStop(), null);
    }

    private static SysActEntrust getSysActEntrust(String id, String processId, String processName, String consignor, String consignee, String consigneeName, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust = new SysActEntrust();
        sysActEntrust.setId(id);
        sysActEntrust.setProcessId(processId);
        sysActEntrust.setProcessName(processName);
        sysActEntrust.setConsignor(consignor);
        sysActEntrust.setConsignee(consignee);
        sysActEntrust.setConsigneeName(consigneeName);
        sysActEntrust.setState(state);
        sysActEntrust.setStartTime(Timestamp.valueOf(startTime));
        sysActEntrust.setEndTime(Timestamp.valueOf(endTime));
        return sysActEntrust;
    }
}

