/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processdiagram.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import com.jxdinfo.hussar.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.bpm.processdiagram.service.ProcessDiagramService;
import com.jxdinfo.hussar.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProcessDiagramServiceImpl
implements ProcessDiagramService {
    @Autowired
    private HistoryService historyService;
    @Autowired
    private InstanceEngineService instanceEngineService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Autowired
    private ProcessInstMapper processInstMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private TaskEngineMapper taskEngineMapper;
    @Value(value="${spring.datasource.url:}")
    private String url;
    private static final String FINISH_STATE = "finish";
    private static final String COMPLETE_STATE = "complete";
    private static final String NEXT_STATE = "next";
    private static final String SUSPENDED_STATE = "suspend";
    private static final String OVER_TIME_STATE = "overtime";

    @Override
    public JSONObject getProcessInfo(String processInstanceId) {
        List<String> idList;
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (ToolUtil.isEmpty((Object)processInstance)) {
            return new JSONObject();
        }
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        boolean suspended = false;
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).includeTaskLocalVariables()).includeProcessVariables()).list();
        List<Object> lineList = new ArrayList();
        if (taskList.size() == 0) {
            idList = this.queryPreActivitiesByTaskIdFinished(processInstanceId);
        } else {
            ProcessInstance instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            suspended = instance.isSuspended();
            idList = this.queryFinishNode(processInstanceId, processDefinitonId);
        }
        ArrayList<String> runningNode = new ArrayList<String>();
        HashMap<String, String> nodeState = new HashMap<String, String>();
        List<Map<String, String>> mapList = this.instanceEngineService.getCallNodeType(processInstanceId);
        for (Map<String, String> map : mapList) {
            runningNode.add(map.get("node"));
            nodeState.put(map.get("node"), ToolUtil.isEmpty((Object)map.get("type")) ? COMPLETE_STATE : map.get("type"));
        }
        for (Task task : taskList) {
            String completeType;
            runningNode.add(task.getTaskDefinitionKey());
            if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && task.getDueDate().getTime() < System.currentTimeMillis()) {
                nodeState.put(task.getTaskDefinitionKey(), OVER_TIME_STATE);
                continue;
            }
            String string = completeType = task.getTaskLocalVariables().get("complete_type") == null ? COMPLETE_STATE : task.getTaskLocalVariables().get("complete_type").toString();
            if ("reject_revoke".equals(completeType)) {
                completeType = COMPLETE_STATE;
            }
            nodeState.put(task.getTaskDefinitionKey(), completeType);
        }
        List<SysActHiLine> sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInstanceId);
        if (sysActHiLines != null && sysActHiLines.size() > 0) {
            lineList = sysActHiLines.stream().map(sysActHiLine -> sysActHiLine.getLineId()).collect(Collectors.toList());
        }
        Process process = bpmnModel.getMainProcess();
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        Map extensionElementsNode = process.getExtensionElements();
        String width = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasWidth")).get(0)).getAttributes().get("canvasWidth")).get(0)).getValue();
        String height = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasHeight")).get(0)).getAttributes().get("canvasHeight")).get(0)).getValue();
        for (FlowNode flowNode : process.findFlowElementsOfType(FlowNode.class)) {
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            if (graphicInfo.getX() > Double.parseDouble(width)) {
                width = String.valueOf(graphicInfo.getX());
            }
            object.put("y", (Object)graphicInfo.getY());
            if (graphicInfo.getY() + 100.0 > Double.parseDouble(height)) {
                height = String.valueOf(graphicInfo.getY() + 100.0);
            }
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            object.put("processInstanceId", (Object)processInstance.getId());
            if (runningNode.contains(flowNodeId)) {
                if (suspended) {
                    object.put("state", (Object)SUSPENDED_STATE);
                } else {
                    object.put("state", (Object)nodeState.getOrDefault(flowNodeId, COMPLETE_STATE));
                }
            } else if (idList.contains(flowNodeId)) {
                object.put("state", (Object)FINISH_STATE);
            } else {
                object.put("state", (Object)NEXT_STATE);
            }
            jsonArray.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && stringListMap.size() > 0 && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && extendFlowNameElement.size() > 0 && ToolUtil.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && graphicInfoList.size() > 0) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                if (lineList.contains(sequenceFlow.getId())) {
                    obj.put("state", (Object)FINISH_STATE);
                } else {
                    obj.put("state", (Object)NEXT_STATE);
                }
                jsonArray.add((Object)obj);
            }
        }
        jsonObject.put("width", (Object)width);
        jsonObject.put("height", (Object)height);
        jsonObject.put("data", (Object)jsonArray);
        return jsonObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JSONArray getProcessCompleteInfo(String processInstanceId, String tenantId) {
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (ToolUtil.isEmpty((Object)processInstance)) {
            return new JSONArray();
        }
        String processDefinitionId = processInstance.getProcessDefinitionId();
        int version = Integer.parseInt(processDefinitionId.split(":")[1]);
        if (version <= 0) {
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processDefinitionId));
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
        List<String> userList = new ArrayList<String>();
        if (hisList != null && hisList.size() > 0) {
            userList = hisList.stream().map(TaskInfo::getAssignee).filter(x -> x != null).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).includeTaskLocalVariables()).list();
        HashMap taskComment = new HashMap();
        if (ToolUtil.isNotEmpty((Object)hisList)) {
            ArrayList<String> hisTaskIds = new ArrayList<String>();
            for (Object hisTask : hisList) {
                if (hisTask.getEndTime() == null) continue;
                hisTaskIds.add(hisTask.getId());
            }
            if (ToolUtil.isNotEmpty(hisTaskIds)) {
                List<Map<String, String>> commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
                for (Map map : commentsMap) {
                    taskComment.put(map.get("id"), map.get("comments"));
                }
            }
        }
        for (ActivityImpl activity : activitiList) {
            void var17_21;
            JSONObject object = new JSONObject();
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("id", (Object)activity.getId());
            Object var17_19 = null;
            if (tasks != null && tasks.size() > 0) {
                List list = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (var17_21 != null && var17_21.size() > 0) {
                ArrayList<String> taskIds = new ArrayList<String>();
                for (Task task : var17_21) {
                    taskIds.add(task.getId());
                }
                List nowHisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                List<String> user = this.getAssigneeByTaskIds(taskIds);
                List ts = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                object.put("startTime", (Object)((Task)ts.get(0)).getCreateTime());
                Map map = ((Task)ts.get(0)).getTaskLocalVariables();
                if (map != null) {
                    object.put("rejectFrom", (Object)(map.get("reject_name") == null ? "" : map.get("reject_name").toString()));
                    object.put("completeType", (Object)(map.get("complete_type") == null ? "" : map.get("complete_type").toString()));
                } else {
                    object.put("rejectFrom", (Object)"");
                    object.put("completeType", (Object)"");
                }
                if (user.size() > 0) {
                    String assignee = this.iAssigneeChooseService.getUserNames(user, tenantId);
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)COMPLETE_STATE);
                if (nowHisActivitList.size() > 0) {
                    nowHisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                    JSONArray json = new JSONArray();
                    for (HistoricTaskInstance historicActivityInstance : nowHisActivitList) {
                        JSONObject o = new JSONObject();
                        String nowUser = historicActivityInstance.getAssignee() != null ? finalUsersMap.get(historicActivityInstance.getAssignee()) : this.bpmConstantProperties.getNullComplete();
                        String comment = (String)taskComment.get(historicActivityInstance.getId());
                        o.put("comments", (Object)(comment == null ? this.bpmConstantProperties.getNullCommont() : comment));
                        o.put("assignee", (Object)nowUser);
                        o.put("endTime", (Object)historicActivityInstance.getEndTime());
                        o.put("startTime", (Object)historicActivityInstance.getStartTime());
                        json.add((Object)o);
                    }
                    object.put("completeInfo", (Object)json);
                }
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && hisList.size() > 0) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.size() <= 0) continue;
                hisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                JSONArray json = new JSONArray();
                for (HistoricTaskInstance historicActivityInstance : hisActivitList) {
                    String comment;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if (StringUtils.isEmpty((CharSequence)user)) {
                        user = this.bpmConstantProperties.getNullComplete();
                    }
                    o.put("comments", (Object)((comment = (String)taskComment.get(historicActivityInstance.getId())) == null ? this.bpmConstantProperties.getNullCommont() : comment));
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return jsonArray;
    }

    @Override
    public JSONArray list(String processInstanceId, String tenantId) {
        BpmResponseResult obj = this.instanceEngineService.getAllProcessTrace(processInstanceId, tenantId);
        return obj.getResult();
    }

    @Override
    public JSONArray microAppList(String processInstanceId, String tenantId) {
        BpmResponseResult obj = this.instanceEngineService.getAllProcessTraceByMicroApp(processInstanceId, tenantId);
        return obj.getResult();
    }

    @Override
    public Map<String, Object> subProcessList(Map<String, Object> map) {
        Page pages = new Page((long)((Integer)map.get("page")).intValue(), (long)((Integer)map.get("limit")).intValue());
        map.put("dbType", this.url.split(":")[1]);
        List<ProcessInst> instList = this.processInstMapper.getCallActivityProcessInstList((Page<ProcessInst>)pages, map);
        for (ProcessInst processInst : instList) {
            List<String> nodeNames = processInst.getNodeNames();
            if (nodeNames == null) continue;
            nodeNames.remove(null);
            if (nodeNames.size() <= 0) continue;
            processInst.setNames(String.join((CharSequence)",", nodeNames));
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("count", pages.getTotal());
        dataMap.put("data", instList);
        return dataMap;
    }

    private void prepareBpmnModel(BpmnModel bpmnModel) {
        ArrayList allGraphicInfos = new ArrayList();
        if (bpmnModel.getLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLocationMap().values());
        }
        if (bpmnModel.getLabelLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLabelLocationMap().values());
        }
        if (bpmnModel.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : bpmnModel.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (allGraphicInfos.size() > 0) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    private String getNodeType(FlowNode flowNode) {
        String type = "";
        if (flowNode instanceof UserTask) {
            type = "userTask";
        } else if (flowNode instanceof StartEvent) {
            EventDefinition eventDefinition;
            StartEvent startEvent = (StartEvent)flowNode;
            type = startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty() ? ((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition ? "startTimerEvent" : (eventDefinition instanceof ErrorEventDefinition ? "errorEvent" : (eventDefinition instanceof SignalEventDefinition ? "signalEvent" : (eventDefinition instanceof MessageEventDefinition ? "messageEvent" : "noneEvent")))) : "startEvent";
        } else if (flowNode instanceof EndEvent) {
            type = "endEvent";
        } else if (flowNode instanceof ParallelGateway) {
            type = "parallelGateway";
        } else if (flowNode instanceof InclusiveGateway) {
            type = "inclusiveGateway";
        } else if (flowNode instanceof ExclusiveGateway) {
            type = "exclusiveGateway";
        } else if (flowNode instanceof SubProcess) {
            type = "subProcess";
        } else if (flowNode instanceof BoundaryEvent) {
            type = "boundaryEvent";
        } else if (flowNode instanceof CallActivity) {
            type = "callActivity";
        }
        return type;
    }

    private List<String> queryPreActivitiesByTaskIdFinished(String processInstanceId) {
        ArrayList<String> idList = new ArrayList<String>();
        List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().finished().asc()).list();
        for (HistoricActivityInstance his : list) {
            idList.add(his.getActivityId());
        }
        return idList;
    }

    private List<String> queryFinishNode(String processInstanceId, String processDefinitionId) {
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        ArrayList<String> idList = new ArrayList<String>();
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).finished().list();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            ActivityImpl activity = def.findActivity(historicActivityInstance.getActivityId());
            if (activity == null) continue;
            idList.add(activity.getId());
        }
        return idList;
    }

    private List<String> getAssigneeByTaskIds(List<String> taskIds) {
        ArrayList<String> users = new ArrayList<String>();
        if (taskIds != null && taskIds.size() > 0) {
            for (String taskId : taskIds) {
                List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
                if (identityLinkList == null || identityLinkList.size() <= 0) continue;
                for (IdentityLink identityLink : identityLinkList) {
                    users.add(identityLink.getUserId());
                }
            }
        }
        return users;
    }
}

