/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processcount.service.impl;

import com.jxdinfo.hussar.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.processcount.dao.ProcessCountMapper;
import com.jxdinfo.hussar.bpm.processcount.service.ProcessCountService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProcessCountServiceImpl
implements ProcessCountService {
    public static final int DAY = 6;
    @Resource
    private ProcessCountMapper processCountMapper;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private ProcessDefinitionsService processDefinitionsService;
    @Value(value="${spring.datasource.url:}")
    private String url;

    @Override
    public List<Map<String, String>> getAllTaskCount(String type) {
        String time = ProcessCountServiceImpl.getStartTime(type);
        return this.processCountMapper.getTask(time, this.url.split(":")[1]);
    }

    @Override
    public List<Map<String, String>> getAllInstanceCount(String type) {
        String time = ProcessCountServiceImpl.getStartTime(type);
        return this.processCountMapper.getInstance(time, this.url.split(":")[1]);
    }

    @Override
    public List<Map<String, Object>> getCurrentInstanceCountWithCompleted(String type) {
        String time = ProcessCountServiceImpl.getStartTime(type);
        return this.processCountMapper.getAllInstance(this.url.split(":")[1], time, null);
    }

    @Override
    public List<Map<String, String>> getGrowthRate(String type) {
        if ("all".equals(type)) {
            return null;
        }
        List<Object> lastList = new ArrayList();
        List<Object> currentList = new ArrayList();
        String startTime = ProcessCountServiceImpl.getStartTimeR(type);
        String endTime = ProcessCountServiceImpl.getStartTime(type);
        lastList = this.processCountMapper.getAllInstance(this.url.split(":")[1], startTime, endTime);
        String time = ProcessCountServiceImpl.getStartTime(type);
        currentList = this.processCountMapper.getAllInstance(this.url.split(":")[1], time, null);
        ArrayList<Map<String, String>> growthRate = new ArrayList<Map<String, String>>();
        for (int i = 0; i < currentList.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("PROCESSKEY", (String)((Map)currentList.get(i)).get("PROCESSKEY"));
            map.put("PROCESSNAME", (String)((Map)currentList.get(i)).get("PROCESSNAME"));
            for (int j = 0; j < lastList.size(); ++j) {
                if (!((Map)lastList.get(j)).containsValue(((Map)currentList.get(i)).get("PROCESSKEY"))) continue;
                float result = ((Long)((Map)currentList.get(i)).get("COUNTNUM")).floatValue() / (float)((Long)((Map)lastList.get(j)).get("COUNTNUM")).longValue() - 1.0f;
                DecimalFormat formatter = new DecimalFormat("0.00");
                String formatedFloatResult = formatter.format(result);
                map.put("PROCESSRATE", String.valueOf(formatedFloatResult));
            }
            if (!map.containsKey("PROCESSRATE")) {
                map.put("PROCESSRATE", String.valueOf(1.0));
            }
            growthRate.add(map);
        }
        return growthRate;
    }

    @Override
    public List<Map<String, String>> getTaskDone() {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("startTime", ProcessCountServiceImpl.getPastDate(6));
        query.put("endTime", ProcessCountServiceImpl.getPastDate(-1));
        List<String> list = this.processCountMapper.getTaskDone(query, this.url.split(":")[1]);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String str : list) {
            String date = str.substring(0, 10);
            int i = 1;
            if (map.get(date) != null) {
                i = (Integer)map.get(date) + 1;
            }
            map.put(date, i);
        }
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= 6; ++i) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            if (map.get(ProcessCountServiceImpl.getPastDate(6 - i)) == null) {
                resultMap.put("DATE", ProcessCountServiceImpl.getPastDate(6 - i));
                resultMap.put("COUNTNUM", "0");
                resultList.add(resultMap);
                continue;
            }
            resultMap.put("DATE", ProcessCountServiceImpl.getPastDate(6 - i));
            resultMap.put("COUNTNUM", ((Integer)map.get(ProcessCountServiceImpl.getPastDate(6 - i))).toString());
            resultList.add(resultMap);
        }
        return resultList;
    }

    @Override
    public List<Map<String, String>> getTaskTodo() {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("startTime", ProcessCountServiceImpl.getPastDate(6));
        query.put("endTime", ProcessCountServiceImpl.getPastDate(-1));
        List<String> list = this.processCountMapper.getTaskTodo(query, this.url.split(":")[1]);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String str : list) {
            String date = str.substring(0, 10);
            int i = 1;
            if (map.get(date) != null) {
                i = (Integer)map.get(date) + 1;
            }
            map.put(date, i);
        }
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= 6; ++i) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            if (map.get(ProcessCountServiceImpl.getPastDate(6 - i)) == null) {
                resultMap.put("DATE", ProcessCountServiceImpl.getPastDate(6 - i));
                resultMap.put("COUNTNUM", "0");
                resultList.add(resultMap);
                continue;
            }
            resultMap.put("DATE", ProcessCountServiceImpl.getPastDate(6 - i));
            resultMap.put("COUNTNUM", ((Integer)map.get(ProcessCountServiceImpl.getPastDate(6 - i))).toString());
            resultList.add(resultMap);
        }
        return resultList;
    }

    public static String getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(calendar.getTime());
    }

    public static String getStartTime(String type) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        if ("week".equals(type)) {
            date.setHours(0);
            date.setMinutes(0);
            date.setSeconds(0);
            cal.setTime(date);
            int dayofweek = cal.get(7);
            if (dayofweek == 1) {
                dayofweek += 7;
            }
            cal.add(5, 2 - dayofweek);
            return formatter.format(cal.getTime());
        }
        if ("month".equals(type)) {
            cal.set(date.getYear() + 1900, date.getMonth(), 1, 0, 0, 0);
            return formatter.format(cal.getTime());
        }
        if ("year".equals(type)) {
            cal.set(date.getYear() + 1900, 0, 1, 0, 0, 0);
            return formatter.format(cal.getTime());
        }
        return null;
    }

    public static String getStartTimeR(String type) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        if ("week".equals(type)) {
            date.setHours(0);
            date.setMinutes(0);
            date.setSeconds(0);
            cal.setTime(date);
            cal.add(5, -7);
            int dayofweek = cal.get(7);
            if (dayofweek == 1) {
                dayofweek += 7;
            }
            cal.add(5, 2 - dayofweek);
            return formatter.format(cal.getTime());
        }
        if ("month".equals(type)) {
            cal.set(date.getYear() + 1900, date.getMonth(), 1, 0, 0, 0);
            cal.add(2, -1);
            return formatter.format(cal.getTime());
        }
        if ("year".equals(type)) {
            cal.set(date.getYear() + 1900, 0, 1, 0, 0, 0);
            cal.add(1, -1);
            return formatter.format(cal.getTime());
        }
        return null;
    }

    @Override
    public List<Map<String, String>> getInstanceTime() {
        return this.processCountMapper.getInstanceTime();
    }

    @Override
    public List<Map<String, String>> getTaskTime(String processKey) {
        if (ToolUtil.isEmpty((Object)processKey)) {
            return new ArrayList<Map<String, String>>();
        }
        DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
        List<Map<String, String>> taskTimeList = this.processCountMapper.getTaskTime(processKey);
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(definitionModel.getId());
        HashMap<String, String> taskDefinitionMap = new HashMap<String, String>();
        Map taskDefinition = ((ProcessDefinitionEntity)processDefinition).getTaskDefinitions();
        for (String string : taskDefinition.keySet()) {
            taskDefinitionMap.put(string, ((TaskDefinition)taskDefinition.get(string)).getNameExpression().getExpressionText());
        }
        for (Map map : taskTimeList) {
            if (!ToolUtil.isNotEmpty(taskDefinitionMap.get(map.get("TASKKEY")))) continue;
            map.put("TASKNAME", taskDefinitionMap.get(map.get("TASKKEY")));
        }
        return taskTimeList;
    }
}

