/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.listener;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.util.HussarBpmSM4Util;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class GodAxeDefaultListener
implements ExecutionListener {
    private final String GodAxePath = "/GodAxeVariables";
    private ITenantConfigService iTenantConfigService = (ITenantConfigService)SpringContextHolder.getBean(ITenantConfigService.class);
    private ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public void notify(DelegateExecution delegateExecution) throws Exception {
        String tenantId = delegateExecution.getTenantId();
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTenantConfigNotExist(), false);
        }
        if ("1".equals(tenantConfig.getIsGodAxe())) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            String id = ((ExecutionEntity)delegateExecution).getActivityId();
            BpmnModel bm = this.repositoryService.getBpmnModel(delegateExecution.getProcessDefinitionId());
            id = CommonCodeUtil.getVisitorNodeId(id, bm);
            String realVersion = String.valueOf(this.modelService.getRealVersion(delegateExecution.getProcessDefinitionId()));
            String[] ids = delegateExecution.getProcessDefinitionId().split(":");
            map.put("tenantId", HussarBpmSM4Util.encrypt(tenantId, "admin#$%^kopoiuy"));
            map.put("beanId", ids[0] + ":" + realVersion + id);
            map.put("businessId", delegateExecution.getProcessBusinessKey());
            String result = HttpRequestUtil.getResult(tenantConfig.getProjectAddress() + "/GodAxeVariables", map);
            if (ToolUtil.isNotEmpty((Object)result)) {
                Map variable = new HashMap();
                try {
                    variable = (Map)JSON.parseObject((String)result, HashMap.class);
                }
                catch (Exception e) {
                    throw new GodAxeRequestException(1);
                }
                for (Map.Entry k : variable.entrySet()) {
                    Object date;
                    String className = k.getValue().getClass().getName();
                    if ("java.lang.String".equals(className) && ToolUtil.isNotEmpty((Object)(date = this.isValidDate(k.getValue().toString())))) {
                        variable.put(k.getKey(), date);
                    }
                    if (!"java.math.BigDecimal".equals(className)) continue;
                    variable.put(k.getKey(), ((BigDecimal)k.getValue()).doubleValue());
                }
                if (ToolUtil.isNotEmpty(variable)) {
                    delegateExecution.setVariables(variable);
                }
            }
        }
    }

    private Object isValidDate(String str) {
        SimpleDateFormat format;
        String yMdhmsRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0[1-9]|1[0-2])([-/]?)(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        String yMdRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0?[1-9]|1[0-2])\\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\\1(?:29|30)|(?:0?[13578]|1[02])\\1(?:31))|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-/]?)0?2\\2(?:29))$";
        String yMRegex = "^\\d{4}([-/]?)(0[1-9]|1[0-2])$";
        String hmsRegex = "([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        if (str.length() == 7) {
            if (!str.matches(yMRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM");
        } else if (str.length() == 10) {
            if (!str.matches(yMdRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd");
        } else if (str.length() == 8) {
            if (!str.matches(hmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("HH:mm:ss");
        } else {
            if (!str.matches(yMdhmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        try {
            format.setLenient(false);
            return format.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

