/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.interfacelog.aop;

import com.jxdinfo.hussar.bpm.interfacelog.annontion.InterfaceLog;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class InterfaceLogAop {
    private Logger log = LoggerFactory.getLogger(InterfaceLogAop.class);
    ISysUserService iSysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);

    @Pointcut(value="@annotation(com.jxdinfo.hussar.bpm.interfacelog.annontion.InterfaceLog)")
    public void cutService() {
    }

    @Around(value="cutService()")
    public Object recordSysLog(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        try {
            this.handle(point);
        }
        catch (Exception e) {
            this.log.error("\u65e5\u5fd7\u8bb0\u5f55\u51fa\u9519!", (Throwable)e);
        }
        return result;
    }

    private void handle(ProceedingJoinPoint point) throws Exception {
        String tenantCipher;
        Signature sig = point.getSignature();
        if (!(sig instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        MethodSignature msig = (MethodSignature)sig;
        Object target = point.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        String methodName = currentMethod.getName();
        String tenantId = HttpKit.getRequest().getParameter("tenantId");
        SysUser sysUser = this.iSysUserService.queryTenantByTenantId(tenantId, tenantCipher = HttpKit.getRequest().getParameter("tenantCipher"));
        if (sysUser == null) {
            throw new TenantException();
        }
        String className = point.getTarget().getClass().getName();
        InterfaceLog annotation = currentMethod.getAnnotation(InterfaceLog.class);
        String businessName = annotation.value();
        String type = annotation.type();
        String levelEvent = annotation.levelEvent();
        String value = annotation.value();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("userId", sysUser.getUserId());
        info.put("userAccount", sysUser.getUserAccount());
        info.put("userName", sysUser.getUserName());
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        info.put("sessionId", HttpKit.getSeesionId());
        info.put("tenantId", tenantId);
        info.put("tenantCipher", tenantCipher);
        InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.businessLog(info, businessName, className, methodName, value, type, levelEvent, sysUser));
    }
}

